/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import android.util.Log;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J*\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0015\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\bJ\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J \u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/core/internal/util/Logger;", "", "()V", "MAX_LOGCAT_MSG_SIZE", "", "NONE", "SENSITIVE", "isLogLevelInitialized", "", "logLevel", "getLogLevel$annotations", "d", "", "tag", "", "msg", "tr", "", "e", "i", "logInChunks", "logToLogcat", "sensitiveLog", "setLogLevel", "setLogLevel$checkout_core_release", "updateDefaultLogLevel", "isDebugBuild", "v", "w", "LogLevel", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static final int SENSITIVE = -1;
    public static final int NONE = 8;
    private static final int MAX_LOGCAT_MSG_SIZE = 2048;
    private static int logLevel = 8;
    private static boolean isLogLevelInitialized;

    private Logger() {
    }

    private static /* synthetic */ void getLogLevel$annotations() {
    }

    public final void updateDefaultLogLevel(boolean isDebugBuild) {
        if (!isLogLevelInitialized) {
            logLevel = isDebugBuild ? 3 : 8;
        }
    }

    public final void setLogLevel$checkout_core_release(int logLevel) {
        isLogLevelInitialized = true;
        Logger.logLevel = logLevel;
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        INSTANCE.logToLogcat(2, tag, msg, null);
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @NotNull String msg, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        INSTANCE.logToLogcat(2, tag, msg, tr);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        INSTANCE.logToLogcat(3, tag, msg, null);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @NotNull String msg, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        INSTANCE.logToLogcat(3, tag, msg, tr);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        INSTANCE.logToLogcat(4, tag, msg, null);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @NotNull String msg, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        INSTANCE.logToLogcat(4, tag, msg, tr);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        INSTANCE.logToLogcat(5, tag, msg, null);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @NotNull String msg, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        INSTANCE.logToLogcat(5, tag, msg, tr);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        INSTANCE.logToLogcat(6, tag, msg, null);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @NotNull String msg, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        INSTANCE.logToLogcat(6, tag, msg, tr);
    }

    public final void sensitiveLog(@NotNull String tag, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (logLevel != -1) {
            throw new SecurityException("Sensitive information should never be logged. Remove before committing.");
        }
        this.logToLogcat(-1, tag, msg, null);
    }

    private final void logToLogcat(int logLevel, String tag, String msg, Throwable tr) {
        if (Logger.logLevel > logLevel) {
            return;
        }
        if (msg.length() > 2048) {
            this.logInChunks(logLevel, tag, msg, tr);
            return;
        }
        switch (logLevel) {
            case -1: {
                if (tr == null) {
                    Log.wtf((String)tag, (String)msg);
                    break;
                }
                Log.wtf((String)tag, (String)msg, (Throwable)tr);
                break;
            }
            case 2: {
                if (tr == null) {
                    Log.v((String)tag, (String)msg);
                    break;
                }
                Log.v((String)tag, (String)msg, (Throwable)tr);
                break;
            }
            case 3: {
                if (tr == null) {
                    Log.d((String)tag, (String)msg);
                    break;
                }
                Log.d((String)tag, (String)msg, (Throwable)tr);
                break;
            }
            case 4: {
                if (tr == null) {
                    Log.i((String)tag, (String)msg);
                    break;
                }
                Log.i((String)tag, (String)msg, (Throwable)tr);
                break;
            }
            case 5: {
                if (tr == null) {
                    Log.w((String)tag, (String)msg);
                    break;
                }
                Log.w((String)tag, (String)msg, (Throwable)tr);
                break;
            }
            case 6: {
                if (tr == null) {
                    Log.e((String)tag, (String)msg);
                    break;
                }
                Log.e((String)tag, (String)msg, (Throwable)tr);
            }
        }
    }

    private final void logInChunks(int logLevel, String tag, String msg, Throwable tr) {
        int i = 0;
        int divisions = msg.length() / 2048;
        if (i <= divisions) {
            while (true) {
                String string;
                if (i != divisions) {
                    String string2 = msg.substring(i * 2048, (i + 1) * 2048);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    String string3 = msg.substring(i * 2048);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
                String newMessage = string;
                this.logToLogcat(logLevel, tag + "-" + i, newMessage, tr);
                if (i == divisions) break;
                ++i;
            }
        }
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/adyen/checkout/core/internal/util/Logger$LogLevel;", "", "checkout-core_release"})
    public static @interface LogLevel {
    }
}

