/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import android.os.Build;
import androidx.annotation.RestrictTo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/adyen/checkout/core/internal/util/LogUtil;", "", "()V", "CHECKOUT_LOG_PREFIX", "", "CLASS_NOT_FOUND", "MAX_TAG_SIZE", "", "callerClassName", "getCallerClassName", "()Ljava/lang/String;", "simplifiedCallerClassName", "getSimplifiedCallerClassName", "getTag", "prefix", "simplifyClassName", "className", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nLogUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogUtil.kt\ncom/adyen/checkout/core/internal/util/LogUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n37#2,2:73\n*S KotlinDebug\n*F\n+ 1 LogUtil.kt\ncom/adyen/checkout/core/internal/util/LogUtil\n*L\n68#1:73,2\n*E\n"})
public final class LogUtil {
    @NotNull
    public static final LogUtil INSTANCE = new LogUtil();
    @NotNull
    private static final String CHECKOUT_LOG_PREFIX = "CO.";
    @NotNull
    private static final String CLASS_NOT_FOUND = "?Unknown?";
    private static final int MAX_TAG_SIZE = 23;

    private LogUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String getTag() {
        return LogUtil.getTag(CHECKOUT_LOG_PREFIX);
    }

    @JvmStatic
    @NotNull
    public static final String getTag(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String callerClass = INSTANCE.getSimplifiedCallerClassName();
        Object tag = prefix + callerClass;
        if (Build.VERSION.SDK_INT <= 23 && ((String)tag).length() > 23) {
            String string = ((String)tag).substring(0, 23);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            tag = string;
        }
        return tag;
    }

    private final String getSimplifiedCallerClassName() {
        String className = this.getCallerClassName();
        return this.simplifyClassName(className);
    }

    private final String getCallerClassName() {
        Object[] stElements = Thread.currentThread().getStackTrace();
        Intrinsics.checkNotNull((Object)stElements);
        for (StackTraceElement ste : ArraysKt.drop((Object[])stElements, (int)1)) {
            String callerClass = ste.getClassName();
            if (Intrinsics.areEqual((Object)callerClass, (Object)LogUtil.class.getName())) continue;
            Intrinsics.checkNotNull((Object)callerClass);
            if (StringsKt.indexOf$default((CharSequence)callerClass, (String)"java.lang.Thread", (int)0, (boolean)false, (int)6, null) == 0) continue;
            return callerClass;
        }
        return CLASS_NOT_FOUND;
    }

    private final String simplifyClassName(String className) {
        String[] stringArray = new String[]{"."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)className, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] packageSplit = thisCollection$iv.toArray(new String[0]);
        return packageSplit.length == 0 ? className : packageSplit[packageSplit.length - 1];
    }
}

