/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.util;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RestrictTo;
import java.util.IllformedLocaleException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/adyen/checkout/core/internal/util/LocaleUtil;", "", "()V", "fromLanguageTag", "Ljava/util/Locale;", "tag", "", "getLocale", "context", "Landroid/content/Context;", "isValidLocale", "", "locale", "toLanguageTag", "checkout-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class LocaleUtil {
    @NotNull
    public static final LocaleUtil INSTANCE = new LocaleUtil();

    private LocaleUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Locale getLocale(@NotNull Context context) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = context.getResources().getConfiguration().getLocales().get(0);
            Intrinsics.checkNotNull((Object)locale2);
            locale = locale2;
        } else {
            Locale locale3 = context.getResources().getConfiguration().locale;
            Intrinsics.checkNotNull((Object)locale3);
            locale = locale3;
        }
        return locale;
    }

    @JvmStatic
    @NotNull
    public static final String toLanguageTag(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = locale.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Locale fromLanguageTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Locale locale = Locale.forLanguageTag(tag);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
        return locale;
    }

    @JvmStatic
    public static final boolean isValidLocale(@NotNull Locale locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        try {
            new Locale.Builder().setLocale(locale).build();
            bl = true;
        }
        catch (IllformedLocaleException ex) {
            bl = false;
        }
        return bl;
    }
}

