/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.ui;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.LruCache;
import com.adyen.checkout.core.internal.ui.InMemoryCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0086\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/core/internal/ui/InMemoryCache;", "", "maxSize", "", "(I)V", "cache", "com/adyen/checkout/core/internal/ui/InMemoryCache$cache$1", "Lcom/adyen/checkout/core/internal/ui/InMemoryCache$cache$1;", "get", "Landroid/graphics/Bitmap;", "key", "", "set", "", "bitmap", "Value", "checkout-core_release"})
public final class InMemoryCache {
    @NotNull
    private final cache.1 cache;

    public InMemoryCache(int maxSize) {
        this.cache = new LruCache<String, Value>(maxSize){

            protected int sizeOf(@NotNull String key, @NotNull Value value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getSize();
            }
        };
    }

    @Nullable
    public final Bitmap get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value = (Value)this.cache.get(key);
        return value != null ? value.getBitmap() : null;
    }

    public final void set(@NotNull String key, @NotNull Bitmap bitmap) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            n = bitmap.getAllocationByteCount();
        }
        catch (Exception exception) {
            int bytesPerPixel = bitmap.getConfig() == Bitmap.Config.ALPHA_8 ? 1 : (bitmap.getConfig() == Bitmap.Config.RGB_565 ? 2 : (bitmap.getConfig() == Bitmap.Config.ARGB_4444 ? 2 : (Build.VERSION.SDK_INT >= 26 && bitmap.getConfig() == Bitmap.Config.RGBA_F16 ? 8 : 4)));
            n = bitmap.getWidth() * bitmap.getHeight() * bytesPerPixel;
        }
        int size = n;
        this.cache.put(key, new Value(bitmap, size));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/adyen/checkout/core/internal/ui/InMemoryCache$Value;", "", "bitmap", "Landroid/graphics/Bitmap;", "size", "", "(Landroid/graphics/Bitmap;I)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getSize", "()I", "checkout-core_release"})
    private static final class Value {
        @NotNull
        private final Bitmap bitmap;
        private final int size;

        public Value(@NotNull Bitmap bitmap, int size) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.size = size;
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

