/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.core.internal.data.api;

import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.HttpException;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.core.internal.data.api.HttpClient;
import com.adyen.checkout.core.internal.data.model.ErrorResponseBody;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J>\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0012JF\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u0017*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/adyen/checkout/core/internal/data/api/OkHttpClient;", "Lcom/adyen/checkout/core/internal/data/api/HttpClient;", "client", "Lokhttp3/OkHttpClient;", "baseUrl", "", "defaultHeaders", "", "(Lokhttp3/OkHttpClient;Ljava/lang/String;Ljava/util/Map;)V", "buildURL", "path", "queryParameters", "executeRequest", "", "request", "Lokhttp3/Request;", "get", "headers", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "post", "jsonBody", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "combineToHeaders", "Lokhttp3/Headers;", "getHttpException", "Lcom/adyen/checkout/core/exception/HttpException;", "Lokhttp3/Response;", "Companion", "checkout-core_release"})
@SourceDebugExtension(value={"SMAP\nOkHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClient.kt\ncom/adyen/checkout/core/internal/data/api/OkHttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n215#2,2:129\n1#3:131\n*S KotlinDebug\n*F\n+ 1 OkHttpClient.kt\ncom/adyen/checkout/core/internal/data/api/OkHttpClient\n*L\n66#1:129,2\n*E\n"})
public final class OkHttpClient
implements HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final okhttp3.OkHttpClient client;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final Map<String, String> defaultHeaders;
    @NotNull
    private static final MediaType MEDIA_TYPE_JSON = MediaType.Companion.get("application/json; charset=utf-8");

    public OkHttpClient(@NotNull okhttp3.OkHttpClient client, @NotNull String baseUrl, @NotNull Map<String, String> defaultHeaders) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(defaultHeaders, (String)"defaultHeaders");
        this.client = client;
        this.baseUrl = baseUrl;
        this.defaultHeaders = defaultHeaders;
    }

    public /* synthetic */ OkHttpClient(okhttp3.OkHttpClient okHttpClient2, String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(okHttpClient2, string, map);
    }

    @Override
    @Nullable
    public Object get(@NotNull String path, @NotNull Map<String, String> queryParameters, @NotNull Map<String, String> headers, @NotNull Continuation<? super byte[]> $completion) {
        Request request = new Request.Builder().headers(this.combineToHeaders(headers)).url(this.buildURL(path, queryParameters)).get().build();
        return this.executeRequest(request);
    }

    @Override
    @Nullable
    public Object post(@NotNull String path, @NotNull String jsonBody, @NotNull Map<String, String> queryParameters, @NotNull Map<String, String> headers, @NotNull Continuation<? super byte[]> $completion) {
        Request request = new Request.Builder().headers(this.combineToHeaders(headers)).url(this.buildURL(path, queryParameters)).post(RequestBody.Companion.create(jsonBody, MEDIA_TYPE_JSON)).build();
        return this.executeRequest(request);
    }

    private final String buildURL(String path, Map<String, String> queryParameters) {
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.baseUrl + path);
        if (httpUrl == null || (httpUrl = httpUrl.newBuilder()) == null) {
            throw new CheckoutException("Failed to parse URL.", null, 2, null);
        }
        HttpUrl builder = httpUrl;
        Map<String, String> $this$forEach$iv = queryParameters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            builder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.toString();
    }

    private final byte[] executeRequest(Request request) {
        Call call = this.client.newCall(request);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                byte[] byArray;
                ResponseBody responseBody = response.body();
                byte[] bytes = responseBody != null && (byArray = responseBody.bytes()) != null ? byArray : new byte[]{};
                ResponseBody responseBody2 = response.body();
                if (responseBody2 != null) {
                    responseBody2.close();
                }
                return bytes;
            }
            HttpException exception = this.getHttpException(response);
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                responseBody.close();
            }
            throw exception;
        }
        catch (CancellationException e) {
            call.cancel();
            throw e;
        }
    }

    private final Headers combineToHeaders(Map<String, String> $this$combineToHeaders) {
        return Headers.Companion.of(MapsKt.plus(this.defaultHeaders, $this$combineToHeaders));
    }

    /*
     * WARNING - void declaration
     */
    private final HttpException getHttpException(Response $this$getHttpException) {
        ErrorResponseBody parsedErrorResponseBody;
        Object object;
        ErrorResponseBody errorResponseBody;
        String string;
        try {
            ResponseBody responseBody = $this$getHttpException.body();
            string = responseBody != null ? responseBody.string() : null;
        }
        catch (IOException e) {
            string = null;
        }
        String stringBody = string;
        try {
            ErrorResponseBody errorResponseBody2;
            if (stringBody != null) {
                String it = stringBody;
                boolean bl = false;
                it = new JSONObject(it);
                boolean bl2 = false;
                errorResponseBody2 = ErrorResponseBody.SERIALIZER.deserialize((JSONObject)it);
            } else {
                errorResponseBody2 = null;
            }
            errorResponseBody = errorResponseBody2;
        }
        catch (JSONException e) {
            errorResponseBody = null;
        }
        catch (ModelSerializationException e) {
            errorResponseBody = null;
        }
        int n = (object = (parsedErrorResponseBody = errorResponseBody)) != null && (object = ((ErrorResponseBody)object).getStatus()) != null ? ((Integer)object).intValue() : $this$getHttpException.code();
        Object object2 = parsedErrorResponseBody;
        if (object2 == null || (object2 = ((ErrorResponseBody)object2).getMessage()) == null) {
            Object object3;
            String string2 = stringBody;
            if (string2 != null) {
                void it;
                String string3;
                String bl2 = string3 = string2;
                int n2 = n;
                boolean bl = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                n = n2;
                object3 = bl3 ? string3 : null;
            } else {
                object3 = object2 = null;
            }
            if (object3 == null) {
                object2 = $this$getHttpException.message();
            }
        }
        ErrorResponseBody errorResponseBody3 = parsedErrorResponseBody;
        Object object4 = object2;
        int n3 = n;
        return new HttpException(n3, (String)object4, errorResponseBody3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/core/internal/data/api/OkHttpClient$Companion;", "", "()V", "MEDIA_TYPE_JSON", "Lokhttp3/MediaType;", "checkout-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

