/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.util;

import com.adyen.checkout.card.R;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.components.core.internal.util.DateUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/adyen/checkout/card/internal/util/KcpValidationUtils;", "", "()V", "KCP_BIRTH_DATE_FORMAT", "", "KCP_BIRTH_DATE_LENGTH", "", "KCP_CARD_PASSWORD_REQUIRED_LENGTH", "KCP_TAX_NUMBER_LENGTH", "validateKcpBirthDateOrTaxNumber", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "birthDateOrTaxNumber", "validateKcpCardPassword", "cardPassword", "card_release"})
public final class KcpValidationUtils {
    @NotNull
    public static final KcpValidationUtils INSTANCE = new KcpValidationUtils();
    public static final int KCP_BIRTH_DATE_LENGTH = 6;
    @NotNull
    private static final String KCP_BIRTH_DATE_FORMAT = "yyMMdd";
    private static final int KCP_TAX_NUMBER_LENGTH = 10;
    private static final int KCP_CARD_PASSWORD_REQUIRED_LENGTH = 2;

    private KcpValidationUtils() {
    }

    @NotNull
    public final FieldState<String> validateKcpBirthDateOrTaxNumber(@NotNull String birthDateOrTaxNumber) {
        Intrinsics.checkNotNullParameter((Object)birthDateOrTaxNumber, (String)"birthDateOrTaxNumber");
        int inputLength = birthDateOrTaxNumber.length();
        Validation validation = inputLength == 6 && DateUtils.INSTANCE.matchesFormat(birthDateOrTaxNumber, KCP_BIRTH_DATE_FORMAT) ? (Validation)Validation.Valid.INSTANCE : (inputLength == 10 ? (Validation)Validation.Valid.INSTANCE : (Validation)new Validation.Invalid(R.string.checkout_kcp_birth_date_or_tax_number_invalid, false, 2, null));
        return new FieldState((Object)birthDateOrTaxNumber, validation);
    }

    @NotNull
    public final FieldState<String> validateKcpCardPassword(@NotNull String cardPassword) {
        Intrinsics.checkNotNullParameter((Object)cardPassword, (String)"cardPassword");
        Validation validation = cardPassword.length() == 2 ? (Validation)Validation.Valid.INSTANCE : (Validation)new Validation.Invalid(R.string.checkout_kcp_password_invalid, false, 2, null);
        return new FieldState((Object)cardPassword, validation);
    }
}

