/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.util;

import android.content.Context;
import com.adyen.checkout.card.InstallmentConfiguration;
import com.adyen.checkout.card.InstallmentOptions;
import com.adyen.checkout.card.R;
import com.adyen.checkout.card.internal.ui.model.InstallmentOption;
import com.adyen.checkout.card.internal.ui.model.InstallmentOptionParams;
import com.adyen.checkout.card.internal.ui.model.InstallmentParams;
import com.adyen.checkout.card.internal.ui.view.InstallmentModel;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.Installments;
import com.adyen.checkout.components.core.internal.util.CurrencyUtils;
import com.adyen.checkout.components.core.internal.util.NumberExtensionKt;
import com.adyen.checkout.core.CardBrand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u00020\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0004\u00a8\u0006!"}, d2={"Lcom/adyen/checkout/card/internal/util/InstallmentUtils;", "", "()V", "areInstallmentValuesValid", "", "installmentConfiguration", "Lcom/adyen/checkout/card/InstallmentConfiguration;", "getTextForInstallmentOption", "", "context", "Landroid/content/Context;", "installmentModel", "Lcom/adyen/checkout/card/internal/ui/view/InstallmentModel;", "isCardBasedOptionsValid", "cardBasedInstallmentOptions", "", "Lcom/adyen/checkout/card/InstallmentOptions$CardBasedInstallmentOptions;", "makeInstallmentModelList", "installmentOptions", "Lcom/adyen/checkout/card/internal/ui/model/InstallmentOptionParams;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "shopperLocale", "Ljava/util/Locale;", "showAmount", "makeInstallmentModelObject", "Lcom/adyen/checkout/components/core/Installments;", "makeInstallmentOptions", "installmentParams", "Lcom/adyen/checkout/card/internal/ui/model/InstallmentParams;", "cardBrand", "Lcom/adyen/checkout/core/CardBrand;", "isCardTypeReliable", "card_release"})
@SourceDebugExtension(value={"SMAP\nInstallmentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallmentUtils.kt\ncom/adyen/checkout/card/internal/util/InstallmentUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,180:1\n1755#2,3:181\n295#2,2:184\n1557#2:186\n1628#2,3:187\n1485#2:190\n1510#2,3:191\n1513#2,3:201\n1755#2,3:204\n1755#2,2:207\n1755#2,3:209\n1757#2:212\n381#3,7:194\n*S KotlinDebug\n*F\n+ 1 InstallmentUtils.kt\ncom/adyen/checkout/card/internal/util/InstallmentUtils\n*L\n42#1:181,3\n47#1:184,2\n97#1:186\n97#1:187,3\n160#1:190\n160#1:191,3\n160#1:201,3\n162#1:204,3\n174#1:207,2\n175#1:209,3\n174#1:212\n160#1:194,7\n*E\n"})
public final class InstallmentUtils {
    @NotNull
    public static final InstallmentUtils INSTANCE = new InstallmentUtils();

    private InstallmentUtils() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<InstallmentModel> makeInstallmentOptions(@Nullable InstallmentParams installmentParams, @Nullable CardBrand cardBrand, boolean isCardTypeReliable) {
        block10: {
            block8: {
                if (installmentParams == null) break block10;
                params = installmentParams;
                $i$a$-let-InstallmentUtils$makeInstallmentOptions$1 = false;
                hasCardBasedInstallmentOptions = ((Collection)params.getCardBasedOptions()).isEmpty() == false;
                v0 = params.getDefaultOptions();
                var7_7 = v0 != null ? v0.getValues() : null;
                v1 = hasDefaultInstallmentOptions = (var7_7 == null || var7_7.isEmpty() != false) == false;
                if (!hasCardBasedInstallmentOptions || !isCardTypeReliable) ** GOTO lbl-1000
                $this$any$iv = params.getCardBasedOptions();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (InstallmentOptionParams.CardBasedInstallmentOptions)element$iv;
                        $i$a$-any-InstallmentUtils$makeInstallmentOptions$1$hasOptionsForCardType$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getCardBrand(), (Object)cardBrand)) continue;
                        v2 = true;
                        break block8;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            hasOptionsForCardType = v3;
            if (hasOptionsForCardType) {
                block9: {
                    $this$any$iv = params.getCardBasedOptions();
                    var15_16 = InstallmentUtils.INSTANCE;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (InstallmentOptionParams.CardBasedInstallmentOptions)element$iv;
                        $i$a$-firstOrNull-InstallmentUtils$makeInstallmentOptions$1$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getCardBrand(), (Object)cardBrand)) continue;
                        v4 = element$iv;
                        break block9;
                    }
                    v4 = null;
                }
                v5 = var15_16.makeInstallmentModelList(v4, params.getAmount(), params.getShopperLocale(), params.getShowInstallmentAmount());
            } else {
                v5 = hasDefaultInstallmentOptions != false ? InstallmentUtils.INSTANCE.makeInstallmentModelList(params.getDefaultOptions(), params.getAmount(), params.getShopperLocale(), params.getShowInstallmentAmount()) : CollectionsKt.emptyList();
            }
            return v5;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<InstallmentModel> makeInstallmentModelList(InstallmentOptionParams installmentOptions, Amount amount, Locale shopperLocale, boolean showAmount) {
        void $this$mapTo$iv$iv;
        if (installmentOptions == null) {
            return CollectionsKt.emptyList();
        }
        List installmentOptionsList = new ArrayList();
        InstallmentModel oneTimeOption = new InstallmentModel(null, InstallmentOption.ONE_TIME, amount, shopperLocale, showAmount);
        installmentOptionsList.add(oneTimeOption);
        if (installmentOptions.getIncludeRevolving()) {
            InstallmentModel revolvingOption = new InstallmentModel(1, InstallmentOption.REVOLVING, amount, shopperLocale, showAmount);
            installmentOptionsList.add(revolvingOption);
        }
        Iterable $this$map$iv = installmentOptions.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void numberOfInstallments;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new InstallmentModel((int)numberOfInstallments, InstallmentOption.REGULAR, amount, shopperLocale, showAmount));
        }
        List regularOptions = (List)destination$iv$iv;
        installmentOptionsList.addAll(regularOptions);
        return installmentOptionsList;
    }

    @NotNull
    public final String getTextForInstallmentOption(@NotNull Context context, @Nullable InstallmentModel installmentModel) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InstallmentModel $this$getTextForInstallmentOption_u24lambda_u244 = installmentModel;
        boolean bl = false;
        InstallmentModel installmentModel2 = $this$getTextForInstallmentOption_u24lambda_u244;
        InstallmentOption installmentOption = installmentModel2 != null ? installmentModel2.getOption() : null;
        switch (installmentOption == null ? -1 : WhenMappings.$EnumSwitchMapping$0[installmentOption.ordinal()]) {
            case 1: {
                String string3 = context.getString(R.string.checkout_card_installments_option_one_time);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                break;
            }
            case 2: {
                String string4 = context.getString(R.string.checkout_card_installments_option_revolving);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                break;
            }
            case 3: {
                String string5;
                Integer n = $this$getTextForInstallmentOption_u24lambda_u244.getNumberOfInstallments();
                int numberOfInstallments = n != null ? n : 1;
                Amount amount = $this$getTextForInstallmentOption_u24lambda_u244.getAmount();
                Amount installmentAmount = amount != null ? Amount.copy$default((Amount)amount, null, (long)($this$getTextForInstallmentOption_u24lambda_u244.getAmount().getValue() / (long)numberOfInstallments), (int)1, null) : null;
                String formattedNumberOfInstallments = NumberExtensionKt.formatToLocalizedString((int)numberOfInstallments, (Locale)$this$getTextForInstallmentOption_u24lambda_u244.getShopperLocale());
                if ($this$getTextForInstallmentOption_u24lambda_u244.getShowAmount() && installmentAmount != null) {
                    String formattedInstallmentAmount = CurrencyUtils.INSTANCE.formatAmount(installmentAmount, $this$getTextForInstallmentOption_u24lambda_u244.getShopperLocale());
                    Object[] objectArray = new Object[]{formattedNumberOfInstallments, formattedInstallmentAmount};
                    string5 = context.getString(R.string.checkout_card_installments_option_regular_with_price, objectArray);
                } else {
                    Object[] objectArray = new Object[]{formattedNumberOfInstallments};
                    string5 = context.getString(R.string.checkout_card_installments_option_regular, objectArray);
                }
                String string6 = string5;
                Intrinsics.checkNotNull((Object)string6);
                string2 = string6;
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    @Nullable
    public final Installments makeInstallmentModelObject(@Nullable InstallmentModel installmentModel) {
        Installments installments;
        InstallmentModel installmentModel2 = installmentModel;
        InstallmentOption installmentOption = installmentModel2 != null ? installmentModel2.getOption() : null;
        switch (installmentOption == null ? -1 : WhenMappings.$EnumSwitchMapping$0[installmentOption.ordinal()]) {
            case 2: 
            case 3: {
                installments = new Installments(installmentModel.getOption().getType(), installmentModel.getNumberOfInstallments());
                break;
            }
            default: {
                installments = null;
            }
        }
        return installments;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCardBasedOptionsValid(@Nullable List<InstallmentOptions.CardBasedInstallmentOptions> cardBasedInstallmentOptions) {
        boolean bl;
        void $this$any$iv;
        Iterable $this$groupByTo$iv$iv;
        if (cardBasedInstallmentOptions == null) return true;
        Iterable $this$groupBy$iv = cardBasedInstallmentOptions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            InstallmentOptions.CardBasedInstallmentOptions it = (InstallmentOptions.CardBasedInstallmentOptions)element$iv$iv;
            boolean bl2 = false;
            CardBrand key$iv$iv = it.getCardBrand();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Collection collection = destination$iv$iv.values();
        if (collection == null) return true;
        $this$groupByTo$iv$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            List value = (List)element$iv;
            boolean bl4 = false;
            if (value.size() > 1) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public final boolean areInstallmentValuesValid(@NotNull InstallmentConfiguration installmentConfiguration) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)installmentConfiguration, (String)"installmentConfiguration");
            List installmentOptions = new ArrayList();
            installmentOptions.add(installmentConfiguration.getDefaultOptions());
            installmentOptions.addAll((Collection)installmentConfiguration.getCardBasedOptions());
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)installmentOptions);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        InstallmentOptions installmentOption = (InstallmentOptions)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = installmentOption.getValues();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                int value = ((Number)element$iv2).intValue();
                                boolean bl4 = false;
                                if (!(value <= 1)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasInvalidValue = bl;
        return !hasInvalidValue;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstallmentOption.values().length];
            try {
                nArray[InstallmentOption.ONE_TIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstallmentOption.REVOLVING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstallmentOption.REGULAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

