/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.util;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.adyen.checkout.card.internal.data.model.Brand;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.card.internal.ui.model.InputFieldUIState;
import com.adyen.checkout.card.internal.util.CardExpiryDateValidation;
import com.adyen.checkout.card.internal.util.CardNumberValidation;
import com.adyen.checkout.card.internal.util.CardSecurityCodeValidation;
import com.adyen.checkout.core.CardBrand;
import com.adyen.checkout.core.internal.ui.model.ExpiryDateExtKt;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.core.ui.model.ExpiryDate;
import com.adyen.checkout.core.ui.validation.CardExpiryDateValidationResult;
import com.adyen.checkout.core.ui.validation.CardExpiryDateValidator;
import com.adyen.checkout.core.ui.validation.CardNumberValidationResult;
import com.adyen.checkout.core.ui.validation.CardNumberValidator;
import com.adyen.checkout.core.ui.validation.CardSecurityCodeValidationResult;
import com.adyen.checkout.core.ui.validation.CardSecurityCodeValidator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\tJ%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001f\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J'\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0002\b\u0013J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001c\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/card/internal/util/CardValidationUtils;", "", "()V", "validateCardNumber", "Lcom/adyen/checkout/card/internal/util/CardNumberValidation;", "validationResult", "Lcom/adyen/checkout/core/ui/validation/CardNumberValidationResult;", "isBrandSupported", "", "validateCardNumber$card_release", "number", "", "enableLuhnCheck", "validateExpiryDate", "Lcom/adyen/checkout/card/internal/util/CardExpiryDateValidation;", "expiryDate", "Lcom/adyen/checkout/core/ui/model/ExpiryDate;", "fieldPolicy", "Lcom/adyen/checkout/card/internal/data/model/Brand$FieldPolicy;", "validateExpiryDate$card_release", "Lcom/adyen/checkout/core/ui/validation/CardExpiryDateValidationResult;", "validateSecurityCode", "Lcom/adyen/checkout/card/internal/util/CardSecurityCodeValidation;", "securityCode", "detectedCardType", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "uiState", "Lcom/adyen/checkout/card/internal/ui/model/InputFieldUIState;", "validateSecurityCode$card_release", "Lcom/adyen/checkout/core/ui/validation/CardSecurityCodeValidationResult;", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CardValidationUtils {
    @NotNull
    public static final CardValidationUtils INSTANCE = new CardValidationUtils();

    private CardValidationUtils() {
    }

    @NotNull
    public final CardNumberValidation validateCardNumber$card_release(@NotNull String number, boolean enableLuhnCheck, boolean isBrandSupported) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        CardNumberValidationResult validation = CardNumberValidator.INSTANCE.validateCardNumber(number, enableLuhnCheck);
        return this.validateCardNumber$card_release(validation, isBrandSupported);
    }

    @VisibleForTesting
    @NotNull
    public final CardNumberValidation validateCardNumber$card_release(@NotNull CardNumberValidationResult validationResult, boolean isBrandSupported) {
        CardNumberValidation cardNumberValidation;
        Intrinsics.checkNotNullParameter((Object)validationResult, (String)"validationResult");
        CardNumberValidationResult cardNumberValidationResult = validationResult;
        if (cardNumberValidationResult instanceof CardNumberValidationResult.Invalid) {
            CardNumberValidationResult cardNumberValidationResult2 = validationResult;
            cardNumberValidation = cardNumberValidationResult2 instanceof CardNumberValidationResult.Invalid.IllegalCharacters ? CardNumberValidation.INVALID_ILLEGAL_CHARACTERS : (cardNumberValidationResult2 instanceof CardNumberValidationResult.Invalid.TooLong ? CardNumberValidation.INVALID_TOO_LONG : (cardNumberValidationResult2 instanceof CardNumberValidationResult.Invalid.TooShort ? CardNumberValidation.INVALID_TOO_SHORT : (cardNumberValidationResult2 instanceof CardNumberValidationResult.Invalid.LuhnCheck ? CardNumberValidation.INVALID_LUHN_CHECK : CardNumberValidation.INVALID_OTHER_REASON)));
        } else if (cardNumberValidationResult instanceof CardNumberValidationResult.Valid) {
            cardNumberValidation = !isBrandSupported ? CardNumberValidation.INVALID_UNSUPPORTED_BRAND : CardNumberValidation.VALID;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return cardNumberValidation;
    }

    @NotNull
    public final CardExpiryDateValidation validateExpiryDate$card_release(@NotNull ExpiryDate expiryDate, @Nullable Brand.FieldPolicy fieldPolicy) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        CardExpiryDateValidationResult result = CardExpiryDateValidator.INSTANCE.validateExpiryDate(expiryDate);
        return this.validateExpiryDate$card_release(expiryDate, result, fieldPolicy);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public final CardExpiryDateValidation validateExpiryDate$card_release(@NotNull ExpiryDate expiryDate, @NotNull CardExpiryDateValidationResult validationResult, @Nullable Brand.FieldPolicy fieldPolicy) {
        CardExpiryDateValidation cardExpiryDateValidation;
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)validationResult, (String)"validationResult");
        CardExpiryDateValidationResult cardExpiryDateValidationResult = validationResult;
        if (cardExpiryDateValidationResult instanceof CardExpiryDateValidationResult.Valid) {
            cardExpiryDateValidation = CardExpiryDateValidation.VALID;
            return cardExpiryDateValidation;
        }
        if (!(cardExpiryDateValidationResult instanceof CardExpiryDateValidationResult.Invalid)) throw new NoWhenBranchMatchedException();
        CardExpiryDateValidationResult cardExpiryDateValidationResult2 = validationResult;
        if (cardExpiryDateValidationResult2 instanceof CardExpiryDateValidationResult.Invalid.TooFarInTheFuture) {
            cardExpiryDateValidation = CardExpiryDateValidation.INVALID_TOO_FAR_IN_THE_FUTURE;
            return cardExpiryDateValidation;
        }
        if (cardExpiryDateValidationResult2 instanceof CardExpiryDateValidationResult.Invalid.TooOld) {
            cardExpiryDateValidation = CardExpiryDateValidation.INVALID_TOO_OLD;
            return cardExpiryDateValidation;
        }
        if (!(cardExpiryDateValidationResult2 instanceof CardExpiryDateValidationResult.Invalid.NonParseableDate)) {
            cardExpiryDateValidation = CardExpiryDateValidation.INVALID_OTHER_REASON;
            return cardExpiryDateValidation;
        }
        if (ExpiryDateExtKt.isEmptyDate((ExpiryDate)expiryDate)) {
            Brand.FieldPolicy fieldPolicy2 = fieldPolicy;
            boolean bl = fieldPolicy2 != null ? !fieldPolicy2.isRequired() : false;
            if (bl) {
                cardExpiryDateValidation = CardExpiryDateValidation.VALID_NOT_REQUIRED;
                return cardExpiryDateValidation;
            }
        }
        cardExpiryDateValidation = CardExpiryDateValidation.INVALID_OTHER_REASON;
        return cardExpiryDateValidation;
    }

    @NotNull
    public final CardSecurityCodeValidation validateSecurityCode$card_release(@NotNull String securityCode, @Nullable DetectedCardType detectedCardType, @NotNull InputFieldUIState uiState) {
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        Intrinsics.checkNotNullParameter((Object)((Object)uiState), (String)"uiState");
        DetectedCardType detectedCardType2 = detectedCardType;
        CardSecurityCodeValidationResult result = CardSecurityCodeValidator.INSTANCE.validateSecurityCode(securityCode, (CardBrand)(detectedCardType2 != null ? detectedCardType2.getCardBrand() : null));
        return this.validateSecurityCode$card_release(securityCode, uiState, result);
    }

    @VisibleForTesting
    @NotNull
    public final CardSecurityCodeValidation validateSecurityCode$card_release(@NotNull String securityCode, @NotNull InputFieldUIState uiState, @NotNull CardSecurityCodeValidationResult validationResult) {
        CardSecurityCodeValidation cardSecurityCodeValidation;
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        Intrinsics.checkNotNullParameter((Object)((Object)uiState), (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)validationResult, (String)"validationResult");
        String normalizedSecurityCode = StringUtil.normalize((String)securityCode, (char[])new char[0]);
        int length = normalizedSecurityCode.length();
        if (uiState == InputFieldUIState.HIDDEN) {
            cardSecurityCodeValidation = CardSecurityCodeValidation.VALID_HIDDEN;
        } else if (uiState == InputFieldUIState.OPTIONAL && length == 0) {
            cardSecurityCodeValidation = CardSecurityCodeValidation.VALID_OPTIONAL_EMPTY;
        } else {
            CardSecurityCodeValidationResult cardSecurityCodeValidationResult = validationResult;
            if (cardSecurityCodeValidationResult instanceof CardSecurityCodeValidationResult.Invalid) {
                cardSecurityCodeValidation = CardSecurityCodeValidation.INVALID;
            } else if (cardSecurityCodeValidationResult instanceof CardSecurityCodeValidationResult.Valid) {
                cardSecurityCodeValidation = CardSecurityCodeValidation.VALID;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cardSecurityCodeValidation;
    }
}

