/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.util;

import com.adyen.checkout.card.internal.ui.model.AddressFieldPolicyParams;
import com.adyen.checkout.ui.core.internal.ui.model.AddressFieldPolicy;
import com.adyen.checkout.ui.core.internal.ui.model.AddressParams;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/card/internal/util/CardAddressValidationUtils;", "", "()V", "isAddressOptional", "", "addressParams", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressParams;", "cardType", "", "Lcom/adyen/checkout/card/internal/ui/model/AddressFieldPolicyParams;", "card_release"})
public final class CardAddressValidationUtils {
    @NotNull
    public static final CardAddressValidationUtils INSTANCE = new CardAddressValidationUtils();

    private CardAddressValidationUtils() {
    }

    public final boolean isAddressOptional(@NotNull AddressParams addressParams, @Nullable String cardType) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)addressParams, (String)"addressParams");
        AddressParams addressParams2 = addressParams;
        if (addressParams2 instanceof AddressParams.FullAddress) {
            AddressFieldPolicy addressFieldPolicy = ((AddressParams.FullAddress)addressParams).getAddressFieldPolicy();
            AddressFieldPolicyParams addressFieldPolicyParams = addressFieldPolicy instanceof AddressFieldPolicyParams ? (AddressFieldPolicyParams)addressFieldPolicy : null;
            bl = addressFieldPolicyParams != null ? Boolean.valueOf(this.isAddressOptional(addressFieldPolicyParams, cardType)) : null;
        } else if (addressParams2 instanceof AddressParams.PostalCode) {
            AddressFieldPolicy addressFieldPolicy = ((AddressParams.PostalCode)addressParams).getAddressFieldPolicy();
            AddressFieldPolicyParams addressFieldPolicyParams = addressFieldPolicy instanceof AddressFieldPolicyParams ? (AddressFieldPolicyParams)addressFieldPolicy : null;
            bl = addressFieldPolicyParams != null ? Boolean.valueOf(this.isAddressOptional(addressFieldPolicyParams, cardType)) : null;
        } else if (Intrinsics.areEqual((Object)addressParams2, (Object)AddressParams.None.INSTANCE)) {
            bl = true;
        } else if (addressParams2 instanceof AddressParams.Lookup) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl != null ? bl : true;
    }

    private final boolean isAddressOptional(AddressFieldPolicyParams $this$isAddressOptional, String cardType) {
        boolean bl;
        AddressFieldPolicyParams addressFieldPolicyParams = $this$isAddressOptional;
        if (addressFieldPolicyParams instanceof AddressFieldPolicyParams.Optional) {
            bl = true;
        } else if (addressFieldPolicyParams instanceof AddressFieldPolicyParams.OptionalForCardTypes) {
            bl = CollectionsKt.contains((Iterable)((AddressFieldPolicyParams.OptionalForCardTypes)$this$isAddressOptional).getBrands(), (Object)cardType);
        } else if (addressFieldPolicyParams instanceof AddressFieldPolicyParams.Required) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

