/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.adyen.checkout.card.R;
import com.adyen.checkout.card.databinding.StoredCardViewBinding;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.card.internal.ui.CardDelegate;
import com.adyen.checkout.card.internal.ui.model.CardInputData;
import com.adyen.checkout.card.internal.ui.model.CardOutputData;
import com.adyen.checkout.card.internal.ui.view.CardNumberInput;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.util.BuildUtils;
import com.adyen.checkout.core.ui.model.ExpiryDate;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.view.RoundCornerImageView;
import com.adyen.checkout.ui.core.internal.ui.view.SecurityCodeInput;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.google.android.material.textfield.TextInputLayout;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0014J\b\u0010\u001e\u001a\u00020\u0014H\u0014J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/StoredCardView;", "Landroid/widget/LinearLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/card/databinding/StoredCardViewBinding;", "cardDelegate", "Lcom/adyen/checkout/card/internal/ui/CardDelegate;", "localizedContext", "getActivity", "Landroid/app/Activity;", "getView", "Landroid/view/View;", "highlightValidationErrors", "", "initLocalizedStrings", "initSecurityCodeInput", "initView", "delegate", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "observeDelegate", "onAttachedToWindow", "onDetachedFromWindow", "outputDataChanged", "cardOutputData", "Lcom/adyen/checkout/card/internal/ui/model/CardOutputData;", "setDetectedCardBrand", "card_release"})
@SourceDebugExtension(value={"SMAP\nStoredCardView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredCardView.kt\ncom/adyen/checkout/card/internal/ui/view/StoredCardView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,178:1\n1#2:179\n254#3:180\n*S KotlinDebug\n*F\n+ 1 StoredCardView.kt\ncom/adyen/checkout/card/internal/ui/view/StoredCardView\n*L\n131#1:180\n*E\n"})
public final class StoredCardView
extends LinearLayout
implements ComponentView {
    @NotNull
    private final StoredCardViewBinding binding;
    private Context localizedContext;
    private CardDelegate cardDelegate;

    @JvmOverloads
    public StoredCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        StoredCardViewBinding storedCardViewBinding = StoredCardViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)storedCardViewBinding, (String)"inflate(...)");
        this.binding = storedCardViewBinding;
        this.setOrientation(1);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_margin);
        this.setPadding(padding, padding, padding, 0);
    }

    public /* synthetic */ StoredCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onAttachedToWindow() {
        block1: {
            super.onAttachedToWindow();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            if (BuildUtils.INSTANCE.isDebugBuild(context)) break block1;
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            Activity activity = this.getActivity(context2);
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.addFlags(8192);
            }
        }
    }

    protected void onDetachedFromWindow() {
        block1: {
            super.onDetachedFromWindow();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            if (BuildUtils.INSTANCE.isDebugBuild(context)) break block1;
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            Activity activity = this.getActivity(context2);
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.clearFlags(8192);
            }
        }
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof CardDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.cardDelegate = (CardDelegate)delegate;
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.observeDelegate((CardDelegate)delegate, coroutineScope);
        this.initSecurityCodeInput();
    }

    private final void initLocalizedStrings(Context localizedContext) {
        TextInputLayout textInputLayout = this.binding.textInputLayoutCardNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardNumber");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout, (int)R.style.AdyenCheckout_Card_CardNumberInput, (Context)localizedContext);
        TextInputLayout textInputLayout2 = this.binding.textInputLayoutExpiryDate;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"textInputLayoutExpiryDate");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout2, (int)R.style.AdyenCheckout_Card_ExpiryDateInput, (Context)localizedContext);
        TextInputLayout textInputLayout3 = this.binding.textInputLayoutSecurityCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"textInputLayoutSecurityCode");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout3, (int)R.style.AdyenCheckout_Card_SecurityCodeInput, (Context)localizedContext);
    }

    private final void observeDelegate(CardDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach(delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<CardOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ StoredCardView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CardOutputData it = (CardOutputData)this.L$0;
                        StoredCardView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CardOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    private final void initSecurityCodeInput() {
        block2: {
            TextInputLayout textInputLayout;
            SecurityCodeInput securityCodeEditText;
            EditText editText = this.binding.textInputLayoutSecurityCode.getEditText();
            SecurityCodeInput securityCodeInput = securityCodeEditText = editText instanceof SecurityCodeInput ? (SecurityCodeInput)editText : null;
            if (securityCodeInput != null) {
                securityCodeInput.setOnChangeListener(arg_0 -> StoredCardView.initSecurityCodeInput$lambda$1(this, arg_0));
            }
            SecurityCodeInput securityCodeInput2 = securityCodeEditText;
            if (securityCodeInput2 != null) {
                securityCodeInput2.setOnFocusChangeListener((arg_0, arg_1) -> StoredCardView.initSecurityCodeInput$lambda$2(this, arg_0, arg_1));
            }
            TextInputLayout it = textInputLayout = this.binding.textInputLayoutSecurityCode;
            boolean bl = false;
            View $this$isVisible$iv = (View)this;
            boolean $i$f$isVisible = false;
            Object object = $this$isVisible$iv.getVisibility() == 0 ? textInputLayout : null;
            if (object == null) break block2;
            object.requestFocus();
        }
    }

    private final void outputDataChanged(CardOutputData cardOutputData) {
        CardNumberInput cardNumberInput = this.binding.editTextCardNumber;
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        Object[] objectArray = new Object[]{cardOutputData.getCardNumberState().getValue()};
        cardNumberInput.setText(context.getString(R.string.card_number_4digit, objectArray));
        this.binding.editTextExpiryDate.setDate((ExpiryDate)cardOutputData.getExpiryDateState().getValue());
        this.setDetectedCardBrand(cardOutputData);
    }

    private final void setDetectedCardBrand(CardOutputData cardOutputData) {
        List<DetectedCardType> detectedCardTypes = cardOutputData.getDetectedCardTypes();
        if (!((Collection)detectedCardTypes).isEmpty()) {
            this.binding.cardBrandLogoImageViewPrimary.setStrokeWidth(4.0f);
            RoundCornerImageView roundCornerImageView = this.binding.cardBrandLogoImageViewPrimary;
            Intrinsics.checkNotNullExpressionValue((Object)roundCornerImageView, (String)"cardBrandLogoImageViewPrimary");
            ImageView imageView = (ImageView)roundCornerImageView;
            CardDelegate cardDelegate = this.cardDelegate;
            if (cardDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
                cardDelegate = null;
            }
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)cardDelegate.getComponentParams().getEnvironment(), (String)detectedCardTypes.get(0).getCardBrand().getTxVariant(), null, null, null, (int)R.drawable.ic_card, (int)R.drawable.ic_card, (int)28, null);
        }
    }

    public void highlightValidationErrors() {
        CardDelegate cardDelegate = this.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        CardOutputData it = cardDelegate.getOutputData();
        boolean bl = false;
        Validation securityCodeValidation = it.getSecurityCodeState().getValidation();
        if (securityCodeValidation instanceof Validation.Invalid) {
            this.binding.textInputLayoutSecurityCode.requestFocus();
            TextInputLayout textInputLayout = this.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)securityCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    private final Activity getActivity(Context context) {
        Activity activity;
        Context context2 = context;
        if (context2 instanceof Activity) {
            activity = (Activity)context;
        } else if (context2 instanceof ContextWrapper) {
            Context context3 = ((ContextWrapper)context).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getBaseContext(...)");
            activity = this.getActivity(context3);
        } else {
            activity = null;
        }
        return activity;
    }

    @JvmOverloads
    public StoredCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StoredCardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initSecurityCodeInput$lambda$1(StoredCardView this$0, Editable editable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(editable){
            final /* synthetic */ Editable $editable;
            {
                this.$editable = $editable;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setSecurityCode(this.$editable.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initSecurityCodeInput$lambda$2(StoredCardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation securityCodeValidation = cardDelegate.getOutputData().getSecurityCodeState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (securityCodeValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)securityCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    public static final /* synthetic */ void access$outputDataChanged(StoredCardView $this, CardOutputData cardOutputData) {
        $this.outputDataChanged(cardOutputData);
    }
}

