/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.model;

import com.adyen.checkout.card.AddressConfiguration;
import com.adyen.checkout.card.CardConfiguration;
import com.adyen.checkout.card.CardConfigurationKt;
import com.adyen.checkout.card.KCPAuthVisibility;
import com.adyen.checkout.card.SocialSecurityNumberVisibility;
import com.adyen.checkout.card.internal.ui.model.AddressFieldPolicyParams;
import com.adyen.checkout.card.internal.ui.model.CVCVisibility;
import com.adyen.checkout.card.internal.ui.model.CardComponentParams;
import com.adyen.checkout.card.internal.ui.model.InstallmentParams;
import com.adyen.checkout.card.internal.ui.model.InstallmentsParamsMapper;
import com.adyen.checkout.card.internal.ui.model.RestrictedCardType;
import com.adyen.checkout.card.internal.ui.model.StoredCVCVisibility;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutConfiguration;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.StoredPaymentMethod;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParamsMapper;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParamsMapperData;
import com.adyen.checkout.components.core.internal.ui.model.DropInOverrideParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.CardBrand;
import com.adyen.checkout.ui.core.internal.ui.model.AddressFieldPolicy;
import com.adyen.checkout.ui.core.internal.ui.model.AddressParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020!J8\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J6\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\f\u0010%\u001a\u00020&*\u00020'H\u0002J\f\u0010(\u001a\u00020)*\u00020*H\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper;", "", "commonComponentParamsMapper", "Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParamsMapper;", "installmentsParamsMapper", "Lcom/adyen/checkout/card/internal/ui/model/InstallmentsParamsMapper;", "(Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParamsMapper;Lcom/adyen/checkout/card/internal/ui/model/InstallmentsParamsMapper;)V", "getInstallmentParams", "Lcom/adyen/checkout/card/internal/ui/model/InstallmentParams;", "sessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "cardConfiguration", "Lcom/adyen/checkout/card/CardConfiguration;", "amount", "Lcom/adyen/checkout/components/core/Amount;", "shopperLocale", "Ljava/util/Locale;", "getStorePaymentFieldVisible", "", "getSupportedCardBrands", "", "Lcom/adyen/checkout/core/CardBrand;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "mapToParams", "Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;", "checkoutConfiguration", "Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "deviceLocale", "dropInOverrideParams", "Lcom/adyen/checkout/components/core/internal/ui/model/DropInOverrideParams;", "componentSessionParams", "storedPaymentMethod", "Lcom/adyen/checkout/components/core/StoredPaymentMethod;", "commonComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParams;", "mapToParamsInternal", "mapToAddressParam", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressParams;", "Lcom/adyen/checkout/card/AddressConfiguration;", "mapToAddressParamFieldPolicy", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressFieldPolicy;", "Lcom/adyen/checkout/card/AddressConfiguration$CardAddressFieldPolicy;", "removeRestrictedCards", "card_release"})
@SourceDebugExtension(value={"SMAP\nCardComponentParamsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardComponentParamsMapper.kt\ncom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n16#2,17:236\n16#2,17:253\n16#2,17:274\n1557#3:270\n1628#3,3:271\n774#3:291\n865#3,2:292\n*S KotlinDebug\n*F\n+ 1 CardComponentParamsMapper.kt\ncom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper\n*L\n142#1:236,17\n147#1:253,17\n154#1:274,17\n148#1:270\n148#1:271,3\n161#1:291\n161#1:292,2\n*E\n"})
public final class CardComponentParamsMapper {
    @NotNull
    private final CommonComponentParamsMapper commonComponentParamsMapper;
    @NotNull
    private final InstallmentsParamsMapper installmentsParamsMapper;

    public CardComponentParamsMapper(@NotNull CommonComponentParamsMapper commonComponentParamsMapper, @NotNull InstallmentsParamsMapper installmentsParamsMapper) {
        Intrinsics.checkNotNullParameter((Object)commonComponentParamsMapper, (String)"commonComponentParamsMapper");
        Intrinsics.checkNotNullParameter((Object)installmentsParamsMapper, (String)"installmentsParamsMapper");
        this.commonComponentParamsMapper = commonComponentParamsMapper;
        this.installmentsParamsMapper = installmentsParamsMapper;
    }

    @NotNull
    public final CardComponentParams mapToParams(@NotNull CheckoutConfiguration checkoutConfiguration, @NotNull Locale deviceLocale, @Nullable DropInOverrideParams dropInOverrideParams, @Nullable SessionParams componentSessionParams, @NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)checkoutConfiguration, (String)"checkoutConfiguration");
        Intrinsics.checkNotNullParameter((Object)deviceLocale, (String)"deviceLocale");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        return this.mapToParamsInternal(checkoutConfiguration, deviceLocale, dropInOverrideParams, componentSessionParams, paymentMethod);
    }

    @NotNull
    public final CardComponentParams mapToParams(@NotNull CheckoutConfiguration checkoutConfiguration, @NotNull Locale deviceLocale, @Nullable DropInOverrideParams dropInOverrideParams, @Nullable SessionParams componentSessionParams, @NotNull StoredPaymentMethod storedPaymentMethod) {
        Intrinsics.checkNotNullParameter((Object)checkoutConfiguration, (String)"checkoutConfiguration");
        Intrinsics.checkNotNullParameter((Object)deviceLocale, (String)"deviceLocale");
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        return this.mapToParamsInternal(checkoutConfiguration, deviceLocale, dropInOverrideParams, componentSessionParams, null);
    }

    private final CardComponentParams mapToParamsInternal(CheckoutConfiguration checkoutConfiguration, Locale deviceLocale, DropInOverrideParams dropInOverrideParams, SessionParams componentSessionParams, PaymentMethod paymentMethod) {
        CommonComponentParamsMapperData commonComponentParamsMapperData = this.commonComponentParamsMapper.mapToParams(checkoutConfiguration, deviceLocale, dropInOverrideParams, componentSessionParams);
        CardConfiguration cardConfiguration = CardConfigurationKt.getCardConfiguration(checkoutConfiguration);
        return this.mapToParams(commonComponentParamsMapperData.getCommonComponentParams(), commonComponentParamsMapperData.getSessionParams(), dropInOverrideParams, cardConfiguration, paymentMethod);
    }

    private final CardComponentParams mapToParams(CommonComponentParams commonComponentParams, SessionParams sessionParams, DropInOverrideParams dropInOverrideParams, CardConfiguration cardConfiguration, PaymentMethod paymentMethod) {
        Object object;
        Object object2;
        boolean bl;
        Object object3 = cardConfiguration;
        boolean bl2 = object3 != null && (object3 = ((CardConfiguration)object3).isHolderNameRequired()) != null ? (Boolean)object3 : false;
        DropInOverrideParams dropInOverrideParams2 = dropInOverrideParams;
        if (dropInOverrideParams2 != null) {
            bl = dropInOverrideParams2.isSubmitButtonVisible();
        } else {
            CardConfiguration cardConfiguration2 = cardConfiguration;
            Boolean bl3 = cardConfiguration2 != null ? cardConfiguration2.isSubmitButtonVisible() : null;
            bl = bl3 != null ? bl3 : true;
        }
        boolean bl4 = bl;
        List<CardBrand> list = this.getSupportedCardBrands(cardConfiguration, paymentMethod);
        CardConfiguration cardConfiguration3 = cardConfiguration;
        String string2 = cardConfiguration3 != null ? cardConfiguration3.getShopperReference() : null;
        boolean bl5 = this.getStorePaymentFieldVisible(sessionParams, cardConfiguration);
        Object object4 = cardConfiguration;
        if (object4 == null || (object4 = object4.getSocialSecurityNumberVisibility()) == null) {
            object4 = object2 = SocialSecurityNumberVisibility.HIDE;
        }
        if ((object = cardConfiguration) == null || (object = object.getKcpAuthVisibility()) == null) {
            object = KCPAuthVisibility.HIDE;
        }
        Object object5 = object;
        InstallmentParams installmentParams = this.getInstallmentParams(sessionParams, cardConfiguration, commonComponentParams.getAmount(), commonComponentParams.getShopperLocale());
        Object object6 = cardConfiguration;
        if (object6 == null || (object6 = ((CardConfiguration)object6).getAddressConfiguration()) == null || (object6 = this.mapToAddressParam((AddressConfiguration)object6)) == null) {
            object6 = (AddressParams)AddressParams.None.INSTANCE;
        }
        Object object7 = object6;
        CardConfiguration cardConfiguration4 = cardConfiguration;
        CVCVisibility cVCVisibility = (cardConfiguration4 != null ? Intrinsics.areEqual((Object)cardConfiguration4.isHideCvc(), (Object)true) : false) ? CVCVisibility.ALWAYS_HIDE : CVCVisibility.ALWAYS_SHOW;
        CardConfiguration cardConfiguration5 = cardConfiguration;
        StoredCVCVisibility storedCVCVisibility = (cardConfiguration5 != null ? Intrinsics.areEqual((Object)cardConfiguration5.isHideCvcStoredCard(), (Object)true) : false) ? StoredCVCVisibility.HIDE : StoredCVCVisibility.SHOW;
        return new CardComponentParams(commonComponentParams, bl4, bl2, list, string2, bl5, (SocialSecurityNumberVisibility)((Object)object2), (KCPAuthVisibility)((Object)object5), installmentParams, (AddressParams)object7, cVCVisibility, storedCVCVisibility);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CardBrand> getSupportedCardBrands(CardConfiguration cardConfiguration, PaymentMethod paymentMethod) {
        List list;
        Object $this$adyenLog_u24default$iv;
        CardConfiguration cardConfiguration2 = cardConfiguration;
        List supportedCardBrands = cardConfiguration2 != null ? cardConfiguration2.getSupportedCardBrands() : null;
        CardComponentParamsMapper cardComponentParamsMapper = this;
        Object object = supportedCardBrands;
        if (!(object == null || object.isEmpty())) {
            object = this;
            AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                CardComponentParamsMapper cardComponentParamsMapper2 = cardComponentParamsMapper;
                boolean bl = false;
                String string3 = "Reading supportedCardTypes from configuration";
                cardComponentParamsMapper = cardComponentParamsMapper2;
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            list = supportedCardBrands;
        } else {
            CardComponentParamsMapper $this$map$iv;
            PaymentMethod paymentMethod2 = paymentMethod;
            List list2 = paymentMethod2 != null ? paymentMethod2.getBrands() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!((Collection)list2).isEmpty()) {
                void $this$mapTo$iv$iv;
                CardComponentParamsMapper cardComponentParamsMapper3;
                CardComponentParamsMapper cardComponentParamsMapper4;
                Object object2;
                $this$adyenLog_u24default$iv = this;
                AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
                CardComponentParamsMapper throwable$iv = null;
                boolean $i$f$adyenLog = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                    String tag$iv;
                    String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    AdyenLogLevel adyenLogLevel = level$iv;
                    object2 = AdyenLogger.Companion.getLogger();
                    cardComponentParamsMapper4 = cardComponentParamsMapper;
                    boolean bl = false;
                    String string5 = "Reading supportedCardTypes from API brands";
                    cardComponentParamsMapper3 = cardComponentParamsMapper4;
                    object2.log(adyenLogLevel, string4, string5, (Throwable)((Object)throwable$iv));
                }
                PaymentMethod paymentMethod3 = paymentMethod;
                List list3 = paymentMethod3 != null ? paymentMethod3.getBrands() : null;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                $this$adyenLog_u24default$iv = list3;
                cardComponentParamsMapper4 = cardComponentParamsMapper3;
                boolean $i$f$map = false;
                throwable$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String bl = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl2 = false;
                    object2.add(new CardBrand((String)it));
                }
                list = (List)destination$iv$iv;
                cardComponentParamsMapper = cardComponentParamsMapper4;
            } else {
                $this$map$iv = this;
                AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
                Throwable throwable$iv = null;
                boolean $i$f$adyenLog = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                    String tag$iv;
                    String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    String string6 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    AdyenLogLevel adyenLogLevel = level$iv;
                    AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                    CardComponentParamsMapper cardComponentParamsMapper5 = cardComponentParamsMapper;
                    boolean bl = false;
                    String string7 = "Falling back to CardConfiguration.DEFAULT_SUPPORTED_CARDS_LIST";
                    cardComponentParamsMapper = cardComponentParamsMapper5;
                    adyenLogger.log(adyenLogLevel, string6, string7, throwable$iv);
                }
                list = CardConfiguration.Companion.getDEFAULT_SUPPORTED_CARDS_LIST();
            }
        }
        return cardComponentParamsMapper.removeRestrictedCards(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CardBrand> removeRestrictedCards(List<CardBrand> $this$removeRestrictedCards) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$removeRestrictedCards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CardBrand it = (CardBrand)element$iv$iv;
            boolean bl = false;
            if (!(!RestrictedCardType.Companion.isRestrictedCardType(it.getTxVariant()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean getStorePaymentFieldVisible(SessionParams sessionParams, CardConfiguration cardConfiguration) {
        boolean bl;
        Object object = sessionParams;
        if (object != null && (object = object.getEnableStoreDetails()) != null) {
            bl = (Boolean)object;
        } else {
            CardConfiguration cardConfiguration2 = cardConfiguration;
            Boolean bl2 = cardConfiguration2 != null ? cardConfiguration2.isStorePaymentFieldVisible() : null;
            bl = bl2 != null ? bl2 : true;
        }
        return bl;
    }

    private final InstallmentParams getInstallmentParams(SessionParams sessionParams, CardConfiguration cardConfiguration, Amount amount, Locale shopperLocale) {
        InstallmentParams installmentParams;
        if (sessionParams != null) {
            installmentParams = this.installmentsParamsMapper.mapToInstallmentParams$card_release(sessionParams.getInstallmentConfiguration(), amount, shopperLocale);
        } else {
            CardConfiguration cardConfiguration2 = cardConfiguration;
            installmentParams = this.installmentsParamsMapper.mapToInstallmentParams$card_release(cardConfiguration2 != null ? cardConfiguration2.getInstallmentConfiguration() : null, amount, shopperLocale);
        }
        return installmentParams;
    }

    private final AddressParams mapToAddressParam(AddressConfiguration $this$mapToAddressParam) {
        AddressParams addressParams;
        AddressConfiguration addressConfiguration = $this$mapToAddressParam;
        if (addressConfiguration instanceof AddressConfiguration.FullAddress) {
            addressParams = (AddressParams)new AddressParams.FullAddress(((AddressConfiguration.FullAddress)$this$mapToAddressParam).getDefaultCountryCode(), ((AddressConfiguration.FullAddress)$this$mapToAddressParam).getSupportedCountryCodes(), this.mapToAddressParamFieldPolicy(((AddressConfiguration.FullAddress)$this$mapToAddressParam).getAddressFieldPolicy()));
        } else if (Intrinsics.areEqual((Object)addressConfiguration, (Object)AddressConfiguration.None.INSTANCE)) {
            addressParams = (AddressParams)AddressParams.None.INSTANCE;
        } else if (addressConfiguration instanceof AddressConfiguration.PostalCode) {
            addressParams = (AddressParams)new AddressParams.PostalCode(this.mapToAddressParamFieldPolicy(((AddressConfiguration.PostalCode)$this$mapToAddressParam).getAddressFieldPolicy()));
        } else if (addressConfiguration instanceof AddressConfiguration.Lookup) {
            addressParams = (AddressParams)new AddressParams.Lookup();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return addressParams;
    }

    private final AddressFieldPolicy mapToAddressParamFieldPolicy(AddressConfiguration.CardAddressFieldPolicy $this$mapToAddressParamFieldPolicy) {
        AddressFieldPolicy addressFieldPolicy;
        AddressConfiguration.CardAddressFieldPolicy cardAddressFieldPolicy = $this$mapToAddressParamFieldPolicy;
        if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.Optional) {
            addressFieldPolicy = AddressFieldPolicyParams.Optional.INSTANCE;
        } else if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.OptionalForCardTypes) {
            addressFieldPolicy = new AddressFieldPolicyParams.OptionalForCardTypes(((AddressConfiguration.CardAddressFieldPolicy.OptionalForCardTypes)$this$mapToAddressParamFieldPolicy).getBrands());
        } else if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.Required) {
            addressFieldPolicy = AddressFieldPolicyParams.Required.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return addressFieldPolicy;
    }
}

