/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.card.R;
import com.adyen.checkout.card.internal.util.CardExpiryDateValidation;
import com.adyen.checkout.card.internal.util.CardNumberValidation;
import com.adyen.checkout.card.internal.util.CardSecurityCodeValidation;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.core.ui.model.ExpiryDate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/adyen/checkout/card/internal/ui/CardValidationMapper;", "", "()V", "mapCardNumberValidation", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "", "cardNumber", "validation", "Lcom/adyen/checkout/card/internal/util/CardNumberValidation;", "mapExpiryDateValidation", "Lcom/adyen/checkout/core/ui/model/ExpiryDate;", "expiryDate", "validationResult", "Lcom/adyen/checkout/card/internal/util/CardExpiryDateValidation;", "mapSecurityCodeValidation", "securityCode", "Lcom/adyen/checkout/card/internal/util/CardSecurityCodeValidation;", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CardValidationMapper {
    @NotNull
    public final FieldState<String> mapCardNumberValidation(@NotNull String cardNumber, @NotNull CardNumberValidation validation) {
        Validation validation2;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkNotNullParameter((Object)((Object)validation), (String)"validation");
        switch (WhenMappings.$EnumSwitchMapping$0[validation.ordinal()]) {
            case 1: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_number_not_valid, false, 2, null);
                break;
            }
            case 2: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_number_not_valid, false, 2, null);
                break;
            }
            case 3: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_number_not_valid, false, 2, null);
                break;
            }
            case 4: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_brand_not_supported, true);
                break;
            }
            case 5: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_number_not_valid, false, 2, null);
                break;
            }
            case 6: {
                validation2 = (Validation)new Validation.Invalid(R.string.checkout_card_number_not_valid, false, 2, null);
                break;
            }
            case 7: {
                validation2 = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Validation fieldStateValidation = validation2;
        return new FieldState((Object)cardNumber, fieldStateValidation);
    }

    @NotNull
    public final FieldState<ExpiryDate> mapExpiryDateValidation(@NotNull ExpiryDate expiryDate, @NotNull CardExpiryDateValidation validationResult) {
        Validation validation;
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)((Object)validationResult), (String)"validationResult");
        switch (WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()]) {
            case 1: {
                validation = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            case 2: {
                validation = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            case 3: {
                validation = (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid_too_far_in_future, false, 2, null);
                break;
            }
            case 4: {
                validation = (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid_too_old, false, 2, null);
                break;
            }
            case 5: {
                validation = (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid, false, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Validation validation2 = validation;
        return new FieldState((Object)expiryDate, validation2);
    }

    @NotNull
    public final FieldState<String> mapSecurityCodeValidation(@NotNull String securityCode, @NotNull CardSecurityCodeValidation validationResult) {
        Validation validation;
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        Intrinsics.checkNotNullParameter((Object)((Object)validationResult), (String)"validationResult");
        String normalizedSecurityCode = StringUtil.normalize((String)securityCode, (char[])new char[0]);
        switch (WhenMappings.$EnumSwitchMapping$2[validationResult.ordinal()]) {
            case 1: {
                validation = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            case 2: {
                validation = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            case 3: {
                validation = (Validation)Validation.Valid.INSTANCE;
                break;
            }
            case 4: {
                validation = (Validation)new Validation.Invalid(R.string.checkout_security_code_not_valid, false, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Validation validation2 = validation;
        return new FieldState((Object)normalizedSecurityCode, validation2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[CardNumberValidation.values().length];
            try {
                nArray[CardNumberValidation.INVALID_ILLEGAL_CHARACTERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.INVALID_TOO_SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.INVALID_TOO_LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.INVALID_UNSUPPORTED_BRAND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.INVALID_LUHN_CHECK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.INVALID_OTHER_REASON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardNumberValidation.VALID.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardExpiryDateValidation.values().length];
            try {
                nArray[CardExpiryDateValidation.VALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardExpiryDateValidation.VALID_NOT_REQUIRED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardExpiryDateValidation.INVALID_TOO_FAR_IN_THE_FUTURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardExpiryDateValidation.INVALID_TOO_OLD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardExpiryDateValidation.INVALID_OTHER_REASON.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CardSecurityCodeValidation.values().length];
            try {
                nArray[CardSecurityCodeValidation.VALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardSecurityCodeValidation.VALID_HIDDEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardSecurityCodeValidation.VALID_OPTIONAL_EMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardSecurityCodeValidation.INVALID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

