/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.card.KCPAuthVisibility;
import com.adyen.checkout.card.SocialSecurityNumberVisibility;
import com.adyen.checkout.card.internal.ui.CardConfigDataGenerator;
import com.adyen.checkout.card.internal.ui.model.CVCVisibility;
import com.adyen.checkout.card.internal.ui.model.CardComponentParams;
import com.adyen.checkout.card.internal.ui.model.StoredCVCVisibility;
import com.adyen.checkout.ui.core.internal.ui.model.AddressParams;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/adyen/checkout/card/internal/ui/CardConfigDataGenerator;", "", "()V", "generate", "", "", "configuration", "Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;", "isStored", "", "getBillingAddressMode", "addressParams", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressParams;", "getHideCVC", "getShowKCPType", "kcpAuthVisibility", "Lcom/adyen/checkout/card/KCPAuthVisibility;", "getSocialSecurityNumberMode", "socialSecurityNumberVisibility", "Lcom/adyen/checkout/card/SocialSecurityNumberVisibility;", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CardConfigDataGenerator {
    @NotNull
    public final Map<String, String> generate(@NotNull CardComponentParams configuration, boolean isStored) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Map $this$generate_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        if (configuration.getAddressParams() instanceof AddressParams.FullAddress) {
            String countryList = CollectionsKt.joinToString$default((Iterable)((AddressParams.FullAddress)configuration.getAddressParams()).getSupportedCountryCodes(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            $this$generate_u24lambda_u240.put("billingAddressAllowedCountries", countryList);
        }
        $this$generate_u24lambda_u240.put("billingAddressMode", this.getBillingAddressMode(configuration.getAddressParams()));
        $this$generate_u24lambda_u240.put("billingAddressRequired", String.valueOf(!(configuration.getAddressParams() instanceof AddressParams.None)));
        $this$generate_u24lambda_u240.put("brands", CollectionsKt.joinToString$default((Iterable)configuration.getSupportedCardBrands(), (CharSequence)",", null, null, (int)0, null, (Function1)generate.1.1.INSTANCE, (int)30, null));
        $this$generate_u24lambda_u240.put("enableStoreDetails", String.valueOf(configuration.isStorePaymentFieldVisible()));
        $this$generate_u24lambda_u240.put("hasHolderName", String.valueOf(configuration.isHolderNameRequired()));
        $this$generate_u24lambda_u240.put("hasInstallmentOptions", String.valueOf(configuration.getInstallmentParams() != null));
        $this$generate_u24lambda_u240.put("hideCVC", this.getHideCVC(configuration, isStored));
        $this$generate_u24lambda_u240.put("holderNameRequired", String.valueOf(configuration.isHolderNameRequired()));
        if (configuration.getInstallmentParams() != null) {
            $this$generate_u24lambda_u240.put("showInstallmentAmounts", String.valueOf(configuration.getInstallmentParams().getShowInstallmentAmount()));
        }
        $this$generate_u24lambda_u240.put("showKCPType", this.getShowKCPType(configuration.getKcpAuthVisibility()));
        $this$generate_u24lambda_u240.put("showPayButton", String.valueOf(configuration.isSubmitButtonVisible()));
        $this$generate_u24lambda_u240.put("socialSecurityNumberMode", this.getSocialSecurityNumberMode(configuration.getSocialSecurityNumberVisibility()));
        return MapsKt.build((Map)map2);
    }

    private final String getBillingAddressMode(AddressParams addressParams) {
        String string2;
        AddressParams addressParams2 = addressParams;
        if (addressParams2 instanceof AddressParams.FullAddress) {
            string2 = "full";
        } else if (addressParams2 instanceof AddressParams.Lookup) {
            string2 = "lookup";
        } else if (Intrinsics.areEqual((Object)addressParams2, (Object)AddressParams.None.INSTANCE)) {
            string2 = "none";
        } else if (addressParams2 instanceof AddressParams.PostalCode) {
            string2 = "partial";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private final String getHideCVC(CardComponentParams configuration, boolean isStored) {
        String string2;
        block10: {
            block9: {
                if (!isStored) break block9;
                switch (WhenMappings.$EnumSwitchMapping$0[configuration.getStoredCVCVisibility().ordinal()]) {
                    case 1: {
                        string2 = "show";
                        break block10;
                    }
                    case 2: {
                        string2 = "hide";
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[configuration.getCvcVisibility().ordinal()]) {
                case 1: {
                    string2 = "show";
                    break;
                }
                case 2: {
                    string2 = "hide";
                    break;
                }
                case 3: {
                    string2 = "auto";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string2;
    }

    private final String getShowKCPType(KCPAuthVisibility kcpAuthVisibility) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$2[kcpAuthVisibility.ordinal()]) {
            case 1: {
                string2 = "show";
                break;
            }
            case 2: {
                string2 = "hide";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String getSocialSecurityNumberMode(SocialSecurityNumberVisibility socialSecurityNumberVisibility) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$3[socialSecurityNumberVisibility.ordinal()]) {
            case 1: {
                string2 = "show";
                break;
            }
            case 2: {
                string2 = "hide";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[StoredCVCVisibility.values().length];
            try {
                nArray[StoredCVCVisibility.SHOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredCVCVisibility.HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CVCVisibility.values().length];
            try {
                nArray[CVCVisibility.ALWAYS_SHOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVCVisibility.ALWAYS_HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVCVisibility.HIDE_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[KCPAuthVisibility.values().length];
            try {
                nArray[KCPAuthVisibility.SHOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KCPAuthVisibility.HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[SocialSecurityNumberVisibility.values().length];
            try {
                nArray[SocialSecurityNumberVisibility.SHOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocialSecurityNumberVisibility.HIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

