/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.data.api;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.card.internal.data.api.BinLookupService;
import com.adyen.checkout.card.internal.data.api.DefaultDetectCardTypeRepository;
import com.adyen.checkout.card.internal.data.api.DetectCardTypeRepository;
import com.adyen.checkout.card.internal.data.model.BinLookupRequest;
import com.adyen.checkout.card.internal.data.model.BinLookupResponse;
import com.adyen.checkout.card.internal.data.model.BinLookupResult;
import com.adyen.checkout.card.internal.data.model.Brand;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.CardBrand;
import com.adyen.checkout.core.CardType;
import com.adyen.checkout.core.internal.util.Sha256;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0002JB\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016JF\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0082@\u00a2\u0006\u0002\u0010 JB\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0002J@\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0082@\u00a2\u0006\u0002\u0010 J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository;", "Lcom/adyen/checkout/card/internal/data/api/DetectCardTypeRepository;", "cardEncryptor", "Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;", "binLookupService", "Lcom/adyen/checkout/card/internal/data/api/BinLookupService;", "(Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;Lcom/adyen/checkout/card/internal/data/api/BinLookupService;)V", "_detectedCardTypesFlow", "Lkotlinx/coroutines/channels/Channel;", "", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "cachedBinLookup", "Ljava/util/HashMap;", "", "Lcom/adyen/checkout/card/internal/data/model/BinLookupResult;", "Lkotlin/collections/HashMap;", "detectedCardTypesFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetectedCardTypesFlow", "()Lkotlinx/coroutines/flow/Flow;", "detectCardLocally", "cardNumber", "supportedCardBrands", "Lcom/adyen/checkout/core/CardBrand;", "detectCardType", "", "publicKey", "clientKey", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "type", "fetch", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchFromNetwork", "getFromCache", "hashBin", "localDetectedCard", "cardBrand", "makeBinLookup", "Lcom/adyen/checkout/card/internal/data/model/BinLookupResponse;", "mapResponse", "binLookupResponse", "shouldFetchReliableTypes", "", "Companion", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultDetectCardTypeRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDetectCardTypeRepository.kt\ncom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ResultExt.kt\ncom/adyen/checkout/core/internal/util/ResultExtKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n16#2,17:219\n16#2,17:236\n16#2,17:253\n16#2,17:270\n16#2,17:287\n16#2,17:304\n21#2,12:336\n16#2,17:348\n16#2,17:365\n1557#3:321\n1628#3,3:322\n1557#3:327\n1628#3,3:328\n1611#3,9:382\n1863#3:391\n1864#3:393\n1620#3:394\n17#4,2:325\n19#4,4:331\n1#5:335\n1#5:392\n*S KotlinDebug\n*F\n+ 1 DefaultDetectCardTypeRepository.kt\ncom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository\n*L\n52#1:219,17\n56#1:236,17\n62#1:253,17\n66#1:270,17\n91#1:287,17\n109#1:304,17\n183#1:336,12\n188#1:348,17\n189#1:365,17\n114#1:321\n114#1:322,3\n175#1:327\n175#1:328,3\n192#1:382,9\n192#1:391\n192#1:393\n192#1:394\n173#1:325,2\n173#1:331,4\n192#1:392\n*E\n"})
public final class DefaultDetectCardTypeRepository
implements DetectCardTypeRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseCardEncryptor cardEncryptor;
    @NotNull
    private final BinLookupService binLookupService;
    @NotNull
    private final Channel<List<DetectedCardType>> _detectedCardTypesFlow;
    @NotNull
    private final Flow<List<DetectedCardType>> detectedCardTypesFlow;
    @NotNull
    private final HashMap<String, BinLookupResult> cachedBinLookup;
    @NotNull
    private static final Set<CardBrand> NO_CVC_BRANDS;
    private static final int REQUIRED_BIN_SIZE = 11;

    public DefaultDetectCardTypeRepository(@NotNull BaseCardEncryptor cardEncryptor, @NotNull BinLookupService binLookupService) {
        Intrinsics.checkNotNullParameter((Object)cardEncryptor, (String)"cardEncryptor");
        Intrinsics.checkNotNullParameter((Object)binLookupService, (String)"binLookupService");
        this.cardEncryptor = cardEncryptor;
        this.binLookupService = binLookupService;
        this._detectedCardTypesFlow = ChannelExtensionsKt.bufferedChannel();
        this.detectedCardTypesFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._detectedCardTypesFlow));
        this.cachedBinLookup = new HashMap();
    }

    @Override
    @NotNull
    public Flow<List<DetectedCardType>> getDetectedCardTypesFlow() {
        return this.detectedCardTypesFlow;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void detectCardType(@NotNull String cardNumber, @Nullable String publicKey, @NotNull List<CardBrand> supportedCardBrands, @NotNull String clientKey, @NotNull CoroutineScope coroutineScope, @Nullable String type) {
        String string2;
        AdyenLogger adyenLogger;
        Object object;
        String string3;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkNotNullParameter(supportedCardBrands, (String)"supportedCardBrands");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        DefaultDetectCardTypeRepository defaultDetectCardTypeRepository = this;
        Object level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            string3 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            object = level$iv;
            adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            string2 = "detectCardType";
            adyenLogger.log(object, string3, string2, throwable$iv);
        }
        if (this.shouldFetchReliableTypes(cardNumber)) {
            String outerClassName$iv;
            String fullClassName$iv;
            DefaultDetectCardTypeRepository $this$adyenLog_u24default$iv;
            AdyenLogLevel level$iv2;
            BinLookupResult cachedResult = this.getFromCache(cardNumber);
            if (cachedResult instanceof BinLookupResult.Available) {
                level$iv = this;
                level$iv2 = AdyenLogLevel.DEBUG;
                Throwable throwable$iv2 = null;
                boolean $i$f$adyenLog2 = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                    String tag$iv;
                    fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    string3 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    object = level$iv2;
                    adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl = false;
                    string2 = "Retrieving from cache.";
                    adyenLogger.log(object, string3, string2, throwable$iv2);
                }
                this._detectedCardTypesFlow.trySend-JP2dKIU(((BinLookupResult.Available)cachedResult).getDetectedCardTypes());
                return;
            }
            if (cachedResult instanceof BinLookupResult.Loading) {
                $this$adyenLog_u24default$iv = this;
                level$iv2 = AdyenLogLevel.DEBUG;
                Throwable throwable$iv3 = null;
                boolean $i$f$adyenLog3 = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                    String tag$iv;
                    fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    string3 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    object = level$iv2;
                    adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl = false;
                    string2 = "BinLookup request is in progress.";
                    adyenLogger.log(object, string3, string2, throwable$iv3);
                }
            } else if (cachedResult instanceof BinLookupResult.Unavailable) {
                $this$adyenLog_u24default$iv = this;
                level$iv2 = AdyenLogLevel.DEBUG;
                Throwable throwable$iv4 = null;
                boolean $i$f$adyenLog4 = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                    String tag$iv;
                    fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    string3 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    object = level$iv2;
                    adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl = false;
                    string2 = "Fetching from network.";
                    adyenLogger.log(object, string3, string2, throwable$iv4);
                }
                this.fetchFromNetwork(cardNumber, publicKey, supportedCardBrands, clientKey, coroutineScope, type);
            }
        }
        this._detectedCardTypesFlow.trySend-JP2dKIU(this.detectCardLocally(cardNumber, supportedCardBrands));
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchFromNetwork(String cardNumber, String publicKey, List<CardBrand> supportedCardBrands, String clientKey, CoroutineScope coroutineScope, String type) {
        if (publicKey != null) {
            DefaultDetectCardTypeRepository defaultDetectCardTypeRepository = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "Launching Bin Lookup";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cardNumber, publicKey, supportedCardBrands, clientKey, type, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                final /* synthetic */ String $cardNumber;
                final /* synthetic */ String $publicKey;
                final /* synthetic */ List<CardBrand> $supportedCardBrands;
                final /* synthetic */ String $clientKey;
                final /* synthetic */ String $type;
                {
                    this.this$0 = $receiver;
                    this.$cardNumber = $cardNumber;
                    this.$publicKey = $publicKey;
                    this.$supportedCardBrands = $supportedCardBrands;
                    this.$clientKey = $clientKey;
                    this.$type = $type;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            var3_4 = $this$launch;
                            level$iv = AdyenLogLevel.DEBUG;
                            throwable$iv = null;
                            $i$f$adyenLog = false;
                            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                                fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                                Intrinsics.checkNotNull((Object)fullClassName$iv);
                                outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                                var13_14 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 != false ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                                var12_15 = level$iv;
                                var11_16 = AdyenLogger.Companion.getLogger();
                                $i$a$-adyenLog$default-DefaultDetectCardTypeRepository$fetchFromNetwork$2$1 = false;
                                var14_18 = "Emitting new detectedCardTypes";
                                var11_16.log(var12_15, var13_14, var14_18, throwable$iv);
                            }
                            this.label = 1;
                            v0 = DefaultDetectCardTypeRepository.access$fetch(this.this$0, this.$cardNumber, this.$publicKey, this.$supportedCardBrands, this.$clientKey, this.$type, (Continuation)this);
                            if (v0 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl29
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            if ((var3_4 = (List)v0) == null) break;
                            var4_5 = var3_4;
                            var5_6 = this.this$0;
                            it = var4_5;
                            $i$a$-let-DefaultDetectCardTypeRepository$fetchFromNetwork$2$2 = false;
                            this.label = 2;
                            v1 = DefaultDetectCardTypeRepository.access$get_detectedCardTypesFlow$p(var5_6).send((Object)it, (Continuation)this);
                            if (v1 == var15_2) {
                                return var15_2;
                            }
                            break;
                        }
                        case 2: {
                            $i$a$-let-DefaultDetectCardTypeRepository$fetchFromNetwork$2$2 = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedCardType> detectCardLocally(String cardNumber, List<CardBrand> supportedCardBrands) {
        void $this$mapTo$iv$iv;
        Object object;
        DefaultDetectCardTypeRepository defaultDetectCardTypeRepository = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog22 = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            object = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "detectCardLocally";
            object.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        if (((CharSequence)cardNumber).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List estimateCardTypes = CardBrand.Companion.estimate(cardNumber);
        Iterable $this$map$iv = estimateCardTypes;
        boolean $i$f$map = false;
        Iterable $i$f$adyenLog22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CardBrand cardBrand = (CardBrand)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.localDetectedCard((CardBrand)it, supportedCardBrands));
        }
        return (List)destination$iv$iv;
    }

    private final DetectedCardType localDetectedCard(CardBrand cardBrand, List<CardBrand> supportedCardBrands) {
        return new DetectedCardType(cardBrand, false, true, NO_CVC_BRANDS.contains(cardBrand) ? Brand.FieldPolicy.HIDDEN : Brand.FieldPolicy.REQUIRED, Brand.FieldPolicy.REQUIRED, supportedCardBrands.contains(cardBrand), null, null, false, 256, null);
    }

    private final boolean shouldFetchReliableTypes(String cardNumber) {
        return cardNumber.length() >= 11;
    }

    private final BinLookupResult getFromCache(String cardNumber) {
        BinLookupResult binLookupResult = this.cachedBinLookup.get(this.hashBin(cardNumber));
        if (binLookupResult == null) {
            binLookupResult = BinLookupResult.Unavailable.INSTANCE;
        }
        return binLookupResult;
    }

    private final String hashBin(String cardNumber) {
        return Sha256.INSTANCE.hashString(StringsKt.take((String)cardNumber, (int)11));
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetch(String var1_1, String var2_2, List<CardBrand> var3_3, String var4_4, String var5_5, Continuation<? super List<DetectedCardType>> var6_6) {
        if (!(var6_6 instanceof fetch.1)) ** GOTO lbl-1000
        var11_7 = var6_6;
        if ((var11_7.label & -2147483648) != 0) {
            var11_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDetectCardTypeRepository.access$fetch(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                key = this.hashBin((String)cardNumber);
                ((Map)this.cachedBinLookup).put(key, BinLookupResult.Loading.INSTANCE);
                $continuation.L$0 = this;
                $continuation.L$1 = key;
                $continuation.label = 1;
                v0 = this.makeBinLookup((String)cardNumber, (String)publicKey, (List<CardBrand>)supportedCardBrands, (String)clientKey, (String)type, (Continuation<? super BinLookupResponse>)$continuation);
                if (v0 == var12_9) {
                    return var12_9;
                }
                ** GOTO lbl27
            }
            case 1: {
                key = (String)$continuation.L$1;
                this = (DefaultDetectCardTypeRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((binLookupResponse = (BinLookupResponse)v0) == null) {
                    this.cachedBinLookup.remove(key);
                    v1 = null;
                } else {
                    detectedCardTypes = this.mapResponse(binLookupResponse);
                    ((Map)this.cachedBinLookup).put(key, new BinLookupResult.Available(detectedCardTypes));
                    v1 = detectedCardTypes;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeBinLookup(String var1_1, String var2_2, List<CardBrand> var3_3, String var4_4, String var5_5, Continuation<? super BinLookupResponse> var6_6) {
        if (!(var6_6 instanceof makeBinLookup.1)) ** GOTO lbl-1000
        var26_7 = var6_6;
        if ((var26_7.label & -2147483648) != 0) {
            var26_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDetectCardTypeRepository.access$makeBinLookup(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$runSuspendCatching$iv = this;
                $i$f$runSuspendCatching = false;
                $this$makeBinLookup_u24lambda_u248 = $this$runSuspendCatching$iv;
                $i$a$-runSuspendCatching-DefaultDetectCardTypeRepository$makeBinLookup$2 = false;
                encryptedBin = $this$makeBinLookup_u24lambda_u248.cardEncryptor.encryptBin((String)cardNumber, (String)publicKey);
                $this$map$iv = (Iterable)supportedCardBrands;
                $i$f$map = false;
                var14_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var19_24 = (CardBrand)item$iv$iv;
                    var20_25 = destination$iv$iv;
                    $i$a$-map-DefaultDetectCardTypeRepository$makeBinLookup$2$cardBrands$1 = false;
                    var20_25.add(it.getTxVariant());
                }
                cardBrands = (List)destination$iv$iv;
                request = new BinLookupRequest((String)encryptedBin, UUID.randomUUID().toString(), cardBrands, (String)type);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = $this$makeBinLookup_u24lambda_u248.binLookupService.makeBinLookup(request, (String)clientKey, (Continuation<? super BinLookupResponse>)$continuation);
                ** if (v0 != var27_9) goto lbl39
lbl38:
                // 1 sources

                return var27_9;
lbl39:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$f$runSuspendCatching = false;
                $i$a$-runSuspendCatching-DefaultDetectCardTypeRepository$makeBinLookup$2 = false;
                this = (DefaultDetectCardTypeRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl48:
                    // 2 sources

                    var23_30 = Result.constructor-impl((Object)((BinLookupResponse)v0));
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Throwable e$iv) {
                    var23_30 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                var7_10 = var23_30;
                v1 = Result.exceptionOrNull-impl((Object)var7_10);
                if (v1 != null) {
                    e = var8_12 = v1;
                    $i$a$-onFailure-DefaultDetectCardTypeRepository$makeBinLookup$3 = false;
                    encryptedBin = this;
                    level$iv = AdyenLogLevel.ERROR;
                    $i$f$adyenLog = false;
                    if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                        fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                        Intrinsics.checkNotNull((Object)fullClassName$iv);
                        outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                        tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 != false ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                        var17_22 = tag$iv;
                        var18_23 = level$iv;
                        var19_24 = AdyenLogger.Companion.getLogger();
                        $i$a$-adyenLog-DefaultDetectCardTypeRepository$makeBinLookup$3$1 = false;
                        var21_28 = "checkCardType - Failed to do bin lookup";
                        var19_24.log(var18_23, var17_22, var21_28, e);
                    }
                }
                return Result.isFailure-impl((Object)var7_10) != false ? null : var7_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedCardType> mapResponse(BinLookupResponse binLookupResponse) {
        void $this$mapNotNullTo$iv$iv;
        List list;
        Object object;
        AdyenLogger adyenLogger;
        AdyenLogLevel adyenLogLevel;
        String string2;
        String tag$iv;
        String outerClassName$iv;
        String fullClassName$iv;
        DefaultDetectCardTypeRepository $this$adyenLog_u24default$iv;
        DefaultDetectCardTypeRepository defaultDetectCardTypeRepository = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Iterable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            adyenLogLevel = level$iv;
            adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            object = "handleBinLookupResponse";
            adyenLogger.log(adyenLogLevel, string2, (String)object, (Throwable)((Object)throwable$iv));
        }
        $this$adyenLog_u24default$iv = this;
        level$iv = AdyenLogLevel.VERBOSE;
        throwable$iv = null;
        $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            adyenLogLevel = level$iv;
            adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            object = "Brands: " + binLookupResponse.getBrands();
            adyenLogger.log(adyenLogLevel, string2, (String)object, (Throwable)((Object)throwable$iv));
        }
        if ((list = binLookupResponse.getBrands()) == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        throwable$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DetectedCardType detectedCardType;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Brand brandResponse = (Brand)((Object)element$iv$iv);
            boolean bl2 = false;
            if (brandResponse.getBrand() == null) {
                detectedCardType = null;
            } else {
                CardBrand cardBrand = new CardBrand(brandResponse.getBrand());
                boolean bl3 = Intrinsics.areEqual((Object)brandResponse.getEnableLuhnCheck(), (Object)true);
                String string3 = brandResponse.getCvcPolicy();
                if (string3 == null) {
                    string3 = Brand.FieldPolicy.REQUIRED.getValue();
                }
                Brand.FieldPolicy fieldPolicy = Brand.FieldPolicy.Companion.parse(string3);
                String string4 = brandResponse.getExpiryDatePolicy();
                if (string4 == null) {
                    string4 = Brand.FieldPolicy.REQUIRED.getValue();
                }
                detectedCardType = new DetectedCardType(cardBrand, true, bl3, fieldPolicy, Brand.FieldPolicy.Companion.parse(string4), !Intrinsics.areEqual((Object)brandResponse.getSupported(), (Object)false), brandResponse.getPanLength(), brandResponse.getPaymentMethodVariant(), false, 256, null);
            }
            if (detectedCardType == null) continue;
            DetectedCardType it$iv$iv = detectedCardType;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object access$fetch(DefaultDetectCardTypeRepository $this, String cardNumber, String publicKey, List supportedCardBrands, String clientKey, String type, Continuation $completion) {
        return $this.fetch(cardNumber, publicKey, supportedCardBrands, clientKey, type, (Continuation<? super List<DetectedCardType>>)$completion);
    }

    public static final /* synthetic */ Channel access$get_detectedCardTypesFlow$p(DefaultDetectCardTypeRepository $this) {
        return $this._detectedCardTypesFlow;
    }

    public static final /* synthetic */ Object access$makeBinLookup(DefaultDetectCardTypeRepository $this, String cardNumber, String publicKey, List supportedCardBrands, String clientKey, String type, Continuation $completion) {
        return $this.makeBinLookup(cardNumber, publicKey, supportedCardBrands, clientKey, type, (Continuation<? super BinLookupResponse>)$completion);
    }

    static {
        Object[] objectArray = new CardBrand[]{new CardBrand(CardType.BCMC)};
        NO_CVC_BRANDS = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository$Companion;", "", "()V", "NO_CVC_BRANDS", "", "Lcom/adyen/checkout/core/CardBrand;", "REQUIRED_BIN_SIZE", "", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

