/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.util;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.adyen.checkout.card.CardBrand;
import com.adyen.checkout.card.CardType;
import com.adyen.checkout.card.R;
import com.adyen.checkout.card.internal.data.model.Brand;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.card.internal.ui.model.ExpiryDate;
import com.adyen.checkout.card.internal.ui.model.InputFieldUIState;
import com.adyen.checkout.card.internal.util.CardNumberValidation;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.core.internal.util.StringUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#J-\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b$J-\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180!2\u0006\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/adyen/checkout/card/internal/util/CardValidationUtils;", "", "()V", "AMEX_SECURITY_CODE_SIZE", "", "FIVE_DIGIT", "GENERAL_CARD_SECURITY_CODE_SIZE", "MAXIMUM_CARD_NUMBER_LENGTH", "MAXIMUM_EXPIRED_MONTHS", "MAXIMUM_YEARS_IN_FUTURE", "MINIMUM_CARD_NUMBER_LENGTH", "MONTHS_IN_YEAR", "RADIX", "dateExists", "", "expiryDate", "Lcom/adyen/checkout/card/internal/ui/model/ExpiryDate;", "getExpiryCalendar", "Ljava/util/Calendar;", "isInMaxYearRange", "calendar", "isInMinMonthRange", "isLuhnChecksumValid", "normalizedNumber", "", "isValidMonth", "month", "validateCardNumber", "Lcom/adyen/checkout/card/internal/util/CardNumberValidation;", "number", "enableLuhnCheck", "isBrandSupported", "validateExpiryDate", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "fieldPolicy", "Lcom/adyen/checkout/card/internal/data/model/Brand$FieldPolicy;", "validateExpiryDate$card_release", "validateSecurityCode", "securityCode", "detectedCardType", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "cvcUIState", "Lcom/adyen/checkout/card/internal/ui/model/InputFieldUIState;", "validateSecurityCode$card_release", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CardValidationUtils {
    @NotNull
    public static final CardValidationUtils INSTANCE = new CardValidationUtils();
    private static final int RADIX = 10;
    private static final int FIVE_DIGIT = 5;
    private static final int MINIMUM_CARD_NUMBER_LENGTH = 12;
    public static final int MAXIMUM_CARD_NUMBER_LENGTH = 19;
    private static final int GENERAL_CARD_SECURITY_CODE_SIZE = 3;
    private static final int AMEX_SECURITY_CODE_SIZE = 4;
    private static final int MONTHS_IN_YEAR = 12;
    private static final int MAXIMUM_YEARS_IN_FUTURE = 30;
    private static final int MAXIMUM_EXPIRED_MONTHS = 3;

    private CardValidationUtils() {
    }

    @NotNull
    public final CardNumberValidation validateCardNumber(@NotNull String number, boolean enableLuhnCheck, boolean isBrandSupported) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String normalizedNumber = StringUtil.normalize((String)number, (char[])new char[0]);
        int length = normalizedNumber.length();
        return !StringUtil.INSTANCE.isDigitsAndSeparatorsOnly(normalizedNumber, new char[0]) ? CardNumberValidation.INVALID_ILLEGAL_CHARACTERS : (length > 19 ? CardNumberValidation.INVALID_TOO_LONG : (length < 12 ? CardNumberValidation.INVALID_TOO_SHORT : (!isBrandSupported ? CardNumberValidation.INVALID_UNSUPPORTED_BRAND : (enableLuhnCheck && !this.isLuhnChecksumValid(normalizedNumber) ? CardNumberValidation.INVALID_LUHN_CHECK : CardNumberValidation.VALID))));
    }

    private final boolean isLuhnChecksumValid(String normalizedNumber) {
        int s1 = 0;
        int s2 = 0;
        String string2 = new StringBuffer(normalizedNumber).reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String reverse = string2;
        int n = reverse.length();
        for (int i = 0; i < n; ++i) {
            int digit = Character.digit(reverse.charAt(i), 10);
            if (i % 2 == 0) {
                s1 += digit;
                continue;
            }
            s2 += 2 * digit;
            if (digit < 5) continue;
            s2 -= 9;
        }
        return (s1 + s2) % 10 == 0;
    }

    @NotNull
    public final FieldState<ExpiryDate> validateExpiryDate(@NotNull ExpiryDate expiryDate, @Nullable Brand.FieldPolicy fieldPolicy) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Calendar calendar = GregorianCalendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        return this.validateExpiryDate$card_release(expiryDate, fieldPolicy, calendar);
    }

    @VisibleForTesting
    @NotNull
    public final FieldState<ExpiryDate> validateExpiryDate$card_release(@NotNull ExpiryDate expiryDate, @Nullable Brand.FieldPolicy fieldPolicy, @NotNull Calendar calendar) {
        FieldState fieldState;
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        FieldState invalidState = new FieldState((Object)expiryDate, (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid, false, 2, null));
        if (this.dateExists(expiryDate)) {
            FieldState fieldState2;
            boolean isInMaxYearRange = this.isInMaxYearRange(expiryDate, calendar);
            boolean isInMinMonthRange = this.isInMinMonthRange(expiryDate, calendar);
            fieldState = fieldState2 = isInMinMonthRange && isInMaxYearRange ? new FieldState((Object)expiryDate, (Validation)Validation.Valid.INSTANCE) : (!isInMaxYearRange ? new FieldState((Object)expiryDate, (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid_too_far_in_future, false, 2, null)) : (!isInMinMonthRange ? new FieldState((Object)expiryDate, (Validation)new Validation.Invalid(R.string.checkout_expiry_date_not_valid_too_old, false, 2, null)) : invalidState));
        } else {
            Brand.FieldPolicy fieldPolicy2 = fieldPolicy;
            fieldState = (fieldPolicy2 != null ? !fieldPolicy2.isRequired() : false) && !Intrinsics.areEqual((Object)expiryDate, (Object)ExpiryDate.INVALID_DATE) ? new FieldState((Object)expiryDate, (Validation)Validation.Valid.INSTANCE) : invalidState;
        }
        return fieldState;
    }

    private final boolean isInMaxYearRange(ExpiryDate expiryDate, Calendar calendar) {
        Calendar expiryDateCalendar = this.getExpiryCalendar(expiryDate);
        Object object = calendar.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.GregorianCalendar");
        GregorianCalendar maxFutureCalendar = (GregorianCalendar)object;
        maxFutureCalendar.add(1, 30);
        return expiryDateCalendar.get(1) <= maxFutureCalendar.get(1);
    }

    private final boolean isInMinMonthRange(ExpiryDate expiryDate, Calendar calendar) {
        Calendar expiryDateCalendar = this.getExpiryCalendar(expiryDate);
        Object object = calendar.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.GregorianCalendar");
        GregorianCalendar maxPastCalendar = (GregorianCalendar)object;
        maxPastCalendar.add(2, -3);
        return expiryDateCalendar.compareTo(maxPastCalendar) >= 0;
    }

    @NotNull
    public final FieldState<String> validateSecurityCode$card_release(@NotNull String securityCode, @Nullable DetectedCardType detectedCardType, @NotNull InputFieldUIState cvcUIState) {
        Validation validation;
        Intrinsics.checkNotNullParameter((Object)securityCode, (String)"securityCode");
        Intrinsics.checkNotNullParameter((Object)((Object)cvcUIState), (String)"cvcUIState");
        String normalizedSecurityCode = StringUtil.normalize((String)securityCode, (char[])new char[0]);
        int length = normalizedSecurityCode.length();
        Validation.Invalid invalidState = new Validation.Invalid(R.string.checkout_security_code_not_valid, false, 2, null);
        if (cvcUIState == InputFieldUIState.HIDDEN) {
            validation = (Validation)Validation.Valid.INSTANCE;
        } else if (!StringUtil.INSTANCE.isDigitsAndSeparatorsOnly(normalizedSecurityCode, new char[0])) {
            validation = (Validation)invalidState;
        } else if (cvcUIState == InputFieldUIState.OPTIONAL && length == 0) {
            validation = (Validation)Validation.Valid.INSTANCE;
        } else {
            DetectedCardType detectedCardType2 = detectedCardType;
            if (Intrinsics.areEqual((Object)(detectedCardType2 != null ? detectedCardType2.getCardBrand() : null), (Object)new CardBrand(CardType.AMERICAN_EXPRESS)) && length == 4) {
                validation = (Validation)Validation.Valid.INSTANCE;
            } else {
                DetectedCardType detectedCardType3 = detectedCardType;
                validation = !Intrinsics.areEqual((Object)(detectedCardType3 != null ? detectedCardType3.getCardBrand() : null), (Object)new CardBrand(CardType.AMERICAN_EXPRESS)) && length == 3 ? (Validation)Validation.Valid.INSTANCE : (Validation)invalidState;
            }
        }
        Validation validation2 = validation;
        return new FieldState((Object)normalizedSecurityCode, validation2);
    }

    private final boolean dateExists(ExpiryDate expiryDate) {
        return expiryDate != ExpiryDate.EMPTY_DATE && this.isValidMonth(expiryDate.getExpiryMonth()) && expiryDate.getExpiryYear() > 0;
    }

    private final boolean isValidMonth(int month) {
        return 1 <= month ? month < 13 : false;
    }

    private final Calendar getExpiryCalendar(ExpiryDate expiryDate) {
        Calendar expiryCalendar = GregorianCalendar.getInstance();
        expiryCalendar.clear();
        expiryCalendar.set(expiryDate.getExpiryYear(), expiryDate.getExpiryMonth() - 1, 1);
        expiryCalendar.add(2, 1);
        expiryCalendar.add(5, -1);
        Intrinsics.checkNotNull((Object)expiryCalendar);
        return expiryCalendar;
    }
}

