/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import androidx.annotation.RestrictTo;
import com.adyen.checkout.card.databinding.InstallmentViewBinding;
import com.adyen.checkout.card.internal.ui.view.InstallmentFilter;
import com.adyen.checkout.card.internal.ui.view.InstallmentModel;
import com.adyen.checkout.card.internal.ui.view.InstallmentViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\rH\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/InstallmentListAdapter;", "Landroid/widget/BaseAdapter;", "Landroid/widget/Filterable;", "context", "Landroid/content/Context;", "localizedContext", "(Landroid/content/Context;Landroid/content/Context;)V", "installmentFilter", "Lcom/adyen/checkout/card/internal/ui/view/InstallmentFilter;", "installmentOptions", "", "Lcom/adyen/checkout/card/internal/ui/view/InstallmentModel;", "getCount", "", "getFilter", "Landroid/widget/Filter;", "getItem", "position", "getItemId", "", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "setItems", "", "", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstallmentListAdapter
extends BaseAdapter
implements Filterable {
    @NotNull
    private final Context context;
    @NotNull
    private final Context localizedContext;
    @NotNull
    private final List<InstallmentModel> installmentOptions;
    @NotNull
    private final InstallmentFilter installmentFilter;

    public InstallmentListAdapter(@NotNull Context context, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        this.context = context;
        this.localizedContext = localizedContext;
        this.installmentOptions = new ArrayList();
        this.installmentFilter = new InstallmentFilter(this.localizedContext, this.installmentOptions);
    }

    public final void setItems(@NotNull List<InstallmentModel> installmentOptions) {
        Intrinsics.checkNotNullParameter(installmentOptions, (String)"installmentOptions");
        this.installmentOptions.clear();
        this.installmentOptions.addAll((Collection<InstallmentModel>)installmentOptions);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.installmentOptions.size();
    }

    @NotNull
    public InstallmentModel getItem(int position) {
        return this.installmentOptions.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @NotNull
    public View getView(int position, @Nullable View convertView, @Nullable ViewGroup parent) {
        View view = null;
        InstallmentViewHolder viewHolder = null;
        InstallmentViewBinding binding = null;
        if (convertView == null) {
            InstallmentViewBinding installmentViewBinding = InstallmentViewBinding.inflate(LayoutInflater.from((Context)this.context), parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)installmentViewBinding, (String)"inflate(...)");
            binding = installmentViewBinding;
            viewHolder = new InstallmentViewHolder(binding, this.localizedContext);
            LinearLayout linearLayout = binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"getRoot(...)");
            view = (View)linearLayout;
            ((LinearLayout)view).setTag((Object)viewHolder);
        } else {
            view = convertView;
            Object object = view.getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.adyen.checkout.card.internal.ui.view.InstallmentViewHolder");
            viewHolder = (InstallmentViewHolder)((Object)object);
        }
        viewHolder.bindItem(this.getItem(position));
        return view;
    }

    @NotNull
    public Filter getFilter() {
        return this.installmentFilter;
    }
}

