/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.util.AttributeSet;
import com.adyen.checkout.card.internal.ui.model.ExpiryDate;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.core.internal.util.StringUtil;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/ExpiryDateInput;", "Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "expiryDate", "Lcom/adyen/checkout/card/internal/ui/model/ExpiryDate;", "date", "getDate", "()Lcom/adyen/checkout/card/internal/ui/model/ExpiryDate;", "setDate", "(Lcom/adyen/checkout/card/internal/ui/model/ExpiryDate;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "afterTextChanged", "", "editable", "Landroid/text/Editable;", "fixCalendarYear", "calendar", "Ljava/util/Calendar;", "isStringInt", "", "s", "", "Companion", "card_release"})
public final class ExpiryDateInput
extends AdyenTextInputEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @NotNull
    public static final String SEPARATOR = "/";
    @NotNull
    private static final String DATE_FORMAT = "MM/yy";
    private static final int MAX_LENGTH = 5;
    private static final int MAX_SECOND_DIGIT_MONTH = 1;

    @JvmOverloads
    public ExpiryDateInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ROOT);
        this.enforceMaxInputLength(5);
        this.dateFormat.setLenient(false);
        if (Build.VERSION.SDK_INT >= 26) {
            String[] stringArray = new String[]{"creditCardExpirationDate"};
            this.setAutofillHints(stringArray);
        }
    }

    public /* synthetic */ ExpiryDateInput(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        String initial = editable.toString();
        CharSequence charSequence = initial;
        Regex regex = new Regex("\\D");
        String string2 = "";
        Object processed = regex.replace(charSequence, string2);
        charSequence = (CharSequence)processed;
        regex = new Regex("(\\d{2})(?=\\d)");
        string2 = "$1/";
        processed = regex.replace(charSequence, string2);
        if (((String)processed).length() == 1 && this.isStringInt((String)processed) && Integer.parseInt((String)processed) > 1) {
            processed = "0" + (String)processed;
        }
        if (!Intrinsics.areEqual((Object)initial, (Object)processed)) {
            editable.replace(0, initial.length(), (CharSequence)processed);
        }
        super.afterTextChanged(editable);
    }

    @NotNull
    public final ExpiryDate getDate() {
        ExpiryDate expiryDate;
        String normalizedExpiryDate = StringUtil.normalize((String)this.getRawValue(), (char[])new char[0]);
        Logger.v((String)TAG, (String)("getDate - " + normalizedExpiryDate));
        try {
            Date date = this.dateFormat.parse(normalizedExpiryDate);
            if (date == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            Date parsedDate = date;
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(parsedDate);
            Intrinsics.checkNotNull((Object)calendar);
            this.fixCalendarYear(calendar);
            expiryDate = new ExpiryDate(calendar.get(2) + 1, calendar.get(1));
        }
        catch (ParseException e) {
            Logger.d((String)TAG, (String)("getDate - value does not match expected pattern. " + e.getLocalizedMessage()));
            expiryDate = ((CharSequence)this.getRawValue()).length() == 0 ? ExpiryDate.EMPTY_DATE : ExpiryDate.INVALID_DATE;
        }
        return expiryDate;
    }

    public final void setDate(@NotNull ExpiryDate expiryDate) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        if (expiryDate != ExpiryDate.EMPTY_DATE) {
            Logger.v((String)TAG, (String)("setDate - " + expiryDate.getExpiryYear() + " " + expiryDate.getExpiryMonth()));
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.clear();
            calendar.set(expiryDate.getExpiryYear(), expiryDate.getExpiryMonth() - 1, 1);
            this.setText(this.dateFormat.format(calendar.getTime()));
        } else {
            this.setText("");
        }
    }

    private final void fixCalendarYear(Calendar calendar) {
        int yearsInCentury = 100;
        Calendar currentCalendar = GregorianCalendar.getInstance();
        int currentCentury = currentCalendar.get(1) / yearsInCentury;
        int calendarCentury = calendar.get(1) / yearsInCentury;
        if (calendarCentury < currentCentury) {
            calendar.add(1, yearsInCentury);
        }
    }

    private final boolean isStringInt(String s) {
        boolean bl;
        try {
            Integer.parseInt(s);
            bl = true;
        }
        catch (NumberFormatException ex) {
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public ExpiryDateInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExpiryDateInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/ExpiryDateInput$Companion;", "", "()V", "DATE_FORMAT", "", "MAX_LENGTH", "", "MAX_SECOND_DIGIT_MONTH", "SEPARATOR", "TAG", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

