/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.SwitchCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.adyen.checkout.card.CardBrand;
import com.adyen.checkout.card.CardType;
import com.adyen.checkout.card.R;
import com.adyen.checkout.card.databinding.CardViewBinding;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.card.internal.ui.CardDelegate;
import com.adyen.checkout.card.internal.ui.model.CardInputData;
import com.adyen.checkout.card.internal.ui.model.CardListItem;
import com.adyen.checkout.card.internal.ui.model.CardOutputData;
import com.adyen.checkout.card.internal.ui.model.ExpiryDate;
import com.adyen.checkout.card.internal.ui.model.InputFieldUIState;
import com.adyen.checkout.card.internal.ui.view.CardListAdapter;
import com.adyen.checkout.card.internal.ui.view.CardView;
import com.adyen.checkout.card.internal.ui.view.InstallmentListAdapter;
import com.adyen.checkout.card.internal.ui.view.InstallmentModel;
import com.adyen.checkout.card.internal.ui.view.SecurityCodeInput;
import com.adyen.checkout.card.internal.util.InstallmentUtils;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.BuildUtils;
import com.adyen.checkout.ui.core.internal.ui.AddressDelegate;
import com.adyen.checkout.ui.core.internal.ui.AddressFormUIState;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.view.AddressFormInput;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import com.adyen.checkout.ui.core.internal.ui.view.RoundCornerImageView;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.google.android.material.textfield.TextInputLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0001hB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020\u0014H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\b\u0010,\u001a\u00020\u0014H\u0002J\b\u0010-\u001a\u00020\u0014H\u0002J\b\u0010.\u001a\u00020\u0014H\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\b\u00101\u001a\u00020\u0014H\u0002J\b\u00102\u001a\u00020\u0014H\u0002J\b\u00103\u001a\u00020\u0014H\u0002J \u00104\u001a\u00020\u00142\u0006\u00105\u001a\u0002062\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u00107\u001a\u00020\u00142\u0006\u00105\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00108\u001a\u00020\u0014H\u0014J\u0010\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020\u0014H\u0014J\u0016\u0010=\u001a\u00020\u00142\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002J\u0010\u0010A\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010B\u001a\u00020\u0014H\u0002J\b\u0010C\u001a\u00020\u0014H\u0002J\b\u0010D\u001a\u00020\u0014H\u0002J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020JH\u0002J\u001e\u0010K\u001a\u00020\u00142\f\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u00020JH\u0002J#\u0010P\u001a\u00020\u00142\n\b\u0001\u0010Q\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010R\u001a\u00020JH\u0002\u00a2\u0006\u0002\u0010SJ\u001e\u0010T\u001a\u00020\u00142\f\u0010U\u001a\b\u0012\u0004\u0012\u00020V0M2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020JH\u0002J\u0017\u0010[\u001a\u00020\u00142\b\u0010\\\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010]J\u0010\u0010^\u001a\u00020\u00142\u0006\u0010_\u001a\u00020JH\u0002J\u0010\u0010`\u001a\u00020\u00142\u0006\u0010a\u001a\u00020JH\u0002J\u0018\u0010b\u001a\u00020\u00142\u0006\u0010F\u001a\u00020G2\u0006\u0010c\u001a\u00020JH\u0002J\u0012\u0010d\u001a\u00020\u00142\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\u0010\u0010g\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardView;", "Landroid/widget/LinearLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/card/databinding/CardViewBinding;", "cardDelegate", "Lcom/adyen/checkout/card/internal/ui/CardDelegate;", "cardListAdapter", "Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter;", "installmentListAdapter", "Lcom/adyen/checkout/card/internal/ui/view/InstallmentListAdapter;", "localizedContext", "deselectBrands", "", "getActivity", "Landroid/app/Activity;", "getView", "Landroid/view/View;", "goToNextInputIfFocus", "view", "handleCvcUIState", "cvcUIState", "Lcom/adyen/checkout/card/internal/ui/model/InputFieldUIState;", "handleExpiryDateUIState", "expiryDateUIState", "handleHolderNameUIState", "holderNameUIState", "highlightValidationErrors", "initAddressFormInput", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initBrandSelectionListeners", "initCardBrandLogoViews", "selectedIndex", "initCardNumberInput", "initExpiryDateInput", "initHolderNameInput", "initInstallments", "initKcpAuthenticationInput", "initKcpBirthDateOrTaxNumberInput", "initKcpCardPasswordInput", "initLocalizedStrings", "initPostalCodeInput", "initSecurityCodeInput", "initSocialSecurityNumberInput", "initView", "delegate", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "observeDelegate", "onAttachedToWindow", "onCardNumberValidated", "cardOutputData", "Lcom/adyen/checkout/card/internal/ui/model/CardOutputData;", "onDetachedFromWindow", "onExpiryDateValidated", "expiryDateState", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "Lcom/adyen/checkout/card/internal/ui/model/ExpiryDate;", "outputDataChanged", "resetBrandSelectionInput", "selectPrimaryBrand", "selectSecondaryBrand", "setAddressInputVisibility", "addressFormUIState", "Lcom/adyen/checkout/ui/core/internal/ui/AddressFormUIState;", "setCardErrorState", "hasFocus", "", "setCardList", "cards", "", "Lcom/adyen/checkout/card/internal/ui/model/CardListItem;", "isCardListVisible", "setCardNumberError", "stringResId", "shouldShowSecondaryLogo", "(Ljava/lang/Integer;Z)V", "setDualBrandedCardImages", "detectedCardTypes", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "validation", "Lcom/adyen/checkout/components/core/internal/ui/model/Validation;", "setKcpAuthVisibility", "shouldShowKCPAuth", "setKcpHint", "kcpBirthDateOrTaxNumberHint", "(Ljava/lang/Integer;)V", "setSocialSecurityNumberVisibility", "shouldShowSocialSecurityNumber", "setStorePaymentSwitchVisibility", "showStorePaymentField", "updateAddressHint", "isOptional", "updateInstallmentSelection", "installmentModel", "Lcom/adyen/checkout/card/internal/ui/view/InstallmentModel;", "updateInstallments", "Companion", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCardView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardView.kt\ncom/adyen/checkout/card/internal/ui/view/CardView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ViewExtensions.kt\ncom/adyen/checkout/ui/core/internal/util/ViewExtensionsKt\n+ 4 View.kt\nandroidx/core/view/ViewKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,740:1\n1#2:741\n18#3:742\n18#3:743\n18#3:744\n18#3:745\n18#3:746\n20#3,8:772\n20#3,8:780\n20#3,8:788\n20#3,8:796\n20#3,8:804\n20#3,8:812\n20#3,8:820\n20#3,8:828\n20#3,8:836\n20#3,8:846\n20#3,8:854\n20#3,8:862\n20#3,8:872\n20#3,8:882\n20#3,8:892\n260#4:747\n262#4,2:748\n262#4,2:753\n262#4,2:762\n262#4,2:764\n262#4,2:766\n262#4,2:768\n262#4,2:770\n262#4,2:844\n262#4,2:870\n262#4,2:880\n262#4,2:890\n262#4,2:900\n1747#5,3:750\n350#5,7:755\n*S KotlinDebug\n*F\n+ 1 CardView.kt\ncom/adyen/checkout/card/internal/ui/view/CardView\n*L\n218#1:742\n226#1:743\n234#1:744\n246#1:745\n258#1:746\n573#1:772,8\n575#1:780,8\n595#1:788,8\n603#1:796,8\n610#1:804,8\n623#1:812,8\n631#1:820,8\n638#1:828,8\n647#1:836,8\n655#1:846,8\n659#1:854,8\n660#1:862,8\n672#1:872,8\n677#1:882,8\n682#1:892,8\n267#1:747\n281#1:748,2\n318#1:753,2\n330#1:762,2\n375#1:764,2\n376#1:766,2\n379#1:768,2\n380#1:770,2\n651#1:844,2\n671#1:870,2\n676#1:880,2\n681#1:890,2\n720#1:900,2\n296#1:750,3\n326#1:755,7\n*E\n"})
public final class CardView
extends LinearLayout
implements ComponentView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CardViewBinding binding;
    @Nullable
    private InstallmentListAdapter installmentListAdapter;
    @Nullable
    private CardListAdapter cardListAdapter;
    private Context localizedContext;
    private CardDelegate cardDelegate;
    private static final float UNSELECTED_BRAND_LOGO_ALPHA = 0.2f;
    private static final float SELECTED_BRAND_LOGO_ALPHA = 1.0f;
    private static final int UNSELECTED_BRAND_INDEX = -1;
    private static final int PRIMARY_BRAND_INDEX = 0;
    private static final int SECONDARY_BRAND_INDEX = 1;

    @JvmOverloads
    public CardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        CardViewBinding cardViewBinding = CardViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)cardViewBinding, (String)"inflate(...)");
        this.binding = cardViewBinding;
        this.setOrientation(1);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_margin);
        this.setPadding(padding, padding, padding, 0);
    }

    public /* synthetic */ CardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onAttachedToWindow() {
        block1: {
            super.onAttachedToWindow();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            if (BuildUtils.INSTANCE.isDebugBuild(context)) break block1;
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            Activity activity = this.getActivity(context2);
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.addFlags(8192);
            }
        }
    }

    protected void onDetachedFromWindow() {
        block1: {
            super.onDetachedFromWindow();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            if (BuildUtils.INSTANCE.isDebugBuild(context)) break block1;
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            Activity activity = this.getActivity(context2);
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.clearFlags(8192);
            }
        }
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof CardDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.cardDelegate = (CardDelegate)delegate;
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.observeDelegate((CardDelegate)delegate, coroutineScope);
        this.initCardNumberInput();
        this.initExpiryDateInput();
        this.initSecurityCodeInput();
        this.initHolderNameInput();
        this.initSocialSecurityNumberInput();
        this.initKcpAuthenticationInput();
        this.initPostalCodeInput();
        this.initAddressFormInput(coroutineScope);
        this.binding.switchStorePaymentMethod.setOnCheckedChangeListener((arg_0, arg_1) -> CardView.initView$lambda$1(delegate, arg_0, arg_1));
    }

    private final void initLocalizedStrings(Context localizedContext) {
        TextInputLayout textInputLayout = this.binding.textInputLayoutCardNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardNumber");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout, (int)R.style.AdyenCheckout_Card_CardNumberInput, (Context)localizedContext);
        TextInputLayout textInputLayout2 = this.binding.textInputLayoutExpiryDate;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"textInputLayoutExpiryDate");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout2, (int)R.style.AdyenCheckout_Card_ExpiryDateInput, (Context)localizedContext);
        TextInputLayout textInputLayout3 = this.binding.textInputLayoutSecurityCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"textInputLayoutSecurityCode");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout3, (int)R.style.AdyenCheckout_Card_SecurityCodeInput, (Context)localizedContext);
        TextInputLayout textInputLayout4 = this.binding.textInputLayoutCardHolder;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout4, (String)"textInputLayoutCardHolder");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout4, (int)R.style.AdyenCheckout_Card_HolderNameInput, (Context)localizedContext);
        TextInputLayout textInputLayout5 = this.binding.textInputLayoutPostalCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout5, (String)"textInputLayoutPostalCode");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout5, (int)R.style.AdyenCheckout_PostalCodeInput, (Context)localizedContext);
        TextInputLayout textInputLayout6 = this.binding.textInputLayoutSocialSecurityNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout6, (String)"textInputLayoutSocialSecurityNumber");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout6, (int)R.style.AdyenCheckout_Card_SocialSecurityNumberInput, (Context)localizedContext);
        TextInputLayout textInputLayout7 = this.binding.textInputLayoutKcpBirthDateOrTaxNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout7, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout7, (int)R.style.AdyenCheckout_Card_KcpBirthDateOrTaxNumber, (Context)localizedContext);
        TextInputLayout textInputLayout8 = this.binding.textInputLayoutKcpCardPassword;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout8, (String)"textInputLayoutKcpCardPassword");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout8, (int)R.style.AdyenCheckout_Card_KcpCardPassword, (Context)localizedContext);
        TextInputLayout textInputLayout9 = this.binding.textInputLayoutInstallments;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout9, (String)"textInputLayoutInstallments");
        ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout9, (int)R.style.AdyenCheckout_DropdownTextInputLayout_Installments, (Context)localizedContext);
        SwitchCompat switchCompat = this.binding.switchStorePaymentMethod;
        Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"switchStorePaymentMethod");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)switchCompat), (int)R.style.AdyenCheckout_Card_StorePaymentSwitch, (Context)localizedContext, (boolean)false, (int)4, null);
        this.binding.addressFormInput.initLocalizedContext(localizedContext);
    }

    private final void observeDelegate(CardDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach(delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<CardOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ CardView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CardOutputData it = (CardOutputData)this.L$0;
                        CardView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CardOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    private final void outputDataChanged(CardOutputData cardOutputData) {
        this.onCardNumberValidated(cardOutputData);
        this.onExpiryDateValidated(cardOutputData.getExpiryDateState());
        this.setSocialSecurityNumberVisibility(cardOutputData.isSocialSecurityNumberRequired());
        this.setKcpAuthVisibility(cardOutputData.isKCPAuthRequired());
        this.setKcpHint(cardOutputData.getKcpBirthDateOrTaxNumberHint());
        this.setAddressInputVisibility(cardOutputData.getAddressUIState());
        this.handleCvcUIState(cardOutputData.getCvcUIState());
        this.handleExpiryDateUIState(cardOutputData.getExpiryDateUIState());
        this.handleHolderNameUIState(cardOutputData.getHolderNameUIState());
        this.setStorePaymentSwitchVisibility(cardOutputData.getShowStorePaymentField());
        this.updateInstallments(cardOutputData);
        this.updateAddressHint(cardOutputData.getAddressUIState(), cardOutputData.getAddressState().isOptional());
        this.setCardList(cardOutputData.getCardBrands(), cardOutputData.isCardListVisible());
    }

    public void highlightValidationErrors() {
        Validation securityCodeValidation;
        Validation expiryDateValidation;
        CardDelegate cardDelegate = this.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        CardOutputData it = cardDelegate.getOutputData();
        boolean bl = false;
        boolean isErrorFocused = false;
        Validation cardNumberValidation = it.getCardNumberState().getValidation();
        if (cardNumberValidation instanceof Validation.Invalid) {
            isErrorFocused = true;
            this.binding.editTextCardNumber.requestFocus();
            CardView.setCardNumberError$default(this, ((Validation.Invalid)cardNumberValidation).getReason(), false, 2, null);
        }
        if ((expiryDateValidation = it.getExpiryDateState().getValidation()) instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutExpiryDate.requestFocus();
            }
            TextInputLayout textInputLayout = this.binding.textInputLayoutExpiryDate;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)expiryDateValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
        if ((securityCodeValidation = it.getSecurityCodeState().getValidation()) instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutSecurityCode.requestFocus();
            }
            TextInputLayout textInputLayout = this.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string3 = context.getString(((Validation.Invalid)securityCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string3);
        }
        Validation holderNameValidation = it.getHolderNameState().getValidation();
        TextInputLayout textInputLayout = this.binding.textInputLayoutCardHolder;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardHolder");
        TextInputLayout $this$isVisible$iv = textInputLayout;
        boolean $i$f$isVisible = false;
        if ($this$isVisible$iv.getVisibility() == 0 && holderNameValidation instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutCardHolder.requestFocus();
            }
            TextInputLayout textInputLayout2 = this.binding.textInputLayoutCardHolder;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"textInputLayoutCardHolder");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string4 = context.getString(((Validation.Invalid)holderNameValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout2, (String)string4);
        }
        Validation postalCodeValidation = it.getAddressState().getPostalCode().getValidation();
        TextInputLayout textInputLayout3 = this.binding.textInputLayoutPostalCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"textInputLayoutPostalCode");
        TextInputLayout $this$isVisible$iv2 = textInputLayout3;
        boolean $i$f$isVisible2 = false;
        if ($this$isVisible$iv2.getVisibility() == 0 && postalCodeValidation instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutPostalCode.requestFocus();
            }
            TextInputLayout textInputLayout4 = this.binding.textInputLayoutPostalCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout4, (String)"textInputLayoutPostalCode");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string5 = context.getString(((Validation.Invalid)postalCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout4, (String)string5);
        }
        Validation socialSecurityNumberValidation = it.getSocialSecurityNumberState().getValidation();
        TextInputLayout textInputLayout5 = this.binding.textInputLayoutSocialSecurityNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout5, (String)"textInputLayoutSocialSecurityNumber");
        TextInputLayout $this$isVisible$iv3 = textInputLayout5;
        boolean $i$f$isVisible3 = false;
        if ($this$isVisible$iv3.getVisibility() == 0 && socialSecurityNumberValidation instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutSocialSecurityNumber.requestFocus();
            }
            TextInputLayout textInputLayout6 = this.binding.textInputLayoutSocialSecurityNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout6, (String)"textInputLayoutSocialSecurityNumber");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string6 = context.getString(((Validation.Invalid)socialSecurityNumberValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout6, (String)string6);
        }
        Validation kcpBirthDateOrTaxNumberValidation = it.getKcpBirthDateOrTaxNumberState().getValidation();
        TextInputLayout textInputLayout7 = this.binding.textInputLayoutKcpBirthDateOrTaxNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout7, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
        TextInputLayout $this$isVisible$iv4 = textInputLayout7;
        boolean $i$f$isVisible4 = false;
        if ($this$isVisible$iv4.getVisibility() == 0 && kcpBirthDateOrTaxNumberValidation instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutKcpBirthDateOrTaxNumber.requestFocus();
            }
            TextInputLayout textInputLayout8 = this.binding.textInputLayoutKcpBirthDateOrTaxNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout8, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string7 = context.getString(((Validation.Invalid)kcpBirthDateOrTaxNumberValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout8, (String)string7);
        }
        Validation kcpPasswordValidation = it.getKcpCardPasswordState().getValidation();
        TextInputLayout textInputLayout9 = this.binding.textInputLayoutKcpCardPassword;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout9, (String)"textInputLayoutKcpCardPassword");
        TextInputLayout $this$isVisible$iv5 = textInputLayout9;
        boolean $i$f$isVisible5 = false;
        if ($this$isVisible$iv5.getVisibility() == 0 && kcpPasswordValidation instanceof Validation.Invalid) {
            if (!isErrorFocused) {
                isErrorFocused = true;
                this.binding.textInputLayoutKcpCardPassword.requestFocus();
            }
            TextInputLayout textInputLayout10 = this.binding.textInputLayoutKcpCardPassword;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout10, (String)"textInputLayoutKcpCardPassword");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string8 = context.getString(((Validation.Invalid)kcpPasswordValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout10, (String)string8);
        }
        AddressFormInput addressFormInput = this.binding.addressFormInput;
        Intrinsics.checkNotNullExpressionValue((Object)addressFormInput, (String)"addressFormInput");
        $this$isVisible$iv5 = (View)addressFormInput;
        $i$f$isVisible5 = false;
        if ($this$isVisible$iv5.getVisibility() == 0 && !it.getAddressState().isValid()) {
            this.binding.addressFormInput.highlightValidationErrors(isErrorFocused);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCardNumberValidated(CardOutputData cardOutputData) {
        List<DetectedCardType> detectedCardTypes = cardOutputData.getDetectedCardTypes();
        if (detectedCardTypes.isEmpty()) {
            void $this$isVisible$iv;
            RoundCornerImageView roundCornerImageView;
            RoundCornerImageView $this$onCardNumberValidated_u24lambda_u243 = roundCornerImageView = this.binding.cardBrandLogoImageViewPrimary;
            boolean bl = false;
            $this$onCardNumberValidated_u24lambda_u243.setStrokeWidth(0.0f);
            $this$onCardNumberValidated_u24lambda_u243.setImageResource(R.drawable.ic_card);
            $this$onCardNumberValidated_u24lambda_u243.setAlpha(1.0f);
            FrameLayout frameLayout = this.binding.cardBrandLogoContainerSecondary;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"cardBrandLogoContainerSecondary");
            roundCornerImageView = (View)frameLayout;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            this.binding.editTextCardNumber.setAmexCardFormat(false);
            this.resetBrandSelectionInput();
        } else {
            boolean bl;
            DetectedCardType firtDetectedCardType;
            block10: {
                firtDetectedCardType = (DetectedCardType)CollectionsKt.first(detectedCardTypes);
                this.binding.cardBrandLogoImageViewPrimary.setStrokeWidth(4.0f);
                RoundCornerImageView roundCornerImageView = this.binding.cardBrandLogoImageViewPrimary;
                Intrinsics.checkNotNullExpressionValue((Object)roundCornerImageView, (String)"cardBrandLogoImageViewPrimary");
                ImageView imageView = (ImageView)roundCornerImageView;
                CardDelegate cardDelegate = this.cardDelegate;
                if (cardDelegate == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
                    cardDelegate = null;
                }
                ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)cardDelegate.getComponentParams().getEnvironment(), (String)detectedCardTypes.get(0).getCardBrand().getTxVariant(), null, null, null, (int)R.drawable.ic_card, (int)R.drawable.ic_card, (int)28, null);
                this.setDualBrandedCardImages(detectedCardTypes, cardOutputData.getCardNumberState().getValidation());
                Iterable $this$any$iv = detectedCardTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DetectedCardType it = (DetectedCardType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getCardBrand(), (Object)new CardBrand(CardType.AMERICAN_EXPRESS))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            boolean isAmex = bl;
            this.binding.editTextCardNumber.setAmexCardFormat(isAmex);
            if (detectedCardTypes.size() == 1) {
                Integer n = firtDetectedCardType.getPanLength();
                int $this$any$iv = this.binding.editTextCardNumber.getRawValue().length();
                if (n != null && n == $this$any$iv) {
                    Validation cardNumberValidation = cardOutputData.getCardNumberState().getValidation();
                    if (cardNumberValidation instanceof Validation.Invalid) {
                        CardView.setCardNumberError$default(this, ((Validation.Invalid)cardNumberValidation).getReason(), false, 2, null);
                    } else {
                        this.goToNextInputIfFocus((View)this.binding.editTextCardNumber);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void setDualBrandedCardImages(List<DetectedCardType> detectedCardTypes, Validation validation) {
        void $this$isVisible$iv;
        Unit unit;
        DetectedCardType detectedCardType;
        block7: {
            int n;
            CardView cardView;
            block4: {
                Iterator iterator;
                int index$iv;
                block6: {
                    block5: {
                        void $this$indexOfFirst$iv;
                        List<DetectedCardType> $this$isVisible$iv2;
                        DetectedCardType detectedCardType2;
                        boolean cardNumberHasFocus = this.binding.textInputLayoutCardNumber.hasFocus();
                        if (validation instanceof Validation.Invalid && !cardNumberHasFocus) {
                            CardView.setCardNumberError$default(this, ((Validation.Invalid)validation).getReason(), false, 2, null);
                            return;
                        }
                        DetectedCardType detectedCardType3 = (DetectedCardType)CollectionsKt.getOrNull(detectedCardTypes, (int)1);
                        if (detectedCardType3 == null) break block5;
                        DetectedCardType it = detectedCardType2 = detectedCardType3;
                        boolean bl = false;
                        detectedCardType3 = it.isReliable() ? detectedCardType2 : null;
                        if (detectedCardType3 == null) break block5;
                        detectedCardType = detectedCardType3;
                        boolean bl2 = false;
                        FrameLayout frameLayout = this.binding.cardBrandLogoContainerSecondary;
                        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"cardBrandLogoContainerSecondary");
                        View view = (View)frameLayout;
                        boolean value$iv = true;
                        boolean $i$f$setVisible = false;
                        $this$isVisible$iv2.setVisibility(0);
                        this.binding.cardBrandLogoImageViewSecondary.setStrokeWidth(4.0f);
                        RoundCornerImageView roundCornerImageView = this.binding.cardBrandLogoImageViewSecondary;
                        Intrinsics.checkNotNullExpressionValue((Object)roundCornerImageView, (String)"cardBrandLogoImageViewSecondary");
                        ImageView imageView = (ImageView)roundCornerImageView;
                        CardDelegate cardDelegate = this.cardDelegate;
                        if (cardDelegate == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
                            cardDelegate = null;
                        }
                        ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)cardDelegate.getComponentParams().getEnvironment(), (String)detectedCardType.getCardBrand().getTxVariant(), null, null, null, (int)R.drawable.ic_card, (int)R.drawable.ic_card, (int)28, null);
                        $this$isVisible$iv2 = detectedCardTypes;
                        cardView = this;
                        boolean $i$f$indexOfFirst = false;
                        index$iv = 0;
                        iterator = $this$indexOfFirst$iv.iterator();
                        break block6;
                    }
                    unit = null;
                    break block7;
                }
                while (iterator.hasNext()) {
                    Object item$iv = iterator.next();
                    DetectedCardType it = (DetectedCardType)item$iv;
                    boolean bl = false;
                    if (it.isSelected()) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            cardView.initCardBrandLogoViews(n2);
            this.initBrandSelectionListeners();
            unit = Unit.INSTANCE;
        }
        if (unit != null) return;
        CardView $this$setDualBrandedCardImages_u24lambda_u248 = this;
        boolean bl = false;
        $this$setDualBrandedCardImages_u24lambda_u248.binding.cardBrandLogoImageViewPrimary.setAlpha(1.0f);
        FrameLayout frameLayout = $this$setDualBrandedCardImages_u24lambda_u248.binding.cardBrandLogoContainerSecondary;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"cardBrandLogoContainerSecondary");
        detectedCardType = (View)frameLayout;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$setDualBrandedCardImages_u24lambda_u248.resetBrandSelectionInput();
    }

    private final void onExpiryDateValidated(FieldState<ExpiryDate> expiryDateState) {
        if (expiryDateState.getValidation().isValid()) {
            this.goToNextInputIfFocus((View)this.binding.editTextExpiryDate);
        }
    }

    private final void goToNextInputIfFocus(View view) {
        if (this.getRootView().findFocus() == view && view != null) {
            this.findViewById(view.getNextFocusForwardId()).requestFocus();
        }
    }

    private final void initCardNumberInput() {
        this.binding.editTextCardNumber.setOnChangeListener(arg_0 -> CardView.initCardNumberInput$lambda$9(this, arg_0));
        this.binding.editTextCardNumber.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initCardNumberInput$lambda$10(this, arg_0, arg_1));
    }

    private final void setCardErrorState(boolean hasFocus) {
        boolean shouldNotShowError;
        CardOutputData outputData;
        Validation cardNumberValidation;
        CardDelegate cardDelegate = this.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation.Invalid invalid = (cardNumberValidation = (outputData = cardDelegate.getOutputData()).getCardNumberState().getValidation()) instanceof Validation.Invalid ? (Validation.Invalid)cardNumberValidation : null;
        boolean showErrorWhileEditing = invalid != null ? invalid.getShowErrorWhileEditing() : false;
        boolean bl = shouldNotShowError = hasFocus && !showErrorWhileEditing;
        if (shouldNotShowError) {
            boolean shouldShowSecondaryLogo = outputData.isDualBranded();
            this.setCardNumberError(null, shouldShowSecondaryLogo);
        } else if (cardNumberValidation instanceof Validation.Invalid) {
            CardView.setCardNumberError$default(this, ((Validation.Invalid)cardNumberValidation).getReason(), false, 2, null);
        }
    }

    private final void setCardNumberError(@StringRes Integer stringResId, boolean shouldShowSecondaryLogo) {
        if (stringResId == null) {
            View $this$isVisible$iv;
            TextInputLayout textInputLayout = this.binding.textInputLayoutCardNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardNumber");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
            FrameLayout frameLayout = this.binding.cardBrandLogoContainerPrimary;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"cardBrandLogoContainerPrimary");
            View view = (View)frameLayout;
            boolean value$iv = true;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            FrameLayout frameLayout2 = this.binding.cardBrandLogoContainerSecondary;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"cardBrandLogoContainerSecondary");
            $this$isVisible$iv = (View)frameLayout2;
            boolean $i$f$setVisible2 = false;
            $this$isVisible$iv.setVisibility(shouldShowSecondaryLogo ? 0 : 8);
        } else {
            TextInputLayout textInputLayout = this.binding.textInputLayoutCardNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardNumber");
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(stringResId.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
            FrameLayout frameLayout = this.binding.cardBrandLogoContainerPrimary;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"cardBrandLogoContainerPrimary");
            View $this$isVisible$iv = (View)frameLayout;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            FrameLayout frameLayout3 = this.binding.cardBrandLogoContainerSecondary;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout3, (String)"cardBrandLogoContainerSecondary");
            $this$isVisible$iv = (View)frameLayout3;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
    }

    static /* synthetic */ void setCardNumberError$default(CardView cardView, Integer n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        cardView.setCardNumberError(n, bl);
    }

    private final void initCardBrandLogoViews(int selectedIndex) {
        switch (selectedIndex) {
            case -1: {
                this.deselectBrands();
                break;
            }
            case 0: {
                this.selectPrimaryBrand();
                break;
            }
            case 1: {
                this.selectSecondaryBrand();
                break;
            }
            default: {
                throw new CheckoutException("Illegal brand index selected. Selected index must be either 0 or 1.", null, 2, null);
            }
        }
    }

    private final void initBrandSelectionListeners() {
        this.binding.cardBrandLogoContainerPrimary.setOnClickListener(arg_0 -> CardView.initBrandSelectionListeners$lambda$11(this, arg_0));
        this.binding.cardBrandLogoContainerSecondary.setOnClickListener(arg_0 -> CardView.initBrandSelectionListeners$lambda$12(this, arg_0));
    }

    private final void resetBrandSelectionInput() {
        this.binding.cardBrandLogoContainerPrimary.setOnClickListener(null);
        this.binding.cardBrandLogoContainerSecondary.setOnClickListener(null);
    }

    private final void deselectBrands() {
        this.binding.cardBrandLogoImageViewPrimary.setAlpha(0.2f);
        this.binding.cardBrandLogoImageViewSecondary.setAlpha(0.2f);
    }

    private final void selectPrimaryBrand() {
        this.binding.cardBrandLogoImageViewPrimary.setAlpha(1.0f);
        this.binding.cardBrandLogoImageViewSecondary.setAlpha(0.2f);
    }

    private final void selectSecondaryBrand() {
        this.binding.cardBrandLogoImageViewPrimary.setAlpha(0.2f);
        this.binding.cardBrandLogoImageViewSecondary.setAlpha(1.0f);
    }

    private final void initExpiryDateInput() {
        this.binding.editTextExpiryDate.setOnChangeListener(arg_0 -> CardView.initExpiryDateInput$lambda$13(this, arg_0));
        this.binding.editTextExpiryDate.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initExpiryDateInput$lambda$14(this, arg_0, arg_1));
    }

    private final void initSecurityCodeInput() {
        SecurityCodeInput securityCodeEditText;
        EditText editText = this.binding.textInputLayoutSecurityCode.getEditText();
        SecurityCodeInput securityCodeInput = securityCodeEditText = editText instanceof SecurityCodeInput ? (SecurityCodeInput)editText : null;
        if (securityCodeInput != null) {
            securityCodeInput.setOnChangeListener(arg_0 -> CardView.initSecurityCodeInput$lambda$15(this, arg_0));
        }
        SecurityCodeInput securityCodeInput2 = securityCodeEditText;
        if (securityCodeInput2 != null) {
            securityCodeInput2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initSecurityCodeInput$lambda$16(this, arg_0, arg_1));
        }
    }

    private final void initHolderNameInput() {
        AdyenTextInputEditText cardHolderEditText;
        EditText editText = this.binding.textInputLayoutCardHolder.getEditText();
        AdyenTextInputEditText adyenTextInputEditText = cardHolderEditText = editText instanceof AdyenTextInputEditText ? (AdyenTextInputEditText)editText : null;
        if (adyenTextInputEditText != null) {
            adyenTextInputEditText.setOnChangeListener(arg_0 -> CardView.initHolderNameInput$lambda$17(this, arg_0));
        }
        AdyenTextInputEditText adyenTextInputEditText2 = cardHolderEditText;
        if (adyenTextInputEditText2 != null) {
            adyenTextInputEditText2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initHolderNameInput$lambda$18(this, arg_0, arg_1));
        }
    }

    private final void initSocialSecurityNumberInput() {
        AdyenTextInputEditText socialSecurityNumberEditText;
        EditText editText = this.binding.textInputLayoutSocialSecurityNumber.getEditText();
        AdyenTextInputEditText adyenTextInputEditText = socialSecurityNumberEditText = editText instanceof AdyenTextInputEditText ? (AdyenTextInputEditText)editText : null;
        if (adyenTextInputEditText != null) {
            adyenTextInputEditText.setOnChangeListener(arg_0 -> CardView.initSocialSecurityNumberInput$lambda$19(this, arg_0));
        }
        AdyenTextInputEditText adyenTextInputEditText2 = socialSecurityNumberEditText;
        if (adyenTextInputEditText2 != null) {
            adyenTextInputEditText2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initSocialSecurityNumberInput$lambda$20(this, arg_0, arg_1));
        }
    }

    private final void initKcpAuthenticationInput() {
        this.initKcpBirthDateOrTaxNumberInput();
        this.initKcpCardPasswordInput();
    }

    private final void initKcpBirthDateOrTaxNumberInput() {
        AdyenTextInputEditText kcpBirthDateOrRegistrationNumberEditText;
        EditText editText = this.binding.textInputLayoutKcpBirthDateOrTaxNumber.getEditText();
        AdyenTextInputEditText adyenTextInputEditText = kcpBirthDateOrRegistrationNumberEditText = editText instanceof AdyenTextInputEditText ? (AdyenTextInputEditText)editText : null;
        if (adyenTextInputEditText != null) {
            adyenTextInputEditText.setOnChangeListener(arg_0 -> CardView.initKcpBirthDateOrTaxNumberInput$lambda$21(this, arg_0));
        }
        AdyenTextInputEditText adyenTextInputEditText2 = kcpBirthDateOrRegistrationNumberEditText;
        if (adyenTextInputEditText2 != null) {
            adyenTextInputEditText2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initKcpBirthDateOrTaxNumberInput$lambda$22(this, arg_0, arg_1));
        }
    }

    private final void initKcpCardPasswordInput() {
        AdyenTextInputEditText kcpPasswordEditText;
        EditText editText = this.binding.textInputLayoutKcpCardPassword.getEditText();
        AdyenTextInputEditText adyenTextInputEditText = kcpPasswordEditText = editText instanceof AdyenTextInputEditText ? (AdyenTextInputEditText)editText : null;
        if (adyenTextInputEditText != null) {
            adyenTextInputEditText.setOnChangeListener(arg_0 -> CardView.initKcpCardPasswordInput$lambda$23(this, arg_0));
        }
        AdyenTextInputEditText adyenTextInputEditText2 = kcpPasswordEditText;
        if (adyenTextInputEditText2 != null) {
            adyenTextInputEditText2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initKcpCardPasswordInput$lambda$24(this, arg_0, arg_1));
        }
    }

    private final void initPostalCodeInput() {
        AdyenTextInputEditText postalCodeEditText;
        EditText editText = this.binding.textInputLayoutPostalCode.getEditText();
        AdyenTextInputEditText adyenTextInputEditText = postalCodeEditText = editText instanceof AdyenTextInputEditText ? (AdyenTextInputEditText)editText : null;
        if (adyenTextInputEditText != null) {
            adyenTextInputEditText.setOnChangeListener(arg_0 -> CardView.initPostalCodeInput$lambda$25(this, arg_0));
        }
        AdyenTextInputEditText adyenTextInputEditText2 = postalCodeEditText;
        if (adyenTextInputEditText2 != null) {
            adyenTextInputEditText2.setOnFocusChangeListener((arg_0, arg_1) -> CardView.initPostalCodeInput$lambda$26(this, arg_0, arg_1));
        }
    }

    private final void initAddressFormInput(CoroutineScope coroutineScope) {
        AddressFormInput addressFormInput = this.binding.addressFormInput;
        CardDelegate cardDelegate = this.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        addressFormInput.attachDelegate((AddressDelegate)cardDelegate, coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateInstallments(CardOutputData cardOutputData) {
        block5: {
            TextInputLayout installmentTextInputLayout;
            block4: {
                void $this$isVisible$iv;
                Object installmentOptionText;
                TextInputLayout textInputLayout = this.binding.textInputLayoutInstallments;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutInstallments");
                installmentTextInputLayout = textInputLayout;
                AppCompatAutoCompleteTextView appCompatAutoCompleteTextView = this.binding.autoCompleteTextViewInstallments;
                Intrinsics.checkNotNullExpressionValue((Object)appCompatAutoCompleteTextView, (String)"autoCompleteTextViewInstallments");
                AppCompatAutoCompleteTextView installmentAutoCompleteTextView = appCompatAutoCompleteTextView;
                if (!(!((Collection)cardOutputData.getInstallmentOptions()).isEmpty())) break block4;
                if (this.installmentListAdapter == null) {
                    this.initInstallments();
                }
                if (cardOutputData.getInstallmentState().getValue() == null) {
                    this.updateInstallmentSelection((InstallmentModel)CollectionsKt.first(cardOutputData.getInstallmentOptions()));
                    Context context = this.localizedContext;
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                        context = null;
                    }
                    installmentOptionText = InstallmentUtils.INSTANCE.getTextForInstallmentOption(context, (InstallmentModel)CollectionsKt.first(cardOutputData.getInstallmentOptions()));
                    installmentAutoCompleteTextView.setText((CharSequence)installmentOptionText);
                }
                InstallmentListAdapter installmentListAdapter = this.installmentListAdapter;
                if (installmentListAdapter != null) {
                    installmentListAdapter.setItems(cardOutputData.getInstallmentOptions());
                }
                installmentOptionText = installmentTextInputLayout;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText == null) break block5;
                EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                boolean bl = false;
                $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                break block5;
            }
            TextInputLayout $this$isVisible$iv = installmentTextInputLayout;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            int visibility$iv = 8;
            $this$isVisible$iv.setVisibility(visibility$iv);
            EditText editText = $this$isVisible$iv.getEditText();
            if (editText == null) break block5;
            EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
            boolean bl = false;
            $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
        }
    }

    private final void initInstallments() {
        block1: {
            AppCompatAutoCompleteTextView appCompatAutoCompleteTextView;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context2 = this.localizedContext;
            if (context2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context2 = null;
            }
            InstallmentListAdapter installmentListAdapter = this.installmentListAdapter = new InstallmentListAdapter(context, context2);
            if (installmentListAdapter == null) break block1;
            InstallmentListAdapter it = installmentListAdapter;
            boolean bl = false;
            AppCompatAutoCompleteTextView $this$initInstallments_u24lambda_u2429_u24lambda_u2428 = appCompatAutoCompleteTextView = this.binding.autoCompleteTextViewInstallments;
            boolean bl2 = false;
            $this$initInstallments_u24lambda_u2429_u24lambda_u2428.setInputType(0);
            $this$initInstallments_u24lambda_u2429_u24lambda_u2428.setAdapter((ListAdapter)it);
            $this$initInstallments_u24lambda_u2429_u24lambda_u2428.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> CardView.initInstallments$lambda$29$lambda$28$lambda$27(this, arg_0, arg_1, arg_2, arg_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleCvcUIState(InputFieldUIState cvcUIState) {
        switch (WhenMappings.$EnumSwitchMapping$0[cvcUIState.ordinal()]) {
            case 1: {
                void $this$isVisible$iv;
                TextInputLayout textInputLayout = this.binding.textInputLayoutSecurityCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
                TextInputLayout textInputLayout2 = textInputLayout;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                TextInputLayout textInputLayout3 = this.binding.textInputLayoutSecurityCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"textInputLayoutSecurityCode");
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout3, (int)R.style.AdyenCheckout_Card_SecurityCodeInput, (Context)context);
                break;
            }
            case 2: {
                TextInputLayout textInputLayout = this.binding.textInputLayoutSecurityCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
                TextInputLayout $this$isVisible$iv = textInputLayout;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                TextInputLayout textInputLayout4 = this.binding.textInputLayoutSecurityCode;
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                textInputLayout4.setHint((CharSequence)context.getString(R.string.checkout_card_security_code_optional_hint));
                break;
            }
            case 3: {
                TextInputLayout textInputLayout = this.binding.textInputLayoutSecurityCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
                TextInputLayout $this$isVisible$iv = textInputLayout;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                int visibility$iv = 8;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                ViewGroup.LayoutParams layoutParams = this.binding.textInputLayoutExpiryDate.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)layoutParams;
                params.setMarginEnd(0);
                this.binding.textInputLayoutExpiryDate.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleExpiryDateUIState(InputFieldUIState expiryDateUIState) {
        switch (WhenMappings.$EnumSwitchMapping$0[expiryDateUIState.ordinal()]) {
            case 1: {
                void $this$isVisible$iv;
                TextInputLayout textInputLayout = this.binding.textInputLayoutExpiryDate;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
                TextInputLayout textInputLayout2 = textInputLayout;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                TextInputLayout textInputLayout3 = this.binding.textInputLayoutExpiryDate;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"textInputLayoutExpiryDate");
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout3, (int)R.style.AdyenCheckout_Card_ExpiryDateInput, (Context)context);
                break;
            }
            case 2: {
                TextInputLayout textInputLayout = this.binding.textInputLayoutExpiryDate;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
                TextInputLayout $this$isVisible$iv = textInputLayout;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                TextInputLayout textInputLayout4 = this.binding.textInputLayoutExpiryDate;
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                textInputLayout4.setHint((CharSequence)context.getString(R.string.checkout_card_expiry_date_optional_hint));
                break;
            }
            case 3: {
                TextInputLayout textInputLayout = this.binding.textInputLayoutExpiryDate;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
                TextInputLayout $this$isVisible$iv = textInputLayout;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                int visibility$iv = 8;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                ViewGroup.LayoutParams layoutParams = this.binding.textInputLayoutSecurityCode.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)layoutParams;
                params.setMarginStart(0);
                this.binding.textInputLayoutSecurityCode.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleHolderNameUIState(InputFieldUIState holderNameUIState) {
        block0: {
            void $this$isVisible$iv;
            TextInputLayout textInputLayout = this.binding.textInputLayoutCardHolder;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardHolder");
            TextInputLayout textInputLayout2 = textInputLayout;
            boolean value$iv = holderNameUIState != InputFieldUIState.HIDDEN;
            boolean $i$f$setVisible = false;
            int visibility$iv = value$iv ? 0 : 8;
            $this$isVisible$iv.setVisibility(visibility$iv);
            EditText editText = $this$isVisible$iv.getEditText();
            if (editText == null) break block0;
            EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
            boolean bl = false;
            $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
        }
    }

    private final void setStorePaymentSwitchVisibility(boolean showStorePaymentField) {
        SwitchCompat switchCompat = this.binding.switchStorePaymentMethod;
        Intrinsics.checkNotNullExpressionValue((Object)switchCompat, (String)"switchStorePaymentMethod");
        View $this$isVisible$iv = (View)switchCompat;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(showStorePaymentField ? 0 : 8);
    }

    private final void setSocialSecurityNumberVisibility(boolean shouldShowSocialSecurityNumber) {
        block0: {
            TextInputLayout textInputLayout = this.binding.textInputLayoutSocialSecurityNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSocialSecurityNumber");
            TextInputLayout $this$isVisible$iv = textInputLayout;
            boolean $i$f$setVisible = false;
            int visibility$iv = shouldShowSocialSecurityNumber ? 0 : 8;
            $this$isVisible$iv.setVisibility(visibility$iv);
            EditText editText = $this$isVisible$iv.getEditText();
            if (editText == null) break block0;
            EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
            boolean bl = false;
            $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusable(shouldShowSocialSecurityNumber);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(shouldShowSocialSecurityNumber);
        }
    }

    private final void setKcpAuthVisibility(boolean shouldShowKCPAuth) {
        block1: {
            boolean bl;
            EditText $this$_set_isVisible__u24lambda_u240$iv;
            TextInputLayout textInputLayout = this.binding.textInputLayoutKcpBirthDateOrTaxNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
            TextInputLayout $this$isVisible$iv = textInputLayout;
            boolean $i$f$setVisible = false;
            int visibility$iv = shouldShowKCPAuth ? 0 : 8;
            $this$isVisible$iv.setVisibility(visibility$iv);
            EditText editText = $this$isVisible$iv.getEditText();
            if (editText != null) {
                $this$_set_isVisible__u24lambda_u240$iv = editText;
                bl = false;
                $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                $this$_set_isVisible__u24lambda_u240$iv.setFocusable(shouldShowKCPAuth);
                $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(shouldShowKCPAuth);
            }
            TextInputLayout textInputLayout2 = this.binding.textInputLayoutKcpCardPassword;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"textInputLayoutKcpCardPassword");
            $this$isVisible$iv = textInputLayout2;
            $i$f$setVisible = false;
            visibility$iv = shouldShowKCPAuth ? 0 : 8;
            $this$isVisible$iv.setVisibility(visibility$iv);
            EditText editText2 = $this$isVisible$iv.getEditText();
            if (editText2 == null) break block1;
            $this$_set_isVisible__u24lambda_u240$iv = editText2;
            bl = false;
            $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusable(shouldShowKCPAuth);
            $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(shouldShowKCPAuth);
        }
    }

    private final void setKcpHint(Integer kcpBirthDateOrTaxNumberHint) {
        Integer n = kcpBirthDateOrTaxNumberHint;
        if (n == null) {
            return;
        }
        n.intValue();
        TextInputLayout textInputLayout = this.binding.textInputLayoutKcpBirthDateOrTaxNumber;
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        textInputLayout.setHint((CharSequence)context.getString(kcpBirthDateOrTaxNumberHint.intValue()));
    }

    private final void setAddressInputVisibility(AddressFormUIState addressFormUIState) {
        switch (WhenMappings.$EnumSwitchMapping$1[addressFormUIState.ordinal()]) {
            case 1: {
                TextInputLayout $this$isVisible$iv;
                AddressFormInput addressFormInput = this.binding.addressFormInput;
                Intrinsics.checkNotNullExpressionValue((Object)addressFormInput, (String)"addressFormInput");
                View view = (View)addressFormInput;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                TextInputLayout textInputLayout = this.binding.textInputLayoutPostalCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
                $this$isVisible$iv = textInputLayout;
                value$iv = false;
                $i$f$setVisible = false;
                int visibility$iv = 8;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                break;
            }
            case 2: {
                AddressFormInput addressFormInput = this.binding.addressFormInput;
                Intrinsics.checkNotNullExpressionValue((Object)addressFormInput, (String)"addressFormInput");
                View $this$isVisible$iv = (View)addressFormInput;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
                TextInputLayout textInputLayout = this.binding.textInputLayoutPostalCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
                $this$isVisible$iv = textInputLayout;
                value$iv = true;
                $i$f$setVisible = false;
                int visibility$iv = 0;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                break;
            }
            case 3: {
                AddressFormInput addressFormInput = this.binding.addressFormInput;
                Intrinsics.checkNotNullExpressionValue((Object)addressFormInput, (String)"addressFormInput");
                View $this$isVisible$iv = (View)addressFormInput;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
                TextInputLayout textInputLayout = this.binding.textInputLayoutPostalCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
                $this$isVisible$iv = textInputLayout;
                value$iv = false;
                $i$f$setVisible = false;
                int visibility$iv = 8;
                $this$isVisible$iv.setVisibility(visibility$iv);
                EditText editText = $this$isVisible$iv.getEditText();
                if (editText != null) {
                    EditText $this$_set_isVisible__u24lambda_u240$iv = editText;
                    boolean bl = false;
                    $this$_set_isVisible__u24lambda_u240$iv.setVisibility(visibility$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusable(value$iv);
                    $this$_set_isVisible__u24lambda_u240$iv.setFocusableInTouchMode(value$iv);
                }
                break;
            }
        }
    }

    private final void updateAddressHint(AddressFormUIState addressFormUIState, boolean isOptional) {
        switch (WhenMappings.$EnumSwitchMapping$1[addressFormUIState.ordinal()]) {
            case 1: {
                this.binding.addressFormInput.updateAddressHint(isOptional);
                break;
            }
            case 2: {
                int postalCodeStyleResId = isOptional ? R.style.AdyenCheckout_PostalCodeInput_Optional : R.style.AdyenCheckout_PostalCodeInput;
                TextInputLayout textInputLayout = this.binding.textInputLayoutPostalCode;
                Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
                Context context = this.localizedContext;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                    context = null;
                }
                ViewExtensionsKt.setLocalizedHintFromStyle((TextInputLayout)textInputLayout, (int)postalCodeStyleResId, (Context)context);
            }
        }
    }

    private final void updateInstallmentSelection(InstallmentModel installmentModel) {
        block1: {
            InstallmentModel installmentModel2 = installmentModel;
            if (installmentModel2 == null) break block1;
            InstallmentModel it = installmentModel2;
            boolean bl = false;
            CardDelegate cardDelegate = this.cardDelegate;
            if (cardDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
                cardDelegate = null;
            }
            cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(it){
                final /* synthetic */ InstallmentModel $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull CardInputData $this$updateInputData) {
                    Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                    $this$updateInputData.setInstallmentOption(this.$it);
                }
            }));
        }
    }

    private final Activity getActivity(Context context) {
        Activity activity;
        Context context2 = context;
        if (context2 instanceof Activity) {
            activity = (Activity)context;
        } else if (context2 instanceof ContextWrapper) {
            Context context3 = ((ContextWrapper)context).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getBaseContext(...)");
            activity = this.getActivity(context3);
        } else {
            activity = null;
        }
        return activity;
    }

    private final void setCardList(List<CardListItem> cards, boolean isCardListVisible) {
        block2: {
            RecyclerView recyclerView = this.binding.recyclerViewCardList;
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"recyclerViewCardList");
            View $this$isVisible$iv = (View)recyclerView;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(isCardListVisible ? 0 : 8);
            if (!isCardListVisible) break block2;
            if (this.cardListAdapter == null) {
                this.cardListAdapter = new CardListAdapter();
                this.binding.recyclerViewCardList.setAdapter((RecyclerView.Adapter)this.cardListAdapter);
            }
            CardListAdapter cardListAdapter = this.cardListAdapter;
            if (cardListAdapter != null) {
                cardListAdapter.submitList(cards);
            }
        }
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    @JvmOverloads
    public CardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initView$lambda$1(ComponentDelegate $delegate, CompoundButton compoundButton, boolean isChecked) {
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        ((CardDelegate)$delegate).updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(isChecked){
            final /* synthetic */ boolean $isChecked;
            {
                this.$isChecked = $isChecked;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setStorePaymentMethodSwitchChecked(this.$isChecked);
            }
        }));
    }

    private static final void initCardNumberInput$lambda$9(CardView this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setCardErrorState(true);
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(this$0){
            final /* synthetic */ CardView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setCardNumber(CardView.access$getBinding$p((CardView)this.this$0).editTextCardNumber.getRawValue());
            }
        }));
    }

    private static final void initCardNumberInput$lambda$10(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setCardErrorState(hasFocus);
    }

    private static final void initBrandSelectionListeners$lambda$11(CardView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)initBrandSelectionListeners.1.1.INSTANCE));
        this$0.selectPrimaryBrand();
    }

    private static final void initBrandSelectionListeners$lambda$12(CardView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)initBrandSelectionListeners.2.1.INSTANCE));
        this$0.selectSecondaryBrand();
    }

    private static final void initExpiryDateInput$lambda$13(CardView this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExpiryDate date = this$0.binding.editTextExpiryDate.getDate();
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(date){
            final /* synthetic */ ExpiryDate $date;
            {
                this.$date = $date;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setExpiryDate(this.$date);
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutExpiryDate;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initExpiryDateInput$lambda$14(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation expiryDateValidation = cardDelegate.getOutputData().getExpiryDateState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutExpiryDate;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (expiryDateValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutExpiryDate;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutExpiryDate");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)expiryDateValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initSecurityCodeInput$lambda$15(CardView this$0, Editable editable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(editable){
            final /* synthetic */ Editable $editable;
            {
                this.$editable = $editable;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setSecurityCode(this.$editable.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initSecurityCodeInput$lambda$16(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation securityCodeValidation = cardDelegate.getOutputData().getSecurityCodeState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (securityCodeValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSecurityCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSecurityCode");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)securityCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initHolderNameInput$lambda$17(CardView this$0, Editable editable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(editable){
            final /* synthetic */ Editable $editable;
            {
                this.$editable = $editable;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setHolderName(this.$editable.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutCardHolder;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardHolder");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initHolderNameInput$lambda$18(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation holderNameValidation = cardDelegate.getOutputData().getHolderNameState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutCardHolder;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardHolder");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (holderNameValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutCardHolder;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutCardHolder");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)holderNameValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initSocialSecurityNumberInput$lambda$19(CardView this$0, Editable editable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(editable){
            final /* synthetic */ Editable $editable;
            {
                this.$editable = $editable;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setSocialSecurityNumber(this.$editable.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutSocialSecurityNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSocialSecurityNumber");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initSocialSecurityNumberInput$lambda$20(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation socialSecurityNumberValidation = cardDelegate.getOutputData().getSocialSecurityNumberState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSocialSecurityNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSocialSecurityNumber");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (socialSecurityNumberValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutSocialSecurityNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutSocialSecurityNumber");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)socialSecurityNumberValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initKcpBirthDateOrTaxNumberInput$lambda$21(CardView this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(it){
            final /* synthetic */ Editable $it;
            {
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setKcpBirthDateOrTaxNumber(this.$it.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpBirthDateOrTaxNumber;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initKcpBirthDateOrTaxNumberInput$lambda$22(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation kcpBirthDateOrTaxNumberValidation = cardDelegate.getOutputData().getKcpBirthDateOrTaxNumberState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpBirthDateOrTaxNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (kcpBirthDateOrTaxNumberValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpBirthDateOrTaxNumber;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpBirthDateOrTaxNumber");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)kcpBirthDateOrTaxNumberValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initKcpCardPasswordInput$lambda$23(CardView this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(it){
            final /* synthetic */ Editable $it;
            {
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.setKcpCardPassword(this.$it.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpCardPassword;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpCardPassword");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initKcpCardPasswordInput$lambda$24(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation kcpBirthDateOrRegistrationNumberValidation = cardDelegate.getOutputData().getKcpCardPasswordState().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpCardPassword;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpCardPassword");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (kcpBirthDateOrRegistrationNumberValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutKcpCardPassword;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutKcpCardPassword");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)kcpBirthDateOrRegistrationNumberValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initPostalCodeInput$lambda$25(CardView this$0, Editable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        cardDelegate.updateInputData((Function1<? super CardInputData, Unit>)((Function1)new Function1<CardInputData, Unit>(it){
            final /* synthetic */ Editable $it;
            {
                this.$it = $it;
                super(1);
            }

            public final void invoke(@NotNull CardInputData $this$updateInputData) {
                Intrinsics.checkNotNullParameter((Object)$this$updateInputData, (String)"$this$updateInputData");
                $this$updateInputData.getAddress().setPostalCode(this.$it.toString());
            }
        }));
        TextInputLayout textInputLayout = this$0.binding.textInputLayoutPostalCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
        ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
    }

    private static final void initPostalCodeInput$lambda$26(CardView this$0, View view, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CardDelegate cardDelegate = this$0.cardDelegate;
        if (cardDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDelegate");
            cardDelegate = null;
        }
        Validation postalCodeValidation = cardDelegate.getOutputData().getAddressState().getPostalCode().getValidation();
        if (hasFocus) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutPostalCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
            ViewExtensionsKt.hideError((TextInputLayout)textInputLayout);
        } else if (postalCodeValidation instanceof Validation.Invalid) {
            TextInputLayout textInputLayout = this$0.binding.textInputLayoutPostalCode;
            Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"textInputLayoutPostalCode");
            Context context = this$0.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            String string2 = context.getString(((Validation.Invalid)postalCodeValidation).getReason());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ViewExtensionsKt.showError((TextInputLayout)textInputLayout, (String)string2);
        }
    }

    private static final void initInstallments$lambda$29$lambda$28$lambda$27(CardView this$0, AdapterView adapterView, View view, int position, long l) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        InstallmentListAdapter installmentListAdapter = this$0.installmentListAdapter;
        this$0.updateInstallmentSelection(installmentListAdapter != null ? installmentListAdapter.getItem(position) : null);
    }

    public static final /* synthetic */ void access$outputDataChanged(CardView $this, CardOutputData cardOutputData) {
        $this.outputDataChanged(cardOutputData);
    }

    public static final /* synthetic */ CardViewBinding access$getBinding$p(CardView $this) {
        return $this.binding;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardView$Companion;", "", "()V", "PRIMARY_BRAND_INDEX", "", "SECONDARY_BRAND_INDEX", "SELECTED_BRAND_LOGO_ALPHA", "", "UNSELECTED_BRAND_INDEX", "UNSELECTED_BRAND_LOGO_ALPHA", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InputFieldUIState.values().length];
            try {
                nArray[InputFieldUIState.REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputFieldUIState.OPTIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputFieldUIState.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AddressFormUIState.values().length];
            try {
                nArray[AddressFormUIState.FULL_ADDRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressFormUIState.POSTAL_CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AddressFormUIState.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

