/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.adyen.checkout.card.databinding.BrandLogoBinding;
import com.adyen.checkout.card.internal.ui.model.CardListItem;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.view.RoundCornerImageView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/adyen/checkout/card/internal/ui/model/CardListItem;", "Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter$ImageViewHolder;", "()V", "onBindViewHolder", "", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "CardDiffCallback", "Companion", "ImageViewHolder", "card_release"})
public final class CardListAdapter
extends ListAdapter<CardListItem, ImageViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float VIEW_ALPHA_DETECTED = 1.0f;
    private static final float VIEW_ALPHA_NON_DETECTED = 0.2f;

    public CardListAdapter() {
        super((DiffUtil.ItemCallback)CardDiffCallback.INSTANCE);
    }

    @NotNull
    public ImageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BrandLogoBinding brandLogoBinding = BrandLogoBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)brandLogoBinding, (String)"inflate(...)");
        BrandLogoBinding binding = brandLogoBinding;
        return new ImageViewHolder(binding);
    }

    public void onBindViewHolder(@NotNull ImageViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        CardListItem card = (CardListItem)this.getCurrentList().get(position);
        float alpha = card.isDetected() ? 1.0f : 0.2f;
        Intrinsics.checkNotNull((Object)card);
        holder.bind(card, alpha);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter$CardDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lcom/adyen/checkout/card/internal/ui/model/CardListItem;", "()V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "card_release"})
    public static final class CardDiffCallback
    extends DiffUtil.ItemCallback<CardListItem> {
        @NotNull
        public static final CardDiffCallback INSTANCE = new CardDiffCallback();

        private CardDiffCallback() {
        }

        public boolean areItemsTheSame(@NotNull CardListItem oldItem, @NotNull CardListItem newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            return Intrinsics.areEqual((Object)oldItem.getCardBrand().getTxVariant(), (Object)newItem.getCardBrand().getTxVariant());
        }

        public boolean areContentsTheSame(@NotNull CardListItem oldItem, @NotNull CardListItem newItem) {
            Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
            Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
            return Intrinsics.areEqual((Object)oldItem, (Object)newItem);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter$Companion;", "", "()V", "VIEW_ALPHA_DETECTED", "", "VIEW_ALPHA_NON_DETECTED", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardListAdapter$ImageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/adyen/checkout/card/databinding/BrandLogoBinding;", "(Lcom/adyen/checkout/card/databinding/BrandLogoBinding;)V", "bind", "", "card", "Lcom/adyen/checkout/card/internal/ui/model/CardListItem;", "alpha", "", "card_release"})
    public static final class ImageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final BrandLogoBinding binding;

        public ImageViewHolder(@NotNull BrandLogoBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }

        public final void bind(@NotNull CardListItem card, float alpha) {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            this.binding.imageViewBrandLogo.setAlpha(alpha);
            RoundCornerImageView roundCornerImageView = this.binding.imageViewBrandLogo;
            Intrinsics.checkNotNullExpressionValue((Object)roundCornerImageView, (String)"imageViewBrandLogo");
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)((ImageView)roundCornerImageView), (Environment)card.getEnvironment(), (String)card.getCardBrand().getTxVariant(), null, null, null, (int)0, (int)0, (int)124, null);
        }
    }
}

