/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.model;

import com.adyen.checkout.card.AddressConfiguration;
import com.adyen.checkout.card.CardBrand;
import com.adyen.checkout.card.CardConfiguration;
import com.adyen.checkout.card.KCPAuthVisibility;
import com.adyen.checkout.card.SocialSecurityNumberVisibility;
import com.adyen.checkout.card.internal.ui.model.AddressFieldPolicyParams;
import com.adyen.checkout.card.internal.ui.model.CVCVisibility;
import com.adyen.checkout.card.internal.ui.model.CardComponentParams;
import com.adyen.checkout.card.internal.ui.model.InstallmentParams;
import com.adyen.checkout.card.internal.ui.model.InstallmentsParamsMapper;
import com.adyen.checkout.card.internal.ui.model.RestrictedCardType;
import com.adyen.checkout.card.internal.ui.model.StoredCVCVisibility;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.ui.model.AnalyticsParams;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionInstallmentConfiguration;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.model.AddressFieldPolicy;
import com.adyen.checkout.ui.core.internal.ui.model.AddressParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\fH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\n*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u001e\u001a\u00020\n*\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\n*\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper;", "", "installmentsParamsMapper", "Lcom/adyen/checkout/card/internal/ui/model/InstallmentsParamsMapper;", "overrideComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "overrideSessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "(Lcom/adyen/checkout/card/internal/ui/model/InstallmentsParamsMapper;Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;)V", "mapToParams", "Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;", "cardConfiguration", "Lcom/adyen/checkout/card/CardConfiguration;", "supportedCardBrands", "", "Lcom/adyen/checkout/card/CardBrand;", "sessionParams", "mapToParamsDefault", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "mapToParamsStored", "getSupportedCardBrands", "getSupportedCardBrandsStored", "mapToAddressParam", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressParams;", "Lcom/adyen/checkout/card/AddressConfiguration;", "mapToAddressParamFieldPolicy", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressFieldPolicy;", "Lcom/adyen/checkout/card/AddressConfiguration$CardAddressFieldPolicy;", "mapToParamsInternal", "override", "removeRestrictedCards", "Companion", "card_release"})
@SourceDebugExtension(value={"SMAP\nCardComponentParamsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardComponentParamsMapper.kt\ncom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1549#2:213\n1620#2,3:214\n766#2:217\n857#2,2:218\n*S KotlinDebug\n*F\n+ 1 CardComponentParamsMapper.kt\ncom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper\n*L\n120#1:213\n120#1:214,3\n137#1:217\n137#1:218,2\n*E\n"})
public final class CardComponentParamsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstallmentsParamsMapper installmentsParamsMapper;
    @Nullable
    private final ComponentParams overrideComponentParams;
    @Nullable
    private final SessionParams overrideSessionParams;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    public CardComponentParamsMapper(@NotNull InstallmentsParamsMapper installmentsParamsMapper, @Nullable ComponentParams overrideComponentParams, @Nullable SessionParams overrideSessionParams) {
        Intrinsics.checkNotNullParameter((Object)installmentsParamsMapper, (String)"installmentsParamsMapper");
        this.installmentsParamsMapper = installmentsParamsMapper;
        this.overrideComponentParams = overrideComponentParams;
        this.overrideSessionParams = overrideSessionParams;
    }

    @NotNull
    public final CardComponentParams mapToParamsDefault(@NotNull CardConfiguration cardConfiguration, @NotNull PaymentMethod paymentMethod, @Nullable SessionParams sessionParams) {
        Intrinsics.checkNotNullParameter((Object)cardConfiguration, (String)"cardConfiguration");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        List<CardBrand> supportedCardBrands = this.getSupportedCardBrands(cardConfiguration, paymentMethod);
        return this.mapToParams(cardConfiguration, supportedCardBrands, sessionParams);
    }

    @NotNull
    public final CardComponentParams mapToParamsStored(@NotNull CardConfiguration cardConfiguration, @Nullable SessionParams sessionParams) {
        Intrinsics.checkNotNullParameter((Object)cardConfiguration, (String)"cardConfiguration");
        List<CardBrand> supportedCardBrands = this.getSupportedCardBrandsStored(cardConfiguration);
        return this.mapToParams(cardConfiguration, supportedCardBrands, sessionParams);
    }

    private final CardComponentParams mapToParams(CardConfiguration cardConfiguration, List<CardBrand> supportedCardBrands, SessionParams sessionParams) {
        CardComponentParams cardComponentParams = this.override(this.mapToParamsInternal(cardConfiguration, supportedCardBrands), this.overrideComponentParams);
        SessionParams sessionParams2 = sessionParams;
        if (sessionParams2 == null) {
            sessionParams2 = this.overrideSessionParams;
        }
        return this.override(cardComponentParams, sessionParams2);
    }

    private final CardComponentParams mapToParamsInternal(CardConfiguration $this$mapToParamsInternal, List<CardBrand> supportedCardBrands) {
        KCPAuthVisibility kCPAuthVisibility;
        SocialSecurityNumberVisibility socialSecurityNumberVisibility;
        Locale locale = $this$mapToParamsInternal.getShopperLocale();
        Environment environment = $this$mapToParamsInternal.getEnvironment();
        String string2 = $this$mapToParamsInternal.getClientKey();
        AnalyticsParams analyticsParams = new AnalyticsParams($this$mapToParamsInternal.getAnalyticsConfiguration());
        Amount amount = $this$mapToParamsInternal.getAmount();
        Boolean bl = $this$mapToParamsInternal.isHolderNameRequired();
        boolean bl2 = bl != null ? bl : false;
        Boolean bl3 = $this$mapToParamsInternal.isSubmitButtonVisible();
        boolean bl4 = bl3 != null ? bl3 : true;
        String string3 = $this$mapToParamsInternal.getShopperReference();
        Boolean bl5 = $this$mapToParamsInternal.isStorePaymentFieldVisible();
        boolean bl6 = bl5 != null ? bl5 : true;
        SocialSecurityNumberVisibility socialSecurityNumberVisibility2 = $this$mapToParamsInternal.getSocialSecurityNumberVisibility();
        if (socialSecurityNumberVisibility2 == null) {
            socialSecurityNumberVisibility2 = socialSecurityNumberVisibility = SocialSecurityNumberVisibility.HIDE;
        }
        if ((kCPAuthVisibility = $this$mapToParamsInternal.getKcpAuthVisibility()) == null) {
            kCPAuthVisibility = KCPAuthVisibility.HIDE;
        }
        KCPAuthVisibility kCPAuthVisibility2 = kCPAuthVisibility;
        InstallmentParams installmentParams = this.installmentsParamsMapper.mapToInstallmentParams$card_release($this$mapToParamsInternal.getInstallmentConfiguration(), $this$mapToParamsInternal.getAmount(), $this$mapToParamsInternal.getShopperLocale());
        AddressConfiguration addressConfiguration = $this$mapToParamsInternal.getAddressConfiguration();
        if (addressConfiguration == null || (addressConfiguration = this.mapToAddressParam(addressConfiguration)) == null) {
            addressConfiguration = (AddressParams)AddressParams.None.INSTANCE;
        }
        AddressConfiguration addressConfiguration2 = addressConfiguration;
        CVCVisibility cVCVisibility = Intrinsics.areEqual((Object)$this$mapToParamsInternal.isHideCvc(), (Object)true) ? CVCVisibility.ALWAYS_HIDE : CVCVisibility.ALWAYS_SHOW;
        StoredCVCVisibility storedCVCVisibility = Intrinsics.areEqual((Object)$this$mapToParamsInternal.isHideCvcStoredCard(), (Object)true) ? StoredCVCVisibility.HIDE : StoredCVCVisibility.SHOW;
        return new CardComponentParams(locale, environment, string2, analyticsParams, false, amount, bl4, bl2, supportedCardBrands, string3, bl6, socialSecurityNumberVisibility, kCPAuthVisibility2, installmentParams, (AddressParams)addressConfiguration2, cVCVisibility, storedCVCVisibility);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CardBrand> getSupportedCardBrands(CardConfiguration $this$getSupportedCardBrands, PaymentMethod paymentMethod) {
        List list;
        CardComponentParamsMapper cardComponentParamsMapper = this;
        Iterable iterable = $this$getSupportedCardBrands.getSupportedCardBrands();
        if (!(iterable == null || iterable.isEmpty())) {
            Logger.v((String)TAG, (String)"Reading supportedCardTypes from configuration");
            list = $this$getSupportedCardBrands.getSupportedCardBrands();
        } else {
            List list2 = paymentMethod.getBrands();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!((Collection)list2).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Logger.v((String)TAG, (String)"Reading supportedCardTypes from API brands");
                List list3 = paymentMethod.getBrands();
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                iterable = list3;
                CardComponentParamsMapper cardComponentParamsMapper2 = cardComponentParamsMapper;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new CardBrand((String)it));
                }
                list = (List)destination$iv$iv;
                cardComponentParamsMapper = cardComponentParamsMapper2;
            } else {
                Logger.v((String)TAG, (String)"Falling back to CardConfiguration.DEFAULT_SUPPORTED_CARDS_LIST");
                list = CardConfiguration.Companion.getDEFAULT_SUPPORTED_CARDS_LIST();
            }
        }
        return cardComponentParamsMapper.removeRestrictedCards(list);
    }

    private final List<CardBrand> getSupportedCardBrandsStored(CardConfiguration $this$getSupportedCardBrandsStored) {
        List list = $this$getSupportedCardBrandsStored.getSupportedCardBrands();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return this.removeRestrictedCards(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CardBrand> removeRestrictedCards(List<CardBrand> $this$removeRestrictedCards) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$removeRestrictedCards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CardBrand it = (CardBrand)element$iv$iv;
            boolean bl = false;
            if (!(!RestrictedCardType.Companion.isRestrictedCardType(it.getTxVariant()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CardComponentParams override(CardComponentParams $this$override, ComponentParams overrideComponentParams) {
        if (overrideComponentParams == null) {
            return $this$override;
        }
        return CardComponentParams.copy$default($this$override, overrideComponentParams.getShopperLocale(), overrideComponentParams.getEnvironment(), overrideComponentParams.getClientKey(), overrideComponentParams.getAnalyticsParams(), overrideComponentParams.isCreatedByDropIn(), overrideComponentParams.getAmount(), false, false, null, null, false, null, null, null, null, null, null, 131008, null);
    }

    private final AddressParams mapToAddressParam(AddressConfiguration $this$mapToAddressParam) {
        AddressParams addressParams;
        AddressConfiguration addressConfiguration = $this$mapToAddressParam;
        if (addressConfiguration instanceof AddressConfiguration.FullAddress) {
            addressParams = (AddressParams)new AddressParams.FullAddress(((AddressConfiguration.FullAddress)$this$mapToAddressParam).getDefaultCountryCode(), ((AddressConfiguration.FullAddress)$this$mapToAddressParam).getSupportedCountryCodes(), this.mapToAddressParamFieldPolicy(((AddressConfiguration.FullAddress)$this$mapToAddressParam).getAddressFieldPolicy()));
        } else if (Intrinsics.areEqual((Object)addressConfiguration, (Object)AddressConfiguration.None.INSTANCE)) {
            addressParams = (AddressParams)AddressParams.None.INSTANCE;
        } else if (addressConfiguration instanceof AddressConfiguration.PostalCode) {
            addressParams = (AddressParams)new AddressParams.PostalCode(this.mapToAddressParamFieldPolicy(((AddressConfiguration.PostalCode)$this$mapToAddressParam).getAddressFieldPolicy()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return addressParams;
    }

    private final AddressFieldPolicy mapToAddressParamFieldPolicy(AddressConfiguration.CardAddressFieldPolicy $this$mapToAddressParamFieldPolicy) {
        AddressFieldPolicy addressFieldPolicy;
        AddressConfiguration.CardAddressFieldPolicy cardAddressFieldPolicy = $this$mapToAddressParamFieldPolicy;
        if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.Optional) {
            addressFieldPolicy = AddressFieldPolicyParams.Optional.INSTANCE;
        } else if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.OptionalForCardTypes) {
            addressFieldPolicy = new AddressFieldPolicyParams.OptionalForCardTypes(((AddressConfiguration.CardAddressFieldPolicy.OptionalForCardTypes)$this$mapToAddressParamFieldPolicy).getBrands());
        } else if (cardAddressFieldPolicy instanceof AddressConfiguration.CardAddressFieldPolicy.Required) {
            addressFieldPolicy = AddressFieldPolicyParams.Required.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return addressFieldPolicy;
    }

    private final CardComponentParams override(CardComponentParams $this$override, SessionParams sessionParams) {
        if (sessionParams == null) {
            return $this$override;
        }
        Boolean bl = sessionParams.getEnableStoreDetails();
        boolean bl2 = bl != null ? bl.booleanValue() : $this$override.isStorePaymentFieldVisible();
        SessionInstallmentConfiguration sessionInstallmentConfiguration = sessionParams.getInstallmentConfiguration();
        Amount amount = sessionParams.getAmount();
        if (amount == null) {
            amount = $this$override.getAmount();
        }
        InstallmentParams installmentParams = this.installmentsParamsMapper.mapToInstallmentParams$card_release(sessionInstallmentConfiguration, amount, $this$override.getShopperLocale());
        Amount amount2 = sessionParams.getAmount();
        if (amount2 == null) {
            amount2 = $this$override.getAmount();
        }
        Amount amount3 = amount2;
        return CardComponentParams.copy$default($this$override, null, null, null, null, false, amount3, false, false, null, null, bl2, null, null, installmentParams, null, null, null, 121823, null);
    }

    static /* synthetic */ CardComponentParams override$default(CardComponentParamsMapper cardComponentParamsMapper, CardComponentParams cardComponentParams, SessionParams sessionParams, int n, Object object) {
        if ((n & 1) != 0) {
            sessionParams = null;
        }
        return cardComponentParamsMapper.override(cardComponentParams, sessionParams);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper$Companion;", "", "()V", "TAG", "", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

