/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui;

import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.card.BinLookupData;
import com.adyen.checkout.card.CardBrand;
import com.adyen.checkout.card.CardComponentState;
import com.adyen.checkout.card.CardType;
import com.adyen.checkout.card.internal.data.model.Brand;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.card.internal.ui.CardComponentViewType;
import com.adyen.checkout.card.internal.ui.CardDelegate;
import com.adyen.checkout.card.internal.ui.model.CardComponentParams;
import com.adyen.checkout.card.internal.ui.model.CardInputData;
import com.adyen.checkout.card.internal.ui.model.CardOutputData;
import com.adyen.checkout.card.internal.ui.model.ExpiryDate;
import com.adyen.checkout.card.internal.ui.model.InputFieldUIState;
import com.adyen.checkout.card.internal.ui.model.StoredCVCVisibility;
import com.adyen.checkout.card.internal.ui.view.InstallmentModel;
import com.adyen.checkout.card.internal.util.CardValidationUtils;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.StoredPaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepository;
import com.adyen.checkout.components.core.internal.data.api.PublicKeyRepository;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.paymentmethod.CardPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.cse.EncryptedCard;
import com.adyen.checkout.cse.EncryptionException;
import com.adyen.checkout.cse.UnencryptedCard;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import com.adyen.checkout.ui.core.internal.ui.AddressFormUIState;
import com.adyen.checkout.ui.core.internal.ui.ButtonComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIEvent;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIState;
import com.adyen.checkout.ui.core.internal.ui.SubmitHandler;
import com.adyen.checkout.ui.core.internal.ui.model.AddressInputModel;
import com.adyen.checkout.ui.core.internal.ui.model.AddressOutputData;
import com.adyen.checkout.ui.core.internal.util.AddressValidationUtils;
import com.adyen.threeds2.ThreeDS2Service;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0084\u00012\u00020\u0001:\u0002\u0084\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010F\u001a\u00020\u00122\b\b\u0002\u00103\u001a\u00020\u0017H\u0002J\b\u0010G\u001a\u00020\u0017H\u0002J\b\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u000209H\u0002J\b\u0010K\u001a\u000209H\u0016J\u0010\u0010L\u001a\u00020I2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010M\u001a\u00020IH\u0002J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020OH\u0002J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020R2\u0006\u0010V\u001a\u00020TH\u0002J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\u0006\u0010Z\u001a\u00020YH\u0002J\"\u0010[\u001a\u00020\u00122\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u0002092\b\u0010_\u001a\u0004\u0018\u00010#H\u0002J2\u0010`\u001a\u00020I2\u0006\u0010a\u001a\u00020b2\u0006\u0010(\u001a\u00020)2\u0018\u0010c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120e\u0012\u0004\u0012\u00020I0dH\u0016J\b\u0010f\u001a\u00020IH\u0016J\b\u0010g\u001a\u00020IH\u0002J\u0010\u0010h\u001a\u00020I2\u0006\u0010i\u001a\u00020\u0012H\u0002J\b\u0010j\u001a\u00020IH\u0016J\b\u0010k\u001a\u00020IH\u0016J\u0010\u0010l\u001a\u00020I2\u0006\u0010m\u001a\u00020OH\u0016J3\u0010n\u001a\u00020I2)\u0010o\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020q0p\u00a2\u0006\f\br\u0012\b\bs\u0012\u0004\b\b(t\u0012\u0004\u0012\u00020I\u0018\u00010dH\u0016J-\u0010u\u001a\u00020I2#\u0010o\u001a\u001f\u0012\u0013\u0012\u001109\u00a2\u0006\f\br\u0012\b\bs\u0012\u0004\b\b(v\u0012\u0004\u0012\u00020I\u0018\u00010dH\u0016J\u0010\u0010w\u001a\u00020I2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010x\u001a\u00020OH\u0016J!\u0010y\u001a\u00020I2\u0017\u0010z\u001a\u0013\u0012\u0004\u0012\u00020{\u0012\u0004\u0012\u00020I0d\u00a2\u0006\u0002\b|H\u0016J\u0015\u0010}\u001a\u00020I2\u0006\u00103\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b~J!\u0010\u007f\u001a\u00020I2\u0017\u0010z\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020I0d\u00a2\u0006\u0002\b|H\u0016J\"\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u0002092\u0007\u0010\u0083\u0001\u001a\u00020;H\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010!R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010!R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020#02X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010!R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010!R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010!R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010!R\u001c\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010!\u00a8\u0006\u0085\u0001"}, d2={"Lcom/adyen/checkout/card/internal/ui/StoredCardDelegate;", "Lcom/adyen/checkout/card/internal/ui/CardDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "storedPaymentMethod", "Lcom/adyen/checkout/components/core/StoredPaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "componentParams", "Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;", "analyticsRepository", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;", "cardEncryptor", "Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;", "publicKeyRepository", "Lcom/adyen/checkout/components/core/internal/data/api/PublicKeyRepository;", "submitHandler", "Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;", "Lcom/adyen/checkout/card/CardComponentState;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/StoredPaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;Lcom/adyen/checkout/components/core/internal/data/api/PublicKeyRepository;Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;)V", "_componentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_outputDataFlow", "Lcom/adyen/checkout/card/internal/ui/model/CardOutputData;", "_viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "addressOutputData", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressOutputData;", "getAddressOutputData", "()Lcom/adyen/checkout/ui/core/internal/ui/model/AddressOutputData;", "addressOutputDataFlow", "Lkotlinx/coroutines/flow/Flow;", "getAddressOutputDataFlow", "()Lkotlinx/coroutines/flow/Flow;", "cardType", "Lcom/adyen/checkout/card/CardBrand;", "getComponentParams", "()Lcom/adyen/checkout/card/internal/ui/model/CardComponentParams;", "componentStateFlow", "getComponentStateFlow", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "exceptionChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "inputData", "Lcom/adyen/checkout/card/internal/ui/model/CardInputData;", "noCvcBrands", "", "outputData", "getOutputData", "()Lcom/adyen/checkout/card/internal/ui/model/CardOutputData;", "outputDataFlow", "getOutputDataFlow", "publicKey", "", "storedDetectedCardTypes", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "submitFlow", "getSubmitFlow", "uiEventFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIEvent;", "getUiEventFlow", "uiStateFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIState;", "getUiStateFlow", "viewFlow", "getViewFlow", "createComponentState", "createOutputData", "fetchPublicKey", "", "getPaymentMethodId", "getPaymentMethodType", "initialize", "initializeInputData", "isConfirmationRequired", "", "isCvcHidden", "makeCvcUIState", "Lcom/adyen/checkout/card/internal/ui/model/InputFieldUIState;", "cvcPolicy", "Lcom/adyen/checkout/card/internal/data/model/Brand$FieldPolicy;", "makeExpiryDateUIState", "expiryDatePolicy", "makePaymentComponentData", "Lcom/adyen/checkout/components/core/PaymentComponentData;", "Lcom/adyen/checkout/components/core/paymentmethod/CardPaymentMethod;", "cardPaymentMethod", "mapComponentState", "encryptedCard", "Lcom/adyen/checkout/cse/EncryptedCard;", "cardNumber", "firstCardBrand", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "onInputDataChanged", "onState", "cardComponentState", "onSubmit", "removeObserver", "setInteractionBlocked", "isInteractionBlocked", "setOnBinLookupListener", "listener", "", "Lcom/adyen/checkout/card/BinLookupData;", "Lkotlin/ParameterName;", "name", "data", "setOnBinValueListener", "binValue", "setupAnalytics", "shouldShowSubmitButton", "updateAddressInputData", "update", "Lcom/adyen/checkout/ui/core/internal/ui/model/AddressInputModel;", "Lkotlin/ExtensionFunctionType;", "updateComponentState", "updateComponentState$card_release", "updateInputData", "validateSecurityCode", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "securityCode", "detectedCardType", "Companion", "card_release"})
@SourceDebugExtension(value={"SMAP\nStoredCardDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredCardDelegate.kt\ncom/adyen/checkout/card/internal/ui/StoredCardDelegate\n+ 2 RunCompileOnly.kt\ncom/adyen/checkout/core/internal/util/RunCompileOnlyKt\n*L\n1#1,423:1\n15#2,9:424\n*S KotlinDebug\n*F\n+ 1 StoredCardDelegate.kt\ncom/adyen/checkout/card/internal/ui/StoredCardDelegate\n*L\n334#1:424,9\n*E\n"})
public final class StoredCardDelegate
implements CardDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final StoredPaymentMethod storedPaymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final CardComponentParams componentParams;
    @NotNull
    private final AnalyticsRepository analyticsRepository;
    @NotNull
    private final BaseCardEncryptor cardEncryptor;
    @NotNull
    private final PublicKeyRepository publicKeyRepository;
    @NotNull
    private final SubmitHandler<CardComponentState> submitHandler;
    @NotNull
    private final Set<CardBrand> noCvcBrands;
    @NotNull
    private final CardBrand cardType;
    @NotNull
    private final DetectedCardType storedDetectedCardTypes;
    @NotNull
    private final CardInputData inputData;
    @NotNull
    private final MutableStateFlow<CardOutputData> _outputDataFlow;
    @NotNull
    private final Flow<CardOutputData> outputDataFlow;
    @NotNull
    private final MutableStateFlow<CardComponentState> _componentStateFlow;
    @NotNull
    private final Flow<CardComponentState> componentStateFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Flow<CardComponentState> submitFlow;
    @NotNull
    private final Flow<PaymentComponentUIState> uiStateFlow;
    @NotNull
    private final Flow<PaymentComponentUIEvent> uiEventFlow;
    @Nullable
    private String publicKey;
    @Nullable
    private CoroutineScope coroutineScope;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    private static final int LAST_FOUR_LENGTH = 4;

    public StoredCardDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull StoredPaymentMethod storedPaymentMethod, @Nullable OrderRequest order, @NotNull CardComponentParams componentParams, @NotNull AnalyticsRepository analyticsRepository, @NotNull BaseCardEncryptor cardEncryptor, @NotNull PublicKeyRepository publicKeyRepository, @NotNull SubmitHandler<CardComponentState> submitHandler) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)analyticsRepository, (String)"analyticsRepository");
        Intrinsics.checkNotNullParameter((Object)cardEncryptor, (String)"cardEncryptor");
        Intrinsics.checkNotNullParameter((Object)publicKeyRepository, (String)"publicKeyRepository");
        Intrinsics.checkNotNullParameter(submitHandler, (String)"submitHandler");
        this.observerRepository = observerRepository;
        this.storedPaymentMethod = storedPaymentMethod;
        this.order = order;
        this.componentParams = componentParams;
        this.analyticsRepository = analyticsRepository;
        this.cardEncryptor = cardEncryptor;
        this.publicKeyRepository = publicKeyRepository;
        this.submitHandler = submitHandler;
        Object[] objectArray = new CardBrand[]{new CardBrand(CardType.BCMC)};
        this.noCvcBrands = SetsKt.hashSetOf((Object[])objectArray);
        String string2 = this.storedPaymentMethod.getBrand();
        if (string2 == null) {
            string2 = "";
        }
        this.cardType = new CardBrand(string2);
        this.storedDetectedCardTypes = new DetectedCardType(this.cardType, true, true, this.getComponentParams().getStoredCVCVisibility() == StoredCVCVisibility.HIDE || this.noCvcBrands.contains(this.cardType) ? Brand.FieldPolicy.HIDDEN : Brand.FieldPolicy.REQUIRED, Brand.FieldPolicy.REQUIRED, true, null, null, false, 256, null);
        this.inputData = new CardInputData(null, null, null, null, null, null, null, null, null, false, 0, null, 4095, null);
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this._componentStateFlow = StateFlowKt.MutableStateFlow((Object)StoredCardDelegate.createComponentState$default(this, null, 1, null));
        this.componentStateFlow = (Flow)this._componentStateFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this._viewFlow = StateFlowKt.MutableStateFlow(null);
        this.viewFlow = (Flow)this._viewFlow;
        this.submitFlow = this.submitHandler.getSubmitFlow();
        this.uiStateFlow = this.submitHandler.getUiStateFlow();
        this.uiEventFlow = this.submitHandler.getUiEventFlow();
    }

    @NotNull
    public CardComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public Flow<CardOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @NotNull
    public AddressOutputData getAddressOutputData() {
        return ((CardOutputData)this._outputDataFlow.getValue()).getAddressState();
    }

    @NotNull
    public Flow<AddressOutputData> getAddressOutputDataFlow() {
        return (Flow)StateFlowKt.MutableStateFlow((Object)((CardOutputData)this._outputDataFlow.getValue()).getAddressState());
    }

    @Override
    @NotNull
    public Flow<CardComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @Override
    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @NotNull
    public Flow<CardComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIState> getUiStateFlow() {
        return this.uiStateFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIEvent> getUiEventFlow() {
        return this.uiEventFlow;
    }

    @Override
    @NotNull
    public CardOutputData getOutputData() {
        return (CardOutputData)this._outputDataFlow.getValue();
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        boolean requiresShopperInput;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.submitHandler.initialize(coroutineScope, this.getComponentStateFlow());
        this.setupAnalytics(coroutineScope);
        this.initializeInputData();
        this.fetchPublicKey();
        boolean bl = requiresShopperInput = !this.isCvcHidden();
        if (requiresShopperInput) {
            this._viewFlow.tryEmit((Object)CardComponentViewType.StoredCardView.INSTANCE);
        } else {
            FlowKt.launchIn((Flow)FlowKt.onEach(this.getComponentStateFlow(), (Function2)((Function2)new Function2<CardComponentState, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ StoredCardDelegate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CardComponentState it = (CardComponentState)this.L$0;
                            StoredCardDelegate.access$onState(this.this$0, it);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CardComponentState p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)coroutineScope);
        }
    }

    private final void onState(CardComponentState cardComponentState) {
        if (cardComponentState.isValid()) {
            this.submitHandler.onSubmit((PaymentComponentState)cardComponentState);
        }
    }

    private final void setupAnalytics(CoroutineScope coroutineScope) {
        Logger.v((String)TAG, (String)"setupAnalytics");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StoredCardDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = StoredCardDelegate.access$getAnalyticsRepository$p(this.this$0).setupAnalytics((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<CardComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getComponentStateFlow(), this.getExceptionFlow(), this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    private final void fetchPublicKey() {
        block0: {
            CoroutineScope coroutineScope = this.coroutineScope;
            if (coroutineScope == null) break block0;
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ StoredCardDelegate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = StoredCardDelegate.access$getPublicKeyRepository$p(this.this$0).fetchPublicKey-0E7RQCE(this.this$0.getComponentParams().getEnvironment(), this.this$0.getComponentParams().getClientKey(), (Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = ((Result)$result).unbox-impl();
lbl13:
                            // 2 sources

                            var2_3 = v0;
                            var3_4 = this.this$0;
                            var4_5 = this.this$0;
                            v1 = Result.exceptionOrNull-impl((Object)var2_3);
                            if (v1 == null) {
                                key = (String)var2_3;
                                $i$a$-fold-StoredCardDelegate$fetchPublicKey$1$1 = false;
                                StoredCardDelegate.access$setPublicKey$p(var3_4, key);
                                var3_4.updateComponentState$card_release(var3_4.getOutputData());
                            } else {
                                e = v1;
                                $i$a$-fold-StoredCardDelegate$fetchPublicKey$1$2 = false;
                                StoredCardDelegate.access$getExceptionChannel$p(var4_5).trySend-JP2dKIU((Object)new ComponentException("Unable to fetch publicKey.", e));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void updateInputData(@NotNull Function1<? super CardInputData, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        update.invoke((Object)this.inputData);
        this.onInputDataChanged();
    }

    @Override
    public void setInteractionBlocked(boolean isInteractionBlocked) {
        this.submitHandler.setInteractionBlocked(isInteractionBlocked);
    }

    private final void onInputDataChanged() {
        Logger.v((String)TAG, (String)"onInputDataChanged");
        CardOutputData outputData = this.createOutputData();
        this._outputDataFlow.tryEmit((Object)outputData);
        this.updateComponentState$card_release(outputData);
    }

    private final CardOutputData createOutputData() {
        CardInputData $this$createOutputData_u24lambda_u240 = this.inputData;
        boolean bl = false;
        return new CardOutputData((FieldState<String>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getCardNumber(), (Validation)Validation.Valid.INSTANCE), (FieldState<ExpiryDate>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getExpiryDate(), (Validation)Validation.Valid.INSTANCE), this.validateSecurityCode($this$createOutputData_u24lambda_u240.getSecurityCode(), this.storedDetectedCardTypes), (FieldState<String>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getHolderName(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getSocialSecurityNumber(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getKcpBirthDateOrTaxNumber(), (Validation)Validation.Valid.INSTANCE), (FieldState<String>)new FieldState((Object)$this$createOutputData_u24lambda_u240.getKcpCardPassword(), (Validation)Validation.Valid.INSTANCE), AddressValidationUtils.INSTANCE.makeValidEmptyAddressOutput(this.inputData.getAddress()), (FieldState<InstallmentModel>)new FieldState((Object)this.inputData.getInstallmentOption(), (Validation)Validation.Valid.INSTANCE), $this$createOutputData_u24lambda_u240.isStorePaymentMethodSwitchChecked(), this.makeCvcUIState(this.storedDetectedCardTypes.getCvcPolicy()), this.makeExpiryDateUIState(this.storedDetectedCardTypes.getExpiryDatePolicy()), InputFieldUIState.HIDDEN, false, CollectionsKt.listOf((Object)this.storedDetectedCardTypes), false, false, AddressFormUIState.NONE, CollectionsKt.emptyList(), CollectionsKt.emptyList(), false, null, false);
    }

    @VisibleForTesting
    public final void updateComponentState$card_release(@NotNull CardOutputData outputData) {
        Intrinsics.checkNotNullParameter((Object)outputData, (String)"outputData");
        Logger.v((String)TAG, (String)"updateComponentState");
        CardComponentState componentState = this.createComponentState(outputData);
        this._componentStateFlow.tryEmit((Object)componentState);
    }

    private final CardComponentState createComponentState(CardOutputData outputData) {
        EncryptedCard encryptedCard;
        String cardNumber = (String)outputData.getCardNumberState().getValue();
        DetectedCardType detectedCardType = (DetectedCardType)CollectionsKt.firstOrNull(outputData.getDetectedCardTypes());
        CardBrand firstCardBrand = detectedCardType != null ? detectedCardType.getCardBrand() : null;
        String publicKey = this.publicKey;
        if (!outputData.isValid() || publicKey == null) {
            return new CardComponentState((PaymentComponentData<CardPaymentMethod>)new PaymentComponentData(null, null, null, null, null, null, null, null, null, null, null, null, null, 8184, null), outputData.isValid(), publicKey != null, firstCardBrand, "", null);
        }
        UnencryptedCard.Builder unencryptedCardBuilder = new UnencryptedCard.Builder();
        try {
            ExpiryDate expiryDateResult;
            String cvc;
            if (!this.isCvcHidden() && ((CharSequence)(cvc = (String)outputData.getSecurityCodeState().getValue())).length() > 0) {
                unencryptedCardBuilder.setCvc(cvc);
            }
            if (!Intrinsics.areEqual((Object)(expiryDateResult = (ExpiryDate)outputData.getExpiryDateState().getValue()), (Object)ExpiryDate.EMPTY_DATE)) {
                unencryptedCardBuilder.setExpiryDate(String.valueOf(expiryDateResult.getExpiryMonth()), String.valueOf(expiryDateResult.getExpiryYear()));
            }
            encryptedCard = this.cardEncryptor.encryptFields(unencryptedCardBuilder.build(), publicKey);
        }
        catch (EncryptionException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
            return new CardComponentState((PaymentComponentData<CardPaymentMethod>)new PaymentComponentData(null, null, null, null, null, null, null, null, null, null, null, null, null, 8184, null), false, true, firstCardBrand, "", null);
        }
        EncryptedCard encryptedCard2 = encryptedCard;
        return this.mapComponentState(encryptedCard2, cardNumber, firstCardBrand);
    }

    static /* synthetic */ CardComponentState createComponentState$default(StoredCardDelegate storedCardDelegate, CardOutputData cardOutputData, int n, Object object) {
        if ((n & 1) != 0) {
            cardOutputData = storedCardDelegate.getOutputData();
        }
        return storedCardDelegate.createComponentState(cardOutputData);
    }

    public void onSubmit() {
        CardComponentState state = (CardComponentState)this._componentStateFlow.getValue();
        this.submitHandler.onSubmit((PaymentComponentState)state);
    }

    @NotNull
    public String getPaymentMethodType() {
        String string2 = this.storedPaymentMethod.getType();
        if (string2 == null) {
            string2 = "unknown";
        }
        return string2;
    }

    private final FieldState<String> validateSecurityCode(String securityCode, DetectedCardType detectedCardType) {
        InputFieldUIState cvcUiState = this.makeCvcUIState(detectedCardType.getCvcPolicy());
        return CardValidationUtils.INSTANCE.validateSecurityCode$card_release(securityCode, detectedCardType, cvcUiState);
    }

    private final boolean isCvcHidden() {
        return this.getOutputData().getCvcUIState() == InputFieldUIState.HIDDEN;
    }

    private final CardComponentState mapComponentState(EncryptedCard encryptedCard, String cardNumber, CardBrand firstCardBrand) {
        String string2;
        CardPaymentMethod cardPaymentMethod;
        CardPaymentMethod cardPaymentMethod2;
        block4: {
            CardPaymentMethod $this$mapComponentState_u24lambda_u242 = cardPaymentMethod2 = new CardPaymentMethod("scheme", this.analyticsRepository.getCheckoutAttemptId(), null, null, null, null, null, null, null, null, null, null, null, 8188, null);
            boolean bl = false;
            $this$mapComponentState_u24lambda_u242.setStoredPaymentMethodId(this.getPaymentMethodId());
            if (!this.isCvcHidden()) {
                $this$mapComponentState_u24lambda_u242.setEncryptedSecurityCode(encryptedCard.getEncryptedSecurityCode());
            }
            cardPaymentMethod = $this$mapComponentState_u24lambda_u242;
            boolean $i$f$runCompileOnly = false;
            try {
                boolean bl2 = false;
                string2 = ThreeDS2Service.INSTANCE.getSDKVersion();
                break block4;
            }
            catch (ClassNotFoundException e$iv) {
                Logger.w((String)LogUtil.getTag(), (String)"Class not found. Are you missing a dependency?", (Throwable)e$iv);
            }
            catch (NoClassDefFoundError e$iv) {
                Logger.w((String)LogUtil.getTag(), (String)"Class not found. Are you missing a dependency?", (Throwable)e$iv);
            }
            string2 = null;
        }
        cardPaymentMethod.setThreeDS2SdkVersion(string2);
        CardPaymentMethod cardPaymentMethod3 = cardPaymentMethod2;
        PaymentComponentData<CardPaymentMethod> paymentComponentData = this.makePaymentComponentData(cardPaymentMethod3);
        String lastFour = StringsKt.takeLast((String)cardNumber, (int)4);
        return new CardComponentState(paymentComponentData, true, true, firstCardBrand, "", lastFour);
    }

    private final PaymentComponentData<CardPaymentMethod> makePaymentComponentData(CardPaymentMethod cardPaymentMethod) {
        String string2 = this.getComponentParams().getShopperReference();
        OrderRequest orderRequest = this.order;
        Amount amount = this.getComponentParams().getAmount();
        return new PaymentComponentData((PaymentMethodDetails)cardPaymentMethod, orderRequest, amount, null, string2, null, null, null, null, null, null, null, null, 8168, null);
    }

    private final void initializeInputData() {
        String string2 = this.storedPaymentMethod.getLastFour();
        if (string2 == null) {
            string2 = "";
        }
        this.inputData.setCardNumber(string2);
        try {
            String string3 = this.storedPaymentMethod.getExpiryMonth();
            if (string3 == null) {
                string3 = "";
            }
            int n = Integer.parseInt(string3);
            String string4 = this.storedPaymentMethod.getExpiryYear();
            if (string4 == null) {
                string4 = "";
            }
            ExpiryDate storedDate = new ExpiryDate(n, Integer.parseInt(string4));
            this.inputData.setExpiryDate(storedDate);
        }
        catch (NumberFormatException e) {
            Logger.e((String)TAG, (String)"Failed to parse stored Date", (Throwable)e);
            this.inputData.setExpiryDate(ExpiryDate.EMPTY_DATE);
        }
        this.onInputDataChanged();
    }

    private final InputFieldUIState makeCvcUIState(Brand.FieldPolicy cvcPolicy) {
        InputFieldUIState inputFieldUIState;
        Logger.d((String)TAG, (String)("makeCvcUIState: " + cvcPolicy));
        switch (WhenMappings.$EnumSwitchMapping$0[cvcPolicy.ordinal()]) {
            case 1: {
                inputFieldUIState = InputFieldUIState.REQUIRED;
                break;
            }
            case 2: {
                inputFieldUIState = InputFieldUIState.OPTIONAL;
                break;
            }
            case 3: {
                inputFieldUIState = InputFieldUIState.HIDDEN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return inputFieldUIState;
    }

    private final InputFieldUIState makeExpiryDateUIState(Brand.FieldPolicy expiryDatePolicy) {
        return !expiryDatePolicy.isRequired() ? InputFieldUIState.OPTIONAL : InputFieldUIState.REQUIRED;
    }

    private final String getPaymentMethodId() {
        String string2 = this.storedPaymentMethod.getId();
        if (string2 == null) {
            string2 = "ID_NOT_FOUND";
        }
        return string2;
    }

    public boolean isConfirmationRequired() {
        return this._viewFlow.getValue() instanceof ButtonComponentViewType;
    }

    public boolean shouldShowSubmitButton() {
        return this.isConfirmationRequired() && this.getComponentParams().isSubmitButtonVisible();
    }

    public void updateAddressInputData(@NotNull Function1<? super AddressInputModel, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
    }

    @Override
    public void setOnBinValueListener(@Nullable Function1<? super String, Unit> listener) {
    }

    @Override
    public void setOnBinLookupListener(@Nullable Function1<? super List<BinLookupData>, Unit> listener) {
    }

    public void onCleared() {
        this.removeObserver();
        this.coroutineScope = null;
    }

    public static final /* synthetic */ void access$onState(StoredCardDelegate $this, CardComponentState cardComponentState) {
        $this.onState(cardComponentState);
    }

    public static final /* synthetic */ AnalyticsRepository access$getAnalyticsRepository$p(StoredCardDelegate $this) {
        return $this.analyticsRepository;
    }

    public static final /* synthetic */ PublicKeyRepository access$getPublicKeyRepository$p(StoredCardDelegate $this) {
        return $this.publicKeyRepository;
    }

    public static final /* synthetic */ void access$setPublicKey$p(StoredCardDelegate $this, String string2) {
        $this.publicKey = string2;
    }

    public static final /* synthetic */ Channel access$getExceptionChannel$p(StoredCardDelegate $this) {
        return $this.exceptionChannel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/card/internal/ui/StoredCardDelegate$Companion;", "", "()V", "LAST_FOUR_LENGTH", "", "TAG", "", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Brand.FieldPolicy.values().length];
            try {
                nArray[Brand.FieldPolicy.REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Brand.FieldPolicy.OPTIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Brand.FieldPolicy.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

