/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b%\b\u0086\u0081\u0002\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-\u00a8\u0006/"}, d2={"Lcom/adyen/checkout/card/CardType;", "", "txVariant", "", "pattern", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/regex/Pattern;)V", "getTxVariant", "()Ljava/lang/String;", "isEstimateFor", "", "cardNumber", "isEstimateFor$card_release", "AMERICAN_EXPRESS", "ARGENCARD", "BCMC", "BIJENKORF_CARD", "CABAL", "CARTEBANCAIRE", "CODENSA", "CUP", "DANKORT", "DINERS", "DISCOVER", "ELO", "FORBRUGSFORENINGEN", "VISAALPHABANKBONUS", "MCALPHABANKBONUS", "HIPER", "HIPERCARD", "JCB", "OASIS", "KARENMILLER", "WAREHOUSE", "LASER", "MAESTRO", "MAESTRO_UK", "MASTERCARD", "MIR", "NARANJA", "SHOPPING", "SOLO", "TROY", "UATP", "VISA", "VISADANKORT", "Companion", "card_release"})
public final class CardType
extends Enum<CardType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String txVariant;
    @NotNull
    private final Pattern pattern;
    public static final /* enum */ CardType AMERICAN_EXPRESS;
    public static final /* enum */ CardType ARGENCARD;
    public static final /* enum */ CardType BCMC;
    public static final /* enum */ CardType BIJENKORF_CARD;
    public static final /* enum */ CardType CABAL;
    public static final /* enum */ CardType CARTEBANCAIRE;
    public static final /* enum */ CardType CODENSA;
    public static final /* enum */ CardType CUP;
    public static final /* enum */ CardType DANKORT;
    public static final /* enum */ CardType DINERS;
    public static final /* enum */ CardType DISCOVER;
    public static final /* enum */ CardType ELO;
    public static final /* enum */ CardType FORBRUGSFORENINGEN;
    public static final /* enum */ CardType VISAALPHABANKBONUS;
    public static final /* enum */ CardType MCALPHABANKBONUS;
    public static final /* enum */ CardType HIPER;
    public static final /* enum */ CardType HIPERCARD;
    public static final /* enum */ CardType JCB;
    public static final /* enum */ CardType OASIS;
    public static final /* enum */ CardType KARENMILLER;
    public static final /* enum */ CardType WAREHOUSE;
    public static final /* enum */ CardType LASER;
    public static final /* enum */ CardType MAESTRO;
    public static final /* enum */ CardType MAESTRO_UK;
    public static final /* enum */ CardType MASTERCARD;
    public static final /* enum */ CardType MIR;
    public static final /* enum */ CardType NARANJA;
    public static final /* enum */ CardType SHOPPING;
    public static final /* enum */ CardType SOLO;
    public static final /* enum */ CardType TROY;
    public static final /* enum */ CardType UATP;
    public static final /* enum */ CardType VISA;
    public static final /* enum */ CardType VISADANKORT;
    private static final /* synthetic */ CardType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private CardType(String txVariant, Pattern pattern) {
        this.txVariant = txVariant;
        this.pattern = pattern;
    }

    @NotNull
    public final String getTxVariant() {
        return this.txVariant;
    }

    public final boolean isEstimateFor$card_release(@NotNull String cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        CharSequence charSequence = cardNumber;
        Regex regex = new Regex("\\s");
        String string = "";
        String normalizedCardNumber = regex.replace(charSequence, string);
        Matcher matcher = this.pattern.matcher(normalizedCardNumber);
        return matcher.matches() || matcher.hitEnd();
    }

    public static CardType[] values() {
        return (CardType[])$VALUES.clone();
    }

    public static CardType valueOf(String value) {
        return Enum.valueOf(CardType.class, value);
    }

    @NotNull
    public static EnumEntries<CardType> getEntries() {
        return $ENTRIES;
    }

    static {
        Pattern pattern = Pattern.compile("^3[47][0-9]{0,13}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        AMERICAN_EXPRESS = new CardType("amex", pattern);
        Pattern pattern2 = Pattern.compile("^(50)(1)\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        ARGENCARD = new CardType("argencard", pattern2);
        Pattern pattern3 = Pattern.compile("^((6703)[0-9]{0,15}|(479658|606005)[0-9]{0,13})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        BCMC = new CardType("bcmc", pattern3);
        Pattern pattern4 = Pattern.compile("^(5100081)[0-9]{0,9}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        BIJENKORF_CARD = new CardType("bijcard", pattern4);
        Pattern pattern5 = Pattern.compile("^(58|6[03])([03469])\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        CABAL = new CardType("cabal", pattern5);
        Pattern pattern6 = Pattern.compile("^[4-6][0-9]{0,15}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern6, (String)"compile(...)");
        CARTEBANCAIRE = new CardType("cartebancaire", pattern6);
        Pattern pattern7 = Pattern.compile("^(590712)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern7, (String)"compile(...)");
        CODENSA = new CardType("codensa", pattern7);
        Pattern pattern8 = Pattern.compile("^(62|81)[0-9]{0,17}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern8, (String)"compile(...)");
        CUP = new CardType("cup", pattern8);
        Pattern pattern9 = Pattern.compile("^(5019)[0-9]{0,12}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern9, (String)"compile(...)");
        DANKORT = new CardType("dankort", pattern9);
        Pattern pattern10 = Pattern.compile("^(36)[0-9]{0,12}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern10, (String)"compile(...)");
        DINERS = new CardType("diners", pattern10);
        Pattern pattern11 = Pattern.compile("^(6011[0-9]{0,12}|(644|645|646|647|648|649)[0-9]{0,13}|65[0-9]{0,14})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern11, (String)"compile(...)");
        DISCOVER = new CardType("discover", pattern11);
        Pattern pattern12 = Pattern.compile("^((((506699)|(506770)|(506771)|(506772)|(506773)|(506774)|(506775)|(506776)|(506777)|(506778)|(401178)|(438935)|(451416)|(457631)|(457632)|(504175)|(627780)|(636368)|(636297))[0-9]{0,10})|((50676)|(50675)|(50674)|(50673)|(50672)|(50671)|(50670))[0-9]{0,11})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern12, (String)"compile(...)");
        ELO = new CardType("elo", pattern12);
        Pattern pattern13 = Pattern.compile("^(60)(0)\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern13, (String)"compile(...)");
        FORBRUGSFORENINGEN = new CardType("forbrugsforeningen", pattern13);
        Pattern pattern14 = Pattern.compile("^(450903)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern14, (String)"compile(...)");
        VISAALPHABANKBONUS = new CardType("visaalphabankbonus", pattern14);
        Pattern pattern15 = Pattern.compile("^(510099)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern15, (String)"compile(...)");
        MCALPHABANKBONUS = new CardType("mcalphabankbonus", pattern15);
        Pattern pattern16 = Pattern.compile("^(637095|637599|637609|637612)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern16, (String)"compile(...)");
        HIPER = new CardType("hiper", pattern16);
        Pattern pattern17 = Pattern.compile("^(606282)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern17, (String)"compile(...)");
        HIPERCARD = new CardType("hipercard", pattern17);
        Pattern pattern18 = Pattern.compile("^(352[8,9]{1}[0-9]{0,15}|35[4-8]{1}[0-9]{0,16})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern18, (String)"compile(...)");
        JCB = new CardType("jcb", pattern18);
        Pattern pattern19 = Pattern.compile("^(982616)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern19, (String)"compile(...)");
        OASIS = new CardType("oasis", pattern19);
        Pattern pattern20 = Pattern.compile("^(98261465)[0-9]{0,8}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern20, (String)"compile(...)");
        KARENMILLER = new CardType("karenmillen", pattern20);
        Pattern pattern21 = Pattern.compile("^(982633)[0-9]{0,10}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern21, (String)"compile(...)");
        WAREHOUSE = new CardType("warehouse", pattern21);
        Pattern pattern22 = Pattern.compile("^(6304|6706|6709|6771)[0-9]{0,15}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern22, (String)"compile(...)");
        LASER = new CardType("laser", pattern22);
        Pattern pattern23 = Pattern.compile("^(5[0|6-8][0-9]{0,17}|6[0-9]{0,18})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern23, (String)"compile(...)");
        MAESTRO = new CardType("maestro", pattern23);
        Pattern pattern24 = Pattern.compile("^(6759)[0-9]{0,15}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern24, (String)"compile(...)");
        MAESTRO_UK = new CardType("maestrouk", pattern24);
        Pattern pattern25 = Pattern.compile("^(5[1-5][0-9]{0,14}|2[2-7][0-9]{0,14})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern25, (String)"compile(...)");
        MASTERCARD = new CardType("mc", pattern25);
        Pattern pattern26 = Pattern.compile("^(220)[0-9]{0,16}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern26, (String)"compile(...)");
        MIR = new CardType("mir", pattern26);
        Pattern pattern27 = Pattern.compile("^(37|40|5[28])([279])\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern27, (String)"compile(...)");
        NARANJA = new CardType("naranja", pattern27);
        Pattern pattern28 = Pattern.compile("^(27|58|60)([39])\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern28, (String)"compile(...)");
        SHOPPING = new CardType("shopping", pattern28);
        Pattern pattern29 = Pattern.compile("^(6767)[0-9]{0,15}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern29, (String)"compile(...)");
        SOLO = new CardType("solo", pattern29);
        Pattern pattern30 = Pattern.compile("^(97)(9)\\d*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern30, (String)"compile(...)");
        TROY = new CardType("troy", pattern30);
        Pattern pattern31 = Pattern.compile("^1[0-9]{0,14}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern31, (String)"compile(...)");
        UATP = new CardType("uatp", pattern31);
        Pattern pattern32 = Pattern.compile("^4[0-9]{0,18}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern32, (String)"compile(...)");
        VISA = new CardType("visa", pattern32);
        Pattern pattern33 = Pattern.compile("^(4571)[0-9]{0,12}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern33, (String)"compile(...)");
        VISADANKORT = new CardType("visadankort", pattern33);
        $VALUES = cardTypeArray = new CardType[]{CardType.AMERICAN_EXPRESS, CardType.ARGENCARD, CardType.BCMC, CardType.BIJENKORF_CARD, CardType.CABAL, CardType.CARTEBANCAIRE, CardType.CODENSA, CardType.CUP, CardType.DANKORT, CardType.DINERS, CardType.DISCOVER, CardType.ELO, CardType.FORBRUGSFORENINGEN, CardType.VISAALPHABANKBONUS, CardType.MCALPHABANKBONUS, CardType.HIPER, CardType.HIPERCARD, CardType.JCB, CardType.OASIS, CardType.KARENMILLER, CardType.WAREHOUSE, CardType.LASER, CardType.MAESTRO, CardType.MAESTRO_UK, CardType.MASTERCARD, CardType.MIR, CardType.NARANJA, CardType.SHOPPING, CardType.SOLO, CardType.TROY, CardType.UATP, CardType.VISA, CardType.VISADANKORT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/card/CardType$Companion;", "", "()V", "getByBrandName", "Lcom/adyen/checkout/card/CardType;", "brand", "", "card_release"})
    @SourceDebugExtension(value={"SMAP\nCardType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardType.kt\ncom/adyen/checkout/card/CardType$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n1282#2,2:86\n*S KotlinDebug\n*F\n+ 1 CardType.kt\ncom/adyen/checkout/card/CardType$Companion\n*L\n81#1:86,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CardType getByBrandName(@NotNull String brand) {
            CardType cardType;
            block1: {
                Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
                CardType[] $this$firstOrNull$iv = CardType.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    CardType element$iv;
                    CardType it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTxVariant(), (Object)brand)) continue;
                    cardType = element$iv;
                    break block1;
                }
                cardType = null;
            }
            return cardType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

