/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card;

import android.app.Activity;
import android.content.Intent;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.adyen.checkout.action.core.internal.ActionHandlingComponent;
import com.adyen.checkout.action.core.internal.DefaultActionHandlingComponent;
import com.adyen.checkout.action.core.internal.ui.GenericActionDelegate;
import com.adyen.checkout.card.BinLookupData;
import com.adyen.checkout.card.CardComponentState;
import com.adyen.checkout.card.internal.provider.CardComponentProvider;
import com.adyen.checkout.card.internal.ui.CardDelegate;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.internal.ActionComponentEventKt;
import com.adyen.checkout.components.core.internal.ButtonComponent;
import com.adyen.checkout.components.core.internal.ComponentEventHandler;
import com.adyen.checkout.components.core.internal.PaymentComponent;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.ButtonDelegate;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.ViewableComponent;
import com.adyen.checkout.ui.core.internal.util.FlowExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001>B+\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0001J\u0019\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\u0011\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0096\u0001J\b\u0010&\u001a\u00020\u001cH\u0016J*\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\u0018\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0,\u0012\u0004\u0012\u00020 0+H\u0007J\b\u0010-\u001a\u00020 H\u0014J\b\u0010.\u001a\u00020 H\u0007J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u001cH\u0016J1\u00101\u001a\u00020 2)\u00102\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020403\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(7\u0012\u0004\u0012\u00020 \u0018\u00010+J+\u00108\u001a\u00020 2#\u00102\u001a\u001f\u0012\u0013\u0012\u001109\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(:\u0012\u0004\u0012\u00020 \u0018\u00010+J\u0017\u0010;\u001a\u00020 2\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0<H\u0096\u0001J\b\u0010=\u001a\u00020 H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lcom/adyen/checkout/card/CardComponent;", "Landroidx/lifecycle/ViewModel;", "Lcom/adyen/checkout/components/core/internal/PaymentComponent;", "Lcom/adyen/checkout/ui/core/internal/ui/ViewableComponent;", "Lcom/adyen/checkout/components/core/internal/ButtonComponent;", "Lcom/adyen/checkout/action/core/internal/ActionHandlingComponent;", "cardDelegate", "Lcom/adyen/checkout/card/internal/ui/CardDelegate;", "genericActionDelegate", "Lcom/adyen/checkout/action/core/internal/ui/GenericActionDelegate;", "actionHandlingComponent", "Lcom/adyen/checkout/action/core/internal/DefaultActionHandlingComponent;", "componentEventHandler", "Lcom/adyen/checkout/components/core/internal/ComponentEventHandler;", "Lcom/adyen/checkout/card/CardComponentState;", "(Lcom/adyen/checkout/card/internal/ui/CardDelegate;Lcom/adyen/checkout/action/core/internal/ui/GenericActionDelegate;Lcom/adyen/checkout/action/core/internal/DefaultActionHandlingComponent;Lcom/adyen/checkout/components/core/internal/ComponentEventHandler;)V", "getComponentEventHandler$card_release", "()Lcom/adyen/checkout/components/core/internal/ComponentEventHandler;", "delegate", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "getDelegate", "()Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "viewFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getViewFlow", "()Lkotlinx/coroutines/flow/Flow;", "canHandleAction", "", "action", "Lcom/adyen/checkout/components/core/action/Action;", "handleAction", "", "activity", "Landroid/app/Activity;", "handleIntent", "intent", "Landroid/content/Intent;", "isConfirmationRequired", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "removeObserver", "setInteractionBlocked", "isInteractionBlocked", "setOnBinLookupListener", "listener", "", "Lcom/adyen/checkout/card/BinLookupData;", "Lkotlin/ParameterName;", "name", "data", "setOnBinValueListener", "", "binValue", "setOnRedirectListener", "Lkotlin/Function0;", "submit", "Companion", "card_release"})
public class CardComponent
extends ViewModel
implements PaymentComponent,
ViewableComponent,
ButtonComponent,
ActionHandlingComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CardDelegate cardDelegate;
    @NotNull
    private final GenericActionDelegate genericActionDelegate;
    @NotNull
    private final DefaultActionHandlingComponent actionHandlingComponent;
    @NotNull
    private final ComponentEventHandler<CardComponentState> componentEventHandler;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @JvmField
    @NotNull
    public static final CardComponentProvider PROVIDER = new CardComponentProvider(null, null, null, 7, null);
    @JvmField
    @NotNull
    public static final List<String> PAYMENT_METHOD_TYPES = CollectionsKt.listOf((Object)"scheme");

    public CardComponent(@NotNull CardDelegate cardDelegate, @NotNull GenericActionDelegate genericActionDelegate, @NotNull DefaultActionHandlingComponent actionHandlingComponent, @NotNull ComponentEventHandler<CardComponentState> componentEventHandler) {
        Intrinsics.checkNotNullParameter((Object)cardDelegate, (String)"cardDelegate");
        Intrinsics.checkNotNullParameter((Object)genericActionDelegate, (String)"genericActionDelegate");
        Intrinsics.checkNotNullParameter((Object)actionHandlingComponent, (String)"actionHandlingComponent");
        Intrinsics.checkNotNullParameter(componentEventHandler, (String)"componentEventHandler");
        this.cardDelegate = cardDelegate;
        this.genericActionDelegate = genericActionDelegate;
        this.actionHandlingComponent = actionHandlingComponent;
        this.componentEventHandler = componentEventHandler;
        this.viewFlow = (Flow)FlowExtensionsKt.mergeViewFlows$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (Flow)this.cardDelegate.getViewFlow(), (Flow)this.genericActionDelegate.getViewFlow(), null, null, (int)24, null);
        this.cardDelegate.initialize(ViewModelKt.getViewModelScope((ViewModel)this));
        this.genericActionDelegate.initialize(ViewModelKt.getViewModelScope((ViewModel)this));
        this.componentEventHandler.initialize(ViewModelKt.getViewModelScope((ViewModel)this));
    }

    @NotNull
    public final ComponentEventHandler<CardComponentState> getComponentEventHandler$card_release() {
        return this.componentEventHandler;
    }

    public boolean canHandleAction(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.actionHandlingComponent.canHandleAction(action);
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.actionHandlingComponent.handleAction(action, activity);
    }

    public void handleIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.actionHandlingComponent.handleIntent(intent);
    }

    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.actionHandlingComponent.setOnRedirectListener(listener);
    }

    @NotNull
    public ComponentDelegate getDelegate() {
        return this.actionHandlingComponent.getActiveDelegate();
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull Function1<? super PaymentComponentEvent<CardComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cardDelegate.observe(lifecycleOwner, ViewModelKt.getViewModelScope((ViewModel)this), callback);
        this.genericActionDelegate.observe(lifecycleOwner, ViewModelKt.getViewModelScope((ViewModel)this), ActionComponentEventKt.toActionCallback(callback));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void removeObserver() {
        this.cardDelegate.removeObserver();
        this.genericActionDelegate.removeObserver();
    }

    public boolean isConfirmationRequired() {
        return this.cardDelegate.isConfirmationRequired();
    }

    public void submit() {
        Unit unit;
        ComponentDelegate componentDelegate = this.getDelegate();
        ButtonDelegate buttonDelegate = componentDelegate instanceof ButtonDelegate ? (ButtonDelegate)componentDelegate : null;
        if (buttonDelegate != null) {
            buttonDelegate.onSubmit();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            Logger.e((String)TAG, (String)"Component is currently not submittable, ignoring.");
        }
    }

    public void setInteractionBlocked(boolean isInteractionBlocked) {
        block2: {
            Unit unit;
            ComponentDelegate componentDelegate = this.getDelegate();
            CardDelegate cardDelegate = componentDelegate instanceof CardDelegate ? (CardDelegate)componentDelegate : null;
            if (cardDelegate != null) {
                cardDelegate.setInteractionBlocked(isInteractionBlocked);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            Logger.e((String)TAG, (String)"Payment component is not interactable, ignoring.");
        }
    }

    public final void setOnBinValueListener(@Nullable Function1<? super String, Unit> listener) {
        this.cardDelegate.setOnBinValueListener(listener);
    }

    public final void setOnBinLookupListener(@Nullable Function1<? super List<BinLookupData>, Unit> listener) {
        this.cardDelegate.setOnBinLookupListener(listener);
    }

    protected void onCleared() {
        super.onCleared();
        Logger.d((String)TAG, (String)"onCleared");
        this.cardDelegate.onCleared();
        this.genericActionDelegate.onCleared();
        this.componentEventHandler.onCleared();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/card/CardComponent$Companion;", "", "()V", "PAYMENT_METHOD_TYPES", "", "", "PROVIDER", "Lcom/adyen/checkout/card/internal/provider/CardComponentProvider;", "TAG", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

