/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.blik.internal.ui;

import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.blik.BlikComponentState;
import com.adyen.checkout.blik.internal.ui.BlikComponentViewType;
import com.adyen.checkout.blik.internal.ui.BlikDelegate;
import com.adyen.checkout.blik.internal.ui.model.BlikInputData;
import com.adyen.checkout.blik.internal.ui.model.BlikOutputData;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.StoredPaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.ui.model.ButtonComponentParams;
import com.adyen.checkout.components.core.paymentmethod.BlikPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.ui.core.internal.ui.ButtonComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIEvent;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIState;
import com.adyen.checkout.ui.core.internal.ui.SubmitHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010+\u001a\u00020\u000eH\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\b\u00104\u001a\u000205H\u0016J2\u00106\u001a\u0002002\u0006\u00107\u001a\u0002082\u0006\u00101\u001a\u0002022\u0018\u00109\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0;\u0012\u0004\u0012\u0002000:H\u0016J\b\u0010<\u001a\u000200H\u0016J\b\u0010=\u001a\u000200H\u0016J\b\u0010>\u001a\u000200H\u0016J\u0010\u0010?\u001a\u0002002\u0006\u0010@\u001a\u000205H\u0016J\b\u0010A\u001a\u000205H\u0016J!\u0010B\u001a\u0002002\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u0002000:\u00a2\u0006\u0002\bEH\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001bR\u001c\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001b\u00a8\u0006F"}, d2={"Lcom/adyen/checkout/blik/internal/ui/StoredBlikDelegate;", "Lcom/adyen/checkout/blik/internal/ui/BlikDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;", "storedPaymentMethod", "Lcom/adyen/checkout/components/core/StoredPaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "submitHandler", "Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;", "Lcom/adyen/checkout/blik/BlikComponentState;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;Lcom/adyen/checkout/components/core/StoredPaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;)V", "_componentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_outputDataFlow", "Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData;", "_viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;", "componentStateFlow", "Lkotlinx/coroutines/flow/Flow;", "getComponentStateFlow", "()Lkotlinx/coroutines/flow/Flow;", "outputData", "getOutputData", "()Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData;", "outputDataFlow", "getOutputDataFlow", "submitFlow", "getSubmitFlow", "uiEventFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIEvent;", "getUiEventFlow", "uiStateFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIState;", "getUiStateFlow", "viewFlow", "getViewFlow", "createComponentState", "createOutputData", "getPaymentMethodType", "", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initializeAnalytics", "isConfirmationRequired", "", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "onSubmit", "removeObserver", "setInteractionBlocked", "isInteractionBlocked", "shouldShowSubmitButton", "updateInputData", "update", "Lcom/adyen/checkout/blik/internal/ui/model/BlikInputData;", "Lkotlin/ExtensionFunctionType;", "blik_release"})
@SourceDebugExtension(value={"SMAP\nStoredBlikDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredBlikDelegate.kt\ncom/adyen/checkout/blik/internal/ui/StoredBlikDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,153:1\n16#2,17:154\n16#2,17:171\n*S KotlinDebug\n*F\n+ 1 StoredBlikDelegate.kt\ncom/adyen/checkout/blik/internal/ui/StoredBlikDelegate\n*L\n70#1:154,17\n104#1:171,17\n*E\n"})
public final class StoredBlikDelegate
implements BlikDelegate {
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final ButtonComponentParams componentParams;
    @NotNull
    private final StoredPaymentMethod storedPaymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final SubmitHandler<BlikComponentState> submitHandler;
    @NotNull
    private final MutableStateFlow<BlikOutputData> _outputDataFlow;
    @NotNull
    private final Flow<BlikOutputData> outputDataFlow;
    @NotNull
    private final MutableStateFlow<BlikComponentState> _componentStateFlow;
    @NotNull
    private final Flow<BlikComponentState> componentStateFlow;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Flow<BlikComponentState> submitFlow;
    @NotNull
    private final Flow<PaymentComponentUIState> uiStateFlow;
    @NotNull
    private final Flow<PaymentComponentUIEvent> uiEventFlow;

    public StoredBlikDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull ButtonComponentParams componentParams, @NotNull StoredPaymentMethod storedPaymentMethod, @Nullable OrderRequest order, @NotNull AnalyticsManager analyticsManager, @NotNull SubmitHandler<BlikComponentState> submitHandler) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        Intrinsics.checkNotNullParameter((Object)analyticsManager, (String)"analyticsManager");
        Intrinsics.checkNotNullParameter(submitHandler, (String)"submitHandler");
        this.observerRepository = observerRepository;
        this.componentParams = componentParams;
        this.storedPaymentMethod = storedPaymentMethod;
        this.order = order;
        this.analyticsManager = analyticsManager;
        this.submitHandler = submitHandler;
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this._componentStateFlow = StateFlowKt.MutableStateFlow((Object)this.createComponentState());
        this.componentStateFlow = (Flow)this._componentStateFlow;
        this._viewFlow = StateFlowKt.MutableStateFlow((Object)BlikComponentViewType.INSTANCE);
        this.viewFlow = (Flow)this._viewFlow;
        this.submitFlow = this.submitHandler.getSubmitFlow();
        this.uiStateFlow = this.submitHandler.getUiStateFlow();
        this.uiEventFlow = this.submitHandler.getUiEventFlow();
    }

    @NotNull
    public ButtonComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public Flow<BlikOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @Override
    @NotNull
    public BlikOutputData getOutputData() {
        return (BlikOutputData)this._outputDataFlow.getValue();
    }

    @Override
    @NotNull
    public Flow<BlikComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @NotNull
    public Flow<BlikComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIState> getUiStateFlow() {
        return this.uiStateFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIEvent> getUiEventFlow() {
        return this.uiEventFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.submitHandler.initialize(coroutineScope, this.getComponentStateFlow());
        this.initializeAnalytics(coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeAnalytics(CoroutineScope coroutineScope) {
        StoredBlikDelegate storedBlikDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "initializeAnalytics";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        this.analyticsManager.initialize((Object)this, coroutineScope);
        String string4 = this.storedPaymentMethod.getType();
        if (string4 == null) {
            string4 = "";
        }
        AnalyticsEvent.Info event = GenericEvents.rendered$default((GenericEvents)GenericEvents.INSTANCE, (String)string4, (Boolean)true, null, null, (int)12, null);
        this.analyticsManager.trackEvent((AnalyticsEvent)event);
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<BlikComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getComponentStateFlow(), null, this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    @NotNull
    public String getPaymentMethodType() {
        String string2 = this.storedPaymentMethod.getType();
        if (string2 == null) {
            string2 = "unknown";
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateInputData(@NotNull Function1<? super BlikInputData, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        StoredBlikDelegate storedBlikDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "updateInputData should not be called in StoredBlikDelegate";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
    }

    public void onSubmit() {
        String string2 = this.storedPaymentMethod.getType();
        if (string2 == null) {
            string2 = "";
        }
        AnalyticsEvent.Log event = GenericEvents.INSTANCE.submit(string2);
        this.analyticsManager.trackEvent((AnalyticsEvent)event);
        BlikComponentState state = (BlikComponentState)this._componentStateFlow.getValue();
        this.submitHandler.onSubmit((PaymentComponentState)state);
    }

    private final BlikOutputData createOutputData() {
        return new BlikOutputData("");
    }

    private final BlikComponentState createComponentState() {
        BlikPaymentMethod paymentMethod = new BlikPaymentMethod("blik", this.analyticsManager.getCheckoutAttemptId(), null, this.storedPaymentMethod.getId(), 4, null);
        PaymentComponentData paymentComponentData = new PaymentComponentData((PaymentMethodDetails)paymentMethod, this.order, this.getComponentParams().getAmount(), null, null, null, null, null, null, null, null, null, null, null, 16376, null);
        return new BlikComponentState((PaymentComponentData<BlikPaymentMethod>)paymentComponentData, true, true);
    }

    public boolean isConfirmationRequired() {
        return this._viewFlow.getValue() instanceof ButtonComponentViewType;
    }

    public boolean shouldShowSubmitButton() {
        return this.isConfirmationRequired() && this.getComponentParams().isSubmitButtonVisible();
    }

    @Override
    public void setInteractionBlocked(boolean isInteractionBlocked) {
        this.submitHandler.setInteractionBlocked(isInteractionBlocked);
    }

    public void onCleared() {
        this.removeObserver();
        this.analyticsManager.clear((Object)this);
    }
}

