/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.await.internal.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.adyen.checkout.await.R;
import com.adyen.checkout.await.databinding.AwaitViewBinding;
import com.adyen.checkout.await.internal.ui.AwaitDelegate;
import com.adyen.checkout.await.internal.ui.model.AwaitOutputData;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0003\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u0018\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010!\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/adyen/checkout/await/internal/ui/view/AwaitView;", "Landroid/widget/LinearLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/await/databinding/AwaitViewBinding;", "delegate", "Lcom/adyen/checkout/await/internal/ui/AwaitDelegate;", "localizedContext", "getMessageTextResource", "paymentMethodType", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getView", "Landroid/view/View;", "highlightValidationErrors", "", "initLocalizedStrings", "initView", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "observeDelegate", "outputDataChanged", "outputData", "Lcom/adyen/checkout/await/internal/ui/model/AwaitOutputData;", "updateLogo", "updateMessageText", "Companion", "await_release"})
@SourceDebugExtension(value={"SMAP\nAwaitView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwaitView.kt\ncom/adyen/checkout/await/internal/ui/view/AwaitView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class AwaitView
extends LinearLayout
implements ComponentView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AwaitViewBinding binding;
    private Context localizedContext;
    private AwaitDelegate delegate;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    @JvmOverloads
    public AwaitView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        AwaitViewBinding awaitViewBinding = AwaitViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)awaitViewBinding, (String)"inflate(...)");
        this.binding = awaitViewBinding;
        this.setOrientation(1);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_double_margin);
        this.setPadding(padding, padding, padding, padding);
    }

    public /* synthetic */ AwaitView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof AwaitDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.delegate = (AwaitDelegate)delegate;
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.observeDelegate((AwaitDelegate)delegate, coroutineScope);
    }

    private final void initLocalizedStrings(Context localizedContext) {
        TextView textView = this.binding.textViewWaitingConfirmation;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textViewWaitingConfirmation");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)textView, (int)R.style.AdyenCheckout_Await_WaitingConfirmationTextView, (Context)localizedContext, (boolean)false, (int)4, null);
    }

    private final void observeDelegate(AwaitDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<AwaitOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AwaitView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AwaitOutputData it = (AwaitOutputData)this.L$0;
                        AwaitView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull AwaitOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    private final void outputDataChanged(AwaitOutputData outputData) {
        Logger.d((String)TAG, (String)"outputDataChanged");
        this.updateMessageText(outputData.getPaymentMethodType());
        this.updateLogo(outputData.getPaymentMethodType());
    }

    public void highlightValidationErrors() {
    }

    private final void updateMessageText(String paymentMethodType) {
        block1: {
            Integer n = this.getMessageTextResource(paymentMethodType);
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            TextView textView = this.binding.textViewOpenApp;
            Context context = this.localizedContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context = null;
            }
            textView.setText((CharSequence)context.getString(it));
        }
    }

    private final void updateLogo(String paymentMethodType) {
        block1: {
            Logger.d((String)TAG, (String)("updateLogo - " + paymentMethodType));
            String string2 = paymentMethodType;
            if (string2 == null) break block1;
            String txVariant = string2;
            boolean bl = false;
            ImageView imageView = this.binding.imageViewLogo;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewLogo");
            AwaitDelegate awaitDelegate = this.delegate;
            if (awaitDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                awaitDelegate = null;
            }
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)awaitDelegate.getComponentParams().getEnvironment(), (String)txVariant, null, null, null, (int)0, (int)0, (int)124, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @StringRes
    private final Integer getMessageTextResource(String paymentMethodType) {
        String string2 = paymentMethodType;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 0x2E2EEC: {
                if (string2.equals("blik")) {
                    n = 1;
                }
                break;
            }
            case 103700794: {
                if (string2.equals("mbway")) {
                    n = 2;
                }
                break;
            }
            case -2116042983: {
                if (string2.equals("upi_collect")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Integer n2 = R.string.checkout_await_message_blik;
                return n2;
            }
            case 2: {
                Integer n2 = R.string.checkout_await_message_mbway;
                return n2;
            }
            case 3: {
                Integer n2 = R.string.checkout_await_message_upi;
                return n2;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    @JvmOverloads
    public AwaitView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AwaitView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$outputDataChanged(AwaitView $this, AwaitOutputData outputData) {
        $this.outputDataChanged(outputData);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/await/internal/ui/view/AwaitView$Companion;", "", "()V", "TAG", "", "await_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

