/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.await.internal.ui;

import android.app.Activity;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.await.internal.ui.AwaitComponentViewType;
import com.adyen.checkout.await.internal.ui.AwaitDelegate;
import com.adyen.checkout.await.internal.ui.model.AwaitOutputData;
import com.adyen.checkout.components.core.ActionComponentData;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.AwaitAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.PaymentDataRepository;
import com.adyen.checkout.components.core.internal.data.api.StatusRepository;
import com.adyen.checkout.components.core.internal.data.model.StatusResponse;
import com.adyen.checkout.components.core.internal.ui.model.GenericComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.TimerData;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.internal.util.LifecycleExtensionsKt;
import com.adyen.checkout.components.core.internal.util.StatusResponseUtils;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 M2\u00020\u0001:\u0001MB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u000fH\u0002J\u001a\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u0002042\u0006\u00107\u001a\u0002082\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\fH\u0016J,\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u0002040AH\u0016J\b\u0010C\u001a\u000204H\u0016J\u0010\u0010D\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J#\u0010E\u001a\u0002042\f\u0010F\u001a\b\u0012\u0004\u0012\u0002060G2\u0006\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u000204H\u0016J\b\u0010J\u001a\u000204H\u0016J\u0018\u0010K\u001a\u0002042\u0006\u0010L\u001a\u0002022\u0006\u00107\u001a\u000208H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001bR\u001c\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001b\u00a8\u0006N"}, d2={"Lcom/adyen/checkout/await/internal/ui/DefaultAwaitDelegate;", "Lcom/adyen/checkout/await/internal/ui/AwaitDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "statusRepository", "Lcom/adyen/checkout/components/core/internal/data/api/StatusRepository;", "paymentDataRepository", "Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;Lcom/adyen/checkout/components/core/internal/data/api/StatusRepository;Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "_outputDataFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/await/internal/ui/model/AwaitOutputData;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "detailsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/components/core/ActionComponentData;", "detailsFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetailsFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "outputData", "getOutputData", "()Lcom/adyen/checkout/await/internal/ui/model/AwaitOutputData;", "outputDataFlow", "getOutputDataFlow", "statusPollingJob", "Lkotlinx/coroutines/Job;", "timerFlow", "Lcom/adyen/checkout/components/core/internal/ui/model/TimerData;", "getTimerFlow", "viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getViewFlow", "createActionComponentData", "details", "Lorg/json/JSONObject;", "createDetails", "payload", "", "createOutputData", "", "statusResponse", "Lcom/adyen/checkout/components/core/internal/data/model/StatusResponse;", "action", "Lcom/adyen/checkout/components/core/action/Action;", "handleAction", "activity", "Landroid/app/Activity;", "initialize", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "onCleared", "onPollingSuccessful", "onStatus", "result", "Lkotlin/Result;", "(Ljava/lang/Object;Lcom/adyen/checkout/components/core/action/Action;)V", "refreshStatus", "removeObserver", "startStatusPolling", "paymentData", "Companion", "await_release"})
public final class DefaultAwaitDelegate
implements AwaitDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final GenericComponentParams componentParams;
    @NotNull
    private final StatusRepository statusRepository;
    @NotNull
    private final PaymentDataRepository paymentDataRepository;
    @NotNull
    private final MutableStateFlow<AwaitOutputData> _outputDataFlow;
    @NotNull
    private final Flow<AwaitOutputData> outputDataFlow;
    @NotNull
    private final Channel<ActionComponentData> detailsChannel;
    @NotNull
    private final Flow<ActionComponentData> detailsFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Flow<TimerData> timerFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @Nullable
    private Job statusPollingJob;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    private static final long DEFAULT_MAX_POLLING_DURATION = TimeUnit.MINUTES.toMillis(15L);
    @NotNull
    public static final String PAYLOAD_DETAILS_KEY = "payload";

    public DefaultAwaitDelegate(@NotNull ActionObserverRepository observerRepository, @NotNull GenericComponentParams componentParams, @NotNull StatusRepository statusRepository, @NotNull PaymentDataRepository paymentDataRepository) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)statusRepository, (String)"statusRepository");
        Intrinsics.checkNotNullParameter((Object)paymentDataRepository, (String)"paymentDataRepository");
        this.observerRepository = observerRepository;
        this.componentParams = componentParams;
        this.statusRepository = statusRepository;
        this.paymentDataRepository = paymentDataRepository;
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this.detailsChannel = ChannelExtensionsKt.bufferedChannel();
        this.detailsFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.detailsChannel));
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.viewFlow = (Flow)StateFlowKt.MutableStateFlow((Object)AwaitComponentViewType.INSTANCE);
        this.timerFlow = FlowKt.flowOf((Object[])new TimerData[0]);
    }

    @NotNull
    public GenericComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public Flow<AwaitOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @NotNull
    public AwaitOutputData getOutputData() {
        return (AwaitOutputData)this._outputDataFlow.getValue();
    }

    @NotNull
    public Flow<ActionComponentData> getDetailsFlow() {
        return this.detailsFlow;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @NotNull
    public Flow<TimerData> getTimerFlow() {
        return this.timerFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return coroutineScope;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this._coroutineScope = coroutineScope;
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getDetailsFlow(), this.getExceptionFlow(), lifecycleOwner, coroutineScope, callback);
        LifecycleExtensionsKt.repeatOnResume((LifecycleOwner)lifecycleOwner, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultAwaitDelegate this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.refreshStatus();
            }
        }));
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!(action instanceof AwaitAction)) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Unsupported action", null, 2, null));
            return;
        }
        String paymentData = action.getPaymentData();
        this.paymentDataRepository.setPaymentData(paymentData);
        if (paymentData == null) {
            Logger.e((String)TAG, (String)"Payment data is null");
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Payment data is null", null, 2, null));
            return;
        }
        this.createOutputData(null, action);
        this.startStatusPolling(paymentData, action);
    }

    private final void startStatusPolling(String paymentData, Action action) {
        Job job = this.statusPollingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.statusPollingJob = FlowKt.launchIn((Flow)FlowKt.onEach((Flow)this.statusRepository.poll(paymentData, DEFAULT_MAX_POLLING_DURATION), (Function2)((Function2)new Function2<Result<? extends StatusResponse>, Continuation<? super Unit>, Object>(this, action, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAwaitDelegate this$0;
            final /* synthetic */ Action $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Object it = ((Result)this.L$0).unbox-impl();
                        DefaultAwaitDelegate.access$onStatus(this.this$0, it, this.$action);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Object p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(Result.box-impl((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.getCoroutineScope());
    }

    private final void onStatus(Object result, Action action) {
        Object object = result;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            StatusResponse response = (StatusResponse)object;
            boolean bl = false;
            Logger.v((String)TAG, (String)("Status changed - " + response.getResultCode()));
            this.createOutputData(response, action);
            if (StatusResponseUtils.isFinalResult((StatusResponse)response)) {
                this.onPollingSuccessful(response);
            }
        } else {
            Throwable it = throwable;
            boolean bl = false;
            Logger.e((String)TAG, (String)"Error while polling status", (Throwable)it);
            ChannelResult.box-impl((Object)this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Error while polling status", it)));
        }
    }

    private final void createOutputData(StatusResponse statusResponse, Action action) {
        boolean isValid = statusResponse != null && StatusResponseUtils.isFinalResult((StatusResponse)statusResponse);
        AwaitOutputData outputData = new AwaitOutputData(isValid, action.getPaymentMethodType());
        this._outputDataFlow.tryEmit((Object)outputData);
    }

    private final AwaitOutputData createOutputData() {
        return new AwaitOutputData(false, null);
    }

    private final void onPollingSuccessful(StatusResponse statusResponse) {
        CharSequence charSequence;
        String payload = statusResponse.getPayload();
        if (StatusResponseUtils.isFinalResult((StatusResponse)statusResponse) && !((charSequence = (CharSequence)payload) == null || charSequence.length() == 0)) {
            JSONObject details = this.createDetails(payload);
            this.detailsChannel.trySend-JP2dKIU((Object)this.createActionComponentData(details));
        } else {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Payment was not completed. - " + statusResponse.getResultCode(), null, 2, null));
        }
    }

    private final ActionComponentData createActionComponentData(JSONObject details) {
        String string2 = this.paymentDataRepository.getPaymentData();
        return new ActionComponentData(string2, details);
    }

    private final JSONObject createDetails(String payload) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PAYLOAD_DETAILS_KEY, (Object)payload);
        }
        catch (JSONException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Failed to create details.", (Throwable)e));
        }
        return jsonObject;
    }

    public void refreshStatus() {
        String string2 = this.paymentDataRepository.getPaymentData();
        if (string2 == null) {
            return;
        }
        String paymentData = string2;
        this.statusRepository.refreshStatus(paymentData);
    }

    public void onCleared() {
        this.removeObserver();
        Job job = this.statusPollingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.statusPollingJob = null;
        this._coroutineScope = null;
    }

    public void onError(@NotNull CheckoutException e) {
        AwaitDelegate.DefaultImpls.onError(this, e);
    }

    public static final /* synthetic */ void access$onStatus(DefaultAwaitDelegate $this, Object result, Action action) {
        $this.onStatus(result, action);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/await/internal/ui/DefaultAwaitDelegate$Companion;", "", "()V", "DEFAULT_MAX_POLLING_DURATION", "", "PAYLOAD_DETAILS_KEY", "", "getPAYLOAD_DETAILS_KEY$await_release$annotations", "TAG", "await_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPAYLOAD_DETAILS_KEY$await_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

