/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.action.core.internal.ui;

import android.app.Application;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.adyen3ds2.internal.provider.Adyen3DS2ComponentProvider;
import com.adyen.checkout.await.internal.provider.AwaitComponentProvider;
import com.adyen.checkout.components.core.CheckoutConfiguration;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.AwaitAction;
import com.adyen.checkout.components.core.action.BaseThreeds2Action;
import com.adyen.checkout.components.core.action.QrCodeAction;
import com.adyen.checkout.components.core.action.RedirectAction;
import com.adyen.checkout.components.core.action.SdkAction;
import com.adyen.checkout.components.core.action.VoucherAction;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.provider.ActionComponentProvider;
import com.adyen.checkout.components.core.internal.ui.ActionDelegate;
import com.adyen.checkout.components.core.internal.ui.model.DropInOverrideParams;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.internal.util.LocaleProvider;
import com.adyen.checkout.qrcode.internal.provider.QRCodeComponentProvider;
import com.adyen.checkout.redirect.internal.provider.RedirectComponentProvider;
import com.adyen.checkout.twint.action.internal.provider.TwintActionComponentProvider;
import com.adyen.checkout.voucher.internal.provider.VoucherComponentProvider;
import com.adyen.checkout.wechatpay.internal.provider.WeChatPayActionComponentProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adyen/checkout/action/core/internal/ui/ActionDelegateProvider;", "", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "dropInOverrideParams", "Lcom/adyen/checkout/components/core/internal/ui/model/DropInOverrideParams;", "localeProvider", "Lcom/adyen/checkout/core/internal/util/LocaleProvider;", "(Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;Lcom/adyen/checkout/components/core/internal/ui/model/DropInOverrideParams;Lcom/adyen/checkout/core/internal/util/LocaleProvider;)V", "getDelegate", "Lcom/adyen/checkout/components/core/internal/ui/ActionDelegate;", "action", "Lcom/adyen/checkout/components/core/action/Action;", "checkoutConfiguration", "Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "application", "Landroid/app/Application;", "getSdkActionComponentProvider", "Lcom/adyen/checkout/components/core/internal/provider/ActionComponentProvider;", "action-core_release"})
public final class ActionDelegateProvider {
    @Nullable
    private final AnalyticsManager analyticsManager;
    @Nullable
    private final DropInOverrideParams dropInOverrideParams;
    @NotNull
    private final LocaleProvider localeProvider;

    public ActionDelegateProvider(@Nullable AnalyticsManager analyticsManager, @Nullable DropInOverrideParams dropInOverrideParams, @NotNull LocaleProvider localeProvider) {
        Intrinsics.checkNotNullParameter((Object)localeProvider, (String)"localeProvider");
        this.analyticsManager = analyticsManager;
        this.dropInOverrideParams = dropInOverrideParams;
        this.localeProvider = localeProvider;
    }

    public /* synthetic */ ActionDelegateProvider(AnalyticsManager analyticsManager, DropInOverrideParams dropInOverrideParams, LocaleProvider localeProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            localeProvider = new LocaleProvider();
        }
        this(analyticsManager, dropInOverrideParams, localeProvider);
    }

    @NotNull
    public final ActionDelegate getDelegate(@NotNull Action action, @NotNull CheckoutConfiguration checkoutConfiguration, @NotNull SavedStateHandle savedStateHandle, @NotNull Application application) {
        ActionComponentProvider actionComponentProvider;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)checkoutConfiguration, (String)"checkoutConfiguration");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Action action2 = action;
        if (action2 instanceof AwaitAction) {
            actionComponentProvider = (ActionComponentProvider)new AwaitComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (action2 instanceof QrCodeAction) {
            actionComponentProvider = (ActionComponentProvider)new QRCodeComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (action2 instanceof RedirectAction) {
            actionComponentProvider = (ActionComponentProvider)new RedirectComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (action2 instanceof BaseThreeds2Action) {
            actionComponentProvider = (ActionComponentProvider)new Adyen3DS2ComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (action2 instanceof VoucherAction) {
            actionComponentProvider = (ActionComponentProvider)new VoucherComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (action2 instanceof SdkAction) {
            actionComponentProvider = this.getSdkActionComponentProvider(action);
        } else {
            throw new CheckoutException("Can't find delegate for action: " + action.getType(), null, 2, null);
        }
        ActionComponentProvider provider = actionComponentProvider;
        return provider.getDelegate(checkoutConfiguration, savedStateHandle, application);
    }

    private final ActionComponentProvider<?, ?, ?> getSdkActionComponentProvider(Action action) {
        ActionComponentProvider actionComponentProvider;
        String string = action.getPaymentMethodType();
        if (Intrinsics.areEqual((Object)string, (Object)"twint")) {
            actionComponentProvider = (ActionComponentProvider)new TwintActionComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else if (Intrinsics.areEqual((Object)string, (Object)"wechatpaySDK")) {
            actionComponentProvider = (ActionComponentProvider)new WeChatPayActionComponentProvider(this.analyticsManager, this.dropInOverrideParams, this.localeProvider);
        } else {
            throw new CheckoutException("Can't find delegate for action: " + action.getType() + " and type: " + action.getPaymentMethodType(), null, 2, null);
        }
        return actionComponentProvider;
    }
}

