/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.action.core.internal.ui;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.action.core.GenericActionConfiguration;
import com.adyen.checkout.action.core.internal.ui.ActionDelegateProvider;
import com.adyen.checkout.action.core.internal.ui.GenericActionDelegate;
import com.adyen.checkout.adyen3ds2.internal.ui.Adyen3DS2Delegate;
import com.adyen.checkout.components.core.ActionComponentData;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.Threeds2ChallengeAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.ui.ActionDelegate;
import com.adyen.checkout.components.core.internal.ui.DetailsEmittingDelegate;
import com.adyen.checkout.components.core.internal.ui.IntentHandlingDelegate;
import com.adyen.checkout.components.core.internal.ui.RedirectableDelegate;
import com.adyen.checkout.components.core.internal.ui.StatusPollingDelegate;
import com.adyen.checkout.components.core.internal.ui.model.GenericComponentParams;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.internal.util.LifecycleExtensionsKt;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.ViewProvidingDelegate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 G2\u00020\u0001:\u0001GB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020.H\u0002J,\u00107\u001a\u00020)2\u0006\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\u000e2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020)0;H\u0016J\u0010\u0010=\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010>\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010?\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010@\u001a\u00020)H\u0016J\u0010\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020$H\u0016J\b\u0010C\u001a\u00020)H\u0016J\b\u0010D\u001a\u00020)H\u0016J\u0016\u0010E\u001a\u00020)2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\"\u00a8\u0006H"}, d2={"Lcom/adyen/checkout/action/core/internal/ui/DefaultGenericActionDelegate;", "Lcom/adyen/checkout/action/core/internal/ui/GenericActionDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "configuration", "Lcom/adyen/checkout/action/core/GenericActionConfiguration;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "actionDelegateProvider", "Lcom/adyen/checkout/action/core/internal/ui/ActionDelegateProvider;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/action/core/GenericActionConfiguration;Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;Lcom/adyen/checkout/action/core/internal/ui/ActionDelegateProvider;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "_delegate", "Lcom/adyen/checkout/components/core/internal/ui/ActionDelegate;", "_viewFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "delegate", "getDelegate", "()Lcom/adyen/checkout/components/core/internal/ui/ActionDelegate;", "detailsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/components/core/ActionComponentData;", "detailsFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetailsFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "onRedirectListener", "Lkotlin/Function0;", "", "viewFlow", "getViewFlow", "handleAction", "action", "Lcom/adyen/checkout/components/core/action/Action;", "activity", "Landroid/app/Activity;", "handleIntent", "intent", "Landroid/content/Intent;", "initialize", "isOld3DS2Flow", "", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "observeDetails", "observeExceptions", "observeViewFlow", "onCleared", "onError", "e", "refreshStatus", "removeObserver", "setOnRedirectListener", "listener", "Companion", "action-core_release"})
@SourceDebugExtension(value={"SMAP\nDefaultGenericActionDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGenericActionDelegate.kt\ncom/adyen/checkout/action/core/internal/ui/DefaultGenericActionDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RunCompileOnly.kt\ncom/adyen/checkout/core/internal/util/RunCompileOnlyKt\n*L\n1#1,200:1\n1#2:201\n15#3,9:202\n*S KotlinDebug\n*F\n+ 1 DefaultGenericActionDelegate.kt\ncom/adyen/checkout/action/core/internal/ui/DefaultGenericActionDelegate\n*L\n129#1:202,9\n*E\n"})
public final class DefaultGenericActionDelegate
implements GenericActionDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final GenericActionConfiguration configuration;
    @NotNull
    private final GenericComponentParams componentParams;
    @NotNull
    private final ActionDelegateProvider actionDelegateProvider;
    @Nullable
    private ActionDelegate _delegate;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Channel<ActionComponentData> detailsChannel;
    @NotNull
    private final Flow<ActionComponentData> detailsFlow;
    @Nullable
    private Function0<Unit> onRedirectListener;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    public DefaultGenericActionDelegate(@NotNull ActionObserverRepository observerRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull GenericActionConfiguration configuration, @NotNull GenericComponentParams componentParams, @NotNull ActionDelegateProvider actionDelegateProvider) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)actionDelegateProvider, (String)"actionDelegateProvider");
        this.observerRepository = observerRepository;
        this.savedStateHandle = savedStateHandle;
        this.configuration = configuration;
        this.componentParams = componentParams;
        this.actionDelegateProvider = actionDelegateProvider;
        this._viewFlow = StateFlowKt.MutableStateFlow(null);
        this.viewFlow = (Flow)this._viewFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.detailsChannel = ChannelExtensionsKt.bufferedChannel();
        this.detailsFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.detailsChannel));
    }

    @NotNull
    public GenericComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public ActionDelegate getDelegate() {
        ActionDelegate actionDelegate = this._delegate;
        if (actionDelegate == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return actionDelegate;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return coroutineScope;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<ActionComponentData> getDetailsFlow() {
        return this.detailsFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Logger.d((String)TAG, (String)"initialize");
        this._coroutineScope = coroutineScope;
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getDetailsFlow(), this.getExceptionFlow(), lifecycleOwner, coroutineScope, callback);
        LifecycleExtensionsKt.repeatOnResume((LifecycleOwner)lifecycleOwner, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultGenericActionDelegate this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.refreshStatus();
            }
        }));
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.isOld3DS2Flow(action)) {
            Logger.d((String)TAG, (String)"Continuing the handling of 3ds2 challenge with old flow.");
        } else {
            ActionDelegate delegate;
            Application application = activity.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            this._delegate = delegate = this.actionDelegateProvider.getDelegate(action, this.configuration, this.savedStateHandle, application);
            Logger.d((String)TAG, (String)("Created delegate of type " + Reflection.getOrCreateKotlinClass(delegate.getClass()).getSimpleName()));
            if (delegate instanceof RedirectableDelegate) {
                Function0<Unit> function0 = this.onRedirectListener;
                if (function0 != null) {
                    Function0<Unit> it = function0;
                    boolean bl = false;
                    ((RedirectableDelegate)delegate).setOnRedirectListener(it);
                }
            }
            delegate.initialize(this.getCoroutineScope());
            this.observeDetails(delegate);
            this.observeExceptions(delegate);
            this.observeViewFlow(delegate);
        }
        this.getDelegate().handleAction(action, activity);
    }

    private final boolean isOld3DS2Flow(Action action) {
        Boolean bl;
        block3: {
            boolean $i$f$runCompileOnly = false;
            try {
                boolean bl2 = false;
                bl = this._delegate instanceof Adyen3DS2Delegate && action instanceof Threeds2ChallengeAction;
                break block3;
            }
            catch (ClassNotFoundException e$iv) {
                Logger.w((String)LogUtil.getTag(), (String)"Class not found. Are you missing a dependency?", (Throwable)e$iv);
            }
            catch (NoClassDefFoundError e$iv) {
                Logger.w((String)LogUtil.getTag(), (String)"Class not found. Are you missing a dependency?", (Throwable)e$iv);
            }
            bl = null;
        }
        return bl != null ? bl : false;
    }

    private final void observeExceptions(ActionDelegate delegate) {
        Logger.d((String)TAG, (String)"Observing exceptions");
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getExceptionFlow(), (Function2)((Function2)new Function2<CheckoutException, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultGenericActionDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CheckoutException it = (CheckoutException)this.L$0;
                        DefaultGenericActionDelegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CheckoutException p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.getCoroutineScope());
    }

    private final void observeDetails(ActionDelegate delegate) {
        if (!(delegate instanceof DetailsEmittingDelegate)) {
            return;
        }
        Logger.d((String)TAG, (String)"Observing details");
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((DetailsEmittingDelegate)delegate).getDetailsFlow(), (Function2)((Function2)new Function2<ActionComponentData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultGenericActionDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ActionComponentData it = (ActionComponentData)this.L$0;
                        DefaultGenericActionDelegate.access$getDetailsChannel$p(this.this$0).trySend-JP2dKIU((Object)it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ActionComponentData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.getCoroutineScope());
    }

    private final void observeViewFlow(ActionDelegate delegate) {
        if (!(delegate instanceof ViewProvidingDelegate)) {
            return;
        }
        Logger.d((String)TAG, (String)"Observing view flow");
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((ViewProvidingDelegate)delegate).getViewFlow(), (Function2)((Function2)new Function2<ComponentViewType, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultGenericActionDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ComponentViewType it = (ComponentViewType)this.L$0;
                        DefaultGenericActionDelegate.access$get_viewFlow$p(this.this$0).tryEmit((Object)it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@Nullable ComponentViewType p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.getCoroutineScope());
    }

    public void handleIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        ActionDelegate delegate = this._delegate;
        if (delegate == null) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("handleIntent should not be called before handleAction", null, 2, null));
        } else if (!(delegate instanceof IntentHandlingDelegate)) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Cannot handle intent with the current component", null, 2, null));
        } else {
            Logger.d((String)TAG, (String)"Handling intent");
            ((IntentHandlingDelegate)delegate).handleIntent(intent);
        }
    }

    @Override
    public void refreshStatus() {
        ActionDelegate delegate = this._delegate;
        if (!(delegate instanceof StatusPollingDelegate)) {
            return;
        }
        Logger.d((String)TAG, (String)"Refreshing status");
        ((StatusPollingDelegate)delegate).refreshStatus();
    }

    public void onError(@NotNull CheckoutException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.getDelegate().onError(e);
    }

    @Override
    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onRedirectListener = listener;
    }

    public void onCleared() {
        Logger.d((String)TAG, (String)"onCleared");
        this.removeObserver();
        ActionDelegate actionDelegate = this._delegate;
        if (actionDelegate != null) {
            actionDelegate.onCleared();
        }
        this._delegate = null;
        this._coroutineScope = null;
        this.onRedirectListener = null;
    }

    public static final /* synthetic */ Channel access$getExceptionChannel$p(DefaultGenericActionDelegate $this) {
        return $this.exceptionChannel;
    }

    public static final /* synthetic */ Channel access$getDetailsChannel$p(DefaultGenericActionDelegate $this) {
        return $this.detailsChannel;
    }

    public static final /* synthetic */ MutableStateFlow access$get_viewFlow$p(DefaultGenericActionDelegate $this) {
        return $this._viewFlow;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/action/core/internal/ui/DefaultGenericActionDelegate$Companion;", "", "()V", "TAG", "", "action-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

