/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.adyen3ds2.internal.ui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.adyen3ds2.Authentication3DS2Exception;
import com.adyen.checkout.adyen3ds2.Cancelled3DS2Exception;
import com.adyen.checkout.adyen3ds2.internal.analytics.ThreeDS2Events;
import com.adyen.checkout.adyen3ds2.internal.data.api.SubmitFingerprintRepository;
import com.adyen.checkout.adyen3ds2.internal.data.model.Adyen3DS2Serializer;
import com.adyen.checkout.adyen3ds2.internal.data.model.ChallengeToken;
import com.adyen.checkout.adyen3ds2.internal.data.model.FingerprintToken;
import com.adyen.checkout.adyen3ds2.internal.data.model.SubmitFingerprintResult;
import com.adyen.checkout.adyen3ds2.internal.ui.Adyen3DS2ComponentViewType;
import com.adyen.checkout.adyen3ds2.internal.ui.Adyen3DS2Delegate;
import com.adyen.checkout.adyen3ds2.internal.ui.DefaultAdyen3DS2Delegate;
import com.adyen.checkout.adyen3ds2.internal.ui.SharedChallengeStatusHandler;
import com.adyen.checkout.adyen3ds2.internal.ui.model.Adyen3DS2ComponentParams;
import com.adyen.checkout.components.core.ActionComponentData;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.BaseThreeds2Action;
import com.adyen.checkout.components.core.action.RedirectAction;
import com.adyen.checkout.components.core.action.Threeds2Action;
import com.adyen.checkout.components.core.action.Threeds2ChallengeAction;
import com.adyen.checkout.components.core.action.Threeds2FingerprintAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.PaymentDataRepository;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.exception.ModelSerializationException;
import com.adyen.checkout.ui.core.internal.RedirectHandler;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.threeds2.AuthenticationRequestParameters;
import com.adyen.threeds2.ChallengeResult;
import com.adyen.threeds2.ChallengeStatusHandler;
import com.adyen.threeds2.InitializeResult;
import com.adyen.threeds2.ThreeDS2Service;
import com.adyen.threeds2.Transaction;
import com.adyen.threeds2.TransactionResult;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.exception.SDKNotInitializedException;
import com.adyen.threeds2.exception.SDKRuntimeException;
import com.adyen.threeds2.parameters.ChallengeParameters;
import com.adyen.threeds2.parameters.ConfigParameters;
import com.adyen.threeds2.util.AdyenConfigParameters;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0092\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0092\u0001B_\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0001\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020>H\u0002J\b\u0010E\u001a\u00020>H\u0002J\b\u0010F\u001a\u00020>H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020B2\u0006\u0010P\u001a\u00020QH\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010,2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020BH\u0002J\u0010\u0010U\u001a\u00020>2\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u00020>2\u0006\u0010Y\u001a\u000205H\u0002J\u0018\u0010Z\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020[2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010\\\u001a\u00020>2\u0006\u0010]\u001a\u00020^H\u0016J\u0018\u0010_\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020`2\u0006\u0010?\u001a\u00020@H\u0002J \u0010a\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020`2\u0006\u0010?\u001a\u00020@2\u0006\u0010b\u001a\u00020cH\u0002J\u0018\u0010d\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020e2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010f\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020g2\u0006\u0010?\u001a\u00020@H\u0002J%\u0010h\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010i\u001a\u00020B2\u0006\u0010j\u001a\u00020kH\u0001\u00a2\u0006\u0002\blJ\u0010\u0010m\u001a\u00020>2\u0006\u0010(\u001a\u00020\u001cH\u0016J\u001c\u0010n\u001a\u00020W2\u0006\u0010o\u001a\u00020B2\n\b\u0002\u0010p\u001a\u0004\u0018\u00010BH\u0002J\u0018\u0010q\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001f\u001a\u00020rH\u0002J,\u0010s\u001a\u00020>2\u0006\u0010t\u001a\u00020u2\u0006\u0010(\u001a\u00020\u001c2\u0012\u0010v\u001a\u000e\u0012\u0004\u0012\u00020x\u0012\u0004\u0012\u00020>0wH\u0016J\b\u0010y\u001a\u00020>H\u0002J\b\u0010z\u001a\u00020>H\u0016J\u0010\u0010{\u001a\u00020>2\u0006\u0010o\u001a\u00020BH\u0002J\u0010\u0010|\u001a\u00020>2\u0006\u0010}\u001a\u00020~H\u0016J\u0010\u0010\u007f\u001a\u00020>2\u0006\u0010Y\u001a\u000205H\u0016J\u0011\u0010\u007f\u001a\u00020>2\u0007\u0010}\u001a\u00030\u0080\u0001H\u0002J\u001a\u0010\u0081\u0001\u001a\u00020>2\u0007\u0010}\u001a\u00030\u0082\u00012\u0006\u0010?\u001a\u00020@H\u0002J\u0012\u0010\u0083\u0001\u001a\u00020>2\u0007\u0010}\u001a\u00030\u0084\u0001H\u0002J\t\u0010\u0085\u0001\u001a\u00020>H\u0016J\u0019\u0010\u0086\u0001\u001a\u00020>2\u000e\u0010\u0087\u0001\u001a\t\u0012\u0004\u0012\u00020>0\u0088\u0001H\u0016J \u0010j\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0007\u0010\u0089\u0001\u001a\u00020BH\u0082@\u00a2\u0006\u0003\u0010\u008a\u0001J\u001a\u0010\u008b\u0001\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020[2\u0007\u0010\u008c\u0001\u001a\u00020BH\u0002J\u0011\u0010\u008d\u0001\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020[H\u0002J\u0012\u0010\u008e\u0001\u001a\u00020>2\u0007\u0010}\u001a\u00030\u008f\u0001H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020[H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020>2\u0007\u0010}\u001a\u00030\u008f\u0001H\u0002R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020/01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020501X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010;01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00103\u00a8\u0006\u0093\u0001"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate;", "Lcom/adyen/checkout/adyen3ds2/internal/ui/Adyen3DS2Delegate;", "Lcom/adyen/threeds2/ChallengeStatusHandler;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "componentParams", "Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;", "submitFingerprintRepository", "Lcom/adyen/checkout/adyen3ds2/internal/data/api/SubmitFingerprintRepository;", "paymentDataRepository", "Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;", "adyen3DS2Serializer", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer;", "redirectHandler", "Lcom/adyen/checkout/ui/core/internal/RedirectHandler;", "threeDS2Service", "Lcom/adyen/threeds2/ThreeDS2Service;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "application", "Landroid/app/Application;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;Lcom/adyen/checkout/adyen3ds2/internal/data/api/SubmitFingerprintRepository;Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer;Lcom/adyen/checkout/ui/core/internal/RedirectHandler;Lcom/adyen/threeds2/ThreeDS2Service;Lkotlinx/coroutines/CoroutineDispatcher;Landroid/app/Application;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "Lcom/adyen/checkout/components/core/action/BaseThreeds2Action;", "action", "getAction", "()Lcom/adyen/checkout/components/core/action/BaseThreeds2Action;", "setAction", "(Lcom/adyen/checkout/components/core/action/BaseThreeds2Action;)V", "action$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getComponentParams", "()Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "currentTransaction", "Lcom/adyen/threeds2/Transaction;", "detailsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/components/core/ActionComponentData;", "detailsFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetailsFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getViewFlow", "challengeShopper", "", "activity", "Landroid/app/Activity;", "encodedChallengeToken", "", "challengeShopper$3ds2_release", "cleanUp3DS2", "clearState", "closeTransaction", "createAdyenConfigParameters", "Lcom/adyen/threeds2/parameters/ConfigParameters;", "fingerprintToken", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/FingerprintToken;", "createChallengeParameters", "Lcom/adyen/threeds2/parameters/ChallengeParameters;", "challenge", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/ChallengeToken;", "createEncodedFingerprint", "authenticationRequestParameters", "Lcom/adyen/threeds2/AuthenticationRequestParameters;", "createTransaction", "decodeFingerprintToken", "encoded", "emitDetails", "details", "Lorg/json/JSONObject;", "emitError", "e", "handleAction", "Lcom/adyen/checkout/components/core/action/Action;", "handleIntent", "intent", "Landroid/content/Intent;", "handleThreeds2Action", "Lcom/adyen/checkout/components/core/action/Threeds2Action;", "handleThreeds2ActionSubtype", "subtype", "Lcom/adyen/checkout/components/core/action/Threeds2Action$SubType;", "handleThreeds2ChallengeAction", "Lcom/adyen/checkout/components/core/action/Threeds2ChallengeAction;", "handleThreeds2FingerprintAction", "Lcom/adyen/checkout/components/core/action/Threeds2FingerprintAction;", "identifyShopper", "encodedFingerprintToken", "submitFingerprintAutomatically", "", "identifyShopper$3ds2_release", "initialize", "makeDetails", "transactionStatus", "errorDetails", "makeRedirect", "Lcom/adyen/checkout/components/core/action/RedirectAction;", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "onCancelled", "onCleared", "onCompleted", "onCompletion", "result", "Lcom/adyen/threeds2/ChallengeResult;", "onError", "Lcom/adyen/threeds2/ChallengeResult$Error;", "onSubmitFingerprintResult", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/SubmitFingerprintResult;", "onTimeout", "Lcom/adyen/threeds2/ChallengeResult$Timeout;", "removeObserver", "setOnRedirectListener", "listener", "Lkotlin/Function0;", "encodedFingerprint", "(Landroid/app/Activity;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackActionEvent", "message", "trackChallengeActionEvent", "trackChallengeCompletedEvent", "Lcom/adyen/checkout/adyen3ds2/internal/analytics/ThreeDS2Events$Result;", "trackFingerprintActionEvent", "trackFingerprintCompletedEvent", "Companion", "3ds2_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAdyen3DS2Delegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAdyen3DS2Delegate.kt\ncom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,655:1\n16#2,17:656\n16#2,17:677\n16#2,17:694\n16#2,17:711\n16#2,17:728\n16#2,17:745\n16#2,17:762\n16#2,17:779\n16#2,17:796\n46#3,4:673\n*S KotlinDebug\n*F\n+ 1 DefaultAdyen3DS2Delegate.kt\ncom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate\n*L\n224#1:656,17\n297#1:677,17\n325#1:694,17\n415#1:711,17\n425#1:728,17\n490#1:745,17\n502#1:762,17\n508#1:779,17\n520#1:796,17\n240#1:673,4\n*E\n"})
public final class DefaultAdyen3DS2Delegate
implements Adyen3DS2Delegate,
ChallengeStatusHandler,
SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final Adyen3DS2ComponentParams componentParams;
    @NotNull
    private final SubmitFingerprintRepository submitFingerprintRepository;
    @NotNull
    private final PaymentDataRepository paymentDataRepository;
    @NotNull
    private final Adyen3DS2Serializer adyen3DS2Serializer;
    @NotNull
    private final RedirectHandler redirectHandler;
    @NotNull
    private final ThreeDS2Service threeDS2Service;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final Application application;
    @Nullable
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final Channel<ActionComponentData> detailsChannel;
    @NotNull
    private final Flow<ActionComponentData> detailsFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @Nullable
    private Transaction currentTransaction;
    @NotNull
    private final SavedStateHandleProperty action$delegate;
    @NotNull
    public static final String ANALYTICS_MESSAGE_FINGERPRINT = "Fingerprint action was handled by the SDK";
    @NotNull
    public static final String ANALYTICS_MESSAGE_CHALLENGE = "Challenge action was handled by the SDK";
    private static final int DEFAULT_CHALLENGE_TIME_OUT = 10;
    @NotNull
    private static final String PROTOCOL_VERSION_2_1_0 = "2.1.0";
    @NotNull
    public static final String ACTION_KEY = "ACTION_KEY";

    public DefaultAdyen3DS2Delegate(@NotNull ActionObserverRepository observerRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull Adyen3DS2ComponentParams componentParams, @NotNull SubmitFingerprintRepository submitFingerprintRepository, @NotNull PaymentDataRepository paymentDataRepository, @NotNull Adyen3DS2Serializer adyen3DS2Serializer, @NotNull RedirectHandler redirectHandler, @NotNull ThreeDS2Service threeDS2Service, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull Application application, @Nullable AnalyticsManager analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)submitFingerprintRepository, (String)"submitFingerprintRepository");
        Intrinsics.checkNotNullParameter((Object)paymentDataRepository, (String)"paymentDataRepository");
        Intrinsics.checkNotNullParameter((Object)adyen3DS2Serializer, (String)"adyen3DS2Serializer");
        Intrinsics.checkNotNullParameter((Object)redirectHandler, (String)"redirectHandler");
        Intrinsics.checkNotNullParameter((Object)threeDS2Service, (String)"threeDS2Service");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.observerRepository = observerRepository;
        this.savedStateHandle = savedStateHandle;
        this.componentParams = componentParams;
        this.submitFingerprintRepository = submitFingerprintRepository;
        this.paymentDataRepository = paymentDataRepository;
        this.adyen3DS2Serializer = adyen3DS2Serializer;
        this.redirectHandler = redirectHandler;
        this.threeDS2Service = threeDS2Service;
        this.coroutineDispatcher = coroutineDispatcher;
        this.application = application;
        this.analyticsManager = analyticsManager;
        this.detailsChannel = ChannelExtensionsKt.bufferedChannel();
        this.detailsFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.detailsChannel));
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.viewFlow = (Flow)StateFlowKt.MutableStateFlow((Object)Adyen3DS2ComponentViewType.INSTANCE);
        this.action$delegate = new SavedStateHandleProperty(ACTION_KEY);
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    @NotNull
    public Adyen3DS2ComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public Flow<ActionComponentData> getDetailsFlow() {
        return this.detailsFlow;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return coroutineScope;
    }

    private final BaseThreeds2Action getAction() {
        return (BaseThreeds2Action)this.action$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setAction(BaseThreeds2Action baseThreeds2Action) {
        this.action$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)baseThreeds2Action);
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this._coroutineScope = coroutineScope;
        SharedChallengeStatusHandler.INSTANCE.setOnCompletionListener(this);
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getDetailsFlow(), this.getExceptionFlow(), null, lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!(action instanceof BaseThreeds2Action)) {
            this.emitError((CheckoutException)new ComponentException("Unsupported action", null, 2, null));
            return;
        }
        this.setAction((BaseThreeds2Action)action);
        String paymentData = action.getPaymentData();
        this.paymentDataRepository.setPaymentData(paymentData);
        Action action2 = action;
        if (action2 instanceof Threeds2FingerprintAction) {
            this.handleThreeds2FingerprintAction((Threeds2FingerprintAction)action, activity);
        } else if (action2 instanceof Threeds2ChallengeAction) {
            this.handleThreeds2ChallengeAction((Threeds2ChallengeAction)action, activity);
        } else if (action2 instanceof Threeds2Action) {
            this.handleThreeds2Action((Threeds2Action)action, activity);
        }
    }

    private final void handleThreeds2FingerprintAction(Threeds2FingerprintAction action, Activity activity) {
        CharSequence charSequence = action.getToken();
        if (charSequence == null || charSequence.length() == 0) {
            this.emitError((CheckoutException)new ComponentException("Fingerprint token not found.", null, 2, null));
            return;
        }
        this.trackFingerprintActionEvent((Action)action);
        String string = action.getToken();
        if (string == null) {
            string = "";
        }
        this.identifyShopper$3ds2_release(activity, string, false);
    }

    private final void handleThreeds2ChallengeAction(Threeds2ChallengeAction action, Activity activity) {
        CharSequence charSequence = action.getToken();
        if (charSequence == null || charSequence.length() == 0) {
            this.emitError((CheckoutException)new ComponentException("Challenge token not found.", null, 2, null));
            return;
        }
        this.trackChallengeActionEvent((Action)action);
        String string = action.getToken();
        if (string == null) {
            string = "";
        }
        this.challengeShopper$3ds2_release(activity, string);
    }

    private final void handleThreeds2Action(Threeds2Action action, Activity activity) {
        CharSequence charSequence = action.getToken();
        if (charSequence == null || charSequence.length() == 0) {
            this.emitError((CheckoutException)new ComponentException("3DS2 token not found.", null, 2, null));
            return;
        }
        if (action.getSubtype() == null) {
            this.emitError((CheckoutException)new ComponentException("3DS2 Action subtype not found.", null, 2, null));
            return;
        }
        String string = action.getSubtype();
        if (string == null) {
            string = "";
        }
        Threeds2Action.SubType subtype = Threeds2Action.SubType.Companion.parse(string);
        this.handleThreeds2ActionSubtype(action, activity, subtype);
    }

    private final void handleThreeds2ActionSubtype(Threeds2Action action, Activity activity, Threeds2Action.SubType subtype) {
        String string = action.getToken();
        if (string == null) {
            string = "";
        }
        String token = string;
        switch (WhenMappings.$EnumSwitchMapping$0[subtype.ordinal()]) {
            case 1: {
                this.trackFingerprintActionEvent((Action)action);
                this.identifyShopper$3ds2_release(activity, token, true);
                break;
            }
            case 2: {
                this.trackChallengeActionEvent((Action)action);
                this.challengeShopper$3ds2_release(activity, token);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void identifyShopper$3ds2_release(@NotNull Activity activity, @NotNull String encodedFingerprintToken, boolean submitFingerprintAutomatically2) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)encodedFingerprintToken, (String)"encodedFingerprintToken");
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        Object level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            Object object = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "identifyShopper - submitFingerprintAutomatically: " + submitFingerprintAutomatically2;
            adyenLogger.log(object, string, string2, throwable$iv);
        }
        try {
            level$iv = this.decodeFingerprintToken(encodedFingerprintToken);
        }
        catch (CheckoutException e) {
            this.emitError((CheckoutException)new ComponentException("Failed to decode fingerprint token", (Throwable)e));
            return;
        }
        Object fingerprintToken = level$iv;
        ConfigParameters configParameters = this.createAdyenConfigParameters((FingerprintToken)((Object)fingerprintToken));
        if (configParameters == null) {
            DefaultAdyen3DS2Delegate $this$identifyShopper_u24lambda_u241 = this;
            boolean bl = false;
            $this$identifyShopper_u24lambda_u241.emitError((CheckoutException)new ComponentException("Failed to create ConfigParameters.", null, 2, null));
            return;
        }
        ConfigParameters configParameters2 = configParameters;
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler coroutineExceptionHandler = new CoroutineExceptionHandler(key, this){
            final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
            {
                this.this$0 = defaultAdyen3DS2Delegate;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void handleException(CoroutineContext context, Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this.this$0;
                AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
                boolean $i$f$adyenLog = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                    String tag$iv;
                    void $this$adyenLog$iv;
                    String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    AdyenLogLevel adyenLogLevel = level$iv;
                    AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl2 = false;
                    String string2 = "Unexpected uncaught 3DS2 Exception";
                    adyenLogger.log(adyenLogLevel, string, string2, throwable);
                }
                DefaultAdyen3DS2Delegate.access$emitError(this.this$0, new CheckoutException("Unexpected 3DS2 exception.", throwable));
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), (CoroutineContext)this.coroutineDispatcher.plus((CoroutineContext)coroutineExceptionHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, activity, configParameters2, (FingerprintToken)((Object)fingerprintToken), submitFingerprintAutomatically2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ ConfigParameters $configParameters;
            final /* synthetic */ FingerprintToken $fingerprintToken;
            final /* synthetic */ boolean $submitFingerprintAutomatically;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
                this.$configParameters = $configParameters;
                this.$fingerprintToken = $fingerprintToken;
                this.$submitFingerprintAutomatically = $submitFingerprintAutomatically;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block9: {
                    String encodedFingerprint;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            AuthenticationRequestParameters authenticationRequestParameters;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            DefaultAdyen3DS2Delegate.access$closeTransaction(this.this$0);
                            CoroutineScope coroutineScope = $this$launch;
                            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
                            Throwable throwable$iv = null;
                            boolean $i$f$adyenLog = false;
                            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                                String tag$iv;
                                void $this$adyenLog_u24default$iv;
                                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                                Intrinsics.checkNotNull((Object)fullClassName$iv);
                                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                                AdyenLogLevel adyenLogLevel = level$iv;
                                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                                boolean bl = false;
                                String string2 = "initialize 3DS2 SDK";
                                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
                            }
                            InitializeResult initializeResult = DefaultAdyen3DS2Delegate.access$getThreeDS2Service$p(this.this$0).initialize((Context)this.$activity, this.$configParameters, null, this.this$0.getComponentParams().getUiCustomization());
                            if (initializeResult instanceof InitializeResult.Failure) {
                                JSONObject details = DefaultAdyen3DS2Delegate.access$makeDetails(this.this$0, ((InitializeResult.Failure)initializeResult).getTransactionStatus(), ((InitializeResult.Failure)initializeResult).getAdditionalDetails());
                                DefaultAdyen3DS2Delegate.access$emitDetails(this.this$0, details);
                                return Unit.INSTANCE;
                            }
                            Transaction transaction = DefaultAdyen3DS2Delegate.access$createTransaction(this.this$0, this.$fingerprintToken);
                            if (transaction == null) {
                                return Unit.INSTANCE;
                            }
                            DefaultAdyen3DS2Delegate.access$setCurrentTransaction$p(this.this$0, transaction);
                            Transaction transaction2 = DefaultAdyen3DS2Delegate.access$getCurrentTransaction$p(this.this$0);
                            Object object3 = authenticationRequestParameters = transaction2 != null ? transaction2.getAuthenticationRequestParameters() : null;
                            if (authenticationRequestParameters == null) {
                                DefaultAdyen3DS2Delegate.access$emitError(this.this$0, (CheckoutException)new ComponentException("Failed to retrieve 3DS2 authentication parameters", null, 2, null));
                                return Unit.INSTANCE;
                            }
                            encodedFingerprint = DefaultAdyen3DS2Delegate.access$createEncodedFingerprint(this.this$0, authenticationRequestParameters);
                            if (!this.$submitFingerprintAutomatically) break;
                            this.label = 1;
                            Object object4 = DefaultAdyen3DS2Delegate.access$submitFingerprintAutomatically(this.this$0, this.$activity, encodedFingerprint, (Continuation)this);
                            if (object4 == object2) {
                                return object2;
                            }
                            break block9;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            break block9;
                        }
                    }
                    DefaultAdyen3DS2Delegate.access$emitDetails(this.this$0, DefaultAdyen3DS2Delegate.access$getAdyen3DS2Serializer$p(this.this$0).createFingerprintDetails(encodedFingerprint));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final FingerprintToken decodeFingerprintToken(String encoded) throws ComponentException, ModelSerializationException {
        JSONObject jSONObject;
        String decodedFingerprintToken = new String(Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)encoded, (int)0, (int)0, (int)6, null), Charsets.UTF_8);
        try {
            jSONObject = new JSONObject(decodedFingerprintToken);
        }
        catch (JSONException e) {
            throw new ComponentException("JSON parsing of FingerprintToken failed", (Throwable)e);
        }
        JSONObject fingerprintJson = jSONObject;
        return (FingerprintToken)FingerprintToken.SERIALIZER.deserialize(fingerprintJson);
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigParameters createAdyenConfigParameters(FingerprintToken fingerprintToken) {
        String directoryServerId = fingerprintToken.component1();
        String directoryServerPublicKey = fingerprintToken.component2();
        String directoryServerRootCertificates = fingerprintToken.component3();
        if (directoryServerId == null || directoryServerPublicKey == null || directoryServerRootCertificates == null) {
            DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string2 = "directoryServerId, directoryServerPublicKey or directoryServerRootCertificates is null.";
                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
            }
            return null;
        }
        return new AdyenConfigParameters.Builder(directoryServerId, directoryServerPublicKey, directoryServerRootCertificates).deviceParameterBlockList(this.getComponentParams().getDeviceParameterBlockList()).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Transaction createTransaction(FingerprintToken fingerprintToken) {
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate;
        if (fingerprintToken.getThreeDSMessageVersion() == null) {
            String error = "Failed to create 3DS2 Transaction. Missing threeDSMessageVersion inside fingerprintToken.";
            this.emitError((CheckoutException)new ComponentException(error, null, 2, null));
            return null;
        }
        AnalyticsEvent.Log event = ThreeDS2Events.threeDS2Fingerprint$default(ThreeDS2Events.INSTANCE, ThreeDS2Events.SubType.FINGERPRINT_DATA_SENT, null, null, 6, null);
        AnalyticsManager analyticsManager = this.analyticsManager;
        if (analyticsManager != null) {
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
        try {
            Transaction transaction;
            defaultAdyen3DS2Delegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string2 = "create transaction";
                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
            }
            TransactionResult result = this.threeDS2Service.createTransaction(null, fingerprintToken.getThreeDSMessageVersion());
            if (result instanceof TransactionResult.Failure) {
                JSONObject details = this.makeDetails(((TransactionResult.Failure)result).getTransactionStatus(), ((TransactionResult.Failure)result).getAdditionalDetails());
                this.emitDetails(details);
                transaction = null;
            } else if (result instanceof TransactionResult.Success) {
                transaction = ((TransactionResult.Success)result).getTransaction();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            defaultAdyen3DS2Delegate = transaction;
        }
        catch (SDKNotInitializedException e) {
            this.emitError((CheckoutException)new ComponentException("Failed to create 3DS2 Transaction", (Throwable)e));
            defaultAdyen3DS2Delegate = null;
        }
        catch (SDKRuntimeException e) {
            this.emitError((CheckoutException)new ComponentException("Failed to create 3DS2 Transaction", (Throwable)e));
            defaultAdyen3DS2Delegate = null;
        }
        return defaultAdyen3DS2Delegate;
    }

    private final String createEncodedFingerprint(AuthenticationRequestParameters authenticationRequestParameters) throws ComponentException {
        String string;
        try {
            Object object = new JSONObject();
            JSONObject $this$createEncodedFingerprint_u24lambda_u247 = object;
            boolean bl = false;
            AuthenticationRequestParameters $this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246 = authenticationRequestParameters;
            boolean bl2 = false;
            $this$createEncodedFingerprint_u24lambda_u247.put("sdkAppID", (Object)$this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getSDKAppID());
            $this$createEncodedFingerprint_u24lambda_u247.put("sdkEncData", (Object)$this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getDeviceData());
            $this$createEncodedFingerprint_u24lambda_u247.put("sdkEphemPubKey", (Object)new JSONObject($this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getSDKEphemeralPublicKey()));
            $this$createEncodedFingerprint_u24lambda_u247.put("sdkReferenceNumber", (Object)$this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getSDKReferenceNumber());
            $this$createEncodedFingerprint_u24lambda_u247.put("sdkTransID", (Object)$this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getSDKTransactionID());
            $this$createEncodedFingerprint_u24lambda_u247.put("messageVersion", (Object)$this$createEncodedFingerprint_u24lambda_u247_u24lambda_u246.getMessageVersion());
            JSONObject fingerprintJson = object;
            Base64 base64 = (Base64)Base64.Default;
            String string2 = fingerprintJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            object = string2;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
        }
        catch (JSONException e) {
            throw new ComponentException("Failed to create encoded fingerprint", (Throwable)e);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final Object submitFingerprintAutomatically(Activity var1_1, String var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof submitFingerprintAutomatically.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultAdyen3DS2Delegate.access$submitFingerprintAutomatically(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = activity;
                $continuation.label = 1;
                v0 = this.submitFingerprintRepository.submitFingerprint-BWLJW6A(var2_2, this.getComponentParams().getClientKey(), this.paymentDataRepository.getPaymentData(), (Continuation<? super Result<? extends SubmitFingerprintResult>>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                activity = (Activity)$continuation.L$1;
                this = (DefaultAdyen3DS2Delegate)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl24:
                // 2 sources

                var4_7 = v0;
                v1 = Result.exceptionOrNull-impl((Object)var4_7);
                if (v1 == null) {
                    result = (SubmitFingerprintResult)var4_7;
                    $i$a$-fold-DefaultAdyen3DS2Delegate$submitFingerprintAutomatically$2 = false;
                    this.onSubmitFingerprintResult(result, activity);
                } else {
                    e = v1;
                    $i$a$-fold-DefaultAdyen3DS2Delegate$submitFingerprintAutomatically$3 = false;
                    this.emitError((CheckoutException)new ComponentException("Unable to submit fingerprint", e));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void onSubmitFingerprintResult(SubmitFingerprintResult result, Activity activity) {
        this.paymentDataRepository.setPaymentData(null);
        SubmitFingerprintResult submitFingerprintResult = result;
        if (submitFingerprintResult instanceof SubmitFingerprintResult.Completed) {
            this.trackFingerprintCompletedEvent(ThreeDS2Events.Result.COMPLETED);
            this.emitDetails(((SubmitFingerprintResult.Completed)result).getDetails());
        } else if (submitFingerprintResult instanceof SubmitFingerprintResult.Redirect) {
            this.trackFingerprintCompletedEvent(ThreeDS2Events.Result.REDIRECT);
            this.makeRedirect(activity, ((SubmitFingerprintResult.Redirect)result).getAction());
        } else if (submitFingerprintResult instanceof SubmitFingerprintResult.Threeds2) {
            this.trackFingerprintCompletedEvent(ThreeDS2Events.Result.THREEDS2);
            this.handleAction((Action)((SubmitFingerprintResult.Threeds2)result).getAction(), activity);
        }
    }

    private final void trackFingerprintCompletedEvent(ThreeDS2Events.Result result) {
        block0: {
            AnalyticsEvent.Log event = ThreeDS2Events.threeDS2Fingerprint$default(ThreeDS2Events.INSTANCE, ThreeDS2Events.SubType.FINGERPRINT_COMPLETED, result, null, 4, null);
            AnalyticsManager analyticsManager = this.analyticsManager;
            if (analyticsManager == null) break block0;
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void makeRedirect(Activity activity, RedirectAction action) {
        String url = action.getUrl();
        try {
            DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string2 = "makeRedirect - " + url;
                adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
            }
            this.redirectHandler.launchUriRedirect((Context)activity, url);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void challengeShopper$3ds2_release(@NotNull Activity activity, @NotNull String encodedChallengeToken) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)encodedChallengeToken, (String)"encodedChallengeToken");
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        JSONObject throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "challengeShopper";
            adyenLogger.log(adyenLogLevel, string, string2, (Throwable)throwable$iv);
        }
        if (this.currentTransaction == null) {
            this.emitError((CheckoutException)((Object)new Authentication3DS2Exception("Failed to make challenge, missing reference to initial transaction.")));
            return;
        }
        String decodedChallengeToken = new String(Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)encodedChallengeToken, (int)0, (int)0, (int)6, null), Charsets.UTF_8);
        try {
            throwable$iv = new JSONObject(decodedChallengeToken);
        }
        catch (JSONException e) {
            this.emitError((CheckoutException)new ComponentException("JSON parsing of FingerprintToken failed", (Throwable)e));
            return;
        }
        JSONObject challengeTokenJson = throwable$iv;
        AnalyticsEvent.Log challengeSentEvent = ThreeDS2Events.threeDS2Challenge$default(ThreeDS2Events.INSTANCE, ThreeDS2Events.SubType.CHALLENGE_DATA_SENT, null, null, 6, null);
        AnalyticsManager analyticsManager = this.analyticsManager;
        if (analyticsManager != null) {
            analyticsManager.trackEvent((AnalyticsEvent)challengeSentEvent);
        }
        ChallengeToken challengeToken = (ChallengeToken)ChallengeToken.SERIALIZER.deserialize(challengeTokenJson);
        ChallengeParameters challengeParameters = this.createChallengeParameters(challengeToken);
        try {
            Transaction transaction = this.currentTransaction;
            if (transaction != null) {
                transaction.doChallenge(activity, challengeParameters, (ChallengeStatusHandler)SharedChallengeStatusHandler.INSTANCE, 10);
            }
            AnalyticsEvent.Log challengeDisplayedEvent = ThreeDS2Events.threeDS2Challenge$default(ThreeDS2Events.INSTANCE, ThreeDS2Events.SubType.CHALLENGE_DISPLAYED, null, null, 6, null);
            AnalyticsManager analyticsManager2 = this.analyticsManager;
            if (analyticsManager2 != null) {
                analyticsManager2.trackEvent((AnalyticsEvent)challengeDisplayedEvent);
            }
        }
        catch (InvalidInputException e) {
            this.emitError(new CheckoutException("Error starting challenge", (Throwable)e));
        }
    }

    private final ChallengeParameters createChallengeParameters(ChallengeToken challenge) {
        ChallengeParameters challengeParameters;
        ChallengeParameters $this$createChallengeParameters_u24lambda_u2412 = challengeParameters = new ChallengeParameters();
        boolean bl = false;
        $this$createChallengeParameters_u24lambda_u2412.set3DSServerTransactionID(challenge.getThreeDSServerTransID());
        $this$createChallengeParameters_u24lambda_u2412.setAcsTransactionID(challenge.getAcsTransID());
        $this$createChallengeParameters_u24lambda_u2412.setAcsRefNumber(challenge.getAcsReferenceNumber());
        $this$createChallengeParameters_u24lambda_u2412.setAcsSignedContent(challenge.getAcsSignedContent());
        if (!Intrinsics.areEqual((Object)challenge.getMessageVersion(), (Object)PROTOCOL_VERSION_2_1_0)) {
            $this$createChallengeParameters_u24lambda_u2412.setThreeDSRequestorAppURL(this.getComponentParams().getThreeDSRequestorAppURL());
        }
        return challengeParameters;
    }

    public void handleIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            JSONObject parsedResult = this.redirectHandler.parseRedirectResult(intent.getData());
            this.emitDetails(parsedResult);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void onCompleted(String transactionStatus) {
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "challenge completed";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        try {
            JSONObject details = DefaultAdyen3DS2Delegate.makeDetails$default(this, transactionStatus, null, 2, null);
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
        finally {
            this.closeTransaction();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onCancelled() {
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "challenge cancelled";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        this.emitError((CheckoutException)((Object)new Cancelled3DS2Exception("Challenge canceled.")));
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void onTimeout(ChallengeResult.Timeout result) {
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "challenge timed out";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        try {
            JSONObject details = this.makeDetails(result.getTransactionStatus(), result.getAdditionalDetails());
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
        finally {
            this.closeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void onError(ChallengeResult.Error result) {
        DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "challenge timed out";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        try {
            JSONObject details = this.makeDetails(result.getTransactionStatus(), result.getAdditionalDetails());
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
        finally {
            this.closeTransaction();
        }
    }

    public void onCompletion(@NotNull ChallengeResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        ChallengeResult challengeResult = result;
        if (challengeResult instanceof ChallengeResult.Cancelled) {
            this.trackChallengeCompletedEvent(ThreeDS2Events.Result.CANCELLED);
            this.onCancelled();
        } else if (challengeResult instanceof ChallengeResult.Completed) {
            this.trackChallengeCompletedEvent(ThreeDS2Events.Result.COMPLETED);
            this.onCompleted(((ChallengeResult.Completed)result).getTransactionStatus());
        } else if (challengeResult instanceof ChallengeResult.Error) {
            this.trackChallengeCompletedEvent(ThreeDS2Events.Result.ERROR);
            this.onError((ChallengeResult.Error)result);
        } else if (challengeResult instanceof ChallengeResult.Timeout) {
            this.trackChallengeCompletedEvent(ThreeDS2Events.Result.TIMEOUT);
            this.onTimeout((ChallengeResult.Timeout)result);
        }
    }

    private final void trackChallengeCompletedEvent(ThreeDS2Events.Result result) {
        block0: {
            AnalyticsEvent.Log event = ThreeDS2Events.threeDS2Challenge$default(ThreeDS2Events.INSTANCE, ThreeDS2Events.SubType.CHALLENGE_COMPLETED, result, null, 4, null);
            AnalyticsManager analyticsManager = this.analyticsManager;
            if (analyticsManager == null) break block0;
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
    }

    private final void trackFingerprintActionEvent(Action action) {
        this.trackActionEvent(action, ANALYTICS_MESSAGE_FINGERPRINT);
    }

    private final void trackChallengeActionEvent(Action action) {
        this.trackActionEvent(action, ANALYTICS_MESSAGE_CHALLENGE);
    }

    private final void trackActionEvent(Action action, String message) {
        block2: {
            String string;
            String string2 = action.getPaymentMethodType();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = action.getType()) == null) {
                string = "";
            }
            AnalyticsEvent.Log event = GenericEvents.INSTANCE.action(string2, string, message);
            AnalyticsManager analyticsManager = this.analyticsManager;
            if (analyticsManager == null) break block2;
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
    }

    private final void closeTransaction() {
        Transaction transaction = this.currentTransaction;
        if (transaction != null) {
            transaction.close();
        }
        this.currentTransaction = null;
        this.cleanUp3DS2();
    }

    private final void cleanUp3DS2() {
        try {
            this.threeDS2Service.cleanup((Context)this.application);
        }
        catch (SDKNotInitializedException sDKNotInitializedException) {
            // empty catch block
        }
    }

    public void onError(@NotNull CheckoutException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.emitError(e);
    }

    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.redirectHandler.setOnRedirectListener(listener);
    }

    private final void emitError(CheckoutException e) {
        this.exceptionChannel.trySend-JP2dKIU((Object)e);
        this.clearState();
    }

    private final void emitDetails(JSONObject details) {
        String string = this.paymentDataRepository.getPaymentData();
        ActionComponentData actionComponentData = new ActionComponentData(string, details);
        this.detailsChannel.trySend-JP2dKIU((Object)actionComponentData);
        this.clearState();
    }

    private final JSONObject makeDetails(String transactionStatus, String errorDetails) {
        BaseThreeds2Action baseThreeds2Action = this.getAction();
        Threeds2Action threeds2Action = baseThreeds2Action instanceof Threeds2Action ? (Threeds2Action)baseThreeds2Action : null;
        String token = threeds2Action != null ? threeds2Action.getAuthorisationToken() : null;
        return token == null ? this.adyen3DS2Serializer.createChallengeDetails(transactionStatus, errorDetails) : this.adyen3DS2Serializer.createThreeDsResultDetails(transactionStatus, token, errorDetails);
    }

    static /* synthetic */ JSONObject makeDetails$default(DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return defaultAdyen3DS2Delegate.makeDetails(string, string2);
    }

    private final void clearState() {
        this.setAction(null);
    }

    public void onCleared() {
        this.removeObserver();
        SharedChallengeStatusHandler.INSTANCE.setOnCompletionListener(null);
        this._coroutineScope = null;
        this.redirectHandler.removeOnRedirectListener();
    }

    public static final /* synthetic */ void access$closeTransaction(DefaultAdyen3DS2Delegate $this) {
        $this.closeTransaction();
    }

    public static final /* synthetic */ ThreeDS2Service access$getThreeDS2Service$p(DefaultAdyen3DS2Delegate $this) {
        return $this.threeDS2Service;
    }

    public static final /* synthetic */ JSONObject access$makeDetails(DefaultAdyen3DS2Delegate $this, String transactionStatus, String errorDetails) {
        return $this.makeDetails(transactionStatus, errorDetails);
    }

    public static final /* synthetic */ void access$emitDetails(DefaultAdyen3DS2Delegate $this, JSONObject details) {
        $this.emitDetails(details);
    }

    public static final /* synthetic */ void access$setCurrentTransaction$p(DefaultAdyen3DS2Delegate $this, Transaction transaction) {
        $this.currentTransaction = transaction;
    }

    public static final /* synthetic */ Transaction access$createTransaction(DefaultAdyen3DS2Delegate $this, FingerprintToken fingerprintToken) {
        return $this.createTransaction(fingerprintToken);
    }

    public static final /* synthetic */ Transaction access$getCurrentTransaction$p(DefaultAdyen3DS2Delegate $this) {
        return $this.currentTransaction;
    }

    public static final /* synthetic */ void access$emitError(DefaultAdyen3DS2Delegate $this, CheckoutException e) {
        $this.emitError(e);
    }

    public static final /* synthetic */ String access$createEncodedFingerprint(DefaultAdyen3DS2Delegate $this, AuthenticationRequestParameters authenticationRequestParameters) {
        return $this.createEncodedFingerprint(authenticationRequestParameters);
    }

    public static final /* synthetic */ Object access$submitFingerprintAutomatically(DefaultAdyen3DS2Delegate $this, Activity activity, String encodedFingerprint, Continuation $completion) {
        return $this.submitFingerprintAutomatically(activity, encodedFingerprint, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Adyen3DS2Serializer access$getAdyen3DS2Serializer$p(DefaultAdyen3DS2Delegate $this) {
        return $this.adyen3DS2Serializer;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DefaultAdyen3DS2Delegate.class, "action", "getAction()Lcom/adyen/checkout/components/core/action/BaseThreeds2Action;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate$Companion;", "", "()V", "ACTION_KEY", "", "getACTION_KEY$3ds2_release$annotations", "ANALYTICS_MESSAGE_CHALLENGE", "getANALYTICS_MESSAGE_CHALLENGE$3ds2_release$annotations", "ANALYTICS_MESSAGE_FINGERPRINT", "getANALYTICS_MESSAGE_FINGERPRINT$3ds2_release$annotations", "DEFAULT_CHALLENGE_TIME_OUT", "", "PROTOCOL_VERSION_2_1_0", "3ds2_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getANALYTICS_MESSAGE_FINGERPRINT$3ds2_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getANALYTICS_MESSAGE_CHALLENGE$3ds2_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_KEY$3ds2_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Threeds2Action.SubType.values().length];
            try {
                nArray[Threeds2Action.SubType.FINGERPRINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Threeds2Action.SubType.CHALLENGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

