/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.adyen3ds2.internal.ui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.adyen3ds2.Authentication3DS2Exception;
import com.adyen.checkout.adyen3ds2.Cancelled3DS2Exception;
import com.adyen.checkout.adyen3ds2.internal.data.api.SubmitFingerprintRepository;
import com.adyen.checkout.adyen3ds2.internal.data.model.Adyen3DS2Serializer;
import com.adyen.checkout.adyen3ds2.internal.data.model.ChallengeToken;
import com.adyen.checkout.adyen3ds2.internal.data.model.FingerprintToken;
import com.adyen.checkout.adyen3ds2.internal.data.model.SubmitFingerprintResult;
import com.adyen.checkout.adyen3ds2.internal.ui.Adyen3DS2ComponentViewType;
import com.adyen.checkout.adyen3ds2.internal.ui.Adyen3DS2Delegate;
import com.adyen.checkout.adyen3ds2.internal.ui.DefaultAdyen3DS2Delegate;
import com.adyen.checkout.adyen3ds2.internal.ui.model.Adyen3DS2ComponentParams;
import com.adyen.checkout.components.core.ActionComponentData;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.BaseThreeds2Action;
import com.adyen.checkout.components.core.action.RedirectAction;
import com.adyen.checkout.components.core.action.Threeds2Action;
import com.adyen.checkout.components.core.action.Threeds2ChallengeAction;
import com.adyen.checkout.components.core.action.Threeds2FingerprintAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.PaymentDataRepository;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.components.core.internal.util.Base64Encoder;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.RedirectHandler;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.threeds2.AuthenticationRequestParameters;
import com.adyen.threeds2.ChallengeResult;
import com.adyen.threeds2.ChallengeStatusHandler;
import com.adyen.threeds2.ThreeDS2Service;
import com.adyen.threeds2.Transaction;
import com.adyen.threeds2.exception.InvalidInputException;
import com.adyen.threeds2.exception.SDKAlreadyInitializedException;
import com.adyen.threeds2.exception.SDKNotInitializedException;
import com.adyen.threeds2.exception.SDKRuntimeException;
import com.adyen.threeds2.parameters.ChallengeParameters;
import com.adyen.threeds2.parameters.ConfigParameters;
import com.adyen.threeds2.util.AdyenConfigParameters;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 }2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001}B]\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\bBJ\b\u0010C\u001a\u00020>H\u0002J\b\u0010D\u001a\u00020>H\u0002J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u001e2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010O\u001a\u00020>2\u0006\u0010P\u001a\u00020Q2\u0006\u0010?\u001a\u00020@H\u0016J \u0010R\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u001eH\u0002J\u0010\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020XH\u0016J%\u0010Y\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010Z\u001a\u00020\u001e2\u0006\u0010[\u001a\u00020\\H\u0001\u00a2\u0006\u0002\b]J\u0010\u0010^\u001a\u00020>2\u0006\u0010(\u001a\u00020\u001cH\u0016J\u001c\u0010_\u001a\u00020N2\u0006\u0010`\u001a\u00020\u001e2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010b\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010P\u001a\u00020cH\u0002J,\u0010d\u001a\u00020>2\u0006\u0010e\u001a\u00020f2\u0006\u0010(\u001a\u00020\u001c2\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u00020i\u0012\u0004\u0012\u00020>0hH\u0016J\b\u0010j\u001a\u00020>H\u0002J\b\u0010k\u001a\u00020>H\u0016J\u0010\u0010l\u001a\u00020>2\u0006\u0010`\u001a\u00020\u001eH\u0002J\u0010\u0010m\u001a\u00020>2\u0006\u0010n\u001a\u00020oH\u0016J\u0010\u0010p\u001a\u00020>2\u0006\u0010q\u001a\u000205H\u0016J\u0010\u0010p\u001a\u00020>2\u0006\u0010n\u001a\u00020rH\u0002J\u0018\u0010s\u001a\u00020>2\u0006\u0010n\u001a\u00020t2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010u\u001a\u00020>2\u0006\u0010n\u001a\u00020vH\u0002J\b\u0010w\u001a\u00020>H\u0016J\u0016\u0010x\u001a\u00020>2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020>0zH\u0016J\u001e\u0010[\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010{\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010|R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020/01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020501X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010;01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00103\u00a8\u0006~"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate;", "Lcom/adyen/checkout/adyen3ds2/internal/ui/Adyen3DS2Delegate;", "Lcom/adyen/threeds2/ChallengeStatusHandler;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "componentParams", "Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;", "submitFingerprintRepository", "Lcom/adyen/checkout/adyen3ds2/internal/data/api/SubmitFingerprintRepository;", "paymentDataRepository", "Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;", "adyen3DS2Serializer", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer;", "redirectHandler", "Lcom/adyen/checkout/ui/core/internal/RedirectHandler;", "threeDS2Service", "Lcom/adyen/threeds2/ThreeDS2Service;", "defaultDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "base64Encoder", "Lcom/adyen/checkout/components/core/internal/util/Base64Encoder;", "application", "Landroid/app/Application;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;Lcom/adyen/checkout/adyen3ds2/internal/data/api/SubmitFingerprintRepository;Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer;Lcom/adyen/checkout/ui/core/internal/RedirectHandler;Lcom/adyen/threeds2/ThreeDS2Service;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/adyen/checkout/components/core/internal/util/Base64Encoder;Landroid/app/Application;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "", "authorizationToken", "getAuthorizationToken", "()Ljava/lang/String;", "setAuthorizationToken", "(Ljava/lang/String;)V", "authorizationToken$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getComponentParams", "()Lcom/adyen/checkout/adyen3ds2/internal/ui/model/Adyen3DS2ComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "currentTransaction", "Lcom/adyen/threeds2/Transaction;", "detailsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/components/core/ActionComponentData;", "detailsFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetailsFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getViewFlow", "challengeShopper", "", "activity", "Landroid/app/Activity;", "encodedChallengeToken", "challengeShopper$3ds2_release", "cleanUp3DS2", "closeTransaction", "createChallengeParameters", "Lcom/adyen/threeds2/parameters/ChallengeParameters;", "challenge", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/ChallengeToken;", "createEncodedFingerprint", "authenticationRequestParameters", "Lcom/adyen/threeds2/AuthenticationRequestParameters;", "emitDetails", "details", "Lorg/json/JSONObject;", "handleAction", "action", "Lcom/adyen/checkout/components/core/action/Action;", "handleActionSubtype", "subtype", "Lcom/adyen/checkout/components/core/action/Threeds2Action$SubType;", "token", "handleIntent", "intent", "Landroid/content/Intent;", "identifyShopper", "encodedFingerprintToken", "submitFingerprintAutomatically", "", "identifyShopper$3ds2_release", "initialize", "makeDetails", "transactionStatus", "errorDetails", "makeRedirect", "Lcom/adyen/checkout/components/core/action/RedirectAction;", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "onCancelled", "onCleared", "onCompleted", "onCompletion", "result", "Lcom/adyen/threeds2/ChallengeResult;", "onError", "e", "Lcom/adyen/threeds2/ChallengeResult$Error;", "onSubmitFingerprintResult", "Lcom/adyen/checkout/adyen3ds2/internal/data/model/SubmitFingerprintResult;", "onTimeout", "Lcom/adyen/threeds2/ChallengeResult$Timeout;", "removeObserver", "setOnRedirectListener", "listener", "Lkotlin/Function0;", "encodedFingerprint", "(Landroid/app/Activity;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "3ds2_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAdyen3DS2Delegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAdyen3DS2Delegate.kt\ncom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,498:1\n48#2,4:499\n*S KotlinDebug\n*F\n+ 1 DefaultAdyen3DS2Delegate.kt\ncom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate\n*L\n211#1:499,4\n*E\n"})
public final class DefaultAdyen3DS2Delegate
implements Adyen3DS2Delegate,
ChallengeStatusHandler,
SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final Adyen3DS2ComponentParams componentParams;
    @NotNull
    private final SubmitFingerprintRepository submitFingerprintRepository;
    @NotNull
    private final PaymentDataRepository paymentDataRepository;
    @NotNull
    private final Adyen3DS2Serializer adyen3DS2Serializer;
    @NotNull
    private final RedirectHandler redirectHandler;
    @NotNull
    private final ThreeDS2Service threeDS2Service;
    @NotNull
    private final CoroutineDispatcher defaultDispatcher;
    @NotNull
    private final Base64Encoder base64Encoder;
    @NotNull
    private final Application application;
    @NotNull
    private final Channel<ActionComponentData> detailsChannel;
    @NotNull
    private final Flow<ActionComponentData> detailsFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @Nullable
    private Transaction currentTransaction;
    @NotNull
    private final SavedStateHandleProperty authorizationToken$delegate;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final String AUTHORIZATION_TOKEN_KEY = "authorization_token";
    private static final int DEFAULT_CHALLENGE_TIME_OUT = 10;
    @NotNull
    private static final String PROTOCOL_VERSION_2_1_0 = "2.1.0";

    public DefaultAdyen3DS2Delegate(@NotNull ActionObserverRepository observerRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull Adyen3DS2ComponentParams componentParams, @NotNull SubmitFingerprintRepository submitFingerprintRepository, @NotNull PaymentDataRepository paymentDataRepository, @NotNull Adyen3DS2Serializer adyen3DS2Serializer, @NotNull RedirectHandler redirectHandler, @NotNull ThreeDS2Service threeDS2Service, @NotNull CoroutineDispatcher defaultDispatcher, @NotNull Base64Encoder base64Encoder, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)submitFingerprintRepository, (String)"submitFingerprintRepository");
        Intrinsics.checkNotNullParameter((Object)paymentDataRepository, (String)"paymentDataRepository");
        Intrinsics.checkNotNullParameter((Object)adyen3DS2Serializer, (String)"adyen3DS2Serializer");
        Intrinsics.checkNotNullParameter((Object)redirectHandler, (String)"redirectHandler");
        Intrinsics.checkNotNullParameter((Object)threeDS2Service, (String)"threeDS2Service");
        Intrinsics.checkNotNullParameter((Object)defaultDispatcher, (String)"defaultDispatcher");
        Intrinsics.checkNotNullParameter((Object)base64Encoder, (String)"base64Encoder");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.observerRepository = observerRepository;
        this.savedStateHandle = savedStateHandle;
        this.componentParams = componentParams;
        this.submitFingerprintRepository = submitFingerprintRepository;
        this.paymentDataRepository = paymentDataRepository;
        this.adyen3DS2Serializer = adyen3DS2Serializer;
        this.redirectHandler = redirectHandler;
        this.threeDS2Service = threeDS2Service;
        this.defaultDispatcher = defaultDispatcher;
        this.base64Encoder = base64Encoder;
        this.application = application;
        this.detailsChannel = ChannelExtensionsKt.bufferedChannel();
        this.detailsFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.detailsChannel));
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.viewFlow = (Flow)StateFlowKt.MutableStateFlow((Object)Adyen3DS2ComponentViewType.INSTANCE);
        this.authorizationToken$delegate = new SavedStateHandleProperty(AUTHORIZATION_TOKEN_KEY);
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    @NotNull
    public Adyen3DS2ComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public Flow<ActionComponentData> getDetailsFlow() {
        return this.detailsFlow;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return coroutineScope;
    }

    private final String getAuthorizationToken() {
        return (String)this.authorizationToken$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setAuthorizationToken(String string) {
        this.authorizationToken$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)string);
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this._coroutineScope = coroutineScope;
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getDetailsFlow(), this.getExceptionFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!(action instanceof BaseThreeds2Action)) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Unsupported action", null, 2, null));
            return;
        }
        String paymentData = action.getPaymentData();
        this.paymentDataRepository.setPaymentData(paymentData);
        Action action2 = action;
        if (action2 instanceof Threeds2FingerprintAction) {
            CharSequence charSequence = ((Threeds2FingerprintAction)action).getToken();
            if (charSequence == null || charSequence.length() == 0) {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Fingerprint token not found.", null, 2, null));
                return;
            }
            String string = ((Threeds2FingerprintAction)action).getToken();
            if (string == null) {
                string = "";
            }
            this.identifyShopper$3ds2_release(activity, string, false);
        } else if (action2 instanceof Threeds2ChallengeAction) {
            CharSequence charSequence = ((Threeds2ChallengeAction)action).getToken();
            if (charSequence == null || charSequence.length() == 0) {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Challenge token not found.", null, 2, null));
                return;
            }
            String string = ((Threeds2ChallengeAction)action).getToken();
            if (string == null) {
                string = "";
            }
            this.challengeShopper$3ds2_release(activity, string);
        } else if (action2 instanceof Threeds2Action) {
            CharSequence charSequence = ((Threeds2Action)action).getToken();
            if (charSequence == null || charSequence.length() == 0) {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("3DS2 token not found.", null, 2, null));
                return;
            }
            if (((Threeds2Action)action).getSubtype() == null) {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("3DS2 Action subtype not found.", null, 2, null));
                return;
            }
            String string = ((Threeds2Action)action).getSubtype();
            if (string == null) {
                string = "";
            }
            Threeds2Action.SubType subtype = Threeds2Action.SubType.Companion.parse(string);
            this.setAuthorizationToken(((Threeds2Action)action).getAuthorisationToken());
            String string2 = ((Threeds2Action)action).getToken();
            if (string2 == null) {
                string2 = "";
            }
            this.handleActionSubtype(activity, subtype, string2);
        }
    }

    private final void handleActionSubtype(Activity activity, Threeds2Action.SubType subtype, String token) {
        switch (WhenMappings.$EnumSwitchMapping$0[subtype.ordinal()]) {
            case 1: {
                this.identifyShopper$3ds2_release(activity, token, true);
                break;
            }
            case 2: {
                this.challengeShopper$3ds2_release(activity, token);
            }
        }
    }

    @VisibleForTesting
    public final void identifyShopper$3ds2_release(@NotNull Activity activity, @NotNull String encodedFingerprintToken, boolean submitFingerprintAutomatically2) throws ComponentException {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)encodedFingerprintToken, (String)"encodedFingerprintToken");
        Logger.d((String)TAG, (String)("identifyShopper - submitFingerprintAutomatically: " + submitFingerprintAutomatically2));
        String decodedFingerprintToken = Base64Encoder.DefaultImpls.decode$default((Base64Encoder)this.base64Encoder, (String)encodedFingerprintToken, (int)0, (int)2, null);
        try {
            jSONObject = new JSONObject(decodedFingerprintToken);
        }
        catch (JSONException e) {
            throw new ComponentException("JSON parsing of FingerprintToken failed", (Throwable)e);
        }
        JSONObject fingerprintJson = jSONObject;
        FingerprintToken fingerprintToken = (FingerprintToken)FingerprintToken.SERIALIZER.deserialize(fingerprintJson);
        ConfigParameters configParameters = new AdyenConfigParameters.Builder(fingerprintToken.getDirectoryServerId(), fingerprintToken.getDirectoryServerPublicKey(), fingerprintToken.getDirectoryServerRootCertificates()).deviceParameterBlockList(this.getComponentParams().getDeviceParameterBlockList()).build();
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler coroutineExceptionHandler = new CoroutineExceptionHandler(key, this){
            final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
            {
                this.this$0 = defaultAdyen3DS2Delegate;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                Logger.e((String)DefaultAdyen3DS2Delegate.access$getTAG$cp(), (String)"Unexpected uncaught 3DS2 Exception", (Throwable)throwable);
                DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)((Object)new CheckoutException("Unexpected 3DS2 exception.", throwable)));
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), (CoroutineContext)this.defaultDispatcher.plus((CoroutineContext)coroutineExceptionHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, activity, configParameters, fingerprintToken, submitFingerprintAutomatically2, null){
            int label;
            final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
            final /* synthetic */ Activity $activity;
            final /* synthetic */ ConfigParameters $configParameters;
            final /* synthetic */ FingerprintToken $fingerprintToken;
            final /* synthetic */ boolean $submitFingerprintAutomatically;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
                this.$configParameters = $configParameters;
                this.$fingerprintToken = $fingerprintToken;
                this.$submitFingerprintAutomatically = $submitFingerprintAutomatically;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block13: {
                    String encodedFingerprint;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            AuthenticationRequestParameters authenticationRequestParameters;
                            Transaction e2;
                            DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate;
                            ResultKt.throwOnFailure((Object)object);
                            DefaultAdyen3DS2Delegate.access$closeTransaction(this.this$0);
                            try {
                                Logger.d((String)DefaultAdyen3DS2Delegate.access$getTAG$cp(), (String)"initialize 3DS2 SDK");
                                DefaultAdyen3DS2Delegate.access$getThreeDS2Service$p(this.this$0).initialize((Context)this.$activity, this.$configParameters, null, this.this$0.getComponentParams().getUiCustomization());
                            }
                            catch (SDKRuntimeException e2) {
                                DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)new ComponentException("Failed to initialize 3DS2 SDK", (Throwable)e2));
                                return Unit.INSTANCE;
                            }
                            catch (SDKAlreadyInitializedException e2) {
                                Logger.w((String)DefaultAdyen3DS2Delegate.access$getTAG$cp(), (String)"3DS2 Service already initialized.");
                            }
                            DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate2 = this.this$0;
                            try {
                                defaultAdyen3DS2Delegate = defaultAdyen3DS2Delegate2;
                                Logger.d((String)DefaultAdyen3DS2Delegate.access$getTAG$cp(), (String)"create transaction");
                                if (this.$fingerprintToken.getThreeDSMessageVersion() == null) {
                                    DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)new ComponentException("Failed to create 3DS2 Transaction. Missing threeDSMessageVersion inside fingerprintToken.", null, 2, null));
                                    return Unit.INSTANCE;
                                }
                                e2 = DefaultAdyen3DS2Delegate.access$getThreeDS2Service$p(this.this$0).createTransaction(null, this.$fingerprintToken.getThreeDSMessageVersion());
                            }
                            catch (SDKNotInitializedException sDKNotInitializedException) {
                                void e3;
                                DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate3 = defaultAdyen3DS2Delegate2;
                                DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)new ComponentException("Failed to create 3DS2 Transaction", (Throwable)e3));
                                return Unit.INSTANCE;
                            }
                            catch (SDKRuntimeException e3) {
                                DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate4 = defaultAdyen3DS2Delegate2;
                                DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)new ComponentException("Failed to create 3DS2 Transaction", (Throwable)e3));
                                return Unit.INSTANCE;
                            }
                            DefaultAdyen3DS2Delegate.access$setCurrentTransaction$p(defaultAdyen3DS2Delegate, e2);
                            Transaction transaction = DefaultAdyen3DS2Delegate.access$getCurrentTransaction$p(this.this$0);
                            Object object3 = authenticationRequestParameters = transaction != null ? transaction.getAuthenticationRequestParameters() : null;
                            if (authenticationRequestParameters == null) {
                                DefaultAdyen3DS2Delegate.access$getExceptionChannel$p(this.this$0).trySend-JP2dKIU((Object)new ComponentException("Failed to retrieve 3DS2 authentication parameters", null, 2, null));
                                return Unit.INSTANCE;
                            }
                            encodedFingerprint = DefaultAdyen3DS2Delegate.access$createEncodedFingerprint(this.this$0, authenticationRequestParameters);
                            if (!this.$submitFingerprintAutomatically) break;
                            this.label = 1;
                            Object object4 = DefaultAdyen3DS2Delegate.access$submitFingerprintAutomatically(this.this$0, this.$activity, encodedFingerprint, (Continuation)this);
                            if (object4 == object2) {
                                return object2;
                            }
                            break block13;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            break block13;
                        }
                    }
                    DefaultAdyen3DS2Delegate.access$emitDetails(this.this$0, DefaultAdyen3DS2Delegate.access$getAdyen3DS2Serializer$p(this.this$0).createFingerprintDetails(encodedFingerprint));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final String createEncodedFingerprint(AuthenticationRequestParameters authenticationRequestParameters) throws ComponentException {
        String string;
        try {
            JSONObject jSONObject;
            JSONObject $this$createEncodedFingerprint_u24lambda_u242 = jSONObject = new JSONObject();
            boolean bl = false;
            AuthenticationRequestParameters $this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241 = authenticationRequestParameters;
            boolean bl2 = false;
            $this$createEncodedFingerprint_u24lambda_u242.put("sdkAppID", (Object)$this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getSDKAppID());
            $this$createEncodedFingerprint_u24lambda_u242.put("sdkEncData", (Object)$this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getDeviceData());
            $this$createEncodedFingerprint_u24lambda_u242.put("sdkEphemPubKey", (Object)new JSONObject($this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getSDKEphemeralPublicKey()));
            $this$createEncodedFingerprint_u24lambda_u242.put("sdkReferenceNumber", (Object)$this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getSDKReferenceNumber());
            $this$createEncodedFingerprint_u24lambda_u242.put("sdkTransID", (Object)$this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getSDKTransactionID());
            $this$createEncodedFingerprint_u24lambda_u242.put("messageVersion", (Object)$this$createEncodedFingerprint_u24lambda_u242_u24lambda_u241.getMessageVersion());
            JSONObject fingerprintJson = jSONObject;
            String string2 = fingerprintJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = Base64Encoder.DefaultImpls.encode$default((Base64Encoder)this.base64Encoder, (String)string2, (int)0, (int)2, null);
        }
        catch (JSONException e) {
            throw new ComponentException("Failed to create encoded fingerprint", (Throwable)e);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final Object submitFingerprintAutomatically(Activity var1_1, String var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof submitFingerprintAutomatically.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultAdyen3DS2Delegate this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultAdyen3DS2Delegate.access$submitFingerprintAutomatically(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = activity;
                $continuation.label = 1;
                v0 = this.submitFingerprintRepository.submitFingerprint-BWLJW6A(var2_2, this.getComponentParams().getClientKey(), this.paymentDataRepository.getPaymentData(), (Continuation<? super Result<? extends SubmitFingerprintResult>>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                activity = (Activity)$continuation.L$1;
                this = (DefaultAdyen3DS2Delegate)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl24:
                // 2 sources

                var4_7 = v0;
                v1 = Result.exceptionOrNull-impl((Object)var4_7);
                if (v1 == null) {
                    result = (SubmitFingerprintResult)var4_7;
                    $i$a$-fold-DefaultAdyen3DS2Delegate$submitFingerprintAutomatically$2 = false;
                    this.onSubmitFingerprintResult(result, activity);
                } else {
                    e = v1;
                    $i$a$-fold-DefaultAdyen3DS2Delegate$submitFingerprintAutomatically$3 = false;
                    ChannelResult.box-impl((Object)this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Unable to submit fingerprint", e)));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void onSubmitFingerprintResult(SubmitFingerprintResult result, Activity activity) {
        this.paymentDataRepository.setPaymentData(null);
        SubmitFingerprintResult submitFingerprintResult = result;
        if (submitFingerprintResult instanceof SubmitFingerprintResult.Completed) {
            this.emitDetails(((SubmitFingerprintResult.Completed)result).getDetails());
        } else if (submitFingerprintResult instanceof SubmitFingerprintResult.Redirect) {
            this.makeRedirect(activity, ((SubmitFingerprintResult.Redirect)result).getAction());
        } else if (submitFingerprintResult instanceof SubmitFingerprintResult.Threeds2) {
            this.handleAction((Action)((SubmitFingerprintResult.Threeds2)result).getAction(), activity);
        }
    }

    private final void emitDetails(JSONObject details) {
        String string = this.paymentDataRepository.getPaymentData();
        ActionComponentData actionComponentData = new ActionComponentData(string, details);
        this.detailsChannel.trySend-JP2dKIU((Object)actionComponentData);
    }

    private final void makeRedirect(Activity activity, RedirectAction action) {
        String url = action.getUrl();
        try {
            Logger.d((String)TAG, (String)("makeRedirect - " + url));
            this.redirectHandler.launchUriRedirect((Context)activity, url);
        }
        catch (CheckoutException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
        }
    }

    @VisibleForTesting
    public final void challengeShopper$3ds2_release(@NotNull Activity activity, @NotNull String encodedChallengeToken) throws ComponentException {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)encodedChallengeToken, (String)"encodedChallengeToken");
        Logger.d((String)TAG, (String)"challengeShopper");
        if (this.currentTransaction == null) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new Authentication3DS2Exception("Failed to make challenge, missing reference to initial transaction."));
            return;
        }
        String decodedChallengeToken = Base64Encoder.DefaultImpls.decode$default((Base64Encoder)this.base64Encoder, (String)encodedChallengeToken, (int)0, (int)2, null);
        try {
            jSONObject = new JSONObject(decodedChallengeToken);
        }
        catch (JSONException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("JSON parsing of FingerprintToken failed", (Throwable)e));
            return;
        }
        JSONObject challengeTokenJson = jSONObject;
        ChallengeToken challengeToken = (ChallengeToken)ChallengeToken.SERIALIZER.deserialize(challengeTokenJson);
        ChallengeParameters challengeParameters = this.createChallengeParameters(challengeToken);
        try {
            Transaction transaction = this.currentTransaction;
            if (transaction != null) {
                transaction.doChallenge(activity, challengeParameters, (ChallengeStatusHandler)this, 10);
            }
        }
        catch (InvalidInputException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)new CheckoutException("Error starting challenge", (Throwable)e));
        }
    }

    private final ChallengeParameters createChallengeParameters(ChallengeToken challenge) {
        ChallengeParameters challengeParameters;
        ChallengeParameters $this$createChallengeParameters_u24lambda_u245 = challengeParameters = new ChallengeParameters();
        boolean bl = false;
        $this$createChallengeParameters_u24lambda_u245.set3DSServerTransactionID(challenge.getThreeDSServerTransID());
        $this$createChallengeParameters_u24lambda_u245.setAcsTransactionID(challenge.getAcsTransID());
        $this$createChallengeParameters_u24lambda_u245.setAcsRefNumber(challenge.getAcsReferenceNumber());
        $this$createChallengeParameters_u24lambda_u245.setAcsSignedContent(challenge.getAcsSignedContent());
        if (!Intrinsics.areEqual((Object)challenge.getMessageVersion(), (Object)PROTOCOL_VERSION_2_1_0)) {
            $this$createChallengeParameters_u24lambda_u245.setThreeDSRequestorAppURL(this.getComponentParams().getThreeDSRequestorAppURL());
        }
        return challengeParameters;
    }

    public void handleIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            JSONObject parsedResult = this.redirectHandler.parseRedirectResult(intent.getData());
            this.emitDetails(parsedResult);
        }
        catch (CheckoutException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onCompleted(String transactionStatus) {
        Logger.d((String)TAG, (String)"challenge completed");
        try {
            JSONObject details = DefaultAdyen3DS2Delegate.makeDetails$default(this, transactionStatus, null, 2, null);
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
        }
        finally {
            this.closeTransaction();
        }
    }

    private final void onCancelled() {
        Logger.d((String)TAG, (String)"challenge cancelled");
        this.exceptionChannel.trySend-JP2dKIU((Object)new Cancelled3DS2Exception("Challenge canceled."));
        this.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onTimeout(ChallengeResult.Timeout result) {
        Logger.d((String)TAG, (String)"challenge timed out");
        try {
            JSONObject details = this.makeDetails(result.getTransactionStatus(), result.getAdditionalDetails());
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
        }
        finally {
            this.closeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onError(ChallengeResult.Error result) {
        Logger.d((String)TAG, (String)"challenge timed out");
        try {
            JSONObject details = this.makeDetails(result.getTransactionStatus(), result.getAdditionalDetails());
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.exceptionChannel.trySend-JP2dKIU((Object)e);
        }
        finally {
            this.closeTransaction();
        }
    }

    public void onCompletion(@NotNull ChallengeResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        ChallengeResult challengeResult = result;
        if (challengeResult instanceof ChallengeResult.Cancelled) {
            this.onCancelled();
        } else if (challengeResult instanceof ChallengeResult.Completed) {
            this.onCompleted(((ChallengeResult.Completed)result).getTransactionStatus());
        } else if (challengeResult instanceof ChallengeResult.Error) {
            this.onError((ChallengeResult.Error)result);
        } else if (challengeResult instanceof ChallengeResult.Timeout) {
            this.onTimeout((ChallengeResult.Timeout)result);
        }
    }

    private final void closeTransaction() {
        Transaction transaction = this.currentTransaction;
        if (transaction != null) {
            transaction.close();
        }
        this.currentTransaction = null;
        this.cleanUp3DS2();
    }

    private final void cleanUp3DS2() {
        try {
            ThreeDS2Service.INSTANCE.cleanup((Context)this.application);
        }
        catch (SDKNotInitializedException sDKNotInitializedException) {
            // empty catch block
        }
    }

    public void onError(@NotNull CheckoutException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.exceptionChannel.trySend-JP2dKIU((Object)e);
    }

    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.redirectHandler.setOnRedirectListener(listener);
    }

    public void onCleared() {
        this.removeObserver();
        this._coroutineScope = null;
        this.redirectHandler.removeOnRedirectListener();
    }

    private final JSONObject makeDetails(String transactionStatus, String errorDetails) {
        String token = this.getAuthorizationToken();
        return token == null ? this.adyen3DS2Serializer.createChallengeDetails(transactionStatus, errorDetails) : this.adyen3DS2Serializer.createThreeDsResultDetails(transactionStatus, token, errorDetails);
    }

    static /* synthetic */ JSONObject makeDetails$default(DefaultAdyen3DS2Delegate defaultAdyen3DS2Delegate, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return defaultAdyen3DS2Delegate.makeDetails(string, string2);
    }

    public static final /* synthetic */ void access$closeTransaction(DefaultAdyen3DS2Delegate $this) {
        $this.closeTransaction();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ ThreeDS2Service access$getThreeDS2Service$p(DefaultAdyen3DS2Delegate $this) {
        return $this.threeDS2Service;
    }

    public static final /* synthetic */ Channel access$getExceptionChannel$p(DefaultAdyen3DS2Delegate $this) {
        return $this.exceptionChannel;
    }

    public static final /* synthetic */ void access$setCurrentTransaction$p(DefaultAdyen3DS2Delegate $this, Transaction transaction) {
        $this.currentTransaction = transaction;
    }

    public static final /* synthetic */ Transaction access$getCurrentTransaction$p(DefaultAdyen3DS2Delegate $this) {
        return $this.currentTransaction;
    }

    public static final /* synthetic */ String access$createEncodedFingerprint(DefaultAdyen3DS2Delegate $this, AuthenticationRequestParameters authenticationRequestParameters) {
        return $this.createEncodedFingerprint(authenticationRequestParameters);
    }

    public static final /* synthetic */ Object access$submitFingerprintAutomatically(DefaultAdyen3DS2Delegate $this, Activity activity, String encodedFingerprint, Continuation $completion) {
        return $this.submitFingerprintAutomatically(activity, encodedFingerprint, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$emitDetails(DefaultAdyen3DS2Delegate $this, JSONObject details) {
        $this.emitDetails(details);
    }

    public static final /* synthetic */ Adyen3DS2Serializer access$getAdyen3DS2Serializer$p(DefaultAdyen3DS2Delegate $this) {
        return $this.adyen3DS2Serializer;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DefaultAdyen3DS2Delegate.class, "authorizationToken", "getAuthorizationToken()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        TAG = LogUtil.getTag();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/ui/DefaultAdyen3DS2Delegate$Companion;", "", "()V", "AUTHORIZATION_TOKEN_KEY", "", "DEFAULT_CHALLENGE_TIME_OUT", "", "PROTOCOL_VERSION_2_1_0", "TAG", "3ds2_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Threeds2Action.SubType.values().length];
            try {
                nArray[Threeds2Action.SubType.FINGERPRINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Threeds2Action.SubType.CHALLENGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

