/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.payment;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.payment.AdjustAuthorisationRequest;
import com.adyen.model.payment.CancelOrRefundRequest;
import com.adyen.model.payment.CancelRequest;
import com.adyen.model.payment.CaptureRequest;
import com.adyen.model.payment.DonationRequest;
import com.adyen.model.payment.ModificationResult;
import com.adyen.model.payment.RefundRequest;
import com.adyen.model.payment.TechnicalCancelRequest;
import com.adyen.model.payment.VoidPendingRefundRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class ModificationsApi
extends Service {
    public static final String API_VERSION = "68";
    protected String baseURL;

    public ModificationsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://pal-test.adyen.com/pal/servlet/Payment/v68");
    }

    public ModificationsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ModificationResult adjustAuthorisation(AdjustAuthorisationRequest adjustAuthorisationRequest) throws ApiException, IOException {
        return this.adjustAuthorisation(adjustAuthorisationRequest, null);
    }

    public ModificationResult adjustAuthorisation(AdjustAuthorisationRequest adjustAuthorisationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = adjustAuthorisationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/adjustAuthorisation", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult cancel(CancelRequest cancelRequest) throws ApiException, IOException {
        return this.cancel(cancelRequest, null);
    }

    public ModificationResult cancel(CancelRequest cancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = cancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest) throws ApiException, IOException {
        return this.cancelOrRefund(cancelOrRefundRequest, null);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = cancelOrRefundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cancelOrRefund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult capture(CaptureRequest captureRequest) throws ApiException, IOException {
        return this.capture(captureRequest, null);
    }

    public ModificationResult capture(CaptureRequest captureRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = captureRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/capture", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    @Deprecated
    public ModificationResult donate(DonationRequest donationRequest) throws ApiException, IOException {
        return this.donate(donationRequest, null);
    }

    @Deprecated
    public ModificationResult donate(DonationRequest donationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = donationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/donate", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult refund(RefundRequest refundRequest) throws ApiException, IOException {
        return this.refund(refundRequest, null);
    }

    public ModificationResult refund(RefundRequest refundRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = refundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/refund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest) throws ApiException, IOException {
        return this.technicalCancel(technicalCancelRequest, null);
    }

    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = technicalCancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/technicalCancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest) throws ApiException, IOException {
        return this.voidPendingRefund(voidPendingRefundRequest, null);
    }

    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = voidPendingRefundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/voidPendingRefund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }
}

