/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.Logo;
import com.adyen.model.management.TerminalSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalSettingsStoreLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalSettingsStoreLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalSettingsStoreLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public Logo getTerminalLogo(String merchantId, String reference, String model) throws ApiException, IOException {
        return this.getTerminalLogo(merchantId, reference, model, null);
    }

    public Logo getTerminalLogo(String merchantId, String reference, String model, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public Logo getTerminalLogoByStoreId(String storeId, String model) throws ApiException, IOException {
        return this.getTerminalLogoByStoreId(storeId, model, null);
    }

    public Logo getTerminalLogoByStoreId(String storeId, String model, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String merchantId, String reference) throws ApiException, IOException {
        return this.getTerminalSettings(merchantId, reference, null);
    }

    public TerminalSettings getTerminalSettings(String merchantId, String reference, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettingsByStoreId(String storeId) throws ApiException, IOException {
        return this.getTerminalSettingsByStoreId(storeId, null);
    }

    public TerminalSettings getTerminalSettingsByStoreId(String storeId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateTerminalLogo(String merchantId, String reference, String model, Logo logo) throws ApiException, IOException {
        return this.updateTerminalLogo(merchantId, reference, model, logo, null);
    }

    public Logo updateTerminalLogo(String merchantId, String reference, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public Logo updateTerminalLogoByStoreId(String storeId, String model, Logo logo) throws ApiException, IOException {
        return this.updateTerminalLogoByStoreId(storeId, model, logo, null);
    }

    public Logo updateTerminalLogoByStoreId(String storeId, String model, Logo logo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (model != null) {
            queryParams.put("model", model);
        }
        String requestBody = logo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalLogos", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String merchantId, String reference, TerminalSettings terminalSettings) throws ApiException, IOException {
        return this.updateTerminalSettings(merchantId, reference, terminalSettings, null);
    }

    public TerminalSettings updateTerminalSettings(String merchantId, String reference, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (reference == null) {
            throw new IllegalArgumentException("Please provide the reference path parameter");
        }
        pathParams.put("reference", reference);
        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{reference}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettingsByStoreId(String storeId, TerminalSettings terminalSettings) throws ApiException, IOException {
        return this.updateTerminalSettingsByStoreId(storeId, terminalSettings, null);
    }

    public TerminalSettings updateTerminalSettingsByStoreId(String storeId, TerminalSettings terminalSettings, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = terminalSettings.toJson();
        Resource resource = new Resource(this, this.baseURL + "/stores/{storeId}/terminalSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}

