/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.BillingEntitiesResponse;
import com.adyen.model.management.ShippingLocation;
import com.adyen.model.management.ShippingLocationsResponse;
import com.adyen.model.management.TerminalModelsResponse;
import com.adyen.model.management.TerminalOrder;
import com.adyen.model.management.TerminalOrderRequest;
import com.adyen.model.management.TerminalOrdersResponse;
import com.adyen.model.management.TerminalProductsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalOrdersMerchantLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalOrdersMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalOrdersMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public TerminalOrder cancelOrder(String merchantId, String orderId) throws ApiException, IOException {
        return this.cancelOrder(merchantId, orderId, null);
    }

    public TerminalOrder cancelOrder(String merchantId, String orderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalOrders/{orderId}/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public TerminalOrder createOrder(String merchantId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        return this.createOrder(merchantId, terminalOrderRequest, null);
    }

    public TerminalOrder createOrder(String merchantId, TerminalOrderRequest terminalOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = terminalOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalOrders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public ShippingLocation createShippingLocation(String merchantId, ShippingLocation shippingLocation) throws ApiException, IOException {
        return this.createShippingLocation(merchantId, shippingLocation, null);
    }

    public ShippingLocation createShippingLocation(String merchantId, ShippingLocation shippingLocation, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = shippingLocation.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/shippingLocations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return ShippingLocation.fromJson(jsonResult);
    }

    public TerminalOrder getOrder(String merchantId, String orderId) throws ApiException, IOException {
        return this.getOrder(merchantId, orderId, null);
    }

    public TerminalOrder getOrder(String merchantId, String orderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalOrders/{orderId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public BillingEntitiesResponse listBillingEntities(String merchantId) throws ApiException, IOException {
        return this.listBillingEntities(merchantId, null, null);
    }

    public BillingEntitiesResponse listBillingEntities(String merchantId, String name, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (name != null) {
            queryParams.put("name", name);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/billingEntities", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return BillingEntitiesResponse.fromJson(jsonResult);
    }

    public TerminalOrdersResponse listOrders(String merchantId) throws ApiException, IOException {
        return this.listOrders(merchantId, null, null, null, null, null);
    }

    public TerminalOrdersResponse listOrders(String merchantId, String customerOrderReference, String status, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (customerOrderReference != null) {
            queryParams.put("customerOrderReference", customerOrderReference);
        }
        if (status != null) {
            queryParams.put("status", status);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalOrders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalOrdersResponse.fromJson(jsonResult);
    }

    public ShippingLocationsResponse listShippingLocations(String merchantId) throws ApiException, IOException {
        return this.listShippingLocations(merchantId, null, null, null, null);
    }

    public ShippingLocationsResponse listShippingLocations(String merchantId, String name, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (name != null) {
            queryParams.put("name", name);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/shippingLocations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ShippingLocationsResponse.fromJson(jsonResult);
    }

    public TerminalModelsResponse listTerminalModels(String merchantId) throws ApiException, IOException {
        return this.listTerminalModels(merchantId, null);
    }

    public TerminalModelsResponse listTerminalModels(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalModels", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalModelsResponse.fromJson(jsonResult);
    }

    public TerminalProductsResponse listTerminalProducts(String merchantId, String country) throws ApiException, IOException {
        return this.listTerminalProducts(merchantId, country, null, null, null, null);
    }

    public TerminalProductsResponse listTerminalProducts(String merchantId, String country, String terminalModelId, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (country != null) {
            queryParams.put("country", country);
        }
        if (terminalModelId != null) {
            queryParams.put("terminalModelId", terminalModelId);
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalProducts", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalProductsResponse.fromJson(jsonResult);
    }

    public TerminalOrder updateOrder(String merchantId, String orderId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        return this.updateOrder(merchantId, orderId, terminalOrderRequest, null);
    }

    public TerminalOrder updateOrder(String merchantId, String orderId, TerminalOrderRequest terminalOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (orderId == null) {
            throw new IllegalArgumentException("Please provide the orderId path parameter");
        }
        pathParams.put("orderId", orderId);
        String requestBody = terminalOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/terminalOrders/{orderId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }
}

