/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.BeginScaDeviceRegistrationRequest;
import com.adyen.model.balanceplatform.BeginScaDeviceRegistrationResponse;
import com.adyen.model.balanceplatform.FinishScaDeviceRegistrationRequest;
import com.adyen.model.balanceplatform.FinishScaDeviceRegistrationResponse;
import com.adyen.model.balanceplatform.SubmitScaAssociationRequest;
import com.adyen.model.balanceplatform.SubmitScaAssociationResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ScaDeviceManagementApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public ScaDeviceManagementApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public ScaDeviceManagementApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public BeginScaDeviceRegistrationResponse beginScaDeviceRegistration(BeginScaDeviceRegistrationRequest beginScaDeviceRegistrationRequest) throws ApiException, IOException {
        return this.beginScaDeviceRegistration(beginScaDeviceRegistrationRequest, null);
    }

    public BeginScaDeviceRegistrationResponse beginScaDeviceRegistration(BeginScaDeviceRegistrationRequest beginScaDeviceRegistrationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = beginScaDeviceRegistrationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scaDevices", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return BeginScaDeviceRegistrationResponse.fromJson(jsonResult);
    }

    public FinishScaDeviceRegistrationResponse finishScaDeviceRegistration(String deviceId, FinishScaDeviceRegistrationRequest finishScaDeviceRegistrationRequest) throws ApiException, IOException {
        return this.finishScaDeviceRegistration(deviceId, finishScaDeviceRegistrationRequest, null);
    }

    public FinishScaDeviceRegistrationResponse finishScaDeviceRegistration(String deviceId, FinishScaDeviceRegistrationRequest finishScaDeviceRegistrationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (deviceId == null) {
            throw new IllegalArgumentException("Please provide the deviceId path parameter");
        }
        pathParams.put("deviceId", deviceId);
        String requestBody = finishScaDeviceRegistrationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scaDevices/{deviceId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return FinishScaDeviceRegistrationResponse.fromJson(jsonResult);
    }

    public SubmitScaAssociationResponse submitScaAssociation(String deviceId, SubmitScaAssociationRequest submitScaAssociationRequest) throws ApiException, IOException {
        return this.submitScaAssociation(deviceId, submitScaAssociationRequest, null);
    }

    public SubmitScaAssociationResponse submitScaAssociation(String deviceId, SubmitScaAssociationRequest submitScaAssociationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (deviceId == null) {
            throw new IllegalArgumentException("Please provide the deviceId path parameter");
        }
        pathParams.put("deviceId", deviceId);
        String requestBody = submitScaAssociationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scaDevices/{deviceId}/scaAssociations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return SubmitScaAssociationResponse.fromJson(jsonResult);
    }
}

