/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.ApproveAssociationRequest;
import com.adyen.model.balanceplatform.ApproveAssociationResponse;
import com.adyen.model.balanceplatform.ListAssociationsResponse;
import com.adyen.model.balanceplatform.RemoveAssociationRequest;
import com.adyen.model.balanceplatform.ScaEntityType;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class ScaAssociationManagementApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public ScaAssociationManagementApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public ScaAssociationManagementApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ApproveAssociationResponse approveAssociation(ApproveAssociationRequest approveAssociationRequest) throws ApiException, IOException {
        return this.approveAssociation(approveAssociationRequest, null);
    }

    public ApproveAssociationResponse approveAssociation(ApproveAssociationRequest approveAssociationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = approveAssociationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scaAssociations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, null);
        return ApproveAssociationResponse.fromJson(jsonResult);
    }

    public ListAssociationsResponse listAssociations(ScaEntityType entityType, String entityId, Integer pageSize, Integer pageNumber) throws ApiException, IOException {
        return this.listAssociations(entityType, entityId, pageSize, pageNumber, null);
    }

    public ListAssociationsResponse listAssociations(ScaEntityType entityType, String entityId, Integer pageSize, Integer pageNumber, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (entityType != null) {
            queryParams.put("entityType", entityType.toString());
        }
        if (entityId != null) {
            queryParams.put("entityId", entityId);
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/scaAssociations", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListAssociationsResponse.fromJson(jsonResult);
    }

    public void removeAssociation(RemoveAssociationRequest removeAssociationRequest) throws ApiException, IOException {
        this.removeAssociation(removeAssociationRequest, null);
    }

    public void removeAssociation(RemoveAssociationRequest removeAssociationRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = removeAssociationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/scaAssociations", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, null);
    }
}

