/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyInfoV3;
import com.adyen.model.transfers.ExecutionDate;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.TransferRequestReview;
import com.adyen.model.transfers.UltimatePartyIdentification;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "balanceAccountId", "category", "counterparty", "description", "executionDate", "paymentInstrumentId", "priorities", "priority", "reference", "referenceForBeneficiary", "review", "type", "ultimateParty"})
public class TransferInfo {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    private boolean isSetBalanceAccountId = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    private boolean isSetCategory = false;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CounterpartyInfoV3 counterparty;
    private boolean isSetCounterparty = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    private boolean isSetDescription = false;
    public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
    private ExecutionDate executionDate;
    private boolean isSetExecutionDate = false;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    private boolean isSetPaymentInstrumentId = false;
    public static final String JSON_PROPERTY_PRIORITIES = "priorities";
    private List<PrioritiesEnum> priorities;
    private boolean isSetPriorities = false;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    private boolean isSetPriority = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    private boolean isSetReferenceForBeneficiary = false;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private TransferRequestReview review;
    private boolean isSetReview = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_ULTIMATE_PARTY = "ultimateParty";
    private UltimatePartyIdentification ultimateParty;
    private boolean isSetUltimateParty = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TransferInfo amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public TransferInfo balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        this.isSetBalanceAccountId = true;
        return this;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        this.isSetBalanceAccountId = true;
    }

    public TransferInfo category(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
    }

    public TransferInfo counterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyInfoV3 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
    }

    public TransferInfo description(String description) {
        this.description = description;
        this.isSetDescription = true;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
        this.isSetDescription = true;
    }

    public TransferInfo executionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
        this.isSetExecutionDate = true;
        return this;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExecutionDate getExecutionDate() {
        return this.executionDate;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
        this.isSetExecutionDate = true;
    }

    public TransferInfo paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        this.isSetPaymentInstrumentId = true;
        return this;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        this.isSetPaymentInstrumentId = true;
    }

    public TransferInfo priorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        this.isSetPriorities = true;
        return this;
    }

    public TransferInfo addPrioritiesItem(PrioritiesEnum prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<PrioritiesEnum>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PrioritiesEnum> getPriorities() {
        return this.priorities;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        this.isSetPriorities = true;
    }

    public TransferInfo priority(PriorityEnum priority) {
        this.priority = priority;
        this.isSetPriority = true;
        return this;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
        this.isSetPriority = true;
    }

    public TransferInfo reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public TransferInfo referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        this.isSetReferenceForBeneficiary = true;
        return this;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        this.isSetReferenceForBeneficiary = true;
    }

    public TransferInfo review(TransferRequestReview review) {
        this.review = review;
        this.isSetReview = true;
        return this;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferRequestReview getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(TransferRequestReview review) {
        this.review = review;
        this.isSetReview = true;
    }

    public TransferInfo type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public TransferInfo ultimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
        this.isSetUltimateParty = true;
        return this;
    }

    @JsonProperty(value="ultimateParty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UltimatePartyIdentification getUltimateParty() {
        return this.ultimateParty;
    }

    @JsonProperty(value="ultimateParty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUltimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
        this.isSetUltimateParty = true;
    }

    public TransferInfo includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInfo transferInfo = (TransferInfo)o;
        return Objects.equals(this.amount, transferInfo.amount) && Objects.equals(this.isSetAmount, transferInfo.isSetAmount) && Objects.equals(this.balanceAccountId, transferInfo.balanceAccountId) && Objects.equals(this.isSetBalanceAccountId, transferInfo.isSetBalanceAccountId) && Objects.equals((Object)this.category, (Object)transferInfo.category) && Objects.equals(this.isSetCategory, transferInfo.isSetCategory) && Objects.equals(this.counterparty, transferInfo.counterparty) && Objects.equals(this.isSetCounterparty, transferInfo.isSetCounterparty) && Objects.equals(this.description, transferInfo.description) && Objects.equals(this.isSetDescription, transferInfo.isSetDescription) && Objects.equals(this.executionDate, transferInfo.executionDate) && Objects.equals(this.isSetExecutionDate, transferInfo.isSetExecutionDate) && Objects.equals(this.paymentInstrumentId, transferInfo.paymentInstrumentId) && Objects.equals(this.isSetPaymentInstrumentId, transferInfo.isSetPaymentInstrumentId) && Objects.equals(this.priorities, transferInfo.priorities) && Objects.equals(this.isSetPriorities, transferInfo.isSetPriorities) && Objects.equals((Object)this.priority, (Object)transferInfo.priority) && Objects.equals(this.isSetPriority, transferInfo.isSetPriority) && Objects.equals(this.reference, transferInfo.reference) && Objects.equals(this.isSetReference, transferInfo.isSetReference) && Objects.equals(this.referenceForBeneficiary, transferInfo.referenceForBeneficiary) && Objects.equals(this.isSetReferenceForBeneficiary, transferInfo.isSetReferenceForBeneficiary) && Objects.equals(this.review, transferInfo.review) && Objects.equals(this.isSetReview, transferInfo.isSetReview) && Objects.equals((Object)this.type, (Object)transferInfo.type) && Objects.equals(this.isSetType, transferInfo.isSetType) && Objects.equals(this.ultimateParty, transferInfo.ultimateParty) && Objects.equals(this.isSetUltimateParty, transferInfo.isSetUltimateParty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.balanceAccountId, this.isSetBalanceAccountId, this.category, this.isSetCategory, this.counterparty, this.isSetCounterparty, this.description, this.isSetDescription, this.executionDate, this.isSetExecutionDate, this.paymentInstrumentId, this.isSetPaymentInstrumentId, this.priorities, this.isSetPriorities, this.priority, this.isSetPriority, this.reference, this.isSetReference, this.referenceForBeneficiary, this.isSetReferenceForBeneficiary, this.review, this.isSetReview, this.type, this.isSetType, this.ultimateParty, this.isSetUltimateParty});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInfo {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ultimateParty: ").append(this.toIndentedString(this.ultimateParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetBalanceAccountId) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCE_ACCOUNT_ID, this.balanceAccountId);
        }
        if (this.isSetCategory) {
            this.addIfNull(nulls, JSON_PROPERTY_CATEGORY, (Object)this.category);
        }
        if (this.isSetCounterparty) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTERPARTY, this.counterparty);
        }
        if (this.isSetDescription) {
            this.addIfNull(nulls, JSON_PROPERTY_DESCRIPTION, this.description);
        }
        if (this.isSetExecutionDate) {
            this.addIfNull(nulls, JSON_PROPERTY_EXECUTION_DATE, this.executionDate);
        }
        if (this.isSetPaymentInstrumentId) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_INSTRUMENT_ID, this.paymentInstrumentId);
        }
        if (this.isSetPriorities) {
            this.addIfNull(nulls, JSON_PROPERTY_PRIORITIES, this.priorities);
        }
        if (this.isSetPriority) {
            this.addIfNull(nulls, JSON_PROPERTY_PRIORITY, (Object)this.priority);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetReferenceForBeneficiary) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY, this.referenceForBeneficiary);
        }
        if (this.isSetReview) {
            this.addIfNull(nulls, JSON_PROPERTY_REVIEW, this.review);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUltimateParty) {
            this.addIfNull(nulls, JSON_PROPERTY_ULTIMATE_PARTY, this.ultimateParty);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TransferInfo fromJson(String jsonString) throws JsonProcessingException {
        return (TransferInfo)JSON.getMapper().readValue(jsonString, TransferInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKTRANSFER(String.valueOf("bankTransfer")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALDIRECTDEBIT(String.valueOf("internalDirectDebit"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum PriorityEnum {
        CROSSBORDER(String.valueOf("crossBorder")),
        FAST(String.valueOf("fast")),
        INSTANT(String.valueOf("instant")),
        INTERNAL(String.valueOf("internal")),
        REGULAR(String.valueOf("regular")),
        WIRE(String.valueOf("wire"));

        private static final Logger LOG;
        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PriorityEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PriorityEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PriorityEnum.class.getName());
        }
    }

    public static enum PrioritiesEnum {
        CROSSBORDER(String.valueOf("crossBorder")),
        FAST(String.valueOf("fast")),
        INSTANT(String.valueOf("instant")),
        INTERNAL(String.valueOf("internal")),
        REGULAR(String.valueOf("regular")),
        WIRE(String.valueOf("wire"));

        private static final Logger LOG;
        private String value;

        private PrioritiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrioritiesEnum fromValue(String value) {
            for (PrioritiesEnum b : PrioritiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PrioritiesEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PrioritiesEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PrioritiesEnum.class.getName());
        }
    }

    public static enum CategoryEnum {
        BANK(String.valueOf("bank")),
        CARD(String.valueOf("card")),
        INTERNAL(String.valueOf("internal")),
        ISSUEDCARD(String.valueOf("issuedCard")),
        PLATFORMPAYMENT(String.valueOf("platformPayment")),
        TOPUP(String.valueOf("topUp"));

        private static final Logger LOG;
        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CategoryEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CategoryEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CategoryEnum.class.getName());
        }
    }
}

