/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.AbstractOpenApiSchema;
import com.adyen.model.transfers.BankCategoryData;
import com.adyen.model.transfers.InternalCategoryData;
import com.adyen.model.transfers.IssuedCard;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PlatformPayment;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=TransferCategoryDataDeserializer.class)
@JsonSerialize(using=TransferCategoryDataSerializer.class)
public class TransferCategoryData
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(TransferCategoryData.class.getName());
    public static final Map<String, GenericType<?>> schemas = new HashMap();

    public TransferCategoryData() {
        super("oneOf", Boolean.FALSE);
    }

    public TransferCategoryData(BankCategoryData o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public TransferCategoryData(InternalCategoryData o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public TransferCategoryData(IssuedCard o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public TransferCategoryData(PlatformPayment o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(BankCategoryData.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(InternalCategoryData.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(IssuedCard.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(PlatformPayment.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be BankCategoryData, InternalCategoryData, IssuedCard, PlatformPayment");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public BankCategoryData getBankCategoryData() throws ClassCastException {
        return (BankCategoryData)super.getActualInstance();
    }

    public InternalCategoryData getInternalCategoryData() throws ClassCastException {
        return (InternalCategoryData)super.getActualInstance();
    }

    public IssuedCard getIssuedCard() throws ClassCastException {
        return (IssuedCard)super.getActualInstance();
    }

    public PlatformPayment getPlatformPayment() throws ClassCastException {
        return (PlatformPayment)super.getActualInstance();
    }

    public static TransferCategoryData fromJson(String jsonString) throws IOException {
        return (TransferCategoryData)JSON.getMapper().readValue(jsonString, TransferCategoryData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    static {
        schemas.put("BankCategoryData", new GenericType<BankCategoryData>(){});
        schemas.put("InternalCategoryData", new GenericType<InternalCategoryData>(){});
        schemas.put("IssuedCard", new GenericType<IssuedCard>(){});
        schemas.put("PlatformPayment", new GenericType<PlatformPayment>(){});
        JSON.registerDescendants(TransferCategoryData.class, Collections.unmodifiableMap(schemas));
    }

    public static class TransferCategoryDataDeserializer
    extends StdDeserializer<TransferCategoryData> {
        public TransferCategoryDataDeserializer() {
            this(TransferCategoryData.class);
        }

        public TransferCategoryDataDeserializer(Class<?> vc) {
            super(vc);
        }

        public TransferCategoryData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            boolean typeMatch;
            boolean attemptParsing;
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                attemptParsing = true;
                if (attemptParsing) {
                    typeMatch = false;
                    if (tree.findValue("type") != null) {
                        typeMatch = Arrays.stream(BankCategoryData.TypeEnum.values()).anyMatch(t -> t.getValue().equals(tree.findValue("type").asText()));
                    }
                    if (typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(BankCategoryData.class);
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'BankCategoryData'");
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'BankCategoryData'", e);
            }
            try {
                attemptParsing = true;
                if (attemptParsing) {
                    typeMatch = false;
                    if (tree.findValue("type") != null) {
                        typeMatch = Arrays.stream(InternalCategoryData.TypeEnum.values()).anyMatch(t -> t.getValue().equals(tree.findValue("type").asText()));
                    }
                    if (typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(InternalCategoryData.class);
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'InternalCategoryData'");
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'InternalCategoryData'", e);
            }
            try {
                boolean attemptParsing2 = true;
                if (attemptParsing2) {
                    typeMatch = false;
                    if (tree.findValue("type") != null) {
                        typeMatch = Arrays.stream(IssuedCard.TypeEnum.values()).anyMatch(t -> t.getValue().equals(tree.findValue("type").asText()));
                    }
                    if (typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(IssuedCard.class);
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'IssuedCard'");
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'IssuedCard'", e);
            }
            try {
                boolean attemptParsing3 = true;
                if (attemptParsing3) {
                    typeMatch = false;
                    if (tree.findValue("type") != null) {
                        typeMatch = Arrays.stream(PlatformPayment.TypeEnum.values()).anyMatch(t -> t.getValue().equals(tree.findValue("type").asText()));
                    }
                    if (typeMatch) {
                        deserialized = tree.traverse(jp.getCodec()).readValueAs(PlatformPayment.class);
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'PlatformPayment'");
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'PlatformPayment'", e);
            }
            if (match == 1) {
                TransferCategoryData ret = new TransferCategoryData();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for TransferCategoryData: %d classes match result, expected 1", match));
        }

        public TransferCategoryData getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "TransferCategoryData cannot be null");
        }
    }

    public static class TransferCategoryDataSerializer
    extends StdSerializer<TransferCategoryData> {
        public TransferCategoryDataSerializer(Class<TransferCategoryData> t) {
            super(t);
        }

        public TransferCategoryDataSerializer() {
            this(null);
        }

        public void serialize(TransferCategoryData value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

