/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.RepaymentTerm;
import com.adyen.model.transfers.ThresholdRepayment;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"basisPoints", "term", "threshold"})
public class Repayment {
    public static final String JSON_PROPERTY_BASIS_POINTS = "basisPoints";
    private Integer basisPoints;
    private boolean isSetBasisPoints = false;
    public static final String JSON_PROPERTY_TERM = "term";
    private RepaymentTerm term;
    private boolean isSetTerm = false;
    public static final String JSON_PROPERTY_THRESHOLD = "threshold";
    private ThresholdRepayment threshold;
    private boolean isSetThreshold = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Repayment basisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
        this.isSetBasisPoints = true;
        return this;
    }

    @JsonProperty(value="basisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBasisPoints() {
        return this.basisPoints;
    }

    @JsonProperty(value="basisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBasisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
        this.isSetBasisPoints = true;
    }

    public Repayment term(RepaymentTerm term) {
        this.term = term;
        this.isSetTerm = true;
        return this;
    }

    @JsonProperty(value="term")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RepaymentTerm getTerm() {
        return this.term;
    }

    @JsonProperty(value="term")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerm(RepaymentTerm term) {
        this.term = term;
        this.isSetTerm = true;
    }

    public Repayment threshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
        this.isSetThreshold = true;
        return this;
    }

    @JsonProperty(value="threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThresholdRepayment getThreshold() {
        return this.threshold;
    }

    @JsonProperty(value="threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
        this.isSetThreshold = true;
    }

    public Repayment includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repayment repayment = (Repayment)o;
        return Objects.equals(this.basisPoints, repayment.basisPoints) && Objects.equals(this.isSetBasisPoints, repayment.isSetBasisPoints) && Objects.equals(this.term, repayment.term) && Objects.equals(this.isSetTerm, repayment.isSetTerm) && Objects.equals(this.threshold, repayment.threshold) && Objects.equals(this.isSetThreshold, repayment.isSetThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.basisPoints, this.isSetBasisPoints, this.term, this.isSetTerm, this.threshold, this.isSetThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Repayment {\n");
        sb.append("    basisPoints: ").append(this.toIndentedString(this.basisPoints)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBasisPoints) {
            this.addIfNull(nulls, JSON_PROPERTY_BASIS_POINTS, this.basisPoints);
        }
        if (this.isSetTerm) {
            this.addIfNull(nulls, JSON_PROPERTY_TERM, this.term);
        }
        if (this.isSetThreshold) {
            this.addIfNull(nulls, JSON_PROPERTY_THRESHOLD, this.threshold);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Repayment fromJson(String jsonString) throws JsonProcessingException {
        return (Repayment)JSON.getMapper().readValue(jsonString, Repayment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

