/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"authCode", "currentBalance", "paymentMethod", "pspReference", "refusalReason", "resultCode", "thirdPartyRefusalReason"})
public class StoredValueIssueResponse {
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    private boolean isSetAuthCode = false;
    public static final String JSON_PROPERTY_CURRENT_BALANCE = "currentBalance";
    private Amount currentBalance;
    private boolean isSetCurrentBalance = false;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private Map<String, String> paymentMethod;
    private boolean isSetPaymentMethod = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    private boolean isSetRefusalReason = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    public static final String JSON_PROPERTY_THIRD_PARTY_REFUSAL_REASON = "thirdPartyRefusalReason";
    private String thirdPartyRefusalReason;
    private boolean isSetThirdPartyRefusalReason = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public StoredValueIssueResponse authCode(String authCode) {
        this.authCode = authCode;
        this.isSetAuthCode = true;
        return this;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
        this.isSetAuthCode = true;
    }

    public StoredValueIssueResponse currentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
        this.isSetCurrentBalance = true;
        return this;
    }

    @JsonProperty(value="currentBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getCurrentBalance() {
        return this.currentBalance;
    }

    @JsonProperty(value="currentBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
        this.isSetCurrentBalance = true;
    }

    public StoredValueIssueResponse paymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
        return this;
    }

    public StoredValueIssueResponse putPaymentMethodItem(String key, String paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new HashMap<String, String>();
        }
        this.paymentMethod.put(key, paymentMethodItem);
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
    }

    public StoredValueIssueResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public StoredValueIssueResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
    }

    public StoredValueIssueResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public StoredValueIssueResponse thirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
        this.isSetThirdPartyRefusalReason = true;
        return this;
    }

    @JsonProperty(value="thirdPartyRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThirdPartyRefusalReason() {
        return this.thirdPartyRefusalReason;
    }

    @JsonProperty(value="thirdPartyRefusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
        this.isSetThirdPartyRefusalReason = true;
    }

    public StoredValueIssueResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueIssueResponse storedValueIssueResponse = (StoredValueIssueResponse)o;
        return Objects.equals(this.authCode, storedValueIssueResponse.authCode) && Objects.equals(this.isSetAuthCode, storedValueIssueResponse.isSetAuthCode) && Objects.equals(this.currentBalance, storedValueIssueResponse.currentBalance) && Objects.equals(this.isSetCurrentBalance, storedValueIssueResponse.isSetCurrentBalance) && Objects.equals(this.paymentMethod, storedValueIssueResponse.paymentMethod) && Objects.equals(this.isSetPaymentMethod, storedValueIssueResponse.isSetPaymentMethod) && Objects.equals(this.pspReference, storedValueIssueResponse.pspReference) && Objects.equals(this.isSetPspReference, storedValueIssueResponse.isSetPspReference) && Objects.equals(this.refusalReason, storedValueIssueResponse.refusalReason) && Objects.equals(this.isSetRefusalReason, storedValueIssueResponse.isSetRefusalReason) && Objects.equals((Object)this.resultCode, (Object)storedValueIssueResponse.resultCode) && Objects.equals(this.isSetResultCode, storedValueIssueResponse.isSetResultCode) && Objects.equals(this.thirdPartyRefusalReason, storedValueIssueResponse.thirdPartyRefusalReason) && Objects.equals(this.isSetThirdPartyRefusalReason, storedValueIssueResponse.isSetThirdPartyRefusalReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authCode, this.isSetAuthCode, this.currentBalance, this.isSetCurrentBalance, this.paymentMethod, this.isSetPaymentMethod, this.pspReference, this.isSetPspReference, this.refusalReason, this.isSetRefusalReason, this.resultCode, this.isSetResultCode, this.thirdPartyRefusalReason, this.isSetThirdPartyRefusalReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueIssueResponse {\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    currentBalance: ").append(this.toIndentedString(this.currentBalance)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    thirdPartyRefusalReason: ").append(this.toIndentedString(this.thirdPartyRefusalReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAuthCode) {
            this.addIfNull(nulls, JSON_PROPERTY_AUTH_CODE, this.authCode);
        }
        if (this.isSetCurrentBalance) {
            this.addIfNull(nulls, JSON_PROPERTY_CURRENT_BALANCE, this.currentBalance);
        }
        if (this.isSetPaymentMethod) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_METHOD, this.paymentMethod);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON, this.refusalReason);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        if (this.isSetThirdPartyRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_THIRD_PARTY_REFUSAL_REASON, this.thirdPartyRefusalReason);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static StoredValueIssueResponse fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueIssueResponse)JSON.getMapper().readValue(jsonString, StoredValueIssueResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS(String.valueOf("Success")),
        REFUSED(String.valueOf("Refused")),
        ERROR(String.valueOf("Error")),
        NOTENOUGHBALANCE(String.valueOf("NotEnoughBalance"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

