/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Address;
import com.adyen.model.payout.Amount;
import com.adyen.model.payout.Card;
import com.adyen.model.payout.FundSource;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.adyen.model.payout.Recurring;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "billingAddress", "card", "fraudOffset", "fundSource", "merchantAccount", "recurring", "reference", "selectedRecurringDetailReference", "shopperEmail", "shopperInteraction", "shopperName", "shopperReference", "telephoneNumber"})
public class PayoutRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    private boolean isSetBillingAddress = false;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    private boolean isSetCard = false;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    private boolean isSetFraudOffset = false;
    public static final String JSON_PROPERTY_FUND_SOURCE = "fundSource";
    private FundSource fundSource;
    private boolean isSetFundSource = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    private boolean isSetRecurring = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    private boolean isSetSelectedRecurringDetailReference = false;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    private boolean isSetShopperEmail = false;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    private boolean isSetShopperInteraction = false;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    private boolean isSetShopperName = false;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    private boolean isSetShopperReference = false;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    private boolean isSetTelephoneNumber = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PayoutRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public PayoutRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        this.isSetBillingAddress = true;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        this.isSetBillingAddress = true;
    }

    public PayoutRequest card(Card card) {
        this.card = card;
        this.isSetCard = true;
        return this;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
        this.isSetCard = true;
    }

    public PayoutRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        this.isSetFraudOffset = true;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        this.isSetFraudOffset = true;
    }

    public PayoutRequest fundSource(FundSource fundSource) {
        this.fundSource = fundSource;
        this.isSetFundSource = true;
        return this;
    }

    @JsonProperty(value="fundSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundSource getFundSource() {
        return this.fundSource;
    }

    @JsonProperty(value="fundSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundSource(FundSource fundSource) {
        this.fundSource = fundSource;
        this.isSetFundSource = true;
    }

    public PayoutRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public PayoutRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        this.isSetRecurring = true;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
        this.isSetRecurring = true;
    }

    public PayoutRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public PayoutRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        this.isSetSelectedRecurringDetailReference = true;
        return this;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        this.isSetSelectedRecurringDetailReference = true;
    }

    public PayoutRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
    }

    public PayoutRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        this.isSetShopperInteraction = true;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        this.isSetShopperInteraction = true;
    }

    public PayoutRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
    }

    public PayoutRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
    }

    public PayoutRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        this.isSetTelephoneNumber = true;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        this.isSetTelephoneNumber = true;
    }

    public PayoutRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutRequest payoutRequest = (PayoutRequest)o;
        return Objects.equals(this.amount, payoutRequest.amount) && Objects.equals(this.isSetAmount, payoutRequest.isSetAmount) && Objects.equals(this.billingAddress, payoutRequest.billingAddress) && Objects.equals(this.isSetBillingAddress, payoutRequest.isSetBillingAddress) && Objects.equals(this.card, payoutRequest.card) && Objects.equals(this.isSetCard, payoutRequest.isSetCard) && Objects.equals(this.fraudOffset, payoutRequest.fraudOffset) && Objects.equals(this.isSetFraudOffset, payoutRequest.isSetFraudOffset) && Objects.equals(this.fundSource, payoutRequest.fundSource) && Objects.equals(this.isSetFundSource, payoutRequest.isSetFundSource) && Objects.equals(this.merchantAccount, payoutRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, payoutRequest.isSetMerchantAccount) && Objects.equals(this.recurring, payoutRequest.recurring) && Objects.equals(this.isSetRecurring, payoutRequest.isSetRecurring) && Objects.equals(this.reference, payoutRequest.reference) && Objects.equals(this.isSetReference, payoutRequest.isSetReference) && Objects.equals(this.selectedRecurringDetailReference, payoutRequest.selectedRecurringDetailReference) && Objects.equals(this.isSetSelectedRecurringDetailReference, payoutRequest.isSetSelectedRecurringDetailReference) && Objects.equals(this.shopperEmail, payoutRequest.shopperEmail) && Objects.equals(this.isSetShopperEmail, payoutRequest.isSetShopperEmail) && Objects.equals((Object)this.shopperInteraction, (Object)payoutRequest.shopperInteraction) && Objects.equals(this.isSetShopperInteraction, payoutRequest.isSetShopperInteraction) && Objects.equals(this.shopperName, payoutRequest.shopperName) && Objects.equals(this.isSetShopperName, payoutRequest.isSetShopperName) && Objects.equals(this.shopperReference, payoutRequest.shopperReference) && Objects.equals(this.isSetShopperReference, payoutRequest.isSetShopperReference) && Objects.equals(this.telephoneNumber, payoutRequest.telephoneNumber) && Objects.equals(this.isSetTelephoneNumber, payoutRequest.isSetTelephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.billingAddress, this.isSetBillingAddress, this.card, this.isSetCard, this.fraudOffset, this.isSetFraudOffset, this.fundSource, this.isSetFundSource, this.merchantAccount, this.isSetMerchantAccount, this.recurring, this.isSetRecurring, this.reference, this.isSetReference, this.selectedRecurringDetailReference, this.isSetSelectedRecurringDetailReference, this.shopperEmail, this.isSetShopperEmail, this.shopperInteraction, this.isSetShopperInteraction, this.shopperName, this.isSetShopperName, this.shopperReference, this.isSetShopperReference, this.telephoneNumber, this.isSetTelephoneNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    fundSource: ").append(this.toIndentedString(this.fundSource)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetBillingAddress) {
            this.addIfNull(nulls, JSON_PROPERTY_BILLING_ADDRESS, this.billingAddress);
        }
        if (this.isSetCard) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD, this.card);
        }
        if (this.isSetFraudOffset) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_OFFSET, this.fraudOffset);
        }
        if (this.isSetFundSource) {
            this.addIfNull(nulls, JSON_PROPERTY_FUND_SOURCE, this.fundSource);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetRecurring) {
            this.addIfNull(nulls, JSON_PROPERTY_RECURRING, this.recurring);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSelectedRecurringDetailReference) {
            this.addIfNull(nulls, JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE, this.selectedRecurringDetailReference);
        }
        if (this.isSetShopperEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_EMAIL, this.shopperEmail);
        }
        if (this.isSetShopperInteraction) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_INTERACTION, (Object)this.shopperInteraction);
        }
        if (this.isSetShopperName) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_NAME, this.shopperName);
        }
        if (this.isSetShopperReference) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_REFERENCE, this.shopperReference);
        }
        if (this.isSetTelephoneNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_TELEPHONE_NUMBER, this.telephoneNumber);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PayoutRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutRequest)JSON.getMapper().readValue(jsonString, PayoutRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private static final Logger LOG;
        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ShopperInteractionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ShopperInteractionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ShopperInteractionEnum.class.getName());
        }
    }
}

