/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "merchantAccount", "originalReference"})
public class ModifyRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
    private String originalReference;
    private boolean isSetOriginalReference = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public ModifyRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public ModifyRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public ModifyRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public ModifyRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        this.isSetOriginalReference = true;
        return this;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalReference() {
        return this.originalReference;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
        this.isSetOriginalReference = true;
    }

    public ModifyRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyRequest modifyRequest = (ModifyRequest)o;
        return Objects.equals(this.additionalData, modifyRequest.additionalData) && Objects.equals(this.isSetAdditionalData, modifyRequest.isSetAdditionalData) && Objects.equals(this.merchantAccount, modifyRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, modifyRequest.isSetMerchantAccount) && Objects.equals(this.originalReference, modifyRequest.originalReference) && Objects.equals(this.isSetOriginalReference, modifyRequest.isSetOriginalReference);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.isSetAdditionalData, this.merchantAccount, this.isSetMerchantAccount, this.originalReference, this.isSetOriginalReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModifyRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetOriginalReference) {
            this.addIfNull(nulls, JSON_PROPERTY_ORIGINAL_REFERENCE, this.originalReference);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static ModifyRequest fromJson(String jsonString) throws JsonProcessingException {
        return (ModifyRequest)JSON.getMapper().readValue(jsonString, ModifyRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

