/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Address;
import com.adyen.model.payout.Card;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "billingAddress", "card", "shopperEmail", "shopperName", "telephoneNumber"})
public class FundSource {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    private boolean isSetBillingAddress = false;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    private boolean isSetCard = false;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    private boolean isSetShopperEmail = false;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    private boolean isSetShopperName = false;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    private boolean isSetTelephoneNumber = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public FundSource additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public FundSource putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public FundSource billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        this.isSetBillingAddress = true;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        this.isSetBillingAddress = true;
    }

    public FundSource card(Card card) {
        this.card = card;
        this.isSetCard = true;
        return this;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
        this.isSetCard = true;
    }

    public FundSource shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
    }

    public FundSource shopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
    }

    public FundSource telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        this.isSetTelephoneNumber = true;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        this.isSetTelephoneNumber = true;
    }

    public FundSource includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundSource fundSource = (FundSource)o;
        return Objects.equals(this.additionalData, fundSource.additionalData) && Objects.equals(this.isSetAdditionalData, fundSource.isSetAdditionalData) && Objects.equals(this.billingAddress, fundSource.billingAddress) && Objects.equals(this.isSetBillingAddress, fundSource.isSetBillingAddress) && Objects.equals(this.card, fundSource.card) && Objects.equals(this.isSetCard, fundSource.isSetCard) && Objects.equals(this.shopperEmail, fundSource.shopperEmail) && Objects.equals(this.isSetShopperEmail, fundSource.isSetShopperEmail) && Objects.equals(this.shopperName, fundSource.shopperName) && Objects.equals(this.isSetShopperName, fundSource.isSetShopperName) && Objects.equals(this.telephoneNumber, fundSource.telephoneNumber) && Objects.equals(this.isSetTelephoneNumber, fundSource.isSetTelephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.isSetAdditionalData, this.billingAddress, this.isSetBillingAddress, this.card, this.isSetCard, this.shopperEmail, this.isSetShopperEmail, this.shopperName, this.isSetShopperName, this.telephoneNumber, this.isSetTelephoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundSource {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetBillingAddress) {
            this.addIfNull(nulls, JSON_PROPERTY_BILLING_ADDRESS, this.billingAddress);
        }
        if (this.isSetCard) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD, this.card);
        }
        if (this.isSetShopperEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_EMAIL, this.shopperEmail);
        }
        if (this.isSetShopperName) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_NAME, this.shopperName);
        }
        if (this.isSetTelephoneNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_TELEPHONE_NUMBER, this.telephoneNumber);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static FundSource fromJson(String jsonString) throws JsonProcessingException {
        return (FundSource)JSON.getMapper().readValue(jsonString, FundSource.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

