/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"behavior", "costAllocationAccount", "targetAccount"})
public class PlatformChargebackLogic {
    public static final String JSON_PROPERTY_BEHAVIOR = "behavior";
    private BehaviorEnum behavior;
    private boolean isSetBehavior = false;
    public static final String JSON_PROPERTY_COST_ALLOCATION_ACCOUNT = "costAllocationAccount";
    private String costAllocationAccount;
    private boolean isSetCostAllocationAccount = false;
    public static final String JSON_PROPERTY_TARGET_ACCOUNT = "targetAccount";
    private String targetAccount;
    private boolean isSetTargetAccount = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PlatformChargebackLogic behavior(BehaviorEnum behavior) {
        this.behavior = behavior;
        this.isSetBehavior = true;
        return this;
    }

    @JsonProperty(value="behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BehaviorEnum getBehavior() {
        return this.behavior;
    }

    @JsonProperty(value="behavior")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBehavior(BehaviorEnum behavior) {
        this.behavior = behavior;
        this.isSetBehavior = true;
    }

    public PlatformChargebackLogic costAllocationAccount(String costAllocationAccount) {
        this.costAllocationAccount = costAllocationAccount;
        this.isSetCostAllocationAccount = true;
        return this;
    }

    @JsonProperty(value="costAllocationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCostAllocationAccount() {
        return this.costAllocationAccount;
    }

    @JsonProperty(value="costAllocationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCostAllocationAccount(String costAllocationAccount) {
        this.costAllocationAccount = costAllocationAccount;
        this.isSetCostAllocationAccount = true;
    }

    public PlatformChargebackLogic targetAccount(String targetAccount) {
        this.targetAccount = targetAccount;
        this.isSetTargetAccount = true;
        return this;
    }

    @JsonProperty(value="targetAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetAccount() {
        return this.targetAccount;
    }

    @JsonProperty(value="targetAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetAccount(String targetAccount) {
        this.targetAccount = targetAccount;
        this.isSetTargetAccount = true;
    }

    public PlatformChargebackLogic includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformChargebackLogic platformChargebackLogic = (PlatformChargebackLogic)o;
        return Objects.equals((Object)this.behavior, (Object)platformChargebackLogic.behavior) && Objects.equals(this.isSetBehavior, platformChargebackLogic.isSetBehavior) && Objects.equals(this.costAllocationAccount, platformChargebackLogic.costAllocationAccount) && Objects.equals(this.isSetCostAllocationAccount, platformChargebackLogic.isSetCostAllocationAccount) && Objects.equals(this.targetAccount, platformChargebackLogic.targetAccount) && Objects.equals(this.isSetTargetAccount, platformChargebackLogic.isSetTargetAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.behavior, this.isSetBehavior, this.costAllocationAccount, this.isSetCostAllocationAccount, this.targetAccount, this.isSetTargetAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlatformChargebackLogic {\n");
        sb.append("    behavior: ").append(this.toIndentedString((Object)this.behavior)).append("\n");
        sb.append("    costAllocationAccount: ").append(this.toIndentedString(this.costAllocationAccount)).append("\n");
        sb.append("    targetAccount: ").append(this.toIndentedString(this.targetAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBehavior) {
            this.addIfNull(nulls, JSON_PROPERTY_BEHAVIOR, (Object)this.behavior);
        }
        if (this.isSetCostAllocationAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_COST_ALLOCATION_ACCOUNT, this.costAllocationAccount);
        }
        if (this.isSetTargetAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_TARGET_ACCOUNT, this.targetAccount);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PlatformChargebackLogic fromJson(String jsonString) throws JsonProcessingException {
        return (PlatformChargebackLogic)JSON.getMapper().readValue(jsonString, PlatformChargebackLogic.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum BehaviorEnum {
        DEDUCTACCORDINGTOSPLITRATIO(String.valueOf("deductAccordingToSplitRatio")),
        DEDUCTFROMLIABLEACCOUNT(String.valueOf("deductFromLiableAccount")),
        DEDUCTFROMONEBALANCEACCOUNT(String.valueOf("deductFromOneBalanceAccount"));

        private static final Logger LOG;
        private String value;

        private BehaviorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BehaviorEnum fromValue(String value) {
            for (BehaviorEnum b : BehaviorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("BehaviorEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])BehaviorEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(BehaviorEnum.class.getName());
        }
    }
}

