/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"addressMatch", "deliveryAddressIndicator", "deliveryEmail", "deliveryEmailAddress", "deliveryTimeframe", "giftCardAmount", "giftCardCount", "giftCardCurr", "preOrderDate", "preOrderPurchase", "preOrderPurchaseInd", "reorderItems", "reorderItemsInd", "shipIndicator"})
public class MerchantRiskIndicator {
    public static final String JSON_PROPERTY_ADDRESS_MATCH = "addressMatch";
    private Boolean addressMatch;
    private boolean isSetAddressMatch = false;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS_INDICATOR = "deliveryAddressIndicator";
    private DeliveryAddressIndicatorEnum deliveryAddressIndicator;
    private boolean isSetDeliveryAddressIndicator = false;
    public static final String JSON_PROPERTY_DELIVERY_EMAIL = "deliveryEmail";
    @Deprecated
    private String deliveryEmail;
    private boolean isSetDeliveryEmail = false;
    public static final String JSON_PROPERTY_DELIVERY_EMAIL_ADDRESS = "deliveryEmailAddress";
    private String deliveryEmailAddress;
    private boolean isSetDeliveryEmailAddress = false;
    public static final String JSON_PROPERTY_DELIVERY_TIMEFRAME = "deliveryTimeframe";
    private DeliveryTimeframeEnum deliveryTimeframe;
    private boolean isSetDeliveryTimeframe = false;
    public static final String JSON_PROPERTY_GIFT_CARD_AMOUNT = "giftCardAmount";
    private Amount giftCardAmount;
    private boolean isSetGiftCardAmount = false;
    public static final String JSON_PROPERTY_GIFT_CARD_COUNT = "giftCardCount";
    private Integer giftCardCount;
    private boolean isSetGiftCardCount = false;
    public static final String JSON_PROPERTY_GIFT_CARD_CURR = "giftCardCurr";
    private String giftCardCurr;
    private boolean isSetGiftCardCurr = false;
    public static final String JSON_PROPERTY_PRE_ORDER_DATE = "preOrderDate";
    private OffsetDateTime preOrderDate;
    private boolean isSetPreOrderDate = false;
    public static final String JSON_PROPERTY_PRE_ORDER_PURCHASE = "preOrderPurchase";
    private Boolean preOrderPurchase;
    private boolean isSetPreOrderPurchase = false;
    public static final String JSON_PROPERTY_PRE_ORDER_PURCHASE_IND = "preOrderPurchaseInd";
    private String preOrderPurchaseInd;
    private boolean isSetPreOrderPurchaseInd = false;
    public static final String JSON_PROPERTY_REORDER_ITEMS = "reorderItems";
    private Boolean reorderItems;
    private boolean isSetReorderItems = false;
    public static final String JSON_PROPERTY_REORDER_ITEMS_IND = "reorderItemsInd";
    private String reorderItemsInd;
    private boolean isSetReorderItemsInd = false;
    public static final String JSON_PROPERTY_SHIP_INDICATOR = "shipIndicator";
    private String shipIndicator;
    private boolean isSetShipIndicator = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public MerchantRiskIndicator addressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
        this.isSetAddressMatch = true;
        return this;
    }

    @JsonProperty(value="addressMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAddressMatch() {
        return this.addressMatch;
    }

    @JsonProperty(value="addressMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
        this.isSetAddressMatch = true;
    }

    public MerchantRiskIndicator deliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
        this.isSetDeliveryAddressIndicator = true;
        return this;
    }

    @JsonProperty(value="deliveryAddressIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryAddressIndicatorEnum getDeliveryAddressIndicator() {
        return this.deliveryAddressIndicator;
    }

    @JsonProperty(value="deliveryAddressIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
        this.isSetDeliveryAddressIndicator = true;
    }

    @Deprecated
    public MerchantRiskIndicator deliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
        this.isSetDeliveryEmail = true;
        return this;
    }

    @Deprecated
    @JsonProperty(value="deliveryEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryEmail() {
        return this.deliveryEmail;
    }

    @Deprecated
    @JsonProperty(value="deliveryEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
        this.isSetDeliveryEmail = true;
    }

    public MerchantRiskIndicator deliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
        this.isSetDeliveryEmailAddress = true;
        return this;
    }

    @JsonProperty(value="deliveryEmailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryEmailAddress() {
        return this.deliveryEmailAddress;
    }

    @JsonProperty(value="deliveryEmailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
        this.isSetDeliveryEmailAddress = true;
    }

    public MerchantRiskIndicator deliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
        this.isSetDeliveryTimeframe = true;
        return this;
    }

    @JsonProperty(value="deliveryTimeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeliveryTimeframeEnum getDeliveryTimeframe() {
        return this.deliveryTimeframe;
    }

    @JsonProperty(value="deliveryTimeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
        this.isSetDeliveryTimeframe = true;
    }

    public MerchantRiskIndicator giftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
        this.isSetGiftCardAmount = true;
        return this;
    }

    @JsonProperty(value="giftCardAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getGiftCardAmount() {
        return this.giftCardAmount;
    }

    @JsonProperty(value="giftCardAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
        this.isSetGiftCardAmount = true;
    }

    public MerchantRiskIndicator giftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
        this.isSetGiftCardCount = true;
        return this;
    }

    @JsonProperty(value="giftCardCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGiftCardCount() {
        return this.giftCardCount;
    }

    @JsonProperty(value="giftCardCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
        this.isSetGiftCardCount = true;
    }

    public MerchantRiskIndicator giftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
        this.isSetGiftCardCurr = true;
        return this;
    }

    @JsonProperty(value="giftCardCurr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGiftCardCurr() {
        return this.giftCardCurr;
    }

    @JsonProperty(value="giftCardCurr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
        this.isSetGiftCardCurr = true;
    }

    public MerchantRiskIndicator preOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
        this.isSetPreOrderDate = true;
        return this;
    }

    @JsonProperty(value="preOrderDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getPreOrderDate() {
        return this.preOrderDate;
    }

    @JsonProperty(value="preOrderDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
        this.isSetPreOrderDate = true;
    }

    public MerchantRiskIndicator preOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
        this.isSetPreOrderPurchase = true;
        return this;
    }

    @JsonProperty(value="preOrderPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreOrderPurchase() {
        return this.preOrderPurchase;
    }

    @JsonProperty(value="preOrderPurchase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
        this.isSetPreOrderPurchase = true;
    }

    public MerchantRiskIndicator preOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
        this.isSetPreOrderPurchaseInd = true;
        return this;
    }

    @JsonProperty(value="preOrderPurchaseInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreOrderPurchaseInd() {
        return this.preOrderPurchaseInd;
    }

    @JsonProperty(value="preOrderPurchaseInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
        this.isSetPreOrderPurchaseInd = true;
    }

    public MerchantRiskIndicator reorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
        this.isSetReorderItems = true;
        return this;
    }

    @JsonProperty(value="reorderItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReorderItems() {
        return this.reorderItems;
    }

    @JsonProperty(value="reorderItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
        this.isSetReorderItems = true;
    }

    public MerchantRiskIndicator reorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
        this.isSetReorderItemsInd = true;
        return this;
    }

    @JsonProperty(value="reorderItemsInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReorderItemsInd() {
        return this.reorderItemsInd;
    }

    @JsonProperty(value="reorderItemsInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
        this.isSetReorderItemsInd = true;
    }

    public MerchantRiskIndicator shipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
        this.isSetShipIndicator = true;
        return this;
    }

    @JsonProperty(value="shipIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShipIndicator() {
        return this.shipIndicator;
    }

    @JsonProperty(value="shipIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
        this.isSetShipIndicator = true;
    }

    public MerchantRiskIndicator includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantRiskIndicator merchantRiskIndicator = (MerchantRiskIndicator)o;
        return Objects.equals(this.addressMatch, merchantRiskIndicator.addressMatch) && Objects.equals(this.isSetAddressMatch, merchantRiskIndicator.isSetAddressMatch) && Objects.equals((Object)this.deliveryAddressIndicator, (Object)merchantRiskIndicator.deliveryAddressIndicator) && Objects.equals(this.isSetDeliveryAddressIndicator, merchantRiskIndicator.isSetDeliveryAddressIndicator) && Objects.equals(this.deliveryEmail, merchantRiskIndicator.deliveryEmail) && Objects.equals(this.isSetDeliveryEmail, merchantRiskIndicator.isSetDeliveryEmail) && Objects.equals(this.deliveryEmailAddress, merchantRiskIndicator.deliveryEmailAddress) && Objects.equals(this.isSetDeliveryEmailAddress, merchantRiskIndicator.isSetDeliveryEmailAddress) && Objects.equals((Object)this.deliveryTimeframe, (Object)merchantRiskIndicator.deliveryTimeframe) && Objects.equals(this.isSetDeliveryTimeframe, merchantRiskIndicator.isSetDeliveryTimeframe) && Objects.equals(this.giftCardAmount, merchantRiskIndicator.giftCardAmount) && Objects.equals(this.isSetGiftCardAmount, merchantRiskIndicator.isSetGiftCardAmount) && Objects.equals(this.giftCardCount, merchantRiskIndicator.giftCardCount) && Objects.equals(this.isSetGiftCardCount, merchantRiskIndicator.isSetGiftCardCount) && Objects.equals(this.giftCardCurr, merchantRiskIndicator.giftCardCurr) && Objects.equals(this.isSetGiftCardCurr, merchantRiskIndicator.isSetGiftCardCurr) && Objects.equals(this.preOrderDate, merchantRiskIndicator.preOrderDate) && Objects.equals(this.isSetPreOrderDate, merchantRiskIndicator.isSetPreOrderDate) && Objects.equals(this.preOrderPurchase, merchantRiskIndicator.preOrderPurchase) && Objects.equals(this.isSetPreOrderPurchase, merchantRiskIndicator.isSetPreOrderPurchase) && Objects.equals(this.preOrderPurchaseInd, merchantRiskIndicator.preOrderPurchaseInd) && Objects.equals(this.isSetPreOrderPurchaseInd, merchantRiskIndicator.isSetPreOrderPurchaseInd) && Objects.equals(this.reorderItems, merchantRiskIndicator.reorderItems) && Objects.equals(this.isSetReorderItems, merchantRiskIndicator.isSetReorderItems) && Objects.equals(this.reorderItemsInd, merchantRiskIndicator.reorderItemsInd) && Objects.equals(this.isSetReorderItemsInd, merchantRiskIndicator.isSetReorderItemsInd) && Objects.equals(this.shipIndicator, merchantRiskIndicator.shipIndicator) && Objects.equals(this.isSetShipIndicator, merchantRiskIndicator.isSetShipIndicator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressMatch, this.isSetAddressMatch, this.deliveryAddressIndicator, this.isSetDeliveryAddressIndicator, this.deliveryEmail, this.isSetDeliveryEmail, this.deliveryEmailAddress, this.isSetDeliveryEmailAddress, this.deliveryTimeframe, this.isSetDeliveryTimeframe, this.giftCardAmount, this.isSetGiftCardAmount, this.giftCardCount, this.isSetGiftCardCount, this.giftCardCurr, this.isSetGiftCardCurr, this.preOrderDate, this.isSetPreOrderDate, this.preOrderPurchase, this.isSetPreOrderPurchase, this.preOrderPurchaseInd, this.isSetPreOrderPurchaseInd, this.reorderItems, this.isSetReorderItems, this.reorderItemsInd, this.isSetReorderItemsInd, this.shipIndicator, this.isSetShipIndicator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantRiskIndicator {\n");
        sb.append("    addressMatch: ").append(this.toIndentedString(this.addressMatch)).append("\n");
        sb.append("    deliveryAddressIndicator: ").append(this.toIndentedString((Object)this.deliveryAddressIndicator)).append("\n");
        sb.append("    deliveryEmail: ").append(this.toIndentedString(this.deliveryEmail)).append("\n");
        sb.append("    deliveryEmailAddress: ").append(this.toIndentedString(this.deliveryEmailAddress)).append("\n");
        sb.append("    deliveryTimeframe: ").append(this.toIndentedString((Object)this.deliveryTimeframe)).append("\n");
        sb.append("    giftCardAmount: ").append(this.toIndentedString(this.giftCardAmount)).append("\n");
        sb.append("    giftCardCount: ").append(this.toIndentedString(this.giftCardCount)).append("\n");
        sb.append("    giftCardCurr: ").append(this.toIndentedString(this.giftCardCurr)).append("\n");
        sb.append("    preOrderDate: ").append(this.toIndentedString(this.preOrderDate)).append("\n");
        sb.append("    preOrderPurchase: ").append(this.toIndentedString(this.preOrderPurchase)).append("\n");
        sb.append("    preOrderPurchaseInd: ").append(this.toIndentedString(this.preOrderPurchaseInd)).append("\n");
        sb.append("    reorderItems: ").append(this.toIndentedString(this.reorderItems)).append("\n");
        sb.append("    reorderItemsInd: ").append(this.toIndentedString(this.reorderItemsInd)).append("\n");
        sb.append("    shipIndicator: ").append(this.toIndentedString(this.shipIndicator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAddressMatch) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDRESS_MATCH, this.addressMatch);
        }
        if (this.isSetDeliveryAddressIndicator) {
            this.addIfNull(nulls, JSON_PROPERTY_DELIVERY_ADDRESS_INDICATOR, (Object)this.deliveryAddressIndicator);
        }
        if (this.isSetDeliveryEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_DELIVERY_EMAIL, this.deliveryEmail);
        }
        if (this.isSetDeliveryEmailAddress) {
            this.addIfNull(nulls, JSON_PROPERTY_DELIVERY_EMAIL_ADDRESS, this.deliveryEmailAddress);
        }
        if (this.isSetDeliveryTimeframe) {
            this.addIfNull(nulls, JSON_PROPERTY_DELIVERY_TIMEFRAME, (Object)this.deliveryTimeframe);
        }
        if (this.isSetGiftCardAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_GIFT_CARD_AMOUNT, this.giftCardAmount);
        }
        if (this.isSetGiftCardCount) {
            this.addIfNull(nulls, JSON_PROPERTY_GIFT_CARD_COUNT, this.giftCardCount);
        }
        if (this.isSetGiftCardCurr) {
            this.addIfNull(nulls, JSON_PROPERTY_GIFT_CARD_CURR, this.giftCardCurr);
        }
        if (this.isSetPreOrderDate) {
            this.addIfNull(nulls, JSON_PROPERTY_PRE_ORDER_DATE, this.preOrderDate);
        }
        if (this.isSetPreOrderPurchase) {
            this.addIfNull(nulls, JSON_PROPERTY_PRE_ORDER_PURCHASE, this.preOrderPurchase);
        }
        if (this.isSetPreOrderPurchaseInd) {
            this.addIfNull(nulls, JSON_PROPERTY_PRE_ORDER_PURCHASE_IND, this.preOrderPurchaseInd);
        }
        if (this.isSetReorderItems) {
            this.addIfNull(nulls, JSON_PROPERTY_REORDER_ITEMS, this.reorderItems);
        }
        if (this.isSetReorderItemsInd) {
            this.addIfNull(nulls, JSON_PROPERTY_REORDER_ITEMS_IND, this.reorderItemsInd);
        }
        if (this.isSetShipIndicator) {
            this.addIfNull(nulls, JSON_PROPERTY_SHIP_INDICATOR, this.shipIndicator);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static MerchantRiskIndicator fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantRiskIndicator)JSON.getMapper().readValue(jsonString, MerchantRiskIndicator.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum DeliveryTimeframeEnum {
        ELECTRONICDELIVERY(String.valueOf("electronicDelivery")),
        SAMEDAYSHIPPING(String.valueOf("sameDayShipping")),
        OVERNIGHTSHIPPING(String.valueOf("overnightShipping")),
        TWOORMOREDAYSSHIPPING(String.valueOf("twoOrMoreDaysShipping"));

        private static final Logger LOG;
        private String value;

        private DeliveryTimeframeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryTimeframeEnum fromValue(String value) {
            for (DeliveryTimeframeEnum b : DeliveryTimeframeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DeliveryTimeframeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DeliveryTimeframeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DeliveryTimeframeEnum.class.getName());
        }
    }

    public static enum DeliveryAddressIndicatorEnum {
        SHIPTOBILLINGADDRESS(String.valueOf("shipToBillingAddress")),
        SHIPTOVERIFIEDADDRESS(String.valueOf("shipToVerifiedAddress")),
        SHIPTONEWADDRESS(String.valueOf("shipToNewAddress")),
        SHIPTOSTORE(String.valueOf("shipToStore")),
        DIGITALGOODS(String.valueOf("digitalGoods")),
        GOODSNOTSHIPPED(String.valueOf("goodsNotShipped")),
        OTHER(String.valueOf("other"));

        private static final Logger LOG;
        private String value;

        private DeliveryAddressIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryAddressIndicatorEnum fromValue(String value) {
            for (DeliveryAddressIndicatorEnum b : DeliveryAddressIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DeliveryAddressIndicatorEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DeliveryAddressIndicatorEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DeliveryAddressIndicatorEnum.class.getName());
        }
    }
}

