/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"donationAccount", "merchantAccount", "modificationAmount", "originalReference", "platformChargebackLogic", "reference"})
public class DonationRequest {
    public static final String JSON_PROPERTY_DONATION_ACCOUNT = "donationAccount";
    private String donationAccount;
    private boolean isSetDonationAccount = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_MODIFICATION_AMOUNT = "modificationAmount";
    private Amount modificationAmount;
    private boolean isSetModificationAmount = false;
    public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
    private String originalReference;
    private boolean isSetOriginalReference = false;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    private boolean isSetPlatformChargebackLogic = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public DonationRequest donationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
        this.isSetDonationAccount = true;
        return this;
    }

    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationAccount() {
        return this.donationAccount;
    }

    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
        this.isSetDonationAccount = true;
    }

    public DonationRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public DonationRequest modificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        this.isSetModificationAmount = true;
        return this;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getModificationAmount() {
        return this.modificationAmount;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        this.isSetModificationAmount = true;
    }

    public DonationRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        this.isSetOriginalReference = true;
        return this;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalReference() {
        return this.originalReference;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
        this.isSetOriginalReference = true;
    }

    public DonationRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        this.isSetPlatformChargebackLogic = true;
        return this;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        this.isSetPlatformChargebackLogic = true;
    }

    public DonationRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public DonationRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DonationRequest donationRequest = (DonationRequest)o;
        return Objects.equals(this.donationAccount, donationRequest.donationAccount) && Objects.equals(this.isSetDonationAccount, donationRequest.isSetDonationAccount) && Objects.equals(this.merchantAccount, donationRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, donationRequest.isSetMerchantAccount) && Objects.equals(this.modificationAmount, donationRequest.modificationAmount) && Objects.equals(this.isSetModificationAmount, donationRequest.isSetModificationAmount) && Objects.equals(this.originalReference, donationRequest.originalReference) && Objects.equals(this.isSetOriginalReference, donationRequest.isSetOriginalReference) && Objects.equals(this.platformChargebackLogic, donationRequest.platformChargebackLogic) && Objects.equals(this.isSetPlatformChargebackLogic, donationRequest.isSetPlatformChargebackLogic) && Objects.equals(this.reference, donationRequest.reference) && Objects.equals(this.isSetReference, donationRequest.isSetReference);
    }

    public int hashCode() {
        return Objects.hash(this.donationAccount, this.isSetDonationAccount, this.merchantAccount, this.isSetMerchantAccount, this.modificationAmount, this.isSetModificationAmount, this.originalReference, this.isSetOriginalReference, this.platformChargebackLogic, this.isSetPlatformChargebackLogic, this.reference, this.isSetReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DonationRequest {\n");
        sb.append("    donationAccount: ").append(this.toIndentedString(this.donationAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    modificationAmount: ").append(this.toIndentedString(this.modificationAmount)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetDonationAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_DONATION_ACCOUNT, this.donationAccount);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetModificationAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_MODIFICATION_AMOUNT, this.modificationAmount);
        }
        if (this.isSetOriginalReference) {
            this.addIfNull(nulls, JSON_PROPERTY_ORIGINAL_REFERENCE, this.originalReference);
        }
        if (this.isSetPlatformChargebackLogic) {
            this.addIfNull(nulls, JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC, this.platformChargebackLogic);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static DonationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DonationRequest)JSON.getMapper().readValue(jsonString, DonationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

