/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.PersonalDocumentData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"dateOfBirth", "documentData", "nationality"})
public class ViasPersonalData {
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private String dateOfBirth;
    public static final String JSON_PROPERTY_DOCUMENT_DATA = "documentData";
    private List<PersonalDocumentData> documentData = null;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;

    public ViasPersonalData dateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The person's date of birth, in ISO-8601 YYYY-MM-DD format. For example, **2000-01-31**.")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public ViasPersonalData documentData(List<PersonalDocumentData> documentData) {
        this.documentData = documentData;
        return this;
    }

    public ViasPersonalData addDocumentDataItem(PersonalDocumentData documentDataItem) {
        if (this.documentData == null) {
            this.documentData = new ArrayList<PersonalDocumentData>();
        }
        this.documentData.add(documentDataItem);
        return this;
    }

    @ApiModelProperty(value="Array that contains information about the person's identification document. You can submit only one entry per document type.")
    @JsonProperty(value="documentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PersonalDocumentData> getDocumentData() {
        return this.documentData;
    }

    @JsonProperty(value="documentData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentData(List<PersonalDocumentData> documentData) {
        this.documentData = documentData;
    }

    public ViasPersonalData nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The nationality of the person represented by a two-character country code,  in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. For example, **NL**. ")
    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViasPersonalData viasPersonalData = (ViasPersonalData)o;
        return Objects.equals(this.dateOfBirth, viasPersonalData.dateOfBirth) && Objects.equals(this.documentData, viasPersonalData.documentData) && Objects.equals(this.nationality, viasPersonalData.nationality);
    }

    public int hashCode() {
        return Objects.hash(this.dateOfBirth, this.documentData, this.nationality);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViasPersonalData {\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    documentData: ").append(this.toIndentedString(this.documentData)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ViasPersonalData fromJson(String jsonString) throws JsonProcessingException {
        return (ViasPersonalData)JSON.getMapper().readValue(jsonString, ViasPersonalData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

