/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.Amount;
import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"disableReason", "disabled", "processedFrom", "processedTo", "tierNumber"})
public class AccountProcessingState {
    public static final String JSON_PROPERTY_DISABLE_REASON = "disableReason";
    private String disableReason;
    public static final String JSON_PROPERTY_DISABLED = "disabled";
    private Boolean disabled;
    public static final String JSON_PROPERTY_PROCESSED_FROM = "processedFrom";
    private Amount processedFrom;
    public static final String JSON_PROPERTY_PROCESSED_TO = "processedTo";
    private Amount processedTo;
    public static final String JSON_PROPERTY_TIER_NUMBER = "tierNumber";
    private Integer tierNumber;

    public AccountProcessingState disableReason(String disableReason) {
        this.disableReason = disableReason;
        return this;
    }

    @ApiModelProperty(value="The reason why processing has been disabled.")
    @JsonProperty(value="disableReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisableReason() {
        return this.disableReason;
    }

    @JsonProperty(value="disableReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisableReason(String disableReason) {
        this.disableReason = disableReason;
    }

    public AccountProcessingState disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the processing of payments is allowed.")
    @JsonProperty(value="disabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public AccountProcessingState processedFrom(Amount processedFrom) {
        this.processedFrom = processedFrom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="processedFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getProcessedFrom() {
        return this.processedFrom;
    }

    @JsonProperty(value="processedFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessedFrom(Amount processedFrom) {
        this.processedFrom = processedFrom;
    }

    public AccountProcessingState processedTo(Amount processedTo) {
        this.processedTo = processedTo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="processedTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getProcessedTo() {
        return this.processedTo;
    }

    @JsonProperty(value="processedTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessedTo(Amount processedTo) {
        this.processedTo = processedTo;
    }

    public AccountProcessingState tierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
        return this;
    }

    @ApiModelProperty(value="The processing tier that the account holder occupies.")
    @JsonProperty(value="tierNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTierNumber() {
        return this.tierNumber;
    }

    @JsonProperty(value="tierNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountProcessingState accountProcessingState = (AccountProcessingState)o;
        return Objects.equals(this.disableReason, accountProcessingState.disableReason) && Objects.equals(this.disabled, accountProcessingState.disabled) && Objects.equals(this.processedFrom, accountProcessingState.processedFrom) && Objects.equals(this.processedTo, accountProcessingState.processedTo) && Objects.equals(this.tierNumber, accountProcessingState.tierNumber);
    }

    public int hashCode() {
        return Objects.hash(this.disableReason, this.disabled, this.processedFrom, this.processedTo, this.tierNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountProcessingState {\n");
        sb.append("    disableReason: ").append(this.toIndentedString(this.disableReason)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    processedFrom: ").append(this.toIndentedString(this.processedFrom)).append("\n");
        sb.append("    processedTo: ").append(this.toIndentedString(this.processedTo)).append("\n");
        sb.append("    tierNumber: ").append(this.toIndentedString(this.tierNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountProcessingState fromJson(String jsonString) throws JsonProcessingException {
        return (AccountProcessingState)JSON.getMapper().readValue(jsonString, AccountProcessingState.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

