/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.BankAccountInfo;
import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"bankAccount", "legalEntityId", "type"})
public class TransferInstrumentInfo {
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private BankAccountInfo bankAccount;
    private boolean isSetBankAccount = false;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    private boolean isSetLegalEntityId = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TransferInstrumentInfo bankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
        this.isSetBankAccount = true;
        return this;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountInfo getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
        this.isSetBankAccount = true;
    }

    public TransferInstrumentInfo legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
        return this;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
    }

    public TransferInstrumentInfo type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public TransferInstrumentInfo includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInstrumentInfo transferInstrumentInfo = (TransferInstrumentInfo)o;
        return Objects.equals(this.bankAccount, transferInstrumentInfo.bankAccount) && Objects.equals(this.isSetBankAccount, transferInstrumentInfo.isSetBankAccount) && Objects.equals(this.legalEntityId, transferInstrumentInfo.legalEntityId) && Objects.equals(this.isSetLegalEntityId, transferInstrumentInfo.isSetLegalEntityId) && Objects.equals((Object)this.type, (Object)transferInstrumentInfo.type) && Objects.equals(this.isSetType, transferInstrumentInfo.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccount, this.isSetBankAccount, this.legalEntityId, this.isSetLegalEntityId, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInstrumentInfo {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBankAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_BANK_ACCOUNT, this.bankAccount);
        }
        if (this.isSetLegalEntityId) {
            this.addIfNull(nulls, JSON_PROPERTY_LEGAL_ENTITY_ID, this.legalEntityId);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TransferInstrumentInfo fromJson(String jsonString) throws JsonProcessingException {
        return (TransferInstrumentInfo)JSON.getMapper().readValue(jsonString, TransferInstrumentInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKACCOUNT(String.valueOf("bankAccount")),
        RECURRINGDETAIL(String.valueOf("recurringDetail"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

