/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"pageName", "pageNumber", "type"})
public class DocumentPage {
    public static final String JSON_PROPERTY_PAGE_NAME = "pageName";
    private String pageName;
    private boolean isSetPageName = false;
    public static final String JSON_PROPERTY_PAGE_NUMBER = "pageNumber";
    private Integer pageNumber;
    private boolean isSetPageNumber = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public DocumentPage pageName(String pageName) {
        this.pageName = pageName;
        this.isSetPageName = true;
        return this;
    }

    @JsonProperty(value="pageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPageName() {
        return this.pageName;
    }

    @JsonProperty(value="pageName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageName(String pageName) {
        this.pageName = pageName;
        this.isSetPageName = true;
    }

    public DocumentPage pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        this.isSetPageNumber = true;
        return this;
    }

    @JsonProperty(value="pageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @JsonProperty(value="pageNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        this.isSetPageNumber = true;
    }

    public DocumentPage type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public DocumentPage includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPage documentPage = (DocumentPage)o;
        return Objects.equals(this.pageName, documentPage.pageName) && Objects.equals(this.isSetPageName, documentPage.isSetPageName) && Objects.equals(this.pageNumber, documentPage.pageNumber) && Objects.equals(this.isSetPageNumber, documentPage.isSetPageNumber) && Objects.equals((Object)this.type, (Object)documentPage.type) && Objects.equals(this.isSetType, documentPage.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageName, this.isSetPageName, this.pageNumber, this.isSetPageNumber, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentPage {\n");
        sb.append("    pageName: ").append(this.toIndentedString(this.pageName)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetPageName) {
            this.addIfNull(nulls, JSON_PROPERTY_PAGE_NAME, this.pageName);
        }
        if (this.isSetPageNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_PAGE_NUMBER, this.pageNumber);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static DocumentPage fromJson(String jsonString) throws JsonProcessingException {
        return (DocumentPage)JSON.getMapper().readValue(jsonString, DocumentPage.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BACK(String.valueOf("BACK")),
        FRONT(String.valueOf("FRONT")),
        UNDEFINED(String.valueOf("UNDEFINED"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

