/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"issueAddress", "issueDate", "number"})
public class Ticket {
    public static final String JSON_PROPERTY_ISSUE_ADDRESS = "issueAddress";
    private String issueAddress;
    private boolean isSetIssueAddress = false;
    public static final String JSON_PROPERTY_ISSUE_DATE = "issueDate";
    private LocalDate issueDate;
    private boolean isSetIssueDate = false;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    private boolean isSetNumber = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Ticket issueAddress(String issueAddress) {
        this.issueAddress = issueAddress;
        this.isSetIssueAddress = true;
        return this;
    }

    @JsonProperty(value="issueAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssueAddress() {
        return this.issueAddress;
    }

    @JsonProperty(value="issueAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssueAddress(String issueAddress) {
        this.issueAddress = issueAddress;
        this.isSetIssueAddress = true;
    }

    public Ticket issueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        this.isSetIssueDate = true;
        return this;
    }

    @JsonProperty(value="issueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getIssueDate() {
        return this.issueDate;
    }

    @JsonProperty(value="issueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
        this.isSetIssueDate = true;
    }

    public Ticket number(String number) {
        this.number = number;
        this.isSetNumber = true;
        return this;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
        this.isSetNumber = true;
    }

    public Ticket includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ticket ticket = (Ticket)o;
        return Objects.equals(this.issueAddress, ticket.issueAddress) && Objects.equals(this.isSetIssueAddress, ticket.isSetIssueAddress) && Objects.equals(this.issueDate, ticket.issueDate) && Objects.equals(this.isSetIssueDate, ticket.isSetIssueDate) && Objects.equals(this.number, ticket.number) && Objects.equals(this.isSetNumber, ticket.isSetNumber);
    }

    public int hashCode() {
        return Objects.hash(this.issueAddress, this.isSetIssueAddress, this.issueDate, this.isSetIssueDate, this.number, this.isSetNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Ticket {\n");
        sb.append("    issueAddress: ").append(this.toIndentedString(this.issueAddress)).append("\n");
        sb.append("    issueDate: ").append(this.toIndentedString(this.issueDate)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetIssueAddress) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUE_ADDRESS, this.issueAddress);
        }
        if (this.isSetIssueDate) {
            this.addIfNull(nulls, JSON_PROPERTY_ISSUE_DATE, this.issueDate);
        }
        if (this.isSetNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_NUMBER, this.number);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Ticket fromJson(String jsonString) throws JsonProcessingException {
        return (Ticket)JSON.getMapper().readValue(jsonString, Ticket.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

